/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.sql.fluent.models.ElasticPoolProperties;
import com.azure.resourcemanager.sql.models.ElasticPoolLicenseType;
import com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseSettings;
import com.azure.resourcemanager.sql.models.ElasticPoolState;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class ElasticPoolInner
extends Resource {
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="kind", access=JsonProperty.Access.WRITE_ONLY)
    private String kind;
    @JsonProperty(value="properties")
    private ElasticPoolProperties innerProperties;

    public Sku sku() {
        return this.sku;
    }

    public ElasticPoolInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    private ElasticPoolProperties innerProperties() {
        return this.innerProperties;
    }

    public ElasticPoolInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ElasticPoolInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ElasticPoolState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public Long maxSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeBytes();
    }

    public ElasticPoolInner withMaxSizeBytes(Long maxSizeBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolProperties();
        }
        this.innerProperties().withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    public ElasticPoolPerDatabaseSettings perDatabaseSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().perDatabaseSettings();
    }

    public ElasticPoolInner withPerDatabaseSettings(ElasticPoolPerDatabaseSettings perDatabaseSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolProperties();
        }
        this.innerProperties().withPerDatabaseSettings(perDatabaseSettings);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public ElasticPoolInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public ElasticPoolLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public ElasticPoolInner withLicenseType(ElasticPoolLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

