/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.thread;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.DefaultUncaughtExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);

    public static ThreadPoolExecutor newDaemonFixedThreadExecutor(String threadNameFormat, int threadsNum) {
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(threadsNum, ThreadUtils.newDaemonThreadFactory(threadNameFormat));
    }

    public static ScheduledExecutorService newSingleDaemonScheduledExecutorService(String threadNameFormat) {
        return Executors.newSingleThreadScheduledExecutor(ThreadUtils.newDaemonThreadFactory(threadNameFormat));
    }

    public static ScheduledExecutorService newDaemonScheduledExecutorService(String threadNameFormat, int threadsNum) {
        return Executors.newScheduledThreadPool(threadsNum, ThreadUtils.newDaemonThreadFactory(threadNameFormat));
    }

    public static ThreadFactory newDaemonThreadFactory(String threadNameFormat) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadNameFormat).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultUncaughtExceptionHandler.getInstance()).build();
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            log.error("Current thread sleep error", (Throwable)interruptedException);
        }
    }

    public static void rethrowInterruptedException(InterruptedException interruptedException) {
        Thread.currentThread().interrupt();
        throw new RuntimeException("Current thread: " + Thread.currentThread().getName() + " is interrupted", interruptedException);
    }

    public static void consumeInterruptedException(InterruptedException interruptedException) {
        log.info("Current thread: {} is interrupted", (Object)Thread.currentThread().getName(), (Object)interruptedException);
        Thread.currentThread().interrupt();
    }

    @Generated
    private ThreadUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

