/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.am;

import com.google.auto.service.AutoService;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.am.ApplicationManager;
import org.apache.dolphinscheduler.plugin.task.api.am.YarnApplicationManagerContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.ResourceManagerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={ApplicationManager.class})
public class YarnApplicationManager
implements ApplicationManager<YarnApplicationManagerContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(YarnApplicationManager.class);

    @Override
    public boolean killApplication(YarnApplicationManagerContext yarnApplicationManagerContext) throws TaskException {
        String executePath = yarnApplicationManagerContext.getExecutePath();
        String tenantCode = yarnApplicationManagerContext.getTenantCode();
        List<String> appIds = yarnApplicationManagerContext.getAppIds();
        try {
            String commandFile = String.format("%s/%s.kill", executePath, String.join((CharSequence)"_", appIds));
            String cmd = this.getKerberosInitCommand() + "yarn application -kill " + String.join((CharSequence)" ", appIds);
            this.execYarnKillCommand(tenantCode, commandFile, cmd);
        }
        catch (Exception e) {
            log.error("Kill yarn application [{}] failed", appIds, (Object)e);
            throw new TaskException(e.getMessage());
        }
        return true;
    }

    @Override
    public ResourceManagerType getResourceManagerType() {
        return ResourceManagerType.YARN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execYarnKillCommand(String tenantCode, String commandFile, String cmd) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/sh\n");
        sb.append("BASEDIR=$(cd `dirname $0`; pwd)\n");
        sb.append("cd $BASEDIR\n");
        sb.append("\n\n");
        sb.append(cmd);
        Path killCommandAbsolutePath = Paths.get(commandFile, new String[0]);
        try {
            FileUtils.createFileWith755((Path)killCommandAbsolutePath);
            Files.write(killCommandAbsolutePath, sb.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            String runCmd = String.format("%s %s", "sh", commandFile);
            runCmd = OSUtils.getSudoCmd((String)tenantCode, (String)runCmd);
            log.info("kill cmd:{}", (Object)runCmd);
            OSUtils.exeCmd((String)runCmd);
        }
        finally {
            Files.deleteIfExists(killCommandAbsolutePath);
        }
    }

    private String getKerberosInitCommand() {
        log.info("get kerberos init command");
        StringBuilder kerberosCommandBuilder = new StringBuilder();
        boolean hadoopKerberosState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (Boolean)false);
        if (hadoopKerberosState) {
            kerberosCommandBuilder.append("export KRB5_CONFIG=").append(PropertyUtils.getString((String)"java.security.krb5.conf.path")).append("\n\n").append(String.format("kinit -k -t %s %s || true", PropertyUtils.getString((String)"login.user.keytab.path"), PropertyUtils.getString((String)"login.user.keytab.username"))).append("\n\n");
            log.info("kerberos init command: {}", (Object)kerberosCommandBuilder);
        }
        return kerberosCommandBuilder.toString();
    }
}

