/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.etcd;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.ConnectionState;

public class EtcdConnectionStateListener
implements AutoCloseable {
    private final List<ConnectionListener> connectionListeners = Collections.synchronizedList(new ArrayList());
    private final ScheduledExecutorService scheduledExecutorService;
    private final Client client;
    private volatile ConnectionState connectionState;

    public EtcdConnectionStateListener(Client client) {
        this.client = client;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("EtcdConnectionStateListenerThread").setDaemon(true).build());
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    @Override
    public void close() throws Exception {
        this.connectionListeners.clear();
        this.scheduledExecutorService.shutdownNow();
    }

    private ConnectionState currentConnectivityState() {
        try {
            ((LeaseGrantResponse)this.client.getLeaseClient().grant(1L).get()).getID();
            return ConnectionState.CONNECTED;
        }
        catch (ExecutionException e) {
            return ConnectionState.DISCONNECTED;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ConnectionState.DISCONNECTED;
        }
    }

    public void start() {
        long initialDelay = 500L;
        long delay = 500L;
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            ConnectionState currentConnectionState = this.currentConnectivityState();
            if (currentConnectionState == this.connectionState) {
                return;
            }
            if (this.connectionState == ConnectionState.CONNECTED) {
                if (currentConnectionState == ConnectionState.DISCONNECTED) {
                    this.connectionState = ConnectionState.DISCONNECTED;
                    this.triggerListener(ConnectionState.DISCONNECTED);
                }
            } else if (this.connectionState == ConnectionState.DISCONNECTED) {
                if (currentConnectionState == ConnectionState.CONNECTED) {
                    this.connectionState = ConnectionState.CONNECTED;
                    this.triggerListener(ConnectionState.RECONNECTED);
                }
            } else if (this.connectionState == null) {
                this.connectionState = currentConnectionState;
                this.triggerListener(this.connectionState);
            }
        }, initialDelay, delay, TimeUnit.MILLISECONDS);
    }

    private void triggerListener(ConnectionState connectionState) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.onUpdate(connectionState);
        }
    }
}

