/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.datafactory.fluent.models.FactoryProperties;
import com.azure.resourcemanager.datafactory.models.EncryptionConfiguration;
import com.azure.resourcemanager.datafactory.models.FactoryIdentity;
import com.azure.resourcemanager.datafactory.models.FactoryRepoConfiguration;
import com.azure.resourcemanager.datafactory.models.GlobalParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PublicNetworkAccess;
import com.azure.resourcemanager.datafactory.models.PurviewConfiguration;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

public final class FactoryInner
extends Resource {
    @JsonProperty(value="identity")
    private FactoryIdentity identity;
    @JsonProperty(value="properties")
    private FactoryProperties innerProperties;
    @JsonProperty(value="eTag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonIgnore
    private Map<String, Object> additionalProperties;

    public FactoryIdentity identity() {
        return this.identity;
    }

    public FactoryInner withIdentity(FactoryIdentity identity) {
        this.identity = identity;
        return this;
    }

    private FactoryProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public FactoryInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
    }

    public FactoryInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public FactoryInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime createTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createTime();
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public PurviewConfiguration purviewConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().purviewConfiguration();
    }

    public FactoryInner withPurviewConfiguration(PurviewConfiguration purviewConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryProperties();
        }
        this.innerProperties().withPurviewConfiguration(purviewConfiguration);
        return this;
    }

    public FactoryRepoConfiguration repoConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().repoConfiguration();
    }

    public FactoryInner withRepoConfiguration(FactoryRepoConfiguration repoConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryProperties();
        }
        this.innerProperties().withRepoConfiguration(repoConfiguration);
        return this;
    }

    public Map<String, GlobalParameterSpecification> globalParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().globalParameters();
    }

    public FactoryInner withGlobalParameters(Map<String, GlobalParameterSpecification> globalParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryProperties();
        }
        this.innerProperties().withGlobalParameters(globalParameters);
        return this;
    }

    public EncryptionConfiguration encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public FactoryInner withEncryption(EncryptionConfiguration encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public FactoryInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

