/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.FactoryGitHubConfiguration;
import com.azure.resourcemanager.datafactory.models.FactoryVstsConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=FactoryRepoConfiguration.class)
@JsonTypeName(value="FactoryRepoConfiguration")
@JsonSubTypes(value={@JsonSubTypes.Type(name="FactoryVSTSConfiguration", value=FactoryVstsConfiguration.class), @JsonSubTypes.Type(name="FactoryGitHubConfiguration", value=FactoryGitHubConfiguration.class)})
public class FactoryRepoConfiguration {
    @JsonProperty(value="accountName", required=true)
    private String accountName;
    @JsonProperty(value="repositoryName", required=true)
    private String repositoryName;
    @JsonProperty(value="collaborationBranch", required=true)
    private String collaborationBranch;
    @JsonProperty(value="rootFolder", required=true)
    private String rootFolder;
    @JsonProperty(value="lastCommitId")
    private String lastCommitId;
    @JsonProperty(value="disablePublish")
    private Boolean disablePublish;
    private static final ClientLogger LOGGER = new ClientLogger(FactoryRepoConfiguration.class);

    public String accountName() {
        return this.accountName;
    }

    public FactoryRepoConfiguration withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public FactoryRepoConfiguration withRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public String collaborationBranch() {
        return this.collaborationBranch;
    }

    public FactoryRepoConfiguration withCollaborationBranch(String collaborationBranch) {
        this.collaborationBranch = collaborationBranch;
        return this;
    }

    public String rootFolder() {
        return this.rootFolder;
    }

    public FactoryRepoConfiguration withRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
        return this;
    }

    public String lastCommitId() {
        return this.lastCommitId;
    }

    public FactoryRepoConfiguration withLastCommitId(String lastCommitId) {
        this.lastCommitId = lastCommitId;
        return this;
    }

    public Boolean disablePublish() {
        return this.disablePublish;
    }

    public FactoryRepoConfiguration withDisablePublish(Boolean disablePublish) {
        this.disablePublish = disablePublish;
        return this;
    }

    public void validate() {
        if (this.accountName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property accountName in model FactoryRepoConfiguration"));
        }
        if (this.repositoryName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property repositoryName in model FactoryRepoConfiguration"));
        }
        if (this.collaborationBranch() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property collaborationBranch in model FactoryRepoConfiguration"));
        }
        if (this.rootFolder() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property rootFolder in model FactoryRepoConfiguration"));
        }
    }
}

