set batch_size=10;
set require_sequence_in_insert=false;

DROP TABLE IF EXISTS sql_screenshots;

CREATE TABLE `sql_screenshots` (
                                   `sql` varchar(1024) NOT NULL,
                                   `sql_created_month` int NOT NULL,
                                   `sql_created_time` datetime NOT NULL,
                                   `id` varchar(1024) NOT NULL,
                                   `account_id` bigint NULL,
                                   `product` varchar(1024) NULL,
                                   `properties` variant NULL,
                                   `date_time` datetime NULL,
                                   `time_millis` bigint NULL,
                                   `process_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=OLAP
UNIQUE KEY(`sql`, `sql_created_month`, `sql_created_time`, `id`)
        AUTO PARTITION BY LIST (`sql`, `sql_created_month`)
        (PARTITION pe5fscreenshots13162 VALUES IN (("sql_screenshots", "16")),
        PARTITION pe5fscreenshots1325024 VALUES IN (("sql_screenshots", "2502")),
        PARTITION pe5fscreenshots1325034 VALUES IN (("sql_screenshots", "2503")),
        PARTITION pe5fscreenshots1325044 VALUES IN (("sql_screenshots", "2504")))
        DISTRIBUTED BY HASH(`id`) BUCKETS 64
        PROPERTIES (
        "replication_allocation" = "tag.location.default: 1",
        "enable_unique_key_merge_on_write" = "true",
        "function_column.sequence_type" = "datetime",
        "store_row_column" = "true",
        "row_store_page_size" = "16384",
        "disable_auto_compaction" = "false"
        );

INSERT INTO sql_screenshots (`sql`, `sql_created_month`, `sql_created_time`, `id`, `account_id`, `product`,`properties`, `date_time`, `time_millis`, `process_time`) VALUES
('sql_screenshots', 2502, '2025-04-14 16:41:05', 'id_dfb5cd2b40d648f4', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105503656_1744620065000_109657261_1744620065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ab34e75c8d4540b780eb88a13b0080f6.jpg", "device_id": "a83a0071-3aa1-417d-be0d-cfac5868811f", "is_chatting": 1, "label_rate": 2, "log_seq": "f2dd8cff05b94d3283ac578acf152e1d", "phone_model": "Samsung_S21", "rate": 2, "target_id": "105503656"}', '2025-04-14 16:41:05', 1744620065000, '2025-04-14 16:41:05'),
('sql_screenshots', 16, '2025-04-14 16:42:05', 'id_92cd270deef54990', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744620125000_83341608_1744620125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d30033835e2d49a2afef71937e568f31.jpg", "device_id": "b9eff9a2-5938-4b41-9321-bf0d255843ac", "is_chatting": 1, "label_rate": 0, "log_seq": "def919dd0aea460ca15d53c542fe3b6e", "phone_model": "OnePlus_9", "rate": 4, "target_id": "110873051"}', '2025-04-14 16:42:05', 1744620125000, '2025-04-14 16:42:05'),
('sql_screenshots', 16, '2025-04-14 16:43:05', 'id_aa4cdbb0b7684314', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109744448_1744620185000_81479540_1744620185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e5ab4748097640dbb2448d31865a4605.jpg", "device_id": "0cffc10b-7733-4fcd-84fd-1617c7e04043", "is_chatting": 1, "label_rate": 1, "log_seq": "25588a73ce954329ae5e3ffff2255d7e", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "109744448"}', '2025-04-14 16:43:05', 1744620185000, '2025-04-14 16:43:05'),
('sql_screenshots', 16, '2025-04-14 16:44:05', 'id_21f8b17d96f14032', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744620245000_109744448_1744620245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7f71a7aab4094bb3bbade6bbfea90e23.jpg", "device_id": "96ac8771-c55b-4fc1-af0f-cd1c8268bdb0", "is_chatting": 1, "label_rate": 0, "log_seq": "42de4d778f784e38bcbb73891e0a68e3", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "110873051"}', '2025-04-14 16:44:05', 1744620245000, '2025-04-14 16:44:05'),
('sql_screenshots', 16, '2025-04-14 16:45:05', 'id_6d43e389ccb74bd2', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "28230174_1744620305000_57649476_1744620305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/db2bbd77920a4e5db1625e0bc45c8b20.jpg", "device_id": "cda1a2d3-21c6-48a3-a6ec-d3d9e078a770", "is_chatting": 1, "label_rate": 2, "log_seq": "f549ab9347d54812961e941e221953be", "phone_model": "VIVO_X60", "rate": 3, "target_id": "28230174"}', '2025-04-14 16:45:05', 1744620305000, '2025-04-14 16:45:05'),
('sql_screenshots', 16, '2025-04-14 16:46:05', 'id_b383efaa947849bd', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "104844318_1744620365000_81479540_1744620365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a3cea8971cdd408db454fe4b15bc5d52.jpg", "device_id": "99600ab3-8c71-4108-a67b-af2a1a682f28", "is_chatting": 1, "label_rate": 0, "log_seq": "3bfa882d64834e9492dd012795a54cbd", "phone_model": "Samsung_S22", "rate": 5, "target_id": "104844318"}', '2025-04-14 16:46:05', 1744620365000, '2025-04-14 16:46:05'),
('sql_screenshots', 2502, '2025-04-14 16:47:05', 'id_22aa0550e5f24079', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744620425000_82365582_1744620425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ed3bbb4d526b443892c2bb696fc3d939.jpg", "device_id": "b70730d6-48b0-475b-8ac2-a1b53bdb7878", "is_chatting": 1, "label_rate": 0, "log_seq": "6f008441c0e14a939448014ca05dbcf2", "phone_model": "Samsung_S22", "rate": 5, "target_id": "64280379"}', '2025-04-14 16:47:05', 1744620425000, '2025-04-14 16:47:05'),
('sql_screenshots', 2502, '2025-04-14 16:48:05', 'id_1a7ffb71e60c41b4', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "87571440_1744620485000_109744448_1744620485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/13607597c9b84de78cecbfca0a9f28ad.jpg", "device_id": "68811a68-26d3-418b-a5ad-a42b27413458", "is_chatting": 1, "label_rate": 1, "log_seq": "3632b22f24d545afa95a67d0726d2615", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "87571440"}', '2025-04-14 16:48:05', 1744620485000, '2025-04-14 16:48:05'),
('sql_screenshots', 2502, '2025-04-14 16:49:05', 'id_e90424cc7e674c64', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "94369556_1744620545000_82365582_1744620545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cd4af6f5d10344f2ad97536199710875.jpg", "device_id": "f6e59144-3e40-41ea-8a80-a8329c91df4b", "is_chatting": 1, "label_rate": 1, "log_seq": "1d37591ae3244ff6a31e143ad611f614", "phone_model": "VIVO_X60", "rate": 0, "target_id": "94369556"}', '2025-04-14 16:49:05', 1744620545000, '2025-04-14 16:49:05'),
('sql_screenshots', 16, '2025-04-14 16:50:05', 'id_5cdaf877f1d24ada', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "82365582_1744620605000_64280379_1744620605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f8fa890ffa094435b5e9d46474b14615.jpg", "device_id": "bf3a43ed-b2ca-4a2d-9acb-21c3aa3207fc", "is_chatting": 1, "label_rate": 1, "log_seq": "3338fc3c87a64a44bdc71cd1090eb0b3", "phone_model": "Samsung_S22", "rate": 3, "target_id": "82365582"}', '2025-04-14 16:50:05', 1744620605000, '2025-04-14 16:50:05'),
('sql_screenshots', 16, '2025-04-14 16:51:05', 'id_56ed1a6e6f0548c9', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "94369556_1744620665000_110876251_1744620665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/daf1188d773f43a2a7e28d81fa0c12fa.jpg", "device_id": "ea09f910-0073-4a99-9822-ef075649236e", "is_chatting": 1, "label_rate": 0, "log_seq": "5b5de830f8c449d495fc8ed2634e3f99", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "94369556"}', '2025-04-14 16:51:05', 1744620665000, '2025-04-14 16:51:05'),
('sql_screenshots', 16, '2025-04-14 16:52:05', 'id_b502d104c134429f', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "101553185_1744620725000_83341608_1744620725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2a028e024dc54073b8df317e16783c64.jpg", "device_id": "837b18e3-18db-46da-99dc-6827824c7256", "is_chatting": 1, "label_rate": 1, "log_seq": "4d93f6eece674e7b950390c4d40b0706", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "101553185"}', '2025-04-14 16:52:05', 1744620725000, '2025-04-14 16:52:05'),
('sql_screenshots', 16, '2025-04-14 16:53:05', 'id_0ba6365e07354f33', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109980113_1744620785000_57649476_1744620785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/90e2585a840446d59cccfb1e62b2512a.jpg", "device_id": "ff44ff16-5362-4a1b-a4ba-874e0aa364e4", "is_chatting": 1, "label_rate": 1, "log_seq": "b9e8102fb45547b4bcf4ebdffb5935b9", "phone_model": "Huawei_P40", "rate": 5, "target_id": "109980113"}', '2025-04-14 16:53:05', 1744620785000, '2025-04-14 16:53:05'),
('sql_screenshots', 16, '2025-04-14 16:54:05', 'id_31111ab893454af6', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744620845000_110892617_1744620845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/77e43fc1968d44fe9af77bab690be97d.jpg", "device_id": "51696365-fd86-4335-bc94-9a19906c2a0b", "is_chatting": 1, "label_rate": 0, "log_seq": "98842f42070c4d3f995b8390f07c15a3", "phone_model": "Samsung_S22", "rate": 0, "target_id": "109657261"}', '2025-04-14 16:54:05', 1744620845000, '2025-04-14 16:54:05'),
('sql_screenshots', 16, '2025-04-14 16:55:05', 'id_d6ee68d455424d0e', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109980113_1744620905000_107039703_1744620905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/46734a8cabef4d17b4657f11e4982ff4.jpg", "device_id": "a5467c2a-4ab3-40df-8b44-8b7788ac3583", "is_chatting": 1, "label_rate": 2, "log_seq": "933c7c2c81fb44b993d9e40206584635", "phone_model": "Samsung_S21", "rate": 3, "target_id": "109980113"}', '2025-04-14 16:55:05', 1744620905000, '2025-04-14 16:55:05'),
('sql_screenshots', 16, '2025-04-14 16:56:05', 'id_ca4d3d51fe284539', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "32970671_1744620965000_109980113_1744620965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5679dc3e5c7643de9e0c1fb1549c0670.jpg", "device_id": "8d7bf2e6-b6b4-4a65-a15a-6550dd94fa41", "is_chatting": 1, "label_rate": 0, "log_seq": "8602ea269f7d45daae7b4ca004f8c526", "phone_model": "VIVO_X60", "rate": 5, "target_id": "32970671"}', '2025-04-14 16:56:05', 1744620965000, '2025-04-14 16:56:05'),
('sql_screenshots', 16, '2025-04-14 16:57:05', 'id_e8e1147e2a9544a8', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108466147_1744621025000_81479540_1744621025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/578162013a6d48fdb59ebf9fa7a98489.jpg", "device_id": "2e44e7c4-8415-4fd3-bcae-99e2cbb941bd", "is_chatting": 1, "label_rate": 0, "log_seq": "30ff31c1b0be4f34aa3acd1e2c101f58", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "108466147"}', '2025-04-14 16:57:05', 1744621025000, '2025-04-14 16:57:05'),
('sql_screenshots', 16, '2025-04-14 16:58:05', 'id_9d7c775b2c234a20', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "57649476_1744621085000_110890469_1744621085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/47ba1abe2dce47bfa3974ef313fd6268.jpg", "device_id": "93b2d070-1ee3-4fe5-9772-eede58986687", "is_chatting": 1, "label_rate": 2, "log_seq": "feb4bdfa596f46af89dd95178ebe96f4", "phone_model": "Samsung_S22", "rate": 3, "target_id": "57649476"}', '2025-04-14 16:58:05', 1744621085000, '2025-04-14 16:58:05'),
('sql_screenshots', 16, '2025-04-14 16:59:05', 'id_cd6e1a401e9b4e5f', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108466147_1744621145000_54675542_1744621145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cda984f6977149c091ecd61cf4348493.jpg", "device_id": "40943f65-ac20-45ba-973a-44cd89643382", "is_chatting": 1, "label_rate": 2, "log_seq": "9adfa871a8244ca98d26d4f86b3aa553", "phone_model": "OPPO_CPH1937", "rate": 0, "target_id": "108466147"}', '2025-04-14 16:59:05', 1744621145000, '2025-04-14 16:59:05'),
('sql_screenshots', 16, '2025-04-14 17:00:05', 'id_fd8c3e2bde8d4f86', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110892617_1744621205000_109407413_1744621205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6449e339b44f4387bf666fece1dd628a.jpg", "device_id": "d23b9360-718b-438e-95ba-70fb9a564843", "is_chatting": 1, "label_rate": 1, "log_seq": "e2c992bc61e74df9ab994ccb21b53829", "phone_model": "VIVO_X60", "rate": 2, "target_id": "110892617"}', '2025-04-14 17:00:05', 1744621205000, '2025-04-14 17:00:05'),
('sql_screenshots', 2502, '2025-04-14 17:01:05', 'id_9acd00069ef748e4', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "107039703_1744621265000_110892617_1744621265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b173567d213f478a89e26af3b113f713.jpg", "device_id": "c5583561-c05e-445b-b12d-451492402145", "is_chatting": 1, "label_rate": 2, "log_seq": "8cc284f66b814b959e59aa755e68b9f6", "phone_model": "VIVO_X60", "rate": 2, "target_id": "107039703"}', '2025-04-14 17:01:05', 1744621265000, '2025-04-14 17:01:05'),
('sql_screenshots', 2502, '2025-04-14 17:02:05', 'id_886828467ee34bcd', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "32970671_1744621325000_109657261_1744621325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/57f1b9ae59794aaeb1fd105c2772289d.jpg", "device_id": "65c953ba-1f87-4e0c-b18a-0edbc26cd441", "is_chatting": 1, "label_rate": 1, "log_seq": "8215f5d814be48be9c782d352d7435c3", "phone_model": "OnePlus_9", "rate": 1, "target_id": "32970671"}', '2025-04-14 17:02:05', 1744621325000, '2025-04-14 17:02:05'),
('sql_screenshots', 2502, '2025-04-14 17:03:05', 'id_2f53ce99b6e34555', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "81479540_1744621385000_87571440_1744621385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6fb73c386ec24fa98035acdec301d6ad.jpg", "device_id": "71311d84-c2d6-435c-9545-28fb1be9b30e", "is_chatting": 1, "label_rate": 1, "log_seq": "35dcbe1bc9ec4ff6bc42ea9b361ab026", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "81479540"}', '2025-04-14 17:03:05', 1744621385000, '2025-04-14 17:03:05'),
('sql_screenshots', 2502, '2025-04-14 17:04:05', 'id_e0adec6cc5074bd6', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744621445000_101553185_1744621445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bb3741f3e9f84e7abfa95d3a86efb99e.jpg", "device_id": "67d01b09-fd77-4783-9e6c-cc6b12587ca2", "is_chatting": 1, "label_rate": 2, "log_seq": "a332ff38db0e448f8be6825af7562c21", "phone_model": "VIVO_X60", "rate": 4, "target_id": "81479540"}', '2025-04-14 17:04:05', 1744621445000, '2025-04-14 17:04:05'),
('sql_screenshots', 2502, '2025-04-14 17:05:05', 'id_104018378a444138', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744621505000_110892617_1744621505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/02ab5ae0d75e4781bc5866dda4769307.jpg", "device_id": "e4e463d2-506f-4260-b4cf-65b35a20c63e", "is_chatting": 1, "label_rate": 1, "log_seq": "4ad99c71559d4f7c9328d79052daf43b", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "87571440"}', '2025-04-14 17:05:05', 1744621505000, '2025-04-14 17:05:05'),
('sql_screenshots', 16, '2025-04-14 17:06:05', 'id_e995ed8084ce4227', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "54675542_1744621565000_110215081_1744621565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ae4dd02e46544198a27b12bbc62f1826.jpg", "device_id": "0df4b0ae-f913-492b-a73f-f0a4e4c875be", "is_chatting": 1, "label_rate": 2, "log_seq": "99cf31d59ade4f58be126ee87f95ba21", "phone_model": "VIVO_X60", "rate": 0, "target_id": "54675542"}', '2025-04-14 17:06:05', 1744621565000, '2025-04-14 17:06:05'),
('sql_screenshots', 16, '2025-04-14 17:07:05', 'id_3d43c77675b943da', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110766160_1744621625000_101553185_1744621625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7566d1ede6d94645a50abb4ff45fc265.jpg", "device_id": "3f542212-635d-49dc-8251-34c6dd46d45a", "is_chatting": 1, "label_rate": 0, "log_seq": "39def6f8689f4469bafd036be6631e9b", "phone_model": "iPhone_13", "rate": 4, "target_id": "110766160"}', '2025-04-14 17:07:05', 1744621625000, '2025-04-14 17:07:05'),
('sql_screenshots', 16, '2025-04-14 17:08:05', 'id_0a8ae74065224ebf', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "87571440_1744621685000_28230174_1744621685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e48f01fc82ea4c859d63228bced237a3.jpg", "device_id": "4e8d1bdd-2284-40f5-b19f-e555bb5c60e1", "is_chatting": 1, "label_rate": 2, "log_seq": "a2a954e3fa644bbcba113c0e876b171b", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "87571440"}', '2025-04-14 17:08:05', 1744621685000, '2025-04-14 17:08:05'),
('sql_screenshots', 16, '2025-04-14 17:09:05', 'id_0965af05b9124f38', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "101553185_1744621745000_57649476_1744621745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4da09c8f5a074937b0478773e8265ac0.jpg", "device_id": "407dc7ea-9244-4351-9aef-3bc34bbf518a", "is_chatting": 1, "label_rate": 0, "log_seq": "75e3c225ef654679a51ee8e5f8082363", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "101553185"}', '2025-04-14 17:09:05', 1744621745000, '2025-04-14 17:09:05'),
('sql_screenshots', 16, '2025-04-14 17:10:05', 'id_23549e0218f242b8', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "94369556_1744621805000_28230174_1744621805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/874eec3537fb4a138bbfbd49e293d03f.jpg", "device_id": "3e76aa8a-f9db-4b72-9656-0c21c5df2661", "is_chatting": 1, "label_rate": 2, "log_seq": "75491b3e1c514a8eae121982937b6616", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "94369556"}', '2025-04-14 17:10:05', 1744621805000, '2025-04-14 17:10:05'),
('sql_screenshots', 16, '2025-04-14 17:11:05', 'id_73fff4f2dd7541fe', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744621865000_109980113_1744621865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9a3b286e6ff9429e8be85635b0f32dfd.jpg", "device_id": "ac3a6fed-aa97-411f-bf74-2d8b4664122a", "is_chatting": 1, "label_rate": 2, "log_seq": "7a13b4babeef46be9dc305ec97b000b4", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "110876251"}', '2025-04-14 17:11:05', 1744621865000, '2025-04-14 17:11:05'),
('sql_screenshots', 16, '2025-04-14 17:12:05', 'id_dab5dd99925446e8', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "32970671_1744621925000_110876251_1744621925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/53233a980fc84f14a70077d5ef39bca6.jpg", "device_id": "5f2fd7ae-04c8-4e54-82bf-4d7f8775e92d", "is_chatting": 1, "label_rate": 2, "log_seq": "a7f73e019f4942fa9d1a07ac87ffe185", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "32970671"}', '2025-04-14 17:12:05', 1744621925000, '2025-04-14 17:12:05'),
('sql_screenshots', 16, '2025-04-14 17:13:05', 'id_b67c8452c1404a2d', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108870508_1744621985000_110766160_1744621985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/239501c5378a4bf1b0ce12986bc39217.jpg", "device_id": "21a4860c-7ac9-49ff-b7df-252b7be5a739", "is_chatting": 1, "label_rate": 2, "log_seq": "772053a837d4436199f6c0f39d563ca9", "phone_model": "Samsung_S22", "rate": 4, "target_id": "108870508"}', '2025-04-14 17:13:05', 1744621985000, '2025-04-14 17:13:05'),
('sql_screenshots', 16, '2025-04-14 17:14:05', 'id_fb02fd3b9af34ff9', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "28230174_1744622045000_94369556_1744622045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ef6593427c9d4c34ae3d9f2d437cae52.jpg", "device_id": "ba71ca54-195d-4585-8a93-b195e4cd67f7", "is_chatting": 1, "label_rate": 0, "log_seq": "ce34ca46f45c48fc8744b1a77e87e2c4", "phone_model": "Samsung_S22", "rate": 4, "target_id": "28230174"}', '2025-04-14 17:14:05', 1744622045000, '2025-04-14 17:14:05'),
('sql_screenshots', 16, '2025-04-14 17:15:05', 'id_3d49509f99ca455d', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105083641_1744622105000_32970671_1744622105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0cab27e1d59d4e00a4fc41f4f8ae34c2.jpg", "device_id": "1da31d11-b474-4261-be20-bb8f6b18de6a", "is_chatting": 1, "label_rate": 0, "log_seq": "ab02f3cd7d2d40779c61ef7142e26618", "phone_model": "VIVO_X60", "rate": 0, "target_id": "105083641"}', '2025-04-14 17:15:05', 1744622105000, '2025-04-14 17:15:05'),
('sql_screenshots', 16, '2025-04-14 17:16:05', 'id_62ebd005e5654f9a', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744622165000_109657261_1744622165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ef0965550a524ffa953b6bbbee692e35.jpg", "device_id": "0abb0b17-ac31-4e2c-a8e8-109702e3fc41", "is_chatting": 1, "label_rate": 0, "log_seq": "2fa9925b69414b759a96fe9c4683a688", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "110873051"}', '2025-04-14 17:16:05', 1744622165000, '2025-04-14 17:16:05'),
('sql_screenshots', 16, '2025-04-14 17:17:05', 'id_01981fd4385e4d42', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744622225000_82365582_1744622225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c0ee694813844c1f8df2e4b00dbd6539.jpg", "device_id": "b42a98e2-5a6e-4660-92b8-54275130e6dc", "is_chatting": 1, "label_rate": 1, "log_seq": "14eb008d307d4b9480c60180cf9dfae4", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "64280379"}', '2025-04-14 17:17:05', 1744622225000, '2025-04-14 17:17:05'),
('sql_screenshots', 16, '2025-04-14 17:18:05', 'id_5ce4adb9e19b4f0e', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "94369556_1744622285000_110876251_1744622285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3fb6930a28c04734a1d20c4f8d36b5c3.jpg", "device_id": "493ce0a9-b776-4b3d-9580-4cf191f651ab", "is_chatting": 1, "label_rate": 0, "log_seq": "32a90832e1eb4d0d8ad137d861bb3a66", "phone_model": "iPhone_13", "rate": 1, "target_id": "94369556"}', '2025-04-14 17:18:05', 1744622285000, '2025-04-14 17:18:05'),
('sql_screenshots', 2502, '2025-04-14 17:19:05', 'id_d3aa57f0859b4be7', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105503656_1744622345000_82365582_1744622345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/08a2653c74db4e969ef89c26c3c493c9.jpg", "device_id": "71c00fcd-1e59-4ba0-9ce3-456098159594", "is_chatting": 1, "label_rate": 0, "log_seq": "1d2b5fe939734d5c9848201ab32cd669", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "105503656"}', '2025-04-14 17:19:05', 1744622345000, '2025-04-14 17:19:05'),
('sql_screenshots', 2502, '2025-04-14 17:20:05', 'id_306537228c234651', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105083641_1744622405000_107039703_1744622405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8c96d40d64584585813b22b41243b38e.jpg", "device_id": "7c284e9c-79ec-4540-a795-7c1f891c16c1", "is_chatting": 1, "label_rate": 0, "log_seq": "57d8dfbf79e24191873956abf89d8163", "phone_model": "Samsung_S21", "rate": 0, "target_id": "105083641"}', '2025-04-14 17:20:05', 1744622405000, '2025-04-14 17:20:05'),
('sql_screenshots', 2502, '2025-04-14 17:21:05', 'id_169046753a0a43db', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "57649476_1744622465000_109744448_1744622465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9df10c5e323246dcaf0d90cdc96cfe26.jpg", "device_id": "449c5be8-a056-4fce-ae2a-c276ff1ce2b6", "is_chatting": 1, "label_rate": 0, "log_seq": "08556efca75d4b4aa33426b40ec16a3e", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "57649476"}', '2025-04-14 17:21:05', 1744622465000, '2025-04-14 17:21:05'),
('sql_screenshots', 2502, '2025-04-14 17:22:05', 'id_f649a381efcb4f43', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110892617_1744622525000_87571440_1744622525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2ff7edf0c70f4c129cb4771b09200c05.jpg", "device_id": "f2a4ff76-ad9e-4142-9814-14c0dbc98ce5", "is_chatting": 1, "label_rate": 0, "log_seq": "46b1328ec5e248a684781e4a2c6bd886", "phone_model": "VIVO_X60", "rate": 4, "target_id": "110892617"}', '2025-04-14 17:22:05', 1744622525000, '2025-04-14 17:22:05'),
('sql_screenshots', 2502, '2025-04-14 17:23:05', 'id_214d3374225f4f80', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "101553185_1744622585000_81479540_1744622585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5301a4b7d26c40bfb4e75f198818b94b.jpg", "device_id": "10e40b86-abc9-4161-95e9-67680a187081", "is_chatting": 1, "label_rate": 1, "log_seq": "b958851d071b4e5ea7ea545ddf2029a5", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "101553185"}', '2025-04-14 17:23:05', 1744622585000, '2025-04-14 17:23:05'),
('sql_screenshots', 2502, '2025-04-14 17:24:05', 'id_747b1a14f9e84258', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105083641_1744622645000_54675542_1744622645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/81b77e6bc91e49ce85afa977b694e2bf.jpg", "device_id": "a3b53f61-8a96-4a94-803d-911222de9152", "is_chatting": 1, "label_rate": 1, "log_seq": "2f06bc91a2634ba6a7c7372296127d5b", "phone_model": "OnePlus_9", "rate": 3, "target_id": "105083641"}', '2025-04-14 17:24:05', 1744622645000, '2025-04-14 17:24:05'),
('sql_screenshots', 2502, '2025-04-14 17:25:05', 'id_8f43d3f266ec4e86', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109657261_1744622705000_105083641_1744622705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/db6b242358a3483297bd807316909076.jpg", "device_id": "a6357342-3e77-4f52-8232-6c2e4d700016", "is_chatting": 1, "label_rate": 2, "log_seq": "af23056b2d9b4feea5464ea9d1862530", "phone_model": "iPhone_13", "rate": 4, "target_id": "109657261"}', '2025-04-14 17:25:05', 1744622705000, '2025-04-14 17:25:05'),
('sql_screenshots', 16, '2025-04-14 17:26:05', 'id_8ddd7e4aceeb46f4', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744622765000_110876251_1744622765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/96106f09246c4fa9bc960485341df727.jpg", "device_id": "b7f33835-d63c-4c18-a1f3-428cdefbb14e", "is_chatting": 1, "label_rate": 0, "log_seq": "805afe80cfab430ca489bf9dcb5a9411", "phone_model": "iPhone_13", "rate": 5, "target_id": "64280379"}', '2025-04-14 17:26:05', 1744622765000, '2025-04-14 17:26:05'),
('sql_screenshots', 16, '2025-04-14 17:27:05', 'id_9cd4efe48a20431c', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109980113_1744622825000_107039703_1744622825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/90aa8153ed414e4a9e67ce6c793b2594.jpg", "device_id": "c278ff71-65c7-463f-a32a-99743863c429", "is_chatting": 1, "label_rate": 1, "log_seq": "f00165d79cf34ce6b18e335815b785fa", "phone_model": "Samsung_S21", "rate": 3, "target_id": "109980113"}', '2025-04-14 17:27:05', 1744622825000, '2025-04-14 17:27:05'),
('sql_screenshots', 16, '2025-04-14 17:28:05', 'id_2bb0f41993574884', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "101553185_1744622885000_87571440_1744622885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d8c0ea83ef2f491aa639fc473943d9cb.jpg", "device_id": "4f2b4215-2098-44f2-9236-1970f8537979", "is_chatting": 1, "label_rate": 1, "log_seq": "c77d7b2a2d3d499aa5762829e036049b", "phone_model": "VIVO_X60", "rate": 4, "target_id": "101553185"}', '2025-04-14 17:28:05', 1744622885000, '2025-04-14 17:28:05'),
('sql_screenshots', 16, '2025-04-14 17:29:05', 'id_e2c02b70abf4492e', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110876251_1744622945000_81479540_1744622945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/77f1f5fed60f414e9c73c6efdf67453b.jpg", "device_id": "114ae5fb-d9c9-4a04-b952-2196bfdeb97e", "is_chatting": 1, "label_rate": 2, "log_seq": "8af4d63116bb4ede971a79cee2b40bab", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "110876251"}', '2025-04-14 17:29:05', 1744622945000, '2025-04-14 17:29:05'),
('sql_screenshots', 16, '2025-04-14 17:30:05', 'id_a7b4a0a622c445d7', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105083641_1744623005000_54675542_1744623005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5c8f46e5022a4e478a54385d2aad3982.jpg", "device_id": "07ecafc5-bcd9-43db-b806-dea1c799ef44", "is_chatting": 1, "label_rate": 0, "log_seq": "43345f17ae714a9fa2fceef0dbf4e6e8", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "105083641"}', '2025-04-14 17:30:05', 1744623005000, '2025-04-14 17:30:05'),
('sql_screenshots', 16, '2025-04-14 17:31:05', 'id_8aca81ef162e4b94', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "57649476_1744623065000_104844318_1744623065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/eaf0d5095d61479fbe9d9fc6c692f28e.jpg", "device_id": "e1f07b7e-d82e-4dee-b4ae-ed899c2b1b17", "is_chatting": 1, "label_rate": 1, "log_seq": "431a368cb45c41589c3729f4bd3ecce3", "phone_model": "Huawei_P40", "rate": 0, "target_id": "57649476"}', '2025-04-14 17:31:05', 1744623065000, '2025-04-14 17:31:05'),
('sql_screenshots', 16, '2025-04-14 17:32:05', 'id_bc447e71fcfa4892', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105083641_1744623125000_83341608_1744623125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f15bae72872743cb8e3c29a97da41f2f.jpg", "device_id": "b052ff76-dec2-4a33-a422-bdddbfa798ba", "is_chatting": 1, "label_rate": 2, "log_seq": "1e9c095a59ea46138c6c71d5ad76bee6", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "105083641"}', '2025-04-14 17:32:05', 1744623125000, '2025-04-14 17:32:05'),
('sql_screenshots', 16, '2025-04-14 17:33:05', 'id_ad495f2768194699', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109407413_1744623185000_32970671_1744623185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1cd0238e6be444c8aba03cb1fff75737.jpg", "device_id": "bed5d385-21a4-4aa4-ad02-5cd4bc1e8f49", "is_chatting": 1, "label_rate": 0, "log_seq": "25ffb380607d44e8aee31203cca55e2c", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "109407413"}', '2025-04-14 17:33:05', 1744623185000, '2025-04-14 17:33:05'),
('sql_screenshots', 16, '2025-04-14 17:34:05', 'id_55f71f700e984163', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "83341608_1744623245000_105083641_1744623245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/37d1d5a4ecdb46eba971166fd27a6d8a.jpg", "device_id": "3c5824ac-ac7c-4fcd-9b59-2e1eb38814a6", "is_chatting": 1, "label_rate": 0, "log_seq": "e951549270db49dead3816ade7da662c", "phone_model": "iPhone_13", "rate": 2, "target_id": "83341608"}', '2025-04-14 17:34:05', 1744623245000, '2025-04-14 17:34:05'),
('sql_screenshots', 16, '2025-04-14 17:35:05', 'id_6df2253b02b64a96', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744623305000_54675542_1744623305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d122536cde674a109c9317992c6fbf06.jpg", "device_id": "e6a0061d-d7bd-44aa-ad02-b2e2d8381734", "is_chatting": 1, "label_rate": 0, "log_seq": "4eee1cd6b1544a5fb3014ab854196b09", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "109657261"}', '2025-04-14 17:35:05', 1744623305000, '2025-04-14 17:35:05'),
('sql_screenshots', 16, '2025-04-14 17:36:05', 'id_d1846504bfa940fc', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744623365000_110892617_1744623365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/908a34c983e34cc3adc43050cde53173.jpg", "device_id": "b2c1b5b1-364e-4e0d-8ef4-f4ac77afac3b", "is_chatting": 1, "label_rate": 1, "log_seq": "eb01400a0e904581a5d96ad269eba4c1", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "81479540"}', '2025-04-14 17:36:05', 1744623365000, '2025-04-14 17:36:05'),
('sql_screenshots', 2502, '2025-04-14 17:37:05', 'id_91869623c1f04c1d', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105503656_1744623425000_109980113_1744623425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/28d87ffc140b48bdbff4fe2477c857e6.jpg", "device_id": "71ebe984-8242-4c30-9b27-28f1524a0954", "is_chatting": 1, "label_rate": 2, "log_seq": "94e477be6ddd48a18757032c1217236f", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "105503656"}', '2025-04-14 17:37:05', 1744623425000, '2025-04-14 17:37:05'),
('sql_screenshots', 2502, '2025-04-14 17:38:05', 'id_8c4ad566ed29468e', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "64280379_1744623485000_110876251_1744623485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6cfa673258714336b0ba31ef32b9fb1c.jpg", "device_id": "a6db104f-7cf2-4dc9-8e29-51b527bf0d0f", "is_chatting": 1, "label_rate": 0, "log_seq": "e9aaa489a32a4cab997df3a2bca0eaff", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "64280379"}', '2025-04-14 17:38:05', 1744623485000, '2025-04-14 17:38:05'),
('sql_screenshots', 2502, '2025-04-14 17:39:05', 'id_e94a8f5108c04576', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744623545000_54675542_1744623545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e568ad2fd6584000b9825b6f555b3f7c.jpg", "device_id": "9449c571-93bf-42a7-8e0a-fc4ae247b468", "is_chatting": 1, "label_rate": 2, "log_seq": "4686b5e67f7f4160a50d114007694d05", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "110890469"}', '2025-04-14 17:39:05', 1744623545000, '2025-04-14 17:39:05'),
('sql_screenshots', 2502, '2025-04-14 17:40:05', 'id_2c41dde27aab40af', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105503656_1744623605000_109744448_1744623605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0a8ad0907f804374a82b8b508623aaac.jpg", "device_id": "796d2bad-a8ab-475a-a6fd-2715c0d97aab", "is_chatting": 1, "label_rate": 0, "log_seq": "2e2fbf4ed9ff40fa99524055b1aecbb1", "phone_model": "Samsung_S22", "rate": 4, "target_id": "105503656"}', '2025-04-14 17:40:05', 1744623605000, '2025-04-14 17:40:05'),
('sql_screenshots', 2502, '2025-04-14 17:41:05', 'id_26ae1d3130a84091', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "64280379_1744623665000_94369556_1744623665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0a41ef337a5b41d580e96ef2cc61a368.jpg", "device_id": "a58bd396-44cd-4f6f-a0e4-549af3b98291", "is_chatting": 1, "label_rate": 2, "log_seq": "aac5ae2914e04c77a2adc96c802d15f6", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "64280379"}', '2025-04-14 17:41:05', 1744623665000, '2025-04-14 17:41:05'),
('sql_screenshots', 2502, '2025-04-14 17:42:05', 'id_4258b4b732fd4378', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "32970671_1744623725000_108466147_1744623725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/323c3d91f7d34de99c704e0a3e3938b5.jpg", "device_id": "99761362-6699-4acc-b3ca-52a8d2c5f14b", "is_chatting": 1, "label_rate": 1, "log_seq": "c71d667b812a45fc8ccbd9e1156ce081", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "32970671"}', '2025-04-14 17:42:05', 1744623725000, '2025-04-14 17:42:05'),
('sql_screenshots', 2502, '2025-04-14 17:43:05', 'id_8c0faa3561be47cb', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "94369556_1744623785000_108870508_1744623785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3f327ea1098a4f5d935fd9c55aec1206.jpg", "device_id": "edcd31a0-d73a-4c60-835a-27c5d55f79fe", "is_chatting": 1, "label_rate": 0, "log_seq": "831199c86d6f41c099282a6481e541cf", "phone_model": "iPhone_13", "rate": 3, "target_id": "94369556"}', '2025-04-14 17:43:05', 1744623785000, '2025-04-14 17:43:05'),
('sql_screenshots', 2502, '2025-04-14 17:44:05', 'id_44bfe98e07c04718', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "28230174_1744623845000_54675542_1744623845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/885c3cae1f744d73a6aa161d26d71310.jpg", "device_id": "44cc85b1-983a-4299-bc16-95964f06bd91", "is_chatting": 1, "label_rate": 0, "log_seq": "d0c76dfebb1945fa8141b8c0440345b5", "phone_model": "OnePlus_9", "rate": 5, "target_id": "28230174"}', '2025-04-14 17:44:05', 1744623845000, '2025-04-14 17:44:05'),
('sql_screenshots', 16, '2025-04-14 17:45:05', 'id_d241babd6dab4ac9', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108870508_1744623905000_81479540_1744623905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4c6987ac954d47179f83a20b1d7de7ea.jpg", "device_id": "54e3d86f-e5ae-40e2-a899-f3ceb57ff335", "is_chatting": 1, "label_rate": 0, "log_seq": "db94c2a0dda34327a23a4f3f64cf064c", "phone_model": "Samsung_S22", "rate": 3, "target_id": "108870508"}', '2025-04-14 17:45:05', 1744623905000, '2025-04-14 17:45:05'),
('sql_screenshots', 16, '2025-04-14 17:46:05', 'id_c768ebed09b64ea8', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108870508_1744623965000_28230174_1744623965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b2357fa1e3fa49dbbfb656cc078a4458.jpg", "device_id": "8bfdf3a2-e96d-47e1-a03b-a9185d5f550e", "is_chatting": 1, "label_rate": 1, "log_seq": "1db4a74ecd894c08a81c8999b6dd1b8e", "phone_model": "Huawei_P40", "rate": 2, "target_id": "108870508"}', '2025-04-14 17:46:05', 1744623965000, '2025-04-14 17:46:05'),
('sql_screenshots', 16, '2025-04-14 17:47:05', 'id_02e3a131315844e4', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744624025000_82365582_1744624025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e9fa2fceaed4402594929799fe5e86df.jpg", "device_id": "75318d7e-d37e-4d3d-b4e7-a5188567e8e3", "is_chatting": 1, "label_rate": 2, "log_seq": "ffad928a0c3c41f5a634204f9a1a66d8", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "110766160"}', '2025-04-14 17:47:05', 1744624025000, '2025-04-14 17:47:05'),
('sql_screenshots', 16, '2025-04-14 17:48:05', 'id_1e12a80d811b4ba4', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "54675542_1744624085000_81479540_1744624085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c536e5e2a4324838ac9dd466bb107149.jpg", "device_id": "55094ff2-8560-47cc-ac69-fee771ea20f2", "is_chatting": 1, "label_rate": 2, "log_seq": "11a6773c223e405ab0de2c2af8d00c5b", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "54675542"}', '2025-04-14 17:48:05', 1744624085000, '2025-04-14 17:48:05'),
('sql_screenshots', 16, '2025-04-14 17:49:05', 'id_0471a7a47d234ff9', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110215081_1744624145000_110892617_1744624145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/85dcd901708f4cb38ec1e66c07480126.jpg", "device_id": "e60973e4-d3ba-476e-b82c-02e9da646534", "is_chatting": 1, "label_rate": 2, "log_seq": "15e808c785544e708edf27d951c21b76", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "110215081"}', '2025-04-14 17:49:05', 1744624145000, '2025-04-14 17:49:05'),
('sql_screenshots', 2502, '2025-04-14 17:50:05', 'id_48333ad861704a5e', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109407413_1744624205000_110890469_1744624205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0b2e0f71e8dd4a32af91ae2d11295a2e.jpg", "device_id": "a3af5475-f005-40de-9d4f-55e6a611cd6b", "is_chatting": 1, "label_rate": 2, "log_seq": "dd21f91b60b2472283a2c08186c635bc", "phone_model": "Samsung_S22", "rate": 5, "target_id": "109407413"}', '2025-04-14 17:50:05', 1744624205000, '2025-04-14 17:50:05'),
('sql_screenshots', 16, '2025-04-14 17:51:05', 'id_ebfdf3f1528d4dcb', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744624265000_109744448_1744624265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/98f44b2516c74adb9ad4a05418e1d46e.jpg", "device_id": "9ed5a884-2c4a-4a3a-82d8-39cb93123431", "is_chatting": 1, "label_rate": 0, "log_seq": "97b0755545ad4697a6118e00662595dd", "phone_model": "VIVO_X60", "rate": 3, "target_id": "110873051"}', '2025-04-14 17:51:05', 1744624265000, '2025-04-14 17:51:05'),
('sql_screenshots', 16, '2025-04-14 17:52:05', 'id_1834b2c25dfd4577', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105083641_1744624325000_108466147_1744624325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/932a88c97c1341ec86599a5251086a17.jpg", "device_id": "5b98c460-a6df-4ba5-aa3c-c7062cb26159", "is_chatting": 1, "label_rate": 1, "log_seq": "bf1da2570c7d4ced993e9063c8b91b7f", "phone_model": "OnePlus_9", "rate": 4, "target_id": "105083641"}', '2025-04-14 17:52:05', 1744624325000, '2025-04-14 17:52:05'),
('sql_screenshots', 16, '2025-04-14 17:53:05', 'id_62fbc8eb00cf4e20', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110890469_1744624385000_110892617_1744624385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/90b57d724aba4d3fbb3a5c0a89a9809e.jpg", "device_id": "cb872c03-01b4-47a9-a64e-6a630e6cbdeb", "is_chatting": 1, "label_rate": 1, "log_seq": "692aa325ff9f45bf9ae73345df0b2098", "phone_model": "Samsung_S21", "rate": 5, "target_id": "110890469"}', '2025-04-14 17:53:05', 1744624385000, '2025-04-14 17:53:05'),
('sql_screenshots', 16, '2025-04-14 17:54:05', 'id_4abfb516cd5b4c09', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109657261_1744624445000_109407413_1744624445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d27e20a84a3547a2bb820fe9567a88aa.jpg", "device_id": "5dade98f-c260-4a48-8383-b9b189b2263f", "is_chatting": 1, "label_rate": 0, "log_seq": "5f044ddf372c45d79a416a2efb2ae30b", "phone_model": "VIVO_X60", "rate": 2, "target_id": "109657261"}', '2025-04-14 17:54:05', 1744624445000, '2025-04-14 17:54:05'),
('sql_screenshots', 16, '2025-04-14 17:55:05', 'id_3726f5d7877e4618', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744624505000_110215081_1744624505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/aa8e14a575ac4173b62191301eaa0278.jpg", "device_id": "70d5bae6-c12a-493b-92cf-36fefb3f9071", "is_chatting": 1, "label_rate": 2, "log_seq": "d6c020a5e6f448cd8f9154848e536869", "phone_model": "Samsung_S21", "rate": 1, "target_id": "32970671"}', '2025-04-14 17:55:05', 1744624505000, '2025-04-14 17:55:05'),
('sql_screenshots', 16, '2025-04-14 17:56:05', 'id_d19f855af3594aa1', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744624565000_109657261_1744624565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f6de0e5d2b8645568dafe7269d461ac1.jpg", "device_id": "052ec778-471b-4c10-823a-d2f5a11b8713", "is_chatting": 1, "label_rate": 0, "log_seq": "ed9c67ad400d436f8277e3e03b81f8d6", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "110873051"}', '2025-04-14 17:56:05', 1744624565000, '2025-04-14 17:56:05'),
('sql_screenshots', 16, '2025-04-14 17:57:05', 'id_bb8930a67bad47b9', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110873051_1744624625000_110892617_1744624625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ddc1400bd57e4344895e1fb2cef23a6d.jpg", "device_id": "4ced0296-2945-44d5-9d9c-1b64d5775a0b", "is_chatting": 1, "label_rate": 0, "log_seq": "0a4a83e3fbcd40ff99153a7b9a2a5e37", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "110873051"}', '2025-04-14 17:57:05', 1744624625000, '2025-04-14 17:57:05'),
('sql_screenshots', 2502, '2025-04-14 17:58:05', 'id_e52aab23371b497d', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108466147_1744624685000_32970671_1744624685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/55b31e09641b49aaaa41695029ead8f1.jpg", "device_id": "0f0e2af7-708e-4fa4-8de4-db9c2b8e2815", "is_chatting": 1, "label_rate": 2, "log_seq": "eb5a7f8208e1465aad3418d53cb4f025", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "108466147"}', '2025-04-14 17:58:05', 1744624685000, '2025-04-14 17:58:05'),
('sql_screenshots', 2503, '2025-04-14 17:59:05', 'id_03afd631a196486a', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "57649476_1744624745000_105083641_1744624745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/989754072dab4459a55d81ab24e86d34.jpg", "device_id": "0647e0ae-4b26-4414-b02c-ee687243f56d", "is_chatting": 1, "label_rate": 0, "log_seq": "1a7c35ea458b496eb27738d80a1a1d6a", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "57649476"}', '2025-04-14 17:59:05', 1744624745000, '2025-04-14 17:59:05'),
('sql_screenshots', 2503, '2025-04-14 18:00:05', 'id_e518a23b21f84e16', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110215081_1744624805000_101553185_1744624805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c4503b728fe5433b862aa7fed00a71b4.jpg", "device_id": "cdb1b2b7-69ba-4bdb-a151-724cc56f345e", "is_chatting": 1, "label_rate": 0, "log_seq": "fc07879d627d49da9986f4600e264543", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "110215081"}', '2025-04-14 18:00:05', 1744624805000, '2025-04-14 18:00:05'),
('sql_screenshots', 16, '2025-04-14 18:01:05', 'id_1168a105e1744ae1', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109744448_1744624865000_110215081_1744624865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0ae05517d79a4e3d966e78287a873691.jpg", "device_id": "b695a5db-374e-4942-ab61-bdff7c7c3ddc", "is_chatting": 1, "label_rate": 2, "log_seq": "fd21e20d5411462bbe056976959b296f", "phone_model": "VIVO_X60", "rate": 4, "target_id": "109744448"}', '2025-04-14 18:01:05', 1744624865000, '2025-04-14 18:01:05'),
('sql_screenshots', 16, '2025-04-14 18:02:05', 'id_d2231d0529044191', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "28230174_1744624925000_108466147_1744624925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/46254b8dad7f4f93b615834f3ada9bb0.jpg", "device_id": "515bdacc-fee6-4f02-885b-826ee55fdfdb", "is_chatting": 1, "label_rate": 1, "log_seq": "853705cb80cf4d7ba0cf71841ee489b6", "phone_model": "iPhone_13", "rate": 5, "target_id": "28230174"}', '2025-04-14 18:02:05', 1744624925000, '2025-04-14 18:02:05'),
('sql_screenshots', 16, '2025-04-14 18:03:05', 'id_dfe4bd39a1934001', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109407413_1744624985000_109744448_1744624985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6fbac6fd2b2440ffafc1d01c12493801.jpg", "device_id": "677df3ae-f4bd-4198-9557-e28ca32b14ae", "is_chatting": 1, "label_rate": 2, "log_seq": "7de2471a48534be09c3a0f45eccb1f4e", "phone_model": "Huawei_P40", "rate": 0, "target_id": "109407413"}', '2025-04-14 18:03:05', 1744624985000, '2025-04-14 18:03:05'),
('sql_screenshots', 16, '2025-04-14 18:04:05', 'id_4116e0d18d124b58', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110892617_1744625045000_108466147_1744625045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4c7b1395b5e04a0ea13d9a4879ccc2cb.jpg", "device_id": "7f295308-a92c-4713-86b3-f52f26fceea6", "is_chatting": 1, "label_rate": 2, "log_seq": "05937254f7414b7ead273412de80983f", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "110892617"}', '2025-04-14 18:04:05', 1744625045000, '2025-04-14 18:04:05'),
('sql_screenshots', 16, '2025-04-14 18:05:05', 'id_dafad50dc41745da', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "104844318_1744625105000_110892617_1744625105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/30e67993d27846ca957cce993caff8bb.jpg", "device_id": "876a9a1d-f173-4d63-ac8d-e318dd4a803c", "is_chatting": 1, "label_rate": 0, "log_seq": "620c3e3f1bac420a860259458a07064d", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "104844318"}', '2025-04-14 18:05:05', 1744625105000, '2025-04-14 18:05:05'),
('sql_screenshots', 16, '2025-04-14 18:06:05', 'id_0ff41940d4334ee1', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "32970671_1744625165000_83341608_1744625165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d2695bbe48a7493bbe37b1855f82619f.jpg", "device_id": "f38db6db-64be-4a70-abe2-373c45c25761", "is_chatting": 1, "label_rate": 2, "log_seq": "a3d25122126f420b9fd0465b314a57fa", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "32970671"}', '2025-04-14 18:06:05', 1744625165000, '2025-04-14 18:06:05'),
('sql_screenshots', 16, '2025-04-14 18:07:05', 'id_e6e286a7717b4bbc', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744625225000_109744448_1744625225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2ce47968405349359471f74ab063250c.jpg", "device_id": "a64ed9b1-8efd-4374-9b99-fef99af01846", "is_chatting": 1, "label_rate": 2, "log_seq": "ec8125ad77814e099f5b58489fd0359d", "phone_model": "iPhone_13", "rate": 2, "target_id": "81479540"}', '2025-04-14 18:07:05', 1744625225000, '2025-04-14 18:07:05'),
('sql_screenshots', 16, '2025-04-14 18:08:05', 'id_c01d5b661b8b4273', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744625285000_94369556_1744625285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/69943805ec6f4f268036a1e8d6210cfc.jpg", "device_id": "4f1b385b-de0c-4c38-ad86-edcc6f351b3b", "is_chatting": 1, "label_rate": 2, "log_seq": "782189e32bc84005b510ccb8c48faadf", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "110890469"}', '2025-04-14 18:08:05', 1744625285000, '2025-04-14 18:08:05'),
('sql_screenshots', 16, '2025-04-14 18:09:05', 'id_3164de862afd44b0', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "57649476_1744625345000_54675542_1744625345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9808bd652ba842eea9811178c87c8472.jpg", "device_id": "89470ec0-7f47-4f5b-af07-6a4b76fba457", "is_chatting": 1, "label_rate": 1, "log_seq": "533a1d63cf304e6d8c9050dfb42451b6", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "57649476"}', '2025-04-14 18:09:05', 1744625345000, '2025-04-14 18:09:05'),
('sql_screenshots', 2503, '2025-04-14 18:10:05', 'id_699d7205274e4b98', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744625405000_110215081_1744625405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/69c0e231eb1f42e0870b550385db6cb4.jpg", "device_id": "a1174f2f-fd97-4422-8eba-58fe45a99136", "is_chatting": 1, "label_rate": 2, "log_seq": "507b8c7ef3614a238aa63b698f5f7ac2", "phone_model": "VIVO_X60", "rate": 1, "target_id": "87571440"}', '2025-04-14 18:10:05', 1744625405000, '2025-04-14 18:10:05'),
('sql_screenshots', 2503, '2025-04-14 18:11:05', 'id_b546c630b015454d', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "94369556_1744625465000_104844318_1744625465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f906582d11ee47c79aba6c72f25003f9.jpg", "device_id": "2809af35-aff4-4131-b85f-dcf422a18e80", "is_chatting": 1, "label_rate": 1, "log_seq": "95559d77614247489f89503f67155497", "phone_model": "iPhone_13", "rate": 3, "target_id": "94369556"}', '2025-04-14 18:11:05', 1744625465000, '2025-04-14 18:11:05'),
('sql_screenshots', 2503, '2025-04-14 18:12:05', 'id_dd2cf9d23bc842dd', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108466147_1744625525000_109744448_1744625525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5fad26bf4f4043cbb8ec873ab3b1600e.jpg", "device_id": "ef49ff5c-499d-4749-972e-aa139c91e833", "is_chatting": 1, "label_rate": 0, "log_seq": "ced084e618564edf9446ef78203fb51a", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "108466147"}', '2025-04-14 18:12:05', 1744625525000, '2025-04-14 18:12:05'),
('sql_screenshots', 2503, '2025-04-14 18:13:05', 'id_30a9227ef5dc4dfb', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "54675542_1744625585000_32970671_1744625585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/da95700e60cf4857bceaa5dd0df099d5.jpg", "device_id": "c33c5c3a-2560-40a2-9ee0-b17ba6fbf75e", "is_chatting": 1, "label_rate": 2, "log_seq": "901ddefb455846a7adcb19e5a7456a07", "phone_model": "iPhone_13", "rate": 3, "target_id": "54675542"}', '2025-04-14 18:13:05', 1744625585000, '2025-04-14 18:13:05'),
('sql_screenshots', 2503, '2025-04-14 18:14:05', 'id_2b69c4f7aae04367', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "57649476_1744625645000_28230174_1744625645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9853daca934242f3a2f5e3401941a81a.jpg", "device_id": "53003abb-df46-4ca6-9fe5-492f40491cd4", "is_chatting": 1, "label_rate": 0, "log_seq": "b56fe31ec0474487b6e26d86cb1a265f", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "57649476"}', '2025-04-14 18:14:05', 1744625645000, '2025-04-14 18:14:05'),
('sql_screenshots', 2503, '2025-04-14 18:15:05', 'id_a88dd58ee8b94ffd', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "107039703_1744625705000_109407413_1744625705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/30978c1d5aee4d45813ec7ce4c446bdf.jpg", "device_id": "43d966d1-8c67-4003-abde-1dd67d8267c5", "is_chatting": 1, "label_rate": 0, "log_seq": "1c7b9b3d98d24e22b98f730a9bbd2987", "phone_model": "OnePlus_9", "rate": 4, "target_id": "107039703"}', '2025-04-14 18:15:05', 1744625705000, '2025-04-14 18:15:05'),
('sql_screenshots', 16, '2025-04-14 18:16:05', 'id_7947808a202946b2', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109657261_1744625765000_108870508_1744625765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/555c8a98da4a4c3b8bb686ee1aeeadd9.jpg", "device_id": "14781dc5-b645-4b71-897d-b630eb2e02e9", "is_chatting": 1, "label_rate": 0, "log_seq": "d2ddd6aaa37049dd8c02f54aa84d901a", "phone_model": "Samsung_S21", "rate": 4, "target_id": "109657261"}', '2025-04-14 18:16:05', 1744625765000, '2025-04-14 18:16:05'),
('sql_screenshots', 16, '2025-04-14 18:17:05', 'id_a2d7d128f1514435', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110766160_1744625825000_110890469_1744625825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/eae8784cea8c4aa3a9a3e5a3fbb82d2d.jpg", "device_id": "676edaae-47dc-42ad-8ad8-ef83ce918663", "is_chatting": 1, "label_rate": 0, "log_seq": "94ebb71301db4da69599edd7a62f5419", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "110766160"}', '2025-04-14 18:17:05', 1744625825000, '2025-04-14 18:17:05'),
('sql_screenshots', 16, '2025-04-14 18:18:05', 'id_da18ad45d04840b6', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110215081_1744625885000_82365582_1744625885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bf11b2b19a564eaba9dac7345aa55f3d.jpg", "device_id": "83da80bb-f989-411d-8ff0-402e5edd91f8", "is_chatting": 1, "label_rate": 2, "log_seq": "44b8bf4f9081494898eb04a844d4c187", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "110215081"}', '2025-04-14 18:18:05', 1744625885000, '2025-04-14 18:18:05'),
('sql_screenshots', 16, '2025-04-14 18:19:05', 'id_c7210a1f38c64929', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110215081_1744625945000_104844318_1744625945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3e6209b0a19c47258df21e5fd352fafe.jpg", "device_id": "994fec16-4c47-461c-a24e-50a37eafe52e", "is_chatting": 1, "label_rate": 0, "log_seq": "0d0cad0995c145b8b6cf8480bc3a2aca", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "110215081"}', '2025-04-14 18:19:05', 1744625945000, '2025-04-14 18:19:05'),
('sql_screenshots', 16, '2025-04-14 18:20:05', 'id_0bee0336075144f0', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "87571440_1744626005000_110873051_1744626005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4bc730682fc84d3b93b7dd0bf234488e.jpg", "device_id": "7ec57102-0c8f-4fcc-a4f0-824aebb504fe", "is_chatting": 1, "label_rate": 0, "log_seq": "c405b0dac4a94139ad104791ed480516", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "87571440"}', '2025-04-14 18:20:05', 1744626005000, '2025-04-14 18:20:05'),
('sql_screenshots', 16, '2025-04-14 18:21:05', 'id_14c6346e496e44c3', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110766160_1744626065000_110890469_1744626065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bb769bcd5dbb45d8a1c6d01f3e19bb0d.jpg", "device_id": "222358e7-5dc0-4278-b540-870a92c2f507", "is_chatting": 1, "label_rate": 1, "log_seq": "04cbeef19c5940a293a50193fe52becc", "phone_model": "Samsung_S21", "rate": 1, "target_id": "110766160"}', '2025-04-14 18:21:05', 1744626065000, '2025-04-14 18:21:05'),
('sql_screenshots', 2503, '2025-04-14 18:22:05', 'id_2c1b374f74844d1f', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744626125000_110873051_1744626125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ada3abadc5da46a9afcc22a0e73da416.jpg", "device_id": "1294a9e1-1bce-4727-940b-b48506470947", "is_chatting": 1, "label_rate": 2, "log_seq": "0c1888daf0f04792826f8daec5855d34", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "64280379"}', '2025-04-14 18:22:05', 1744626125000, '2025-04-14 18:22:05'),
('sql_screenshots', 16, '2025-04-14 18:23:05', 'id_db935a7410304755', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "32970671_1744626185000_110766160_1744626185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6264b0de16fe4bd4bf17989114c6432d.jpg", "device_id": "69acc64e-a669-4a45-81b1-25c2bdb70a77", "is_chatting": 1, "label_rate": 1, "log_seq": "7c3283d7c64a406eb8edda49ac30a54a", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "32970671"}', '2025-04-14 18:23:05', 1744626185000, '2025-04-14 18:23:05'),
('sql_screenshots', 16, '2025-04-14 18:24:05', 'id_54e01e1e7f48401d', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "64280379_1744626245000_110890469_1744626245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cb7cfe2763354854b0534de015b038f5.jpg", "device_id": "49e95a98-8bf6-49ee-b8ac-20760c6c42f8", "is_chatting": 1, "label_rate": 0, "log_seq": "e61cf2e11d02495e854a2932975b55d2", "phone_model": "Samsung_S21", "rate": 2, "target_id": "64280379"}', '2025-04-14 18:24:05', 1744626245000, '2025-04-14 18:24:05'),
('sql_screenshots', 16, '2025-04-14 18:25:05', 'id_462d806ce2c84652', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "28230174_1744626305000_107039703_1744626305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2b3e8d1e39a4415b81a81758f2e1ef0d.jpg", "device_id": "631a2261-ab7b-46d8-bc5c-4ebdf90ee06c", "is_chatting": 1, "label_rate": 2, "log_seq": "daa31f1bb0de426a9eb87e4657ea679c", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "28230174"}', '2025-04-14 18:25:05', 1744626305000, '2025-04-14 18:25:05'),
('sql_screenshots', 16, '2025-04-14 18:26:05', 'id_f9703fee343444c6', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110766160_1744626365000_81479540_1744626365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2f9f00ad155f48ab9049a3e81d48c2c0.jpg", "device_id": "58f199ba-11f5-400c-999f-ddf9365a0370", "is_chatting": 1, "label_rate": 2, "log_seq": "411bcdc7acfb4dda91bcefd9d867e109", "phone_model": "VIVO_X60", "rate": 2, "target_id": "110766160"}', '2025-04-14 18:26:05', 1744626365000, '2025-04-14 18:26:05'),
('sql_screenshots', 16, '2025-04-14 18:27:05', 'id_351be811b7c74284', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105083641_1744626425000_108466147_1744626425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/847214c98b5a4b8fac5ef6bbd92528cd.jpg", "device_id": "13016f26-5637-4a2e-aa71-ebfee3e16c93", "is_chatting": 1, "label_rate": 2, "log_seq": "3a4a66ed6f894f18b01275c571bc6b2a", "phone_model": "Samsung_S21", "rate": 5, "target_id": "105083641"}', '2025-04-14 18:27:05', 1744626425000, '2025-04-14 18:27:05'),
('sql_screenshots', 16, '2025-04-14 18:28:05', 'id_edece5247d384314', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108466147_1744626485000_105083641_1744626485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/13da878f9f414f01b5a91f216aa35aeb.jpg", "device_id": "487aae50-b270-43d3-835f-75b00f92a62e", "is_chatting": 1, "label_rate": 0, "log_seq": "15dec3dcdbca45fbba7e15482f5604c9", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "108466147"}', '2025-04-14 18:28:05', 1744626485000, '2025-04-14 18:28:05'),
('sql_screenshots', 16, '2025-04-14 18:29:05', 'id_2b44dc6b11a94973', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105083641_1744626545000_81479540_1744626545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6195866852344946b82bbabdbdf3ec19.jpg", "device_id": "9425dda3-52d3-49f0-90bb-76249365a96f", "is_chatting": 1, "label_rate": 2, "log_seq": "ce028bbff581448390c0c41c89f38a45", "phone_model": "Huawei_P40", "rate": 2, "target_id": "105083641"}', '2025-04-14 18:29:05', 1744626545000, '2025-04-14 18:29:05'),
('sql_screenshots', 16, '2025-04-14 18:30:05', 'id_70348a7802144027', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "107039703_1744626605000_109744448_1744626605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ff703a1029b94280bee11da274175dcd.jpg", "device_id": "561e79b0-44e6-498c-8435-14a79b6ad8f3", "is_chatting": 1, "label_rate": 0, "log_seq": "4f9bb36d1ce94228925c38adb86ef989", "phone_model": "Samsung_S22", "rate": 5, "target_id": "107039703"}', '2025-04-14 18:30:05', 1744626605000, '2025-04-14 18:30:05'),
('sql_screenshots', 16, '2025-04-14 18:31:05', 'id_2f85c31859ca48d9', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105083641_1744626665000_81479540_1744626665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/813d61c74e454880a95f08a72784aeb5.jpg", "device_id": "44ed3e9e-f153-4163-90e1-10eb01f38937", "is_chatting": 1, "label_rate": 2, "log_seq": "f108495998b24ae19d8b25be3ba505cb", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "105083641"}', '2025-04-14 18:31:05', 1744626665000, '2025-04-14 18:31:05'),
('sql_screenshots', 16, '2025-04-14 18:32:05', 'id_c1df2433f81a4054', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109657261_1744626725000_110892617_1744626725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/00658984585e40309363ab34bb927c5d.jpg", "device_id": "343bde76-0e04-4f14-9b32-6ffc37180cda", "is_chatting": 1, "label_rate": 2, "log_seq": "6936ddc56b6646a182d6573494dd17ab", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "109657261"}', '2025-04-14 18:32:05', 1744626725000, '2025-04-14 18:32:05'),
('sql_screenshots', 16, '2025-04-14 18:33:05', 'id_85d8c19454a34023', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "28230174_1744626785000_32970671_1744626785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cbf3b41d8a55491c8000460c4e34bd38.jpg", "device_id": "56ff4e63-e642-4bc5-bf1a-20d23acc6b1d", "is_chatting": 1, "label_rate": 1, "log_seq": "623633f7b4864ca4898b649363d9589b", "phone_model": "Samsung_S21", "rate": 2, "target_id": "28230174"}', '2025-04-14 18:33:05', 1744626785000, '2025-04-14 18:33:05'),
('sql_screenshots', 16, '2025-04-14 18:34:05', 'id_9a10d511741e4446', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109744448_1744626845000_94369556_1744626845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3cf1a512c38f42a1877b80852dc125b0.jpg", "device_id": "78f74e6a-2098-42bd-915a-539b4676c7fa", "is_chatting": 1, "label_rate": 2, "log_seq": "d5b285ea5a7e49288a462c9023221544", "phone_model": "Samsung_S22", "rate": 5, "target_id": "109744448"}', '2025-04-14 18:34:05', 1744626845000, '2025-04-14 18:34:05'),
('sql_screenshots', 16, '2025-04-14 18:35:05', 'id_946203024a15446d', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "81479540_1744626905000_83341608_1744626905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0772a7cdfef24ff6ab2fc27ee41ccc5c.jpg", "device_id": "9c26a325-c83d-4e90-ad94-f224487aed95", "is_chatting": 1, "label_rate": 2, "log_seq": "98585d7fac9b42b48202a1432fbb0ad4", "phone_model": "iPhone_13", "rate": 5, "target_id": "81479540"}', '2025-04-14 18:35:05', 1744626905000, '2025-04-14 18:35:05'),
('sql_screenshots', 16, '2025-04-14 18:36:05', 'id_08c763a27b764b54', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "104844318_1744626965000_109407413_1744626965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2fd57e978a2b4fb3805a4f8ee4df0eae.jpg", "device_id": "6f0f620c-44c1-4f79-900c-84bbdaf63d20", "is_chatting": 1, "label_rate": 2, "log_seq": "c5b28a78e175461589013166b358cc15", "phone_model": "OnePlus_9", "rate": 2, "target_id": "104844318"}', '2025-04-14 18:36:05', 1744626965000, '2025-04-14 18:36:05'),
('sql_screenshots', 16, '2025-04-14 18:37:05', 'id_eaf03cfa830a478f', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110215081_1744627025000_110892617_1744627025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c507f795a0de46988a4f019f99604eb6.jpg", "device_id": "69ccc850-3470-4aac-a2f8-d0f3da363be5", "is_chatting": 1, "label_rate": 2, "log_seq": "12ff98a062214da2a730229ca2ff9e1d", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "110215081"}', '2025-04-14 18:37:05', 1744627025000, '2025-04-14 18:37:05'),
('sql_screenshots', 16, '2025-04-14 18:38:05', 'id_f7b28899ad444b6e', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744627085000_107039703_1744627085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7fec91ea2d6043adb52c501c2d760ad4.jpg", "device_id": "6523f906-3fe0-43a1-af9f-9201c8446253", "is_chatting": 1, "label_rate": 2, "log_seq": "eaa3a519964e488a8f0e1a2216d7646d", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "109657261"}', '2025-04-14 18:38:05', 1744627085000, '2025-04-14 18:38:05'),
('sql_screenshots', 16, '2025-04-14 18:39:05', 'id_774444e334384fab', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110766160_1744627145000_28230174_1744627145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0bcbf649bacd451b97fdda0501f958ab.jpg", "device_id": "6ee36a1e-078b-4092-b2c3-80cd26e861aa", "is_chatting": 1, "label_rate": 1, "log_seq": "3349e4f5c57b4b969bd67a8d8105297a", "phone_model": "Huawei_P40", "rate": 0, "target_id": "110766160"}', '2025-04-14 18:39:05', 1744627145000, '2025-04-14 18:39:05'),
('sql_screenshots', 16, '2025-04-14 18:40:05', 'id_8c113b60a9534cb1', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105503656_1744627205000_110876251_1744627205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/57f12007cb3140928cb10ae9b310d540.jpg", "device_id": "2eb43693-388d-42a1-9677-7ed30686d6d2", "is_chatting": 1, "label_rate": 0, "log_seq": "f2e1b95f58624755960422b228fcccb7", "phone_model": "Samsung_S22", "rate": 1, "target_id": "105503656"}', '2025-04-14 18:40:05', 1744627205000, '2025-04-14 18:40:05'),
('sql_screenshots', 16, '2025-04-14 18:41:05', 'id_ceeea6eaec8043d5', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "57649476_1744627265000_110876251_1744627265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cd3afe92060c42c79b5eb34b060de40d.jpg", "device_id": "9c9cd8cf-c2e7-424b-8fbf-ee7a390f283b", "is_chatting": 1, "label_rate": 1, "log_seq": "a6e610c8334049ea8f28a67eaa79bab1", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "57649476"}', '2025-04-14 18:41:05', 1744627265000, '2025-04-14 18:41:05'),
('sql_screenshots', 16, '2025-04-14 18:42:05', 'id_9406fc113942406f', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108870508_1744627325000_82365582_1744627325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c8085078ea20483c8c563587780719d0.jpg", "device_id": "ab4aef4e-7763-41e3-bc4b-ee9d599d705a", "is_chatting": 1, "label_rate": 2, "log_seq": "4a1ee1ed970c49b7ba2063cffbe06488", "phone_model": "OnePlus_9", "rate": 3, "target_id": "108870508"}', '2025-04-14 18:42:05', 1744627325000, '2025-04-14 18:42:05'),
('sql_screenshots', 16, '2025-04-14 18:43:05', 'id_2e9ab76a35954655', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744627385000_108870508_1744627385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/eb0924f2baf04921a3e4473953c207f6.jpg", "device_id": "50307fbd-d5f4-4f31-a432-13b10f6e9a9e", "is_chatting": 1, "label_rate": 2, "log_seq": "399f3677088a45e9afd3d948ba1ccc1c", "phone_model": "Huawei_P40", "rate": 5, "target_id": "110890469"}', '2025-04-14 18:43:05', 1744627385000, '2025-04-14 18:43:05'),
('sql_screenshots', 16, '2025-04-14 18:44:05', 'id_5e9a670f6c614253', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "101553185_1744627445000_104844318_1744627445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f8c177125e944ad8a7de36d7d3140cdc.jpg", "device_id": "01fb7af1-c5fa-48bc-aa7e-f4a2f859075d", "is_chatting": 1, "label_rate": 1, "log_seq": "82e32c08a7f9460c9364bc7167d93000", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "101553185"}', '2025-04-14 18:44:05', 1744627445000, '2025-04-14 18:44:05'),
('sql_screenshots', 16, '2025-04-14 18:45:05', 'id_e2481f57ca854a61', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109407413_1744627505000_110873051_1744627505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/60958e8645034fffb4138c381ff89e9e.jpg", "device_id": "3519f507-3091-4888-a929-c38a205bdc78", "is_chatting": 1, "label_rate": 2, "log_seq": "585ea2e264714e538180a48bcf65c127", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "109407413"}', '2025-04-14 18:45:05', 1744627505000, '2025-04-14 18:45:05'),
('sql_screenshots', 16, '2025-04-14 18:46:05', 'id_841108da3a7343e9', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108466147_1744627565000_110876251_1744627565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/54152769f7c5478a9324b2fba919792b.jpg", "device_id": "5ae5c70c-ca61-4a52-b680-361e97dd7405", "is_chatting": 1, "label_rate": 0, "log_seq": "cb9284f91e184c43a8e6bdbe6e3057c9", "phone_model": "iPhone_13", "rate": 0, "target_id": "108466147"}', '2025-04-14 18:46:05', 1744627565000, '2025-04-14 18:46:05'),
('sql_screenshots', 16, '2025-04-14 18:47:05', 'id_9570c8259acf4855', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "32970671_1744627625000_81479540_1744627625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/93d6a9e3ed49400fb94510ecdeb05c9c.jpg", "device_id": "e340c40e-2695-4173-bf62-99fa88081f14", "is_chatting": 1, "label_rate": 2, "log_seq": "023f870fcc294672b069720ceb930d36", "phone_model": "VIVO_X60", "rate": 2, "target_id": "32970671"}', '2025-04-14 18:47:05', 1744627625000, '2025-04-14 18:47:05'),
('sql_screenshots', 16, '2025-04-14 18:48:05', 'id_4f0f9b2eb9b34b4f', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110892617_1744627685000_109657261_1744627685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/95d3ba90a6a345fb9bb31d1e83c39a9a.jpg", "device_id": "54eada13-c048-4763-98ec-f53263f7d77b", "is_chatting": 1, "label_rate": 1, "log_seq": "8ba5a80a665a478a9056903a3abf7886", "phone_model": "Samsung_S22", "rate": 0, "target_id": "110892617"}', '2025-04-14 18:48:05', 1744627685000, '2025-04-14 18:48:05'),
('sql_screenshots', 16, '2025-04-14 18:49:05', 'id_0ed9300d31da438c', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108870508_1744627745000_110876251_1744627745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d7f87d3ef1784802855f3c2b56b79744.jpg", "device_id": "40441449-8cf1-45f4-a8ae-e2e09a0380f7", "is_chatting": 1, "label_rate": 2, "log_seq": "fc7c76810c7f47ad8d94309952b8f091", "phone_model": "VIVO_X60", "rate": 0, "target_id": "108870508"}', '2025-04-14 18:49:05', 1744627745000, '2025-04-14 18:49:05'),
('sql_screenshots', 16, '2025-04-14 18:50:05', 'id_b4f03b8561784dfd', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "81479540_1744627805000_110876251_1744627805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5e4bdf82d791453bb0463b0252cb00b1.jpg", "device_id": "c9dad648-56db-4847-aed7-a1b6f53d0c1c", "is_chatting": 1, "label_rate": 0, "log_seq": "fe8ce9610934461981242685eaa74996", "phone_model": "OnePlus_9", "rate": 5, "target_id": "81479540"}', '2025-04-14 18:50:05', 1744627805000, '2025-04-14 18:50:05'),
('sql_screenshots', 16, '2025-04-14 18:51:05', 'id_a07c5ad5bb3e48a1', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "101553185_1744627865000_110890469_1744627865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bdf5bd52d4be414eb9b5f03e326c736d.jpg", "device_id": "d975b675-01f8-40cc-90b2-6d02a13395c1", "is_chatting": 1, "label_rate": 0, "log_seq": "051b8709916247e2b9162f66d6beb67c", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "101553185"}', '2025-04-14 18:51:05', 1744627865000, '2025-04-14 18:51:05'),
('sql_screenshots', 16, '2025-04-14 18:52:05', 'id_11fbef80a18346a9', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105503656_1744627925000_110873051_1744627925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/00890aea61de4a7c815454dd523f9118.jpg", "device_id": "d2fd941c-8049-4cf1-883f-65a8d9b4ddbe", "is_chatting": 1, "label_rate": 1, "log_seq": "fb41003a4a4645ac94a974f5b0345696", "phone_model": "Samsung_S22", "rate": 1, "target_id": "105503656"}', '2025-04-14 18:52:05', 1744627925000, '2025-04-14 18:52:05'),
('sql_screenshots', 16, '2025-04-14 18:53:05', 'id_5d3e809f64f744b7', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "94369556_1744627985000_87571440_1744627985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8273b3f81e584677a7113447698a435d.jpg", "device_id": "74554953-bdf4-4865-84e6-132fd95feef2", "is_chatting": 1, "label_rate": 2, "log_seq": "4e206851615e451fae02e5175b17570b", "phone_model": "Samsung_S21", "rate": 2, "target_id": "94369556"}', '2025-04-14 18:53:05', 1744627985000, '2025-04-14 18:53:05'),
('sql_screenshots', 16, '2025-04-14 18:54:05', 'id_4094e352a23341a6', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "83341608_1744628045000_94369556_1744628045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/95f4c6a87e504341852508047a924a48.jpg", "device_id": "8e4b28de-531d-4c23-a66b-577e033d9191", "is_chatting": 1, "label_rate": 0, "log_seq": "b1cff93efc6d4bda895caf5b18a6c0a0", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "83341608"}', '2025-04-14 18:54:05', 1744628045000, '2025-04-14 18:54:05'),
('sql_screenshots', 16, '2025-04-14 18:55:05', 'id_d4610f5373684db8', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "101553185_1744628105000_109980113_1744628105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/59b399c8216c4fbd86efd5f714c29fe7.jpg", "device_id": "87fbb3dd-0a53-4ed8-b2bc-c21f4f70735d", "is_chatting": 1, "label_rate": 0, "log_seq": "54662c6d2a8d4e1eb98ea85a8ca1c8e1", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "101553185"}', '2025-04-14 18:55:05', 1744628105000, '2025-04-14 18:55:05'),
('sql_screenshots', 16, '2025-04-14 18:56:05', 'id_8184f19f40e8418d', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744628165000_110890469_1744628165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/fb116318f6054a2cab8ee6ead68fc125.jpg", "device_id": "fb1dc162-4bdd-444e-8b89-c3980312d372", "is_chatting": 1, "label_rate": 1, "log_seq": "5f70eaa6790342ca98e341ed954f3861", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "110876251"}', '2025-04-14 18:56:05', 1744628165000, '2025-04-14 18:56:05'),
('sql_screenshots', 16, '2025-04-14 18:57:05', 'id_54aee100ad084b55', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108466147_1744628225000_105083641_1744628225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4e875be08b154b3499292921cca8b15f.jpg", "device_id": "4c499ad8-ceca-496d-ac89-42138ee5d873", "is_chatting": 1, "label_rate": 0, "log_seq": "0f5a7cec590449ea8833050d30bbd2c8", "phone_model": "Samsung_S21", "rate": 4, "target_id": "108466147"}', '2025-04-14 18:57:05', 1744628225000, '2025-04-14 18:57:05'),
('sql_screenshots', 16, '2025-04-14 18:58:05', 'id_014e9327afea4c59', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744628285000_94369556_1744628285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/99d73892ef184d36a4c87ccfbadef7e1.jpg", "device_id": "40592b37-f808-4a1d-b3ab-a96f9401a788", "is_chatting": 1, "label_rate": 1, "log_seq": "a99cb4e4c4364c40838e9e5e21bd1932", "phone_model": "Samsung_S22", "rate": 4, "target_id": "110876251"}', '2025-04-14 18:58:05', 1744628285000, '2025-04-14 18:58:05'),
('sql_screenshots', 16, '2025-04-14 18:59:05', 'id_30fa5325a9434217', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "104844318_1744628345000_101553185_1744628345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6c7bb4c8f99e43b28a4004d88c3a2868.jpg", "device_id": "23cdcf72-7cc2-45eb-a346-de76e2240330", "is_chatting": 1, "label_rate": 1, "log_seq": "6299211bdb2f4b3397cd48d449eed856", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "104844318"}', '2025-04-14 18:59:05', 1744628345000, '2025-04-14 18:59:05'),
('sql_screenshots', 16, '2025-04-14 19:00:05', 'id_47329c21c0bc47bc', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744628405000_87571440_1744628405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/dc668aadf3ed48a1b188d4d6ea6a2595.jpg", "device_id": "3b451768-ef78-4638-9457-4f8dfb23233a", "is_chatting": 1, "label_rate": 1, "log_seq": "76cd16e39310438093856fe3480712bf", "phone_model": "Huawei_P40", "rate": 0, "target_id": "110766160"}', '2025-04-14 19:00:05', 1744628405000, '2025-04-14 19:00:05'),
('sql_screenshots', 16, '2025-04-14 19:01:05', 'id_9e3d0a39cb4d4b74', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105503656_1744628465000_54675542_1744628465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c8e4f0dc971b450e9ca44c6c9ef07f12.jpg", "device_id": "dea5a885-6102-4c1a-bb83-279c7bda23b0", "is_chatting": 1, "label_rate": 0, "log_seq": "1b01fd39d4d24e8ea19f6640b5a3ef26", "phone_model": "Huawei_P40", "rate": 0, "target_id": "105503656"}', '2025-04-14 19:01:05', 1744628465000, '2025-04-14 19:01:05'),
('sql_screenshots', 16, '2025-04-14 19:02:05', 'id_aae4b60f513d4396', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "83341608_1744628525000_54675542_1744628525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b8c1e4eb697348868a4f5762bfdaea29.jpg", "device_id": "6190dadf-d14c-48f5-86c9-2e84d96fdf66", "is_chatting": 1, "label_rate": 2, "log_seq": "6e9b55dc84954cfba3b16c737c3c2263", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "83341608"}', '2025-04-14 19:02:05', 1744628525000, '2025-04-14 19:02:05'),
('sql_screenshots', 16, '2025-04-14 19:03:05', 'id_4df0cfa2a03847d9', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110215081_1744628585000_110876251_1744628585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8c9e8737bf3144eab5503e241598d7be.jpg", "device_id": "c2a8bc8b-a6b1-4e99-ab52-f96ae1bd6cc3", "is_chatting": 1, "label_rate": 1, "log_seq": "ca7f5a6e0f9e4ba89cfd6c2f82f7da27", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "110215081"}', '2025-04-14 19:03:05', 1744628585000, '2025-04-14 19:03:05'),
('sql_screenshots', 16, '2025-04-14 19:04:05', 'id_041d42b5d3e14dde', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110892617_1744628645000_108466147_1744628645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/23fb070987af4169b1921c2536a3e43c.jpg", "device_id": "83913f99-9f69-4cb1-a006-36e5b81afd6c", "is_chatting": 1, "label_rate": 0, "log_seq": "7a8cf9c5944e4037a135eaa1c37d2bef", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "110892617"}', '2025-04-14 19:04:05', 1744628645000, '2025-04-14 19:04:05'),
('sql_screenshots', 16, '2025-04-14 19:05:05', 'id_9c6359bb4b714d6d', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744628705000_110890469_1744628705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/419c0749978f43caa0feac2f6c30c8f1.jpg", "device_id": "5a04b53f-c671-4667-a2fb-c48b042c246d", "is_chatting": 1, "label_rate": 2, "log_seq": "8d30a0ffd520458cac90b9dbc20e57a9", "phone_model": "Samsung_S21", "rate": 2, "target_id": "110876251"}', '2025-04-14 19:05:05', 1744628705000, '2025-04-14 19:05:05'),
('sql_screenshots', 16, '2025-04-14 19:06:05', 'id_602bff7476d94e22', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109744448_1744628765000_94369556_1744628765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c7f41ceea9974b648e40731a3bd183be.jpg", "device_id": "8adc1449-eea4-4a2b-b11d-3df8a1a42aaa", "is_chatting": 1, "label_rate": 1, "log_seq": "25ee11b4c59248278c87eb737c9bdf6f", "phone_model": "Samsung_S21", "rate": 5, "target_id": "109744448"}', '2025-04-14 19:06:05', 1744628765000, '2025-04-14 19:06:05'),
('sql_screenshots', 16, '2025-04-14 19:07:05', 'id_37bc4e527d964a1a', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108870508_1744628825000_82365582_1744628825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/75f65fa3b0bb4e00af61410a653fad9a.jpg", "device_id": "2c1ca006-dc61-43ff-894f-2bc12f7e6ce1", "is_chatting": 1, "label_rate": 0, "log_seq": "a04beb5a00f24a94a3a0aafbaf5c85ae", "phone_model": "Huawei_P40", "rate": 5, "target_id": "108870508"}', '2025-04-14 19:07:05', 1744628825000, '2025-04-14 19:07:05'),
('sql_screenshots', 16, '2025-04-14 19:08:05', 'id_e4f41d659b964a91', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "94369556_1744628885000_32970671_1744628885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a54b74ae5075414b839d38620929d25b.jpg", "device_id": "073d62fd-4a00-46c3-b3b9-0b4f887d2747", "is_chatting": 1, "label_rate": 1, "log_seq": "218b0b33250f42dbb39f128450946386", "phone_model": "Samsung_S22", "rate": 1, "target_id": "94369556"}', '2025-04-14 19:08:05', 1744628885000, '2025-04-14 19:08:05'),
('sql_screenshots', 16, '2025-04-14 19:09:05', 'id_733439182da1446f', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110890469_1744628945000_32970671_1744628945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/277e5f6e23424ee6ac419389ec6bcf78.jpg", "device_id": "95e6f10b-88c0-46fd-9ead-89476c42ae1a", "is_chatting": 1, "label_rate": 0, "log_seq": "a6a6b10bc187464a9113f020cd91dacc", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "110890469"}', '2025-04-14 19:09:05', 1744628945000, '2025-04-14 19:09:05'),
('sql_screenshots', 16, '2025-04-14 19:10:05', 'id_7c1cceb5195a4bcf', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109657261_1744629005000_109980113_1744629005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0cc423fedbe7464883ad19183d6b232e.jpg", "device_id": "b1032414-03aa-4239-b5af-64cf0983c11b", "is_chatting": 1, "label_rate": 1, "log_seq": "783a0ba02a5a41d6b5012bceaf222a2c", "phone_model": "OnePlus_9", "rate": 4, "target_id": "109657261"}', '2025-04-14 19:10:05', 1744629005000, '2025-04-14 19:10:05'),
('sql_screenshots', 16, '2025-04-14 19:11:05', 'id_91b08a7fe07b45a7', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "87571440_1744629065000_81479540_1744629065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a883f7ec95274b179997bbb5448c5b52.jpg", "device_id": "61586666-610d-4f7c-b256-f56dfae4f2e4", "is_chatting": 1, "label_rate": 0, "log_seq": "562aeb5aab534787a7c10a2f372e5bd5", "phone_model": "iPhone_13", "rate": 5, "target_id": "87571440"}', '2025-04-14 19:11:05', 1744629065000, '2025-04-14 19:11:05'),
('sql_screenshots', 16, '2025-04-14 19:12:05', 'id_029f423638d941d1', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "94369556_1744629125000_109657261_1744629125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a28a9e2cfc8d4feb86e3ba5ad7f46fbc.jpg", "device_id": "8d903393-0930-4917-a0b6-1a5aac9e226f", "is_chatting": 1, "label_rate": 2, "log_seq": "f9baf3d663814d46aa7b3f83d14d41a6", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "94369556"}', '2025-04-14 19:12:05', 1744629125000, '2025-04-14 19:12:05'),
('sql_screenshots', 16, '2025-04-14 19:13:05', 'id_7d876341b48d4c94', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "81479540_1744629185000_83341608_1744629185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3925d24c460c4057a839e4504c5952f2.jpg", "device_id": "e636ea7e-c59e-4601-8c96-6c9b0478740f", "is_chatting": 1, "label_rate": 2, "log_seq": "9f83c6afe74e4b5287b18fec124f0893", "phone_model": "Samsung_S22", "rate": 3, "target_id": "81479540"}', '2025-04-14 19:13:05', 1744629185000, '2025-04-14 19:13:05'),
('sql_screenshots', 16, '2025-04-14 19:14:05', 'id_4c7bfcfa6b29418e', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109980113_1744629245000_109407413_1744629245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cb20c4f7c2c84670a461fa72e0b8f892.jpg", "device_id": "f10601af-ebe8-4eea-879b-215d6773572f", "is_chatting": 1, "label_rate": 0, "log_seq": "24274b2a2884483a977d8692155abf39", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "109980113"}', '2025-04-14 19:14:05', 1744629245000, '2025-04-14 19:14:05'),
('sql_screenshots', 16, '2025-04-14 19:15:05', 'id_8927edbc7418487d', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "54675542_1744629305000_105083641_1744629305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/912ece12a63d4a37a2e01e73d8fd7653.jpg", "device_id": "fe7976db-04cc-475d-b3e4-5fc144c0a752", "is_chatting": 1, "label_rate": 1, "log_seq": "cd18bf0dc3ec45c5aadf2af99227bc19", "phone_model": "Samsung_S21", "rate": 4, "target_id": "54675542"}', '2025-04-14 19:15:05', 1744629305000, '2025-04-14 19:15:05'),
('sql_screenshots', 16, '2025-04-14 19:16:05', 'id_81fc34cc277944d4', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "104844318_1744629365000_105503656_1744629365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/761de629ccae4145bfeaeda002a0883d.jpg", "device_id": "fa4eb5a5-7586-4e5b-8193-8e953c15514d", "is_chatting": 1, "label_rate": 1, "log_seq": "f315bc72cd074fe5a22300a816d7665c", "phone_model": "OnePlus_9", "rate": 2, "target_id": "104844318"}', '2025-04-14 19:16:05', 1744629365000, '2025-04-14 19:16:05'),
('sql_screenshots', 16, '2025-04-14 19:17:05', 'id_6270400f74714da7', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744629425000_105503656_1744629425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d949e1c8b9b444ed9941a05655edd895.jpg", "device_id": "c9442910-630e-497f-83ad-0acc6bbab751", "is_chatting": 1, "label_rate": 0, "log_seq": "1dd9106e457f4e989b4714e3d2c035cf", "phone_model": "iPhone_13", "rate": 3, "target_id": "82365582"}', '2025-04-14 19:17:05', 1744629425000, '2025-04-14 19:17:05'),
('sql_screenshots', 16, '2025-04-14 19:18:05', 'id_581f8238bf044f23', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109407413_1744629485000_110876251_1744629485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/373f26efa46f4059a536b3f998d76343.jpg", "device_id": "35423e95-ce6c-43b9-bd76-674033ebdaef", "is_chatting": 1, "label_rate": 1, "log_seq": "3467511c387945e4b8f574276c3f96f5", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "109407413"}', '2025-04-14 19:18:05', 1744629485000, '2025-04-14 19:18:05'),
('sql_screenshots', 16, '2025-04-14 19:19:05', 'id_5fa794eadb014345', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110215081_1744629545000_110890469_1744629545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8817e5a78b674881bba7e145bde35b87.jpg", "device_id": "a3ac3a89-d4c3-4bff-bd49-0f5710f079d2", "is_chatting": 1, "label_rate": 1, "log_seq": "14bfe08677174d25badf450c0847f975", "phone_model": "OnePlus_9", "rate": 5, "target_id": "110215081"}', '2025-04-14 19:19:05', 1744629545000, '2025-04-14 19:19:05'),
('sql_screenshots', 16, '2025-04-14 19:20:05', 'id_83ed6a659d794a9d', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108466147_1744629605000_32970671_1744629605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/482c2b1de00f41a79cdb7c0416b5cf78.jpg", "device_id": "e8065564-3232-4342-8f25-528ccd743dea", "is_chatting": 1, "label_rate": 1, "log_seq": "330b810d7e7845b6b818ee7d14271a2a", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "108466147"}', '2025-04-14 19:20:05', 1744629605000, '2025-04-14 19:20:05'),
('sql_screenshots', 16, '2025-04-14 19:21:05', 'id_d3d06776b9504f82', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "82365582_1744629665000_108870508_1744629665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7cedd40974164944b8511d8ae0f11450.jpg", "device_id": "b75962f1-6627-4d78-bd2d-932c6458c812", "is_chatting": 1, "label_rate": 2, "log_seq": "b30efccab2d34e089e79075ecce1d296", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "82365582"}', '2025-04-14 19:21:05', 1744629665000, '2025-04-14 19:21:05'),
('sql_screenshots', 16, '2025-04-14 19:22:05', 'id_72180118e7a742cb', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110892617_1744629725000_105503656_1744629725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6b921264cc1942a1b4b77cd8e99e3d48.jpg", "device_id": "08bfa50f-e35d-4fcd-aa09-ebd34a80732f", "is_chatting": 1, "label_rate": 2, "log_seq": "c67003c02396427fa92a32818bd5a3c9", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "110892617"}', '2025-04-14 19:22:05', 1744629725000, '2025-04-14 19:22:05'),
('sql_screenshots', 16, '2025-04-14 19:23:05', 'id_d4a5a1f1d83643b7', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "57649476_1744629785000_109657261_1744629785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4eb5a5e6044447d099394ca9037571e9.jpg", "device_id": "dff77927-6e02-4d05-94f9-771d0017738e", "is_chatting": 1, "label_rate": 0, "log_seq": "2982d2fb02bf4818bf6641af092c962d", "phone_model": "Samsung_S22", "rate": 4, "target_id": "57649476"}', '2025-04-14 19:23:05', 1744629785000, '2025-04-14 19:23:05'),
('sql_screenshots', 16, '2025-04-14 19:24:05', 'id_22a43094307f4d48', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "107039703_1744629845000_83341608_1744629845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/72cf965b28e04458b970e3f75f7189cc.jpg", "device_id": "616aa53e-9dab-4e81-b5fc-653a45278428", "is_chatting": 1, "label_rate": 1, "log_seq": "7186627187fa40f8a2226e853c9531cd", "phone_model": "VIVO_X60", "rate": 5, "target_id": "107039703"}', '2025-04-14 19:24:05', 1744629845000, '2025-04-14 19:24:05'),
('sql_screenshots', 16, '2025-04-14 19:25:05', 'id_818362f6ef244753', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744629905000_110892617_1744629905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c72ed013d074483c8da1e8cd2d3bdc46.jpg", "device_id": "ed4a77f6-4ad2-42f8-a201-154827b8b647", "is_chatting": 1, "label_rate": 0, "log_seq": "f70a191b07234bfc81d76224aed8a057", "phone_model": "VIVO_X60", "rate": 5, "target_id": "32970671"}', '2025-04-14 19:25:05', 1744629905000, '2025-04-14 19:25:05'),
('sql_screenshots', 16, '2025-04-14 19:26:05', 'id_305b319a33a4486f', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110876251_1744629965000_110873051_1744629965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cf76dab2b50941f899d4d7737c63a818.jpg", "device_id": "29a0a04b-5970-4241-bda5-232326dddf00", "is_chatting": 1, "label_rate": 1, "log_seq": "d62fde281ac6432d80844c501786a3ec", "phone_model": "OnePlus_9", "rate": 0, "target_id": "110876251"}', '2025-04-14 19:26:05', 1744629965000, '2025-04-14 19:26:05'),
('sql_screenshots', 16, '2025-04-14 19:27:05', 'id_c855d24fb1a643d9', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744630025000_81479540_1744630025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5a46e751ff9f4ad5b1a8533d2fe1996c.jpg", "device_id": "50b3d376-859f-42d2-8fe3-74ed4fa01c16", "is_chatting": 1, "label_rate": 1, "log_seq": "91bdaf88ebe544ed85b2e3fdcb6886d8", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "108466147"}', '2025-04-14 19:27:05', 1744630025000, '2025-04-14 19:27:05'),
('sql_screenshots', 16, '2025-04-14 19:28:05', 'id_7e69784c3cbf4942', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105503656_1744630085000_109744448_1744630085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f71b64134e8248ddae15a1001e9287fc.jpg", "device_id": "3a48fc8f-e968-4d6d-a5c4-d49cdcf6a787", "is_chatting": 1, "label_rate": 2, "log_seq": "6246f0fc5e104986a1bf0a4feba72f55", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "105503656"}', '2025-04-14 19:28:05', 1744630085000, '2025-04-14 19:28:05'),
('sql_screenshots', 16, '2025-04-14 19:29:05', 'id_be202e61ec1c4df1', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "83341608_1744630145000_105503656_1744630145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6864aa4ca74f47d5b2a3e355e2348703.jpg", "device_id": "cc000864-3b7c-49e4-95fd-89c0f1ba77de", "is_chatting": 1, "label_rate": 1, "log_seq": "09968350f69944088adc02ac2f06a4f5", "phone_model": "Samsung_S22", "rate": 3, "target_id": "83341608"}', '2025-04-14 19:29:05', 1744630145000, '2025-04-14 19:29:05'),
('sql_screenshots', 16, '2025-04-14 19:30:05', 'id_44565f0cfebb47f8', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108466147_1744630205000_109744448_1744630205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c611f87950524557a0b3bbd914a6f5c9.jpg", "device_id": "8b5609bd-1cc2-4150-94a3-232e1cd89f47", "is_chatting": 1, "label_rate": 0, "log_seq": "58b28f6e85dd4b52ae9b0d5ffa6d6911", "phone_model": "Huawei_P40", "rate": 2, "target_id": "108466147"}', '2025-04-14 19:30:05', 1744630205000, '2025-04-14 19:30:05'),
('sql_screenshots', 16, '2025-04-14 19:31:05', 'id_43e56fea3b3b477f', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108870508_1744630265000_28230174_1744630265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/80987875dab74880a1c4ea5e254c71da.jpg", "device_id": "d4ee587e-7ade-4cf4-91e6-5578e78310dc", "is_chatting": 1, "label_rate": 2, "log_seq": "59504f8ffcb543ac8446aac60bbf5316", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "108870508"}', '2025-04-14 19:31:05', 1744630265000, '2025-04-14 19:31:05'),
('sql_screenshots', 16, '2025-04-14 19:32:05', 'id_31248b8a100348c3', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744630325000_109407413_1744630325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8048e367409d48a7ab30e059db0e0b26.jpg", "device_id": "0e8e983d-ae5d-4770-a595-4774112b737f", "is_chatting": 1, "label_rate": 1, "log_seq": "b7b1d2801867436fa5e5d74a702ca178", "phone_model": "OnePlus_9", "rate": 4, "target_id": "108466147"}', '2025-04-14 19:32:05', 1744630325000, '2025-04-14 19:32:05'),
('sql_screenshots', 16, '2025-04-14 19:33:05', 'id_e44fc58eb35d4194', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "82365582_1744630385000_101553185_1744630385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c8ec886097144388825e575495c21497.jpg", "device_id": "59a2579a-9b56-4dc0-bb17-12aadbca2ca5", "is_chatting": 1, "label_rate": 0, "log_seq": "bab9a3319a724cda949f979b12bff49f", "phone_model": "OnePlus_9", "rate": 2, "target_id": "82365582"}', '2025-04-14 19:33:05', 1744630385000, '2025-04-14 19:33:05'),
('sql_screenshots', 16, '2025-04-14 19:34:05', 'id_cadb22a12aa24d94', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "94369556_1744630445000_108466147_1744630445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4e65ada3211b4ea99ce4cacd41ccc21f.jpg", "device_id": "14448b80-4b6b-40c2-901e-df8a636a01b8", "is_chatting": 1, "label_rate": 1, "log_seq": "38c3cdf98ba34c4cbbcdba7608c71c96", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "94369556"}', '2025-04-14 19:34:05', 1744630445000, '2025-04-14 19:34:05'),
('sql_screenshots', 16, '2025-04-14 19:35:05', 'id_bf26530217b54a2f', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "57649476_1744630505000_107039703_1744630505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d00208c86e2345e09d54b0f3958b9681.jpg", "device_id": "ffb4bf22-df9c-49af-8b07-b2233d7463a6", "is_chatting": 1, "label_rate": 1, "log_seq": "4996a0aaaecb48928af8efac19409008", "phone_model": "Samsung_S22", "rate": 0, "target_id": "57649476"}', '2025-04-14 19:35:05', 1744630505000, '2025-04-14 19:35:05'),
('sql_screenshots', 16, '2025-04-14 19:36:05', 'id_dfa88fa62f1e469f', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "57649476_1744630565000_94369556_1744630565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c7e73ed5fd9b42f1bacbe6e6a76949c1.jpg", "device_id": "f526072f-8f5a-444f-84c7-671d933409f2", "is_chatting": 1, "label_rate": 2, "log_seq": "660705c60ad347edabdc4e0b5a533f68", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "57649476"}', '2025-04-14 19:36:05', 1744630565000, '2025-04-14 19:36:05'),
('sql_screenshots', 16, '2025-04-14 19:37:05', 'id_06bc5813c4ef41a0', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108870508_1744630625000_87571440_1744630625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e6498837bacf455385445a1afd9a949d.jpg", "device_id": "3a19550a-47b0-45a8-bb11-bfec40edc33e", "is_chatting": 1, "label_rate": 1, "log_seq": "43a88a700ae147b2806ea1ffe3f3e09c", "phone_model": "Huawei_P40", "rate": 0, "target_id": "108870508"}', '2025-04-14 19:37:05', 1744630625000, '2025-04-14 19:37:05'),
('sql_screenshots', 16, '2025-04-14 19:38:05', 'id_59f5c669a97b4842', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109980113_1744630685000_94369556_1744630685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e4abaf3a30a2479d9a978cbf52fc29d9.jpg", "device_id": "4e9d298d-0129-4b4c-82ef-a837089a4e15", "is_chatting": 1, "label_rate": 1, "log_seq": "2f9fe80891b34877a4a1356888e160ff", "phone_model": "iPhone_13", "rate": 5, "target_id": "109980113"}', '2025-04-14 19:38:05', 1744630685000, '2025-04-14 19:38:05'),
('sql_screenshots', 16, '2025-04-14 19:39:05', 'id_04d66989c74b4136', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110215081_1744630745000_110876251_1744630745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8776d8934a074c378700e4d4f84b4980.jpg", "device_id": "c514af99-9085-4d8a-8ac7-504c9427a90a", "is_chatting": 1, "label_rate": 2, "log_seq": "f38f45f9c5f34c99b1d8a03baf660fcb", "phone_model": "Samsung_S22", "rate": 1, "target_id": "110215081"}', '2025-04-14 19:39:05', 1744630745000, '2025-04-14 19:39:05'),
('sql_screenshots', 16, '2025-04-14 19:40:05', 'id_fbfa615eba5f461e', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109407413_1744630805000_105503656_1744630805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d9f28d71a867438587e54a4b5f78b3c7.jpg", "device_id": "c4b1b70e-05cd-46e4-907a-2d75c1cd9517", "is_chatting": 1, "label_rate": 0, "log_seq": "7b9aac0fe900440e86393426bc05afc9", "phone_model": "OnePlus_9", "rate": 2, "target_id": "109407413"}', '2025-04-14 19:40:05', 1744630805000, '2025-04-14 19:40:05'),
('sql_screenshots', 16, '2025-04-14 19:41:05', 'id_dd1868cfe73a4630', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "83341608_1744630865000_109980113_1744630865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/dae4d6f6119c420b922d6da653adbc0b.jpg", "device_id": "b053f133-4759-4462-adc8-59c508b3009c", "is_chatting": 1, "label_rate": 2, "log_seq": "8ddd56a893a6490c8032526d45cf9f50", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "83341608"}', '2025-04-14 19:41:05', 1744630865000, '2025-04-14 19:41:05'),
('sql_screenshots', 16, '2025-04-14 19:42:05', 'id_f3da689ddefa4c1b', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109980113_1744630925000_28230174_1744630925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7883a572fdf2488cacc502acd6368c42.jpg", "device_id": "649533b9-ad9c-4e96-8382-d71a11d60a09", "is_chatting": 1, "label_rate": 1, "log_seq": "56edf8bff6d14f19b52b4a5bc30d00cd", "phone_model": "Samsung_S22", "rate": 0, "target_id": "109980113"}', '2025-04-14 19:42:05', 1744630925000, '2025-04-14 19:42:05'),
('sql_screenshots', 16, '2025-04-14 19:43:05', 'id_311a90f0cc214b14', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744630985000_94369556_1744630985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4b43ff1f45d542329358fa6fb36ba318.jpg", "device_id": "eab9dbad-5e3b-4311-abd4-d58ac29e1b41", "is_chatting": 1, "label_rate": 2, "log_seq": "9e489c99e8a64d188dc2d80d693dfbd8", "phone_model": "VIVO_X60", "rate": 4, "target_id": "64280379"}', '2025-04-14 19:43:05', 1744630985000, '2025-04-14 19:43:05'),
('sql_screenshots', 16, '2025-04-14 19:44:05', 'id_4660e22ebb304aeb', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744631045000_110766160_1744631045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7f048100f4bf4a7e8f662a749df5d14d.jpg", "device_id": "c2622b60-f7c7-449a-8a92-936db64dc084", "is_chatting": 1, "label_rate": 1, "log_seq": "b2db1937607f46d487732fec5bbfa155", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "109657261"}', '2025-04-14 19:44:05', 1744631045000, '2025-04-14 19:44:05'),
('sql_screenshots', 16, '2025-04-14 19:45:05', 'id_e0a4f2e3254248db', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105083641_1744631105000_54675542_1744631105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9b1a1155011f44ff8072d4a7be07328e.jpg", "device_id": "c5276411-29a4-47e2-9f26-5515bdc16591", "is_chatting": 1, "label_rate": 2, "log_seq": "230568d400524cbda33134ab13b10b45", "phone_model": "iPhone_13", "rate": 0, "target_id": "105083641"}', '2025-04-14 19:45:05', 1744631105000, '2025-04-14 19:45:05'),
('sql_screenshots', 16, '2025-04-14 19:46:05', 'id_591aee2c5cb94348', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110876251_1744631165000_105503656_1744631165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/186a1c2d70824a17996c7a9a77317fe6.jpg", "device_id": "8485d91c-9265-4243-8af1-2c0fa8355f63", "is_chatting": 1, "label_rate": 0, "log_seq": "502cef4ab2a947a38955af5640a71fc1", "phone_model": "Samsung_S22", "rate": 5, "target_id": "110876251"}', '2025-04-14 19:46:05', 1744631165000, '2025-04-14 19:46:05'),
('sql_screenshots', 16, '2025-04-14 19:47:05', 'id_18c442589cca402c', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "87571440_1744631225000_109744448_1744631225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/dcf71dd1c3194f8591085f608159f7c6.jpg", "device_id": "59b1a0a7-e331-486d-9ba2-2e1d2a4012b9", "is_chatting": 1, "label_rate": 2, "log_seq": "808713e8c7694f098b8703bee06120c4", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "87571440"}', '2025-04-14 19:47:05', 1744631225000, '2025-04-14 19:47:05'),
('sql_screenshots', 16, '2025-04-14 19:48:05', 'id_8dfb77e45f9f4db8', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "83341608_1744631285000_109657261_1744631285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2e1b67124ed546af847291982d16eda3.jpg", "device_id": "3ef4a06a-2338-40f0-a099-df210b6e8b90", "is_chatting": 1, "label_rate": 2, "log_seq": "2fccef7d41234e8fbd33dde4f69eac78", "phone_model": "Samsung_S22", "rate": 2, "target_id": "83341608"}', '2025-04-14 19:48:05', 1744631285000, '2025-04-14 19:48:05'),
('sql_screenshots', 16, '2025-04-14 19:49:05', 'id_658ef7c4f58f4c85', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "32970671_1744631345000_28230174_1744631345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c2898271257b44bfa54eab30f3137dba.jpg", "device_id": "8f47d424-0f59-4fee-80fe-252191119a90", "is_chatting": 1, "label_rate": 0, "log_seq": "b1f2d5671d52443ba1eebfabeba8f073", "phone_model": "Huawei_P40", "rate": 4, "target_id": "32970671"}', '2025-04-14 19:49:05', 1744631345000, '2025-04-14 19:49:05'),
('sql_screenshots', 16, '2025-04-14 19:50:05', 'id_e7cc9345291b4110', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "107039703_1744631405000_94369556_1744631405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8b6d906a8fd44bfb8ff2c209af3c95e4.jpg", "device_id": "0ebbf99b-f5c1-4127-84e0-e109f0a3b837", "is_chatting": 1, "label_rate": 0, "log_seq": "6d6c4d40d96a48a4b8b67bc1c39bc4c8", "phone_model": "OnePlus_9", "rate": 4, "target_id": "107039703"}', '2025-04-14 19:50:05', 1744631405000, '2025-04-14 19:50:05'),
('sql_screenshots', 16, '2025-04-14 19:51:05', 'id_5b0364e74ac74c13', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110215081_1744631465000_81479540_1744631465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2c4eeb31bd384ac59e41f3031a8a08cc.jpg", "device_id": "004d61c7-f967-4bbe-a55e-8711740cac43", "is_chatting": 1, "label_rate": 0, "log_seq": "98c20e0b872b46d1880b1695f3b882b1", "phone_model": "OnePlus_9", "rate": 4, "target_id": "110215081"}', '2025-04-14 19:51:05', 1744631465000, '2025-04-14 19:51:05'),
('sql_screenshots', 16, '2025-04-14 19:52:05', 'id_e3739ac6e2a14028', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "94369556_1744631525000_28230174_1744631525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/396ed39943514ccdacdc56fed2925c91.jpg", "device_id": "e1d339bd-216e-4f07-989e-529c4b43743d", "is_chatting": 1, "label_rate": 1, "log_seq": "492783b9e6f0406784efe9fffa045bbc", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "94369556"}', '2025-04-14 19:52:05', 1744631525000, '2025-04-14 19:52:05'),
('sql_screenshots', 16, '2025-04-14 19:53:05', 'id_68cd2557e2bb4b70', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "101553185_1744631585000_109980113_1744631585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/24b79a076ae145feb0649698629c3350.jpg", "device_id": "e9e7e3e4-ae96-4363-8a56-5ff94b9ab32c", "is_chatting": 1, "label_rate": 2, "log_seq": "15ac8ce253624eb6b41167d0ebef934f", "phone_model": "Samsung_S22", "rate": 4, "target_id": "101553185"}', '2025-04-14 19:53:05', 1744631585000, '2025-04-14 19:53:05'),
('sql_screenshots', 16, '2025-04-14 19:54:05', 'id_ccd7bc0617b04a87', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "64280379_1744631645000_108466147_1744631645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a6ca59f8f1244228a8d83ca09b635135.jpg", "device_id": "87c39ea9-8732-4b67-a3bc-c6b8f227978b", "is_chatting": 1, "label_rate": 0, "log_seq": "c9cdb47ff2264b05a73879ce0c5bef96", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "64280379"}', '2025-04-14 19:54:05', 1744631645000, '2025-04-14 19:54:05'),
('sql_screenshots', 16, '2025-04-14 19:55:05', 'id_b379750ff763421e', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110876251_1744631705000_109657261_1744631705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a6880e36a8c14001ba870ff4f378f070.jpg", "device_id": "7a853f51-a1b5-4b4c-9298-0b413d00349d", "is_chatting": 1, "label_rate": 2, "log_seq": "d5f77b8844a04b45bdf5df81fdb63ef0", "phone_model": "iPhone_13", "rate": 2, "target_id": "110876251"}', '2025-04-14 19:55:05', 1744631705000, '2025-04-14 19:55:05'),
('sql_screenshots', 16, '2025-04-14 19:56:05', 'id_94c5985b61d745ca', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110892617_1744631765000_110215081_1744631765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/849f929ba9da40e1a39c4f667293ab35.jpg", "device_id": "3befbaf0-1ed0-4545-b552-5d7c3a546740", "is_chatting": 1, "label_rate": 0, "log_seq": "e7a9bf90f6cd485cb98a99b9636909e3", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "110892617"}', '2025-04-14 19:56:05', 1744631765000, '2025-04-14 19:56:05'),
('sql_screenshots', 16, '2025-04-14 19:57:05', 'id_73b468e02fb2409d', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744631825000_94369556_1744631825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/575f302d16a94254972e7e04b5d02af3.jpg", "device_id": "ce98e3a3-ae9a-4410-adcf-2617ac4ffa24", "is_chatting": 1, "label_rate": 2, "log_seq": "838bc6b1d674469384bcbf47b8ed387e", "phone_model": "VIVO_X60", "rate": 0, "target_id": "81479540"}', '2025-04-14 19:57:05', 1744631825000, '2025-04-14 19:57:05'),
('sql_screenshots', 16, '2025-04-14 19:58:05', 'id_6b56b930ce1e402c', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110890469_1744631885000_101553185_1744631885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bceae4328d294a8ba19cf71039819738.jpg", "device_id": "742ad0e1-873f-426b-aa02-7e91050cc308", "is_chatting": 1, "label_rate": 2, "log_seq": "664daf6555044233bd7ea9b9321eb39a", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "110890469"}', '2025-04-14 19:58:05', 1744631885000, '2025-04-14 19:58:05'),
('sql_screenshots', 16, '2025-04-14 19:59:05', 'id_8adfbd6cda764df2', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "57649476_1744631945000_104844318_1744631945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2dea11a985db44218078d36e87a98c9c.jpg", "device_id": "0bd82931-e134-41f5-ab0a-0ecbe532245d", "is_chatting": 1, "label_rate": 0, "log_seq": "94b2a9e3dfc640a5931a7a67a19c7799", "phone_model": "Huawei_P40", "rate": 2, "target_id": "57649476"}', '2025-04-14 19:59:05', 1744631945000, '2025-04-14 19:59:05'),
('sql_screenshots', 16, '2025-04-14 20:00:05', 'id_6a84c3b82781484b', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744632005000_105503656_1744632005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ec00b02615f7470e9a03843abd58067b.jpg", "device_id": "63357bf8-609d-415f-bab6-58d637f3fc80", "is_chatting": 1, "label_rate": 2, "log_seq": "9cfaf2ffee3d47319b852b89c0932f1f", "phone_model": "VIVO_X60", "rate": 3, "target_id": "110876251"}', '2025-04-14 20:00:05', 1744632005000, '2025-04-14 20:00:05'),
('sql_screenshots', 16, '2025-04-14 20:01:05', 'id_a1becebf7d3b4bea', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "83341608_1744632065000_107039703_1744632065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ad28f95b4974441d94c251d4fc4ad4a1.jpg", "device_id": "3afbda1f-dedf-41b7-b5d7-bd3d77f8a57c", "is_chatting": 1, "label_rate": 1, "log_seq": "863af51ffc9148d395c7c71943ba4a52", "phone_model": "iPhone_13", "rate": 4, "target_id": "83341608"}', '2025-04-14 20:01:05', 1744632065000, '2025-04-14 20:01:05'),
('sql_screenshots', 16, '2025-04-14 20:02:05', 'id_386cee9c49644809', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110873051_1744632125000_110890469_1744632125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/07abb400638f49b482b6512b48304a4c.jpg", "device_id": "7d8fecb6-1cee-4f73-ab64-2468d566d6ed", "is_chatting": 1, "label_rate": 2, "log_seq": "1bac871825db45248cf184c50209349f", "phone_model": "OnePlus_9", "rate": 2, "target_id": "110873051"}', '2025-04-14 20:02:05', 1744632125000, '2025-04-14 20:02:05'),
('sql_screenshots', 16, '2025-04-14 20:03:05', 'id_68ad16c1671c4f73', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "57649476_1744632185000_28230174_1744632185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9822f355f882468a8bd00f19b0af4282.jpg", "device_id": "0a80d364-d714-4a4e-8560-808dae88012f", "is_chatting": 1, "label_rate": 1, "log_seq": "8daab622ce62403186e55870ac1a6413", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "57649476"}', '2025-04-14 20:03:05', 1744632185000, '2025-04-14 20:03:05'),
('sql_screenshots', 16, '2025-04-14 20:04:05', 'id_60374d423e6c4cad', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744632245000_104844318_1744632245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f12c7e19d63643419a25537dfc13e8ca.jpg", "device_id": "8e2de61b-5052-453e-9a80-201e6438852f", "is_chatting": 1, "label_rate": 0, "log_seq": "a3f3608fc6a04a2f8fd5738f00e404c2", "phone_model": "Huawei_P40", "rate": 1, "target_id": "109657261"}', '2025-04-14 20:04:05', 1744632245000, '2025-04-14 20:04:05'),
('sql_screenshots', 16, '2025-04-14 20:05:05', 'id_b7256c031add4c61', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108870508_1744632305000_110892617_1744632305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1cd50a7bb2994ee0aad92710e73aa01c.jpg", "device_id": "fe680eda-0f11-48c9-ad63-ed2d793c646f", "is_chatting": 1, "label_rate": 1, "log_seq": "0b1d94ada6fd4a93b4f07c727160f19a", "phone_model": "OnePlus_9", "rate": 2, "target_id": "108870508"}', '2025-04-14 20:05:05', 1744632305000, '2025-04-14 20:05:05'),
('sql_screenshots', 16, '2025-04-14 20:06:05', 'id_8bc7f1342fa14cbf', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109657261_1744632365000_109980113_1744632365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/566939fb656d44c8a83738ab84ed641b.jpg", "device_id": "dc037748-9697-4fdb-81a2-772c842676ab", "is_chatting": 1, "label_rate": 2, "log_seq": "9e487c2bbec84b2fa88112741cacfab2", "phone_model": "OnePlus_9", "rate": 0, "target_id": "109657261"}', '2025-04-14 20:06:05', 1744632365000, '2025-04-14 20:06:05'),
('sql_screenshots', 16, '2025-04-14 20:07:05', 'id_e9e4ba25f3ec4a8f', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "54675542_1744632425000_104844318_1744632425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e0e46b13280c4678ba0976831afae01b.jpg", "device_id": "d401e095-ad7f-4e99-8f28-ed60f90d21a7", "is_chatting": 1, "label_rate": 1, "log_seq": "7bc11086daa74b9b9d528739b4591768", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "54675542"}', '2025-04-14 20:07:05', 1744632425000, '2025-04-14 20:07:05'),
('sql_screenshots', 16, '2025-04-14 20:08:05', 'id_54271d698a91451b', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "54675542_1744632485000_32970671_1744632485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1e081232f3344b0aa621e23128e358f8.jpg", "device_id": "0b635c1a-5848-4149-81fc-02336315756d", "is_chatting": 1, "label_rate": 2, "log_seq": "0621731287f643a1a6a7946ca6fb3a8d", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "54675542"}', '2025-04-14 20:08:05', 1744632485000, '2025-04-14 20:08:05'),
('sql_screenshots', 16, '2025-04-14 20:09:05', 'id_ea43f138d90b4a0d', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "82365582_1744632545000_110215081_1744632545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/dfcf2a4515914611900f8a350e6e0cbc.jpg", "device_id": "efb54ec2-456b-416e-9f6d-b072c77dfba7", "is_chatting": 1, "label_rate": 1, "log_seq": "541c433789814c09916dea2c13952773", "phone_model": "Samsung_S22", "rate": 3, "target_id": "82365582"}', '2025-04-14 20:09:05', 1744632545000, '2025-04-14 20:09:05'),
('sql_screenshots', 16, '2025-04-14 20:10:05', 'id_7ceb542d72174406', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "54675542_1744632605000_110873051_1744632605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/133efa852d244ce79431e6c42c2b934f.jpg", "device_id": "caff39b2-991d-4e31-8625-6c1c35d61250", "is_chatting": 1, "label_rate": 1, "log_seq": "c5f70a6c73414f56a16b45bb13cfd732", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "54675542"}', '2025-04-14 20:10:05', 1744632605000, '2025-04-14 20:10:05'),
('sql_screenshots', 16, '2025-04-14 20:11:05', 'id_4f38bf06fd4542c0', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "64280379_1744632665000_108870508_1744632665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6c93eba58a5a4d47beb1f9ed9b5bf2d0.jpg", "device_id": "9ca9e7c0-7c96-422b-836f-4fd3c5787365", "is_chatting": 1, "label_rate": 0, "log_seq": "ad9694d030f54e3dadcb106d155e42e2", "phone_model": "Huawei_P40", "rate": 5, "target_id": "64280379"}', '2025-04-14 20:11:05', 1744632665000, '2025-04-14 20:11:05'),
('sql_screenshots', 16, '2025-04-14 20:12:05', 'id_c808885421c4498c', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "83341608_1744632725000_110892617_1744632725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0cffa97b84f043c3887a00e91e4cd285.jpg", "device_id": "6476e9d7-b8a6-4fd4-870d-3182bf8a5c7a", "is_chatting": 1, "label_rate": 1, "log_seq": "a63dab127ac54b80914c907f6e5df10b", "phone_model": "OnePlus_9", "rate": 2, "target_id": "83341608"}', '2025-04-14 20:12:05', 1744632725000, '2025-04-14 20:12:05'),
('sql_screenshots', 16, '2025-04-14 20:13:05', 'id_5d3838f22f0e406d', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "94369556_1744632785000_110766160_1744632785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/55fe877222ab4d45a3fbfa6c2ea9932a.jpg", "device_id": "2038c60b-e1f4-41fe-89fa-8485dea8581d", "is_chatting": 1, "label_rate": 2, "log_seq": "43d612557ebb4d898505104d77504a15", "phone_model": "Huawei_P40", "rate": 5, "target_id": "94369556"}', '2025-04-14 20:13:05', 1744632785000, '2025-04-14 20:13:05'),
('sql_screenshots', 16, '2025-04-14 20:14:05', 'id_0332c3a286a54519', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110890469_1744632845000_54675542_1744632845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e7ea6a91ccbc4145b4a8b4f58cf52549.jpg", "device_id": "eba99ae5-e4d0-4ed9-9364-8bf344d8b105", "is_chatting": 1, "label_rate": 1, "log_seq": "5f7aeb7d63ed444dbcd0a520dc5e82bf", "phone_model": "Huawei_P40", "rate": 4, "target_id": "110890469"}', '2025-04-14 20:14:05', 1744632845000, '2025-04-14 20:14:05'),
('sql_screenshots', 16, '2025-04-14 20:15:05', 'id_047dd40bd24549eb', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110890469_1744632905000_109657261_1744632905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e5da7ecc60ff4366bf8051b4c7147d92.jpg", "device_id": "4e9d62f6-298a-4ee0-9d00-d196396fa730", "is_chatting": 1, "label_rate": 1, "log_seq": "c00f86c2e6d24eabb6c73dc13065d5c8", "phone_model": "VIVO_X60", "rate": 5, "target_id": "110890469"}', '2025-04-14 20:15:05', 1744632905000, '2025-04-14 20:15:05'),
('sql_screenshots', 16, '2025-04-14 20:16:05', 'id_eb7fc5b935734121', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "81479540_1744632965000_110890469_1744632965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7cf5f0a8a96c4c829cfce31aec92263d.jpg", "device_id": "a97ec1b0-5bf2-45d9-bf2c-ae214cf75d61", "is_chatting": 1, "label_rate": 2, "log_seq": "7994ba776114454093ccaa260ec92d3b", "phone_model": "iPhone_13", "rate": 1, "target_id": "81479540"}', '2025-04-14 20:16:05', 1744632965000, '2025-04-14 20:16:05'),
('sql_screenshots', 16, '2025-04-14 20:17:05', 'id_23f09c44930744ba', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "64280379_1744633025000_109980113_1744633025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b4e2908466154859bc7ce6f46b90bf76.jpg", "device_id": "64d493c3-38cd-4b82-953e-62ffdb175fe4", "is_chatting": 1, "label_rate": 1, "log_seq": "f85ada46a6354cd1b52fedc62a3f74cc", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "64280379"}', '2025-04-14 20:17:05', 1744633025000, '2025-04-14 20:17:05'),
('sql_screenshots', 16, '2025-04-14 20:18:05', 'id_04a5c8ef32794ca1', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109407413_1744633085000_110873051_1744633085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/950064c818104406947922c417ada364.jpg", "device_id": "7da95f94-13d9-4354-bde5-a86ea809d081", "is_chatting": 1, "label_rate": 0, "log_seq": "4e2c097946cc4973bf0e9b2fdc79c2c2", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "109407413"}', '2025-04-14 20:18:05', 1744633085000, '2025-04-14 20:18:05'),
('sql_screenshots', 16, '2025-04-14 20:19:05', 'id_7deadb70a0f54fac', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "32970671_1744633145000_108466147_1744633145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3c43f3e179e74f6fa3651dae9cd985c3.jpg", "device_id": "c6c0ffb7-ffc9-4307-9d0c-6a1602f1b240", "is_chatting": 1, "label_rate": 0, "log_seq": "24482387f1da4ae4bc4a4925a49df0f0", "phone_model": "VIVO_X60", "rate": 4, "target_id": "32970671"}', '2025-04-14 20:19:05', 1744633145000, '2025-04-14 20:19:05'),
('sql_screenshots', 16, '2025-04-14 20:20:05', 'id_605c9d6584d5421c', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110876251_1744633205000_64280379_1744633205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ff86c036215a4ef8a8f951f38dd4a97f.jpg", "device_id": "0a9a516e-5044-4abc-a6e6-54b5b672e05a", "is_chatting": 1, "label_rate": 2, "log_seq": "5fcfa641b8d04857ae2a88bbbc375390", "phone_model": "Samsung_S22", "rate": 5, "target_id": "110876251"}', '2025-04-14 20:20:05', 1744633205000, '2025-04-14 20:20:05'),
('sql_screenshots', 16, '2025-04-14 20:21:05', 'id_b0a411a0f4d94b83', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744633265000_109744448_1744633265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/35c366b02d104f8d87762b4e30d219b9.jpg", "device_id": "a3afea3c-8294-4da9-9701-7c48c99f47d2", "is_chatting": 1, "label_rate": 1, "log_seq": "a158f8c8969c4e7c9505c9ecab6283da", "phone_model": "Samsung_S22", "rate": 4, "target_id": "64280379"}', '2025-04-14 20:21:05', 1744633265000, '2025-04-14 20:21:05'),
('sql_screenshots', 16, '2025-04-14 20:22:05', 'id_c00a58301fb74a85', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "64280379_1744633325000_54675542_1744633325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/641d1d1c123445eaa523987d0d601d4a.jpg", "device_id": "1058980c-be41-4500-9d1d-7d769174dbf2", "is_chatting": 1, "label_rate": 0, "log_seq": "df9cdee2b36a4d7ca7747f664bb734c1", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "64280379"}', '2025-04-14 20:22:05', 1744633325000, '2025-04-14 20:22:05'),
('sql_screenshots', 16, '2025-04-14 20:23:05', 'id_414d0efe3bf0435f', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744633385000_109980113_1744633385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b4578d8d1681439e8bab6aeb4598c0ee.jpg", "device_id": "6f14aea6-10ae-4c46-ac79-4ded30278514", "is_chatting": 1, "label_rate": 1, "log_seq": "bf8cb6d8f6a84ac28b001cf8626f1b36", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "109744448"}', '2025-04-14 20:23:05', 1744633385000, '2025-04-14 20:23:05'),
('sql_screenshots', 16, '2025-04-14 20:24:05', 'id_7f27cd797d51405a', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744633445000_83341608_1744633445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/324b57cf18f2461d89723d92dc779ab2.jpg", "device_id": "026e3297-9261-412b-afc3-15268a7dc2fb", "is_chatting": 1, "label_rate": 2, "log_seq": "6240a0c1049b4bb2a4cf058d963a86bf", "phone_model": "VIVO_X60", "rate": 3, "target_id": "107039703"}', '2025-04-14 20:24:05', 1744633445000, '2025-04-14 20:24:05'),
('sql_screenshots', 16, '2025-04-14 20:25:05', 'id_47c4765e8c7e4786', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "28230174_1744633505000_108466147_1744633505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4771db7d3d2147e0b3f7ad30d84f72e4.jpg", "device_id": "797dcf7a-29dc-4c5c-aa91-d3fb6502bcd3", "is_chatting": 1, "label_rate": 2, "log_seq": "3591cd4160c64d529848fa4564eda241", "phone_model": "Huawei_P40", "rate": 0, "target_id": "28230174"}', '2025-04-14 20:25:05', 1744633505000, '2025-04-14 20:25:05'),
('sql_screenshots', 16, '2025-04-14 20:26:05', 'id_902126941e384001', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744633565000_87571440_1744633565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/75345a0de7b64bf9990e05c525f90ec1.jpg", "device_id": "c1488585-2f8d-44fa-ba55-7d3d6544b4f4", "is_chatting": 1, "label_rate": 0, "log_seq": "9c513b498b9547359232e55e93d6db5c", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "81479540"}', '2025-04-14 20:26:05', 1744633565000, '2025-04-14 20:26:05'),
('sql_screenshots', 16, '2025-04-14 20:27:05', 'id_39a9a267ea044391', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744633625000_87571440_1744633625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ba33f333c5174bf9803d1e28e61ed070.jpg", "device_id": "342bd748-f669-46eb-bbde-639bdb686c61", "is_chatting": 1, "label_rate": 0, "log_seq": "8945bde470ee453b8a823ea652b75117", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "110876251"}', '2025-04-14 20:27:05', 1744633625000, '2025-04-14 20:27:05'),
('sql_screenshots', 16, '2025-04-14 20:28:05', 'id_18a46e5593bf4c75', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110890469_1744633685000_104844318_1744633685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/767644602ae34e1cb8f0e10c8b7c6ff5.jpg", "device_id": "161d095f-d836-4c5b-8dc3-8dc56b8ca391", "is_chatting": 1, "label_rate": 0, "log_seq": "6d83649eaf81426abce804a7800b698c", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "110890469"}', '2025-04-14 20:28:05', 1744633685000, '2025-04-14 20:28:05'),
('sql_screenshots', 16, '2025-04-14 20:29:05', 'id_1dde914669954405', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109744448_1744633745000_110766160_1744633745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ed76c153b74a4db38e2cdafb388c2cbd.jpg", "device_id": "15599e75-5034-4953-81bd-314ec7862342", "is_chatting": 1, "label_rate": 0, "log_seq": "ec2aa95c24034dce997f8c7b0557c81b", "phone_model": "Huawei_P40", "rate": 0, "target_id": "109744448"}', '2025-04-14 20:29:05', 1744633745000, '2025-04-14 20:29:05'),
('sql_screenshots', 16, '2025-04-14 20:30:05', 'id_1ffc95a9f87f42fc', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109657261_1744633805000_110892617_1744633805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f90721504acc4c15baec34b70b5f6a0b.jpg", "device_id": "7e0475f0-1cd8-40f1-a4cb-eb47f8f3a52f", "is_chatting": 1, "label_rate": 0, "log_seq": "582744e0fe6d4f48b91ad963796b7125", "phone_model": "Samsung_S22", "rate": 2, "target_id": "109657261"}', '2025-04-14 20:30:05', 1744633805000, '2025-04-14 20:30:05'),
('sql_screenshots', 16, '2025-04-14 20:31:05', 'id_bb11436721314aa7', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "64280379_1744633865000_109407413_1744633865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/56083e185d8943b0b7fdecadd89f54e3.jpg", "device_id": "1bb25373-5d00-4d45-90fe-ba4d5adfd6a6", "is_chatting": 1, "label_rate": 1, "log_seq": "7a2f0ead70ef49be817e495a292b990e", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "64280379"}', '2025-04-14 20:31:05', 1744633865000, '2025-04-14 20:31:05'),
('sql_screenshots', 16, '2025-04-14 20:32:05', 'id_b85f6553cd684a1a', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "94369556_1744633925000_28230174_1744633925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/58ff9567193a4a64854a47cbd7bc8e3c.jpg", "device_id": "f2d5d466-28fb-45c7-8fda-5defa30aa1f5", "is_chatting": 1, "label_rate": 0, "log_seq": "7d26e60039994e6aaa0766a09884ab7d", "phone_model": "Samsung_S22", "rate": 3, "target_id": "94369556"}', '2025-04-14 20:32:05', 1744633925000, '2025-04-14 20:32:05'),
('sql_screenshots', 16, '2025-04-14 20:33:05', 'id_fada84b3a9ae49bd', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109980113_1744633985000_109744448_1744633985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/01553894a6b849e188542920e6c5330f.jpg", "device_id": "27b4378d-2396-4a05-9d06-988e2f90e1e4", "is_chatting": 1, "label_rate": 2, "log_seq": "89ff1e6a42594169a3d606a772a791de", "phone_model": "Samsung_S22", "rate": 4, "target_id": "109980113"}', '2025-04-14 20:33:05', 1744633985000, '2025-04-14 20:33:05'),
('sql_screenshots', 16, '2025-04-14 20:34:05', 'id_76dadb0780e245d1', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744634045000_87571440_1744634045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ef71e6a6a6cf490ca079b2f4e97e9eb3.jpg", "device_id": "d18cd73c-d2b3-4972-a7aa-cd500f3e1975", "is_chatting": 1, "label_rate": 1, "log_seq": "ebc5c52119284c64b8b36da56bf49577", "phone_model": "OnePlus_9", "rate": 3, "target_id": "64280379"}', '2025-04-14 20:34:05', 1744634045000, '2025-04-14 20:34:05'),
('sql_screenshots', 16, '2025-04-14 20:35:05', 'id_6ac0e615646d4292', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105083641_1744634105000_105503656_1744634105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a32a82c52ef243258d043341ec6ea3cd.jpg", "device_id": "c0d77d26-2e1a-40f9-98f8-167278bdebe7", "is_chatting": 1, "label_rate": 1, "log_seq": "11e467f7242d4fd1870cd5a866e84e02", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "105083641"}', '2025-04-14 20:35:05', 1744634105000, '2025-04-14 20:35:05'),
('sql_screenshots', 16, '2025-04-14 20:36:05', 'id_ab5e5e9c31b04db3', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "32970671_1744634165000_109657261_1744634165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f11a4e48a1ed4e00a5e6602ec3c57e34.jpg", "device_id": "5858cfe7-f87a-4d88-97ae-e71e88fa97b2", "is_chatting": 1, "label_rate": 1, "log_seq": "954f7c1c441f4b7e9027ff857c8ac22a", "phone_model": "Samsung_S21", "rate": 2, "target_id": "32970671"}', '2025-04-14 20:36:05', 1744634165000, '2025-04-14 20:36:05'),
('sql_screenshots', 16, '2025-04-14 20:37:05', 'id_9fe422b21b124f67', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109657261_1744634225000_109407413_1744634225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/92f1766a785e4fb69003f0c380fa6aef.jpg", "device_id": "851f1488-1db5-43a0-8fbf-61fe05686490", "is_chatting": 1, "label_rate": 1, "log_seq": "a679a90ce1d446b59f3a7b857b3f7714", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "109657261"}', '2025-04-14 20:37:05', 1744634225000, '2025-04-14 20:37:05'),
('sql_screenshots', 16, '2025-04-14 20:38:05', 'id_ba0e8619fb2f4dd9', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109980113_1744634285000_109744448_1744634285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6c9877baf0fa4aed97c9da8986aa32fa.jpg", "device_id": "d16be984-c4c6-4526-b100-d7d49c4e9c9e", "is_chatting": 1, "label_rate": 2, "log_seq": "daf502fdc5aa4702ad483726847f3231", "phone_model": "Samsung_S22", "rate": 2, "target_id": "109980113"}', '2025-04-14 20:38:05', 1744634285000, '2025-04-14 20:38:05'),
('sql_screenshots', 16, '2025-04-14 20:39:05', 'id_c32638ea846749f2', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109407413_1744634345000_110876251_1744634345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/014b7e0a0f574b27836a6cf754494640.jpg", "device_id": "fb8f4e0f-bc60-410a-878f-5e94e4becae1", "is_chatting": 1, "label_rate": 1, "log_seq": "16d10e31a7b7477bb201aecb61a21539", "phone_model": "OnePlus_9", "rate": 1, "target_id": "109407413"}', '2025-04-14 20:39:05', 1744634345000, '2025-04-14 20:39:05'),
('sql_screenshots', 16, '2025-04-14 20:40:05', 'id_f5f79d69eaa740cc', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109980113_1744634405000_109407413_1744634405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3e88fc4f399943c8ac522ca1afb3c0f1.jpg", "device_id": "847edb2c-b5d5-4d92-9539-50255b7a1465", "is_chatting": 1, "label_rate": 0, "log_seq": "429d241a75ca4b23b3fba6958675f4e5", "phone_model": "OnePlus_9", "rate": 4, "target_id": "109980113"}', '2025-04-14 20:40:05', 1744634405000, '2025-04-14 20:40:05'),
('sql_screenshots', 16, '2025-04-14 20:41:05', 'id_5f6f290956d4476c', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "82365582_1744634465000_83341608_1744634465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/499c3002926b4d73893d03cf0c286f19.jpg", "device_id": "5cabe461-573f-489c-b87a-9d1a11dd8473", "is_chatting": 1, "label_rate": 2, "log_seq": "359951b3c2e5410a955993b4a45b4165", "phone_model": "OnePlus_9", "rate": 3, "target_id": "82365582"}', '2025-04-14 20:41:05', 1744634465000, '2025-04-14 20:41:05'),
('sql_screenshots', 16, '2025-04-14 20:42:05', 'id_6a0a6ed5e3a84c77', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105503656_1744634525000_110215081_1744634525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/16028e5d91ab4ad8b42af55dd0b8d284.jpg", "device_id": "45395efb-c554-4024-a226-274d5b709507", "is_chatting": 1, "label_rate": 1, "log_seq": "9c30b2bdd2a3490e8342db348cfcf281", "phone_model": "Samsung_S22", "rate": 1, "target_id": "105503656"}', '2025-04-14 20:42:05', 1744634525000, '2025-04-14 20:42:05'),
('sql_screenshots', 16, '2025-04-14 20:43:05', 'id_ca42ba9c380a485b', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "94369556_1744634585000_57649476_1744634585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/397a8562251548679cebd6efa8c4669f.jpg", "device_id": "4e81cecc-9f5f-4509-bf9d-521d76a72954", "is_chatting": 1, "label_rate": 0, "log_seq": "7ad5350435ff4bb8af25bea82b0dbf68", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "94369556"}', '2025-04-14 20:43:05', 1744634585000, '2025-04-14 20:43:05'),
('sql_screenshots', 16, '2025-04-14 20:44:05', 'id_98155e19011e4ef7', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110876251_1744634645000_94369556_1744634645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/62adb23bd4374757b5e23168426dc67d.jpg", "device_id": "1693c177-6b9c-4066-9c40-7b1729453301", "is_chatting": 1, "label_rate": 2, "log_seq": "88c17358dba14144bae66964c10f8039", "phone_model": "Samsung_S22", "rate": 1, "target_id": "110876251"}', '2025-04-14 20:44:05', 1744634645000, '2025-04-14 20:44:05'),
('sql_screenshots', 16, '2025-04-14 20:45:05', 'id_e0d3bade543e4701', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108466147_1744634705000_107039703_1744634705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/28eccf8ccc574cdab36952ccf4853a40.jpg", "device_id": "58daad5e-a8d7-4db2-994d-f3512f4f6051", "is_chatting": 1, "label_rate": 0, "log_seq": "e186890c521e4a1bbbf6b4fa9415e25a", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "108466147"}', '2025-04-14 20:45:05', 1744634705000, '2025-04-14 20:45:05'),
('sql_screenshots', 16, '2025-04-14 20:46:05', 'id_a8aaf2c320b245f9', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109407413_1744634765000_110873051_1744634765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9556ea768229433ab5ace04f401d3086.jpg", "device_id": "ee33f88f-4a53-407c-9ed0-f015a224d8ed", "is_chatting": 1, "label_rate": 0, "log_seq": "b6ef25ba1ed248fdbd5703386e266443", "phone_model": "iPhone_13", "rate": 5, "target_id": "109407413"}', '2025-04-14 20:46:05', 1744634765000, '2025-04-14 20:46:05'),
('sql_screenshots', 16, '2025-04-14 20:47:05', 'id_4de37deffd5c4116', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744634825000_57649476_1744634825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/41407fade08e435d944372f4f4a2f9d2.jpg", "device_id": "d72448c9-4b94-470c-8b32-d934f4a0dd04", "is_chatting": 1, "label_rate": 2, "log_seq": "3dfbfda9f8a649c883b34cd16cbdb141", "phone_model": "OnePlus_9", "rate": 1, "target_id": "110876251"}', '2025-04-14 20:47:05', 1744634825000, '2025-04-14 20:47:05'),
('sql_screenshots', 16, '2025-04-14 20:48:05', 'id_e8791a18eb944f8e', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "104844318_1744634885000_109744448_1744634885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/80feed67b61d48a3b1dd51c935b4041d.jpg", "device_id": "b656836b-eda5-4f1e-bae4-d8c4cda72044", "is_chatting": 1, "label_rate": 1, "log_seq": "257408979ec441519eac7308514133e4", "phone_model": "OnePlus_9", "rate": 2, "target_id": "104844318"}', '2025-04-14 20:48:05', 1744634885000, '2025-04-14 20:48:05'),
('sql_screenshots', 16, '2025-04-14 20:49:05', 'id_63494c9919124724', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "87571440_1744634945000_110766160_1744634945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/03c0eacbd5b04025a5fc6728e31e9d90.jpg", "device_id": "dc5a3d63-4fef-4594-92e4-808ff8a2ee2f", "is_chatting": 1, "label_rate": 0, "log_seq": "24453d9717d747d8abec7ddb03dedd2c", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "87571440"}', '2025-04-14 20:49:05', 1744634945000, '2025-04-14 20:49:05'),
('sql_screenshots', 16, '2025-04-14 20:50:05', 'id_39add67736e64483', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105083641_1744635005000_64280379_1744635005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/012d79e31556426e9414c63ab6003b56.jpg", "device_id": "58fceffc-add7-43a5-9f4f-90259d6e5593", "is_chatting": 1, "label_rate": 0, "log_seq": "56730a5e14ec4702af310fd45611c42c", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "105083641"}', '2025-04-14 20:50:05', 1744635005000, '2025-04-14 20:50:05'),
('sql_screenshots', 16, '2025-04-14 20:51:05', 'id_fd6f813bdfc641ac', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744635065000_107039703_1744635065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/745a95667d964d9a855751139efedd0a.jpg", "device_id": "42b636c4-5dc5-425d-9cdd-f9865dbf84b4", "is_chatting": 1, "label_rate": 1, "log_seq": "bdf80aed25134b269e1534fc984e2aea", "phone_model": "Samsung_S22", "rate": 5, "target_id": "82365582"}', '2025-04-14 20:51:05', 1744635065000, '2025-04-14 20:51:05'),
('sql_screenshots', 16, '2025-04-14 20:52:05', 'id_3e9bf49054044c47', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "83341608_1744635125000_110215081_1744635125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/492f55e119b442f99b560ec10f3b26ab.jpg", "device_id": "5860a844-d2bc-4fbf-92a0-e1b33ea1d672", "is_chatting": 1, "label_rate": 2, "log_seq": "6cb12a091b6f4b18b8aebbc060446705", "phone_model": "iPhone_13", "rate": 4, "target_id": "83341608"}', '2025-04-14 20:52:05', 1744635125000, '2025-04-14 20:52:05'),
('sql_screenshots', 16, '2025-04-14 20:53:05', 'id_ab56d52b08134647', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744635185000_109407413_1744635185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4b6feb33801045489f0b49cdee93e310.jpg", "device_id": "ea7dc842-90e1-46b8-a7ba-a56a69c540df", "is_chatting": 1, "label_rate": 1, "log_seq": "f92244e76f7a4850a86936ebc8ab5e5b", "phone_model": "iPhone_13", "rate": 5, "target_id": "110873051"}', '2025-04-14 20:53:05', 1744635185000, '2025-04-14 20:53:05'),
('sql_screenshots', 16, '2025-04-14 20:54:05', 'id_3e7cd01c02ea4a15', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "28230174_1744635245000_104844318_1744635245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/293ea2bdee17429d8f4aa34a94a2f64e.jpg", "device_id": "0613d209-aebd-4b23-a1ef-3eec88ef4331", "is_chatting": 1, "label_rate": 0, "log_seq": "c62c3d14f8ad4735bad671556886aeee", "phone_model": "OnePlus_9", "rate": 0, "target_id": "28230174"}', '2025-04-14 20:54:05', 1744635245000, '2025-04-14 20:54:05'),
('sql_screenshots', 16, '2025-04-14 20:55:05', 'id_d0f01fd5fc294ee5', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744635305000_109657261_1744635305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/47218fda6a6a41a391f82c7488a168d3.jpg", "device_id": "4aab1ddb-f5d6-40e3-aa83-e752729d4324", "is_chatting": 1, "label_rate": 1, "log_seq": "2826d4a0123340538879a8113775efbd", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "110876251"}', '2025-04-14 20:55:05', 1744635305000, '2025-04-14 20:55:05'),
('sql_screenshots', 16, '2025-04-14 20:56:05', 'id_f1f46344b7eb4921', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744635365000_64280379_1744635365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c0feb3ee61f646e09f6b51420ced51a7.jpg", "device_id": "a42b3702-d1c5-4bd8-9865-f2cf80e3cca9", "is_chatting": 1, "label_rate": 2, "log_seq": "a4edcdd419394c5f9aa36acdad0f3cbc", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "110876251"}', '2025-04-14 20:56:05', 1744635365000, '2025-04-14 20:56:05'),
('sql_screenshots', 16, '2025-04-14 20:57:05', 'id_9b900e0be5d84059', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105083641_1744635425000_110890469_1744635425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1303f2509a0c4e9cbd75427f0d27600c.jpg", "device_id": "556d0364-73bb-4a71-b9ec-78208fc7c99e", "is_chatting": 1, "label_rate": 0, "log_seq": "5b038e624aee471895978566e531c8f5", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "105083641"}', '2025-04-14 20:57:05', 1744635425000, '2025-04-14 20:57:05'),
('sql_screenshots', 16, '2025-04-14 20:58:05', 'id_619edd2883194a41', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "57649476_1744635485000_110876251_1744635485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a11912a201cd456c9d947d275f7fae4a.jpg", "device_id": "528d29a4-468e-415e-bc7a-f2ca097f8acd", "is_chatting": 1, "label_rate": 0, "log_seq": "03f188c0cd564ab7b3e4d249e9d6d959", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "57649476"}', '2025-04-14 20:58:05', 1744635485000, '2025-04-14 20:58:05'),
('sql_screenshots', 16, '2025-04-14 20:59:05', 'id_cc2ae54d33e24d15', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110876251_1744635545000_32970671_1744635545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2c83de7b3a68489099283f7bd732066f.jpg", "device_id": "acce964e-5f2e-4c3a-a6dd-2e7a21acd043", "is_chatting": 1, "label_rate": 2, "log_seq": "10ad102c30994a9e9bf5090e35ae61ca", "phone_model": "Samsung_S22", "rate": 2, "target_id": "110876251"}', '2025-04-14 20:59:05', 1744635545000, '2025-04-14 20:59:05'),
('sql_screenshots', 16, '2025-04-14 21:00:05', 'id_b045977986a04849', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744635605000_32970671_1744635605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b3a3a0a1c9a44e37bc9984c329ecd9e5.jpg", "device_id": "e9e7f972-6b0e-408c-b8ea-b2903b60bb42", "is_chatting": 1, "label_rate": 0, "log_seq": "bc1fae1cc4d64d2c906a09b0a8a431e3", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "110876251"}', '2025-04-14 21:00:05', 1744635605000, '2025-04-14 21:00:05'),
('sql_screenshots', 16, '2025-04-14 21:01:05', 'id_274461442ab5465e', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108870508_1744635665000_110766160_1744635665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bccc58ece5fe4529850360080d5b1de2.jpg", "device_id": "9e52e80b-0586-42f6-8b37-eccdb73683a4", "is_chatting": 1, "label_rate": 1, "log_seq": "eaef50f8dc044be497ad910bca699bad", "phone_model": "iPhone_13", "rate": 1, "target_id": "108870508"}', '2025-04-14 21:01:05', 1744635665000, '2025-04-14 21:01:05'),
('sql_screenshots', 16, '2025-04-14 21:02:05', 'id_8746b8fce70449d1', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "81479540_1744635725000_94369556_1744635725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a499a8b3eaa343dd8b0fea7203e2ef7b.jpg", "device_id": "76caa863-0d2f-45e4-96e3-2a2ba6e240bc", "is_chatting": 1, "label_rate": 0, "log_seq": "32bc5468dedb4f428c3aa71eadf2f5a8", "phone_model": "Samsung_S21", "rate": 2, "target_id": "81479540"}', '2025-04-14 21:02:05', 1744635725000, '2025-04-14 21:02:05'),
('sql_screenshots', 16, '2025-04-14 21:03:05', 'id_502dd0c1e1d24253', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105083641_1744635785000_57649476_1744635785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b3768df7241b4f5d90a909b7c48fb274.jpg", "device_id": "6d4e3275-d410-4411-ab64-b7019813a5c1", "is_chatting": 1, "label_rate": 2, "log_seq": "7290e7acdc37406bb346e34e786afbce", "phone_model": "iPhone_13", "rate": 2, "target_id": "105083641"}', '2025-04-14 21:03:05', 1744635785000, '2025-04-14 21:03:05'),
('sql_screenshots', 16, '2025-04-14 21:04:05', 'id_7e1ba7a7ea0142b3', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108466147_1744635845000_110876251_1744635845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9f485b7435804a6f9c78d1b3a9dcf10e.jpg", "device_id": "277b3d29-b055-46ce-b30c-dec1ef199c98", "is_chatting": 1, "label_rate": 0, "log_seq": "89bd95499ba44857960a3224120ca38d", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "108466147"}', '2025-04-14 21:04:05', 1744635845000, '2025-04-14 21:04:05'),
('sql_screenshots', 16, '2025-04-14 21:05:05', 'id_908788d889534407', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "82365582_1744635905000_57649476_1744635905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6c2a9b23f6bd4a679dd4b2ef8d06d0c3.jpg", "device_id": "60ff8606-bfc6-4530-9319-d3c1db38f4ed", "is_chatting": 1, "label_rate": 2, "log_seq": "363ef47bbb174818993fa136e0ef177a", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "82365582"}', '2025-04-14 21:05:05', 1744635905000, '2025-04-14 21:05:05'),
('sql_screenshots', 16, '2025-04-14 21:06:05', 'id_7cb9bd61a9b4456f', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744635965000_83341608_1744635965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6ea4d4f4fc1f442b8767bcfb61d0886a.jpg", "device_id": "c1903842-add6-4fc5-8133-9b8bca3cfbf0", "is_chatting": 1, "label_rate": 1, "log_seq": "446232346d4b48378fe4b51b7c21abae", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "32970671"}', '2025-04-14 21:06:05', 1744635965000, '2025-04-14 21:06:05'),
('sql_screenshots', 16, '2025-04-14 21:07:05', 'id_fd07b713cb1f4973', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "107039703_1744636025000_83341608_1744636025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d2c1647c3e6c41bca35d68e13eda8d2f.jpg", "device_id": "5070838c-80b3-4663-8890-8c58050f080e", "is_chatting": 1, "label_rate": 0, "log_seq": "92b0bb491f144bd6a41f524f6fd19316", "phone_model": "Huawei_P40", "rate": 2, "target_id": "107039703"}', '2025-04-14 21:07:05', 1744636025000, '2025-04-14 21:07:05'),
('sql_screenshots', 16, '2025-04-14 21:08:05', 'id_50dbbc5bf3b540e3', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "104844318_1744636085000_64280379_1744636085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7e1767bd4a2b4d8a8494d7734e9a1112.jpg", "device_id": "a92c66d3-d1d3-44b5-855d-cec472c0344e", "is_chatting": 1, "label_rate": 1, "log_seq": "c86af16ca2b64c39aaa6e6176f9f683c", "phone_model": "Samsung_S21", "rate": 1, "target_id": "104844318"}', '2025-04-14 21:08:05', 1744636085000, '2025-04-14 21:08:05'),
('sql_screenshots', 16, '2025-04-14 21:09:05', 'id_bffcef7ffb9046a1', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "101553185_1744636145000_108870508_1744636145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ebf12115267247969ecef04e4ce482af.jpg", "device_id": "7f0c4656-789a-4f76-a2a4-d93768a4dcc8", "is_chatting": 1, "label_rate": 0, "log_seq": "06e070019a9b43a2bc98aff337a60aab", "phone_model": "Huawei_P40", "rate": 1, "target_id": "101553185"}', '2025-04-14 21:09:05', 1744636145000, '2025-04-14 21:09:05'),
('sql_screenshots', 16, '2025-04-14 21:10:05', 'id_285749548c2e468b', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105503656_1744636205000_110215081_1744636205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/978259c197054b2197a6f57f0e323c9f.jpg", "device_id": "51324546-b275-4542-bd07-bca68de387a7", "is_chatting": 1, "label_rate": 2, "log_seq": "981287fc9b1d4b65a38500b8ab2bc40b", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "105503656"}', '2025-04-14 21:10:05', 1744636205000, '2025-04-14 21:10:05'),
('sql_screenshots', 16, '2025-04-14 21:11:05', 'id_03515ec56b044801', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744636265000_110892617_1744636265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2eb50c83811242899ee2eec05561355c.jpg", "device_id": "2ea3d0c5-f35b-47b7-91a7-68fa4c43c0ae", "is_chatting": 1, "label_rate": 1, "log_seq": "bfe0a2693663458fbf484df888e00c1d", "phone_model": "Huawei_P40", "rate": 2, "target_id": "110890469"}', '2025-04-14 21:11:05', 1744636265000, '2025-04-14 21:11:05'),
('sql_screenshots', 16, '2025-04-14 21:12:05', 'id_f9521e7b378a4eb8', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744636325000_110892617_1744636325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/01546b380cca40b7a8faf3b9d92480b3.jpg", "device_id": "722186cc-7f11-4b91-a0d7-39aef2a31c4d", "is_chatting": 1, "label_rate": 0, "log_seq": "ec56740a865b495f9f85dfd132cc865a", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "109744448"}', '2025-04-14 21:12:05', 1744636325000, '2025-04-14 21:12:05'),
('sql_screenshots', 16, '2025-04-14 21:13:05', 'id_fba904ad06e2484b', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110215081_1744636385000_105503656_1744636385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/09d598ccf1914c96b6523b4e912a07f1.jpg", "device_id": "c7a70537-790c-4a50-a1c8-362920cb279f", "is_chatting": 1, "label_rate": 2, "log_seq": "2f1d7bb43bc7428db462823d4033cd81", "phone_model": "Samsung_S22", "rate": 4, "target_id": "110215081"}', '2025-04-14 21:13:05', 1744636385000, '2025-04-14 21:13:05'),
('sql_screenshots', 16, '2025-04-14 21:14:05', 'id_ce27c624bfbd4d65', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110876251_1744636445000_94369556_1744636445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3c17bad28aad4e6192ba9c5440174718.jpg", "device_id": "4cfb2099-4fff-40bd-b40f-e271fccfe6ee", "is_chatting": 1, "label_rate": 2, "log_seq": "863958c07f134ef1b154d899d376974e", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "110876251"}', '2025-04-14 21:14:05', 1744636445000, '2025-04-14 21:14:05'),
('sql_screenshots', 16, '2025-04-14 21:15:05', 'id_5e138cc1fdab4468', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "81479540_1744636505000_105503656_1744636505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0b9fccbabc46451783d69e08ef81a86e.jpg", "device_id": "cf2d8475-4b0c-47e6-b32b-b56d54dcc1aa", "is_chatting": 1, "label_rate": 2, "log_seq": "fad02ba951454d5fb5824234b7db7823", "phone_model": "Huawei_P40", "rate": 5, "target_id": "81479540"}', '2025-04-14 21:15:05', 1744636505000, '2025-04-14 21:15:05'),
('sql_screenshots', 16, '2025-04-14 21:16:05', 'id_4beb77c83cb84f84', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744636565000_105083641_1744636565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9bcb696221c4446abd30116c64241a96.jpg", "device_id": "d9881d29-34da-42f8-b80a-1e0fae546fab", "is_chatting": 1, "label_rate": 0, "log_seq": "b95a0e6a690e46fe99da7c6077f3babe", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "110766160"}', '2025-04-14 21:16:05', 1744636565000, '2025-04-14 21:16:05'),
('sql_screenshots', 16, '2025-04-14 21:17:05', 'id_8bccb64850764818', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "107039703_1744636625000_109407413_1744636625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2163d8c73331485c8a4c972795ca7c9e.jpg", "device_id": "14e03f9c-7a9d-46e2-934c-9a3272f63e96", "is_chatting": 1, "label_rate": 1, "log_seq": "0ae01c179c4a478c9219282639364639", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "107039703"}', '2025-04-14 21:17:05', 1744636625000, '2025-04-14 21:17:05'),
('sql_screenshots', 16, '2025-04-14 21:18:05', 'id_7c70332539fb47d8', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110876251_1744636685000_108466147_1744636685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f5f9473a992c4ef8955e326f1bf50099.jpg", "device_id": "a938c55d-fb17-47c7-a35a-2df81901d0e4", "is_chatting": 1, "label_rate": 0, "log_seq": "59ae5aacd141458fb353c880fd1fe185", "phone_model": "OnePlus_9", "rate": 3, "target_id": "110876251"}', '2025-04-14 21:18:05', 1744636685000, '2025-04-14 21:18:05'),
('sql_screenshots', 16, '2025-04-14 21:19:05', 'id_80e9061fcc164094', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110215081_1744636745000_94369556_1744636745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/724cc7d2836147a6b78e3c4b78ec0315.jpg", "device_id": "7509644e-26f2-48d9-b5d9-41c087ea82fb", "is_chatting": 1, "label_rate": 1, "log_seq": "9aecaf1f6a094b7487329ea5dd8946fb", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "110215081"}', '2025-04-14 21:19:05', 1744636745000, '2025-04-14 21:19:05'),
('sql_screenshots', 16, '2025-04-14 21:20:05', 'id_b1e01c76724047d1', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108870508_1744636805000_110892617_1744636805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a96eab88306f44659f9d1cd39cc8c47f.jpg", "device_id": "b100b000-986c-4908-9259-553c8ebb63d8", "is_chatting": 1, "label_rate": 0, "log_seq": "c9b5cf0113ad4ee982c056f5ad677d0c", "phone_model": "OnePlus_9", "rate": 0, "target_id": "108870508"}', '2025-04-14 21:20:05', 1744636805000, '2025-04-14 21:20:05'),
('sql_screenshots', 16, '2025-04-14 21:21:05', 'id_def222bd4a6f4814', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108466147_1744636865000_105503656_1744636865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c72fe3eb96c843ab9ab4debb8cb365bf.jpg", "device_id": "bbc0cda1-40ee-478b-8c4c-3cf8edfe8532", "is_chatting": 1, "label_rate": 1, "log_seq": "a67e42cf55c548e19f671823845b6771", "phone_model": "Samsung_S22", "rate": 3, "target_id": "108466147"}', '2025-04-14 21:21:05', 1744636865000, '2025-04-14 21:21:05'),
('sql_screenshots', 16, '2025-04-14 21:22:05', 'id_4a677959e71c4a01', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "83341608_1744636925000_81479540_1744636925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9d6effdf73904d2fb01fb612c38701e3.jpg", "device_id": "1668c2c2-25b8-4784-b8ec-a7cd5ad0efda", "is_chatting": 1, "label_rate": 1, "log_seq": "18624e19e2d5449a86b2263f1eb2a431", "phone_model": "iPhone_13", "rate": 5, "target_id": "83341608"}', '2025-04-14 21:22:05', 1744636925000, '2025-04-14 21:22:05'),
('sql_screenshots', 16, '2025-04-14 21:23:05', 'id_9de733a344194ee3', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744636985000_57649476_1744636985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b488933609fb40e5840f308ea094991f.jpg", "device_id": "8f847cc2-1d6d-4055-ac1a-d71871ee4bbc", "is_chatting": 1, "label_rate": 2, "log_seq": "1e01ecc350ba463bb1c728acf6033658", "phone_model": "iPhone_13", "rate": 1, "target_id": "110890469"}', '2025-04-14 21:23:05', 1744636985000, '2025-04-14 21:23:05'),
('sql_screenshots', 16, '2025-04-14 21:24:05', 'id_6ce97d7f49584ec9', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110892617_1744637045000_105083641_1744637045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1cbf39a8367e48d08cea6330e7094572.jpg", "device_id": "9588909a-2c4e-479f-b521-dcc2d4c7f773", "is_chatting": 1, "label_rate": 0, "log_seq": "508c9fe8869d49e8851b968cbe7aec7f", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "110892617"}', '2025-04-14 21:24:05', 1744637045000, '2025-04-14 21:24:05'),
('sql_screenshots', 16, '2025-04-14 21:25:05', 'id_32e1f1026f174138', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "54675542_1744637105000_107039703_1744637105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/95b628095c494d388e36fdf58ae14e68.jpg", "device_id": "6b79fde0-d660-46b9-ad5e-a97ecfdb39d9", "is_chatting": 1, "label_rate": 1, "log_seq": "430c9763e7114d929e24d57ac5fafaaa", "phone_model": "OnePlus_9", "rate": 1, "target_id": "54675542"}', '2025-04-14 21:25:05', 1744637105000, '2025-04-14 21:25:05'),
('sql_screenshots', 16, '2025-04-14 21:26:05', 'id_b9701d5f7c4c45db', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108466147_1744637165000_104844318_1744637165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6f43d6bf57664602ab188d5190069a2a.jpg", "device_id": "0b9b6806-efda-499b-af2b-64bbdd596474", "is_chatting": 1, "label_rate": 1, "log_seq": "7027b4d9b9cb47479bbfe8db2b20445c", "phone_model": "Huawei_P40", "rate": 5, "target_id": "108466147"}', '2025-04-14 21:26:05', 1744637165000, '2025-04-14 21:26:05'),
('sql_screenshots', 16, '2025-04-14 21:27:05', 'id_2d25b297dfd545dc', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110873051_1744637225000_82365582_1744637225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/96bb5c35877e4d7b85b275b4db0f7416.jpg", "device_id": "76dbc89c-d351-4d47-9030-a006dc717beb", "is_chatting": 1, "label_rate": 0, "log_seq": "43b5da14ef854fb096e82d29e1d311f5", "phone_model": "Samsung_S22", "rate": 5, "target_id": "110873051"}', '2025-04-14 21:27:05', 1744637225000, '2025-04-14 21:27:05'),
('sql_screenshots', 16, '2025-04-14 21:28:05', 'id_3270460fefee4029', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744637285000_54675542_1744637285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5536f16c21514231815f270aa47e417a.jpg", "device_id": "b308f377-2ec4-4a34-a929-e67dafda962f", "is_chatting": 1, "label_rate": 0, "log_seq": "fead8daa8d294bb781e5aae5efe42cfb", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "110873051"}', '2025-04-14 21:28:05', 1744637285000, '2025-04-14 21:28:05'),
('sql_screenshots', 16, '2025-04-14 21:29:05', 'id_8115d3e19ee74ec8', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108870508_1744637345000_108466147_1744637345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a8a80dddd3b64c36a5d7ee521c6597bb.jpg", "device_id": "d679fe76-332f-4015-88a0-ee1101f9b036", "is_chatting": 1, "label_rate": 0, "log_seq": "2aeacb4691fd4b53a77f20b45fab18b8", "phone_model": "Samsung_S22", "rate": 3, "target_id": "108870508"}', '2025-04-14 21:29:05', 1744637345000, '2025-04-14 21:29:05'),
('sql_screenshots', 16, '2025-04-14 21:30:05', 'id_01584bb2d66447a2', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110876251_1744637405000_108466147_1744637405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/fcac0c2d71b1449f9e6d8877fdbc705c.jpg", "device_id": "5ba23562-da5b-42d0-8178-fa4cc3483888", "is_chatting": 1, "label_rate": 0, "log_seq": "d9d499035bae44ea8aacbb4e6184e98e", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "110876251"}', '2025-04-14 21:30:05', 1744637405000, '2025-04-14 21:30:05'),
('sql_screenshots', 16, '2025-04-14 21:31:05', 'id_962cc13fe4534d22', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "57649476_1744637465000_108870508_1744637465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d89fc3bfcd124c7a8cfd74f034d7ca9d.jpg", "device_id": "c576cc04-1f83-460f-a34a-33e1f7591ad1", "is_chatting": 1, "label_rate": 1, "log_seq": "9b044ce6290b48a789b7bff627968271", "phone_model": "OnePlus_9", "rate": 5, "target_id": "57649476"}', '2025-04-14 21:31:05', 1744637465000, '2025-04-14 21:31:05'),
('sql_screenshots', 16, '2025-04-14 21:32:05', 'id_0337512bf193402b', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109407413_1744637525000_108466147_1744637525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/14c040aa4bb2499ab0b7b416840306fe.jpg", "device_id": "2c785ab4-ba68-4f30-8bd2-81cd0de2e558", "is_chatting": 1, "label_rate": 1, "log_seq": "18e7f1c11a8e4b34863382c6e014edfa", "phone_model": "VIVO_X60", "rate": 1, "target_id": "109407413"}', '2025-04-14 21:32:05', 1744637525000, '2025-04-14 21:32:05'),
('sql_screenshots', 16, '2025-04-14 21:33:05', 'id_42c1aedb9a744edd', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "57649476_1744637585000_108870508_1744637585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2afca2872f914062babc653863b3a9c9.jpg", "device_id": "bf77b73f-235d-47e9-9c68-d683c70fea09", "is_chatting": 1, "label_rate": 1, "log_seq": "c049f2c67387439f9ba2f5a9f03c33e5", "phone_model": "iPhone_13", "rate": 4, "target_id": "57649476"}', '2025-04-14 21:33:05', 1744637585000, '2025-04-14 21:33:05'),
('sql_screenshots', 16, '2025-04-14 21:34:05', 'id_02a88ee907d3450f', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108466147_1744637645000_110892617_1744637645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8cb146cf42934975997d8d682ae1b78c.jpg", "device_id": "9f937974-0f15-41a0-8667-115333548575", "is_chatting": 1, "label_rate": 1, "log_seq": "25209f9de40641748187e847abfb5e3d", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "108466147"}', '2025-04-14 21:34:05', 1744637645000, '2025-04-14 21:34:05'),
('sql_screenshots', 16, '2025-04-14 21:35:05', 'id_8f28c6fba44d4051', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109980113_1744637705000_110215081_1744637705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d350844813454ed09147ffb8e804262f.jpg", "device_id": "beb41f3d-553d-44dd-a2ed-d97b28ebff7b", "is_chatting": 1, "label_rate": 1, "log_seq": "aa6aecabf65841d1a2b4d139f495b98f", "phone_model": "OnePlus_9", "rate": 2, "target_id": "109980113"}', '2025-04-14 21:35:05', 1744637705000, '2025-04-14 21:35:05'),
('sql_screenshots', 16, '2025-04-14 21:36:05', 'id_c478a18be9a04170', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744637765000_107039703_1744637765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/faca4104109440e1aeb10afa29f07ac9.jpg", "device_id": "64920e05-82d0-4041-9d96-f9aedda98f55", "is_chatting": 1, "label_rate": 2, "log_seq": "05300893f9964891b781161577f165e9", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "110876251"}', '2025-04-14 21:36:05', 1744637765000, '2025-04-14 21:36:05'),
('sql_screenshots', 16, '2025-04-14 21:37:05', 'id_abc969d2a34548f2', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105083641_1744637825000_109407413_1744637825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/48873581d7b841e4870445871f50887d.jpg", "device_id": "bd416917-e7db-424d-b561-19cf3efea9b2", "is_chatting": 1, "label_rate": 2, "log_seq": "c410bfe19683486690dc3509bf7a6111", "phone_model": "VIVO_X60", "rate": 0, "target_id": "105083641"}', '2025-04-14 21:37:05', 1744637825000, '2025-04-14 21:37:05'),
('sql_screenshots', 16, '2025-04-14 21:38:05', 'id_4d1059e5e8ba4a84', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110892617_1744637885000_94369556_1744637885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b5942f16ce7845bbba3319f3d1c0c35d.jpg", "device_id": "3277100b-83cf-47a1-9e7a-d1cd280a777e", "is_chatting": 1, "label_rate": 1, "log_seq": "5976d00a3ba64e11823b559b96028538", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "110892617"}', '2025-04-14 21:38:05', 1744637885000, '2025-04-14 21:38:05'),
('sql_screenshots', 16, '2025-04-14 21:39:05', 'id_d1098dc1155740d0', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "64280379_1744637945000_28230174_1744637945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6c03e584931d4a2da1dd21f9913f2377.jpg", "device_id": "c813b551-c5d4-48c5-922b-5071b4faa902", "is_chatting": 1, "label_rate": 2, "log_seq": "3b94594746d0480a8b3e49669ba2512c", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "64280379"}', '2025-04-14 21:39:05', 1744637945000, '2025-04-14 21:39:05'),
('sql_screenshots', 16, '2025-04-14 21:40:05', 'id_2a8c9de15c154d58', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105083641_1744638005000_101553185_1744638005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0e431f8a0c304be0a40369a390e5a180.jpg", "device_id": "7d2f7e3d-4c46-4368-8f25-ce6efb63da06", "is_chatting": 1, "label_rate": 0, "log_seq": "d23c15c8a21f4ebb818e9b52bcaac4e2", "phone_model": "Samsung_S22", "rate": 1, "target_id": "105083641"}', '2025-04-14 21:40:05', 1744638005000, '2025-04-14 21:40:05'),
('sql_screenshots', 16, '2025-04-14 21:41:05', 'id_5fe0c156407e4b86', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744638065000_57649476_1744638065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/670b45c0e244444781de51567cd23b79.jpg", "device_id": "cc8fa0d7-ecda-4db5-a417-f8863c7ff03e", "is_chatting": 1, "label_rate": 0, "log_seq": "2f3516acc43142d7b6d299eafc572660", "phone_model": "OPPO_CPH1937", "rate": 0, "target_id": "87571440"}', '2025-04-14 21:41:05', 1744638065000, '2025-04-14 21:41:05'),
('sql_screenshots', 16, '2025-04-14 21:42:05', 'id_c7607d96f0b44737', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105083641_1744638125000_107039703_1744638125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ba5e5eca385e490284556e8eb083b0fd.jpg", "device_id": "acf5618e-c2a7-449a-965d-7e365d89d26a", "is_chatting": 1, "label_rate": 1, "log_seq": "77c708537d31472b95228d4046f2f306", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "105083641"}', '2025-04-14 21:42:05', 1744638125000, '2025-04-14 21:42:05'),
('sql_screenshots', 16, '2025-04-14 21:43:05', 'id_6d84948f31134647', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "94369556_1744638185000_82365582_1744638185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c00deeffbd6b485da57df312b0a23582.jpg", "device_id": "da89aed5-5867-432a-bc37-4565bebff3b8", "is_chatting": 1, "label_rate": 0, "log_seq": "90565605b46d4efca7156a5f1edb31b5", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "94369556"}', '2025-04-14 21:43:05', 1744638185000, '2025-04-14 21:43:05'),
('sql_screenshots', 16, '2025-04-14 21:44:05', 'id_9c64702d7f4f4b2d', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744638245000_110892617_1744638245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ace430ab923b4617b8a4072996b60c8e.jpg", "device_id": "d508aac5-ed32-4c19-a257-0b699e272f4f", "is_chatting": 1, "label_rate": 2, "log_seq": "1838cd526a494f95bd4fe86a4d9c5a03", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "108466147"}', '2025-04-14 21:44:05', 1744638245000, '2025-04-14 21:44:05'),
('sql_screenshots', 16, '2025-04-14 21:45:05', 'id_f4edb8ec011043bd', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "81479540_1744638305000_57649476_1744638305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ad9843ef8328465eb89f96cadcfafabe.jpg", "device_id": "4f6c8ae6-6842-4b08-a1b6-0d33d298324b", "is_chatting": 1, "label_rate": 1, "log_seq": "11c3bf3f9dfb4e80a39054c0c083a5b5", "phone_model": "VIVO_X60", "rate": 5, "target_id": "81479540"}', '2025-04-14 21:45:05', 1744638305000, '2025-04-14 21:45:05'),
('sql_screenshots', 16, '2025-04-14 21:46:05', 'id_b5ac224f52ce455e', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "32970671_1744638365000_81479540_1744638365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8f32c50088ea454e87d3bb13fc368bbd.jpg", "device_id": "d4065390-19f1-4a9d-b9fc-8e286f06a221", "is_chatting": 1, "label_rate": 2, "log_seq": "7b673d89436f4406854d8333b1edafb1", "phone_model": "Huawei_P40", "rate": 0, "target_id": "32970671"}', '2025-04-14 21:46:05', 1744638365000, '2025-04-14 21:46:05'),
('sql_screenshots', 16, '2025-04-14 21:47:05', 'id_b35387d48ec44d98', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105083641_1744638425000_64280379_1744638425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4be5c23b42ec457990534aece793f161.jpg", "device_id": "1670ca89-ceb6-40f8-9187-bb0a834d9636", "is_chatting": 1, "label_rate": 2, "log_seq": "3385fae6d88640dba64704c25bb55ce4", "phone_model": "iPhone_13", "rate": 5, "target_id": "105083641"}', '2025-04-14 21:47:05', 1744638425000, '2025-04-14 21:47:05'),
('sql_screenshots', 16, '2025-04-14 21:48:05', 'id_610658fa0b484d84', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105083641_1744638485000_94369556_1744638485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e33e997dedd4412a8b3fb487040a0232.jpg", "device_id": "6d13e410-e4b7-4e5e-8626-73e0c281cb37", "is_chatting": 1, "label_rate": 0, "log_seq": "51f79c34f61d47c0ad477503657d09e3", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "105083641"}', '2025-04-14 21:48:05', 1744638485000, '2025-04-14 21:48:05'),
('sql_screenshots', 16, '2025-04-14 21:49:05', 'id_b9b881c47a244f92', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "57649476_1744638545000_105503656_1744638545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/fb3acd9f22f7429cbf0f3f36640a7682.jpg", "device_id": "0f5bda17-9ebf-468f-8983-840503c2b2f2", "is_chatting": 1, "label_rate": 2, "log_seq": "4596fbc228454689a3c117d86e44c33c", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "57649476"}', '2025-04-14 21:49:05', 1744638545000, '2025-04-14 21:49:05'),
('sql_screenshots', 16, '2025-04-14 21:50:05', 'id_4ffe61d17df744b9', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110892617_1744638605000_107039703_1744638605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d81e93e38ee344a28c00a63603eff9e6.jpg", "device_id": "0ce6373e-dcfd-4192-85c5-8ea2cda5f0bb", "is_chatting": 1, "label_rate": 2, "log_seq": "8e7ccb38811a402ca269d5bfb082db8a", "phone_model": "OnePlus_9", "rate": 0, "target_id": "110892617"}', '2025-04-14 21:50:05', 1744638605000, '2025-04-14 21:50:05'),
('sql_screenshots', 16, '2025-04-14 21:51:05', 'id_38e462671dfa4d51', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110890469_1744638665000_104844318_1744638665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/843f3977e785408aa0545d6e46cd96f5.jpg", "device_id": "6e4e55ba-fc3f-4cee-b792-e5e53509fd7d", "is_chatting": 1, "label_rate": 1, "log_seq": "3e9517d9d5264f82bed427c8d54f1b03", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "110890469"}', '2025-04-14 21:51:05', 1744638665000, '2025-04-14 21:51:05'),
('sql_screenshots', 16, '2025-04-14 21:52:05', 'id_b63c32670b134ca6', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110876251_1744638725000_108870508_1744638725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/976cee4c7b5d4a94ac7a0c806146964d.jpg", "device_id": "45089d9e-3c28-4c41-acf1-010d3c6a8fae", "is_chatting": 1, "label_rate": 2, "log_seq": "ef82cde8e5c8468280446f74280c74b7", "phone_model": "Samsung_S22", "rate": 0, "target_id": "110876251"}', '2025-04-14 21:52:05', 1744638725000, '2025-04-14 21:52:05'),
('sql_screenshots', 16, '2025-04-14 21:53:05', 'id_ac171fc93a54438d', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108466147_1744638785000_110766160_1744638785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7500b9fa166d4c7c86b9c4dec987bf4a.jpg", "device_id": "f35cac08-1922-4a09-b711-b929a57d8567", "is_chatting": 1, "label_rate": 1, "log_seq": "b9e6c573ac9e44bd8b3371a9cd29d24c", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "108466147"}', '2025-04-14 21:53:05', 1744638785000, '2025-04-14 21:53:05'),
('sql_screenshots', 16, '2025-04-14 21:54:05', 'id_43299d7aa2414703', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "83341608_1744638845000_110876251_1744638845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b661a3a105c54f378ac2a3b3c99ac4c6.jpg", "device_id": "ce28cee1-adc2-45cb-80bb-48990863656a", "is_chatting": 1, "label_rate": 0, "log_seq": "ef4cf16bac684c449910baecdb1b2d23", "phone_model": "Huawei_P40", "rate": 2, "target_id": "83341608"}', '2025-04-14 21:54:05', 1744638845000, '2025-04-14 21:54:05'),
('sql_screenshots', 16, '2025-04-14 21:55:05', 'id_68c6fa3f7f164ff5', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109744448_1744638905000_104844318_1744638905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/21584f2aa6294d47b776049c30c4879c.jpg", "device_id": "2d6f2887-f21b-4f26-aed6-c8755029a0aa", "is_chatting": 1, "label_rate": 1, "log_seq": "aaab4297f4084dc2ae5f480d4d3d2884", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "109744448"}', '2025-04-14 21:55:05', 1744638905000, '2025-04-14 21:55:05'),
('sql_screenshots', 16, '2025-04-14 21:56:05', 'id_5fdc0c72f0544ac3', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110766160_1744638965000_83341608_1744638965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/499b0cf1d6b9491fb49e1b54200b8f9a.jpg", "device_id": "13cbb076-a3f8-4ee3-9b84-33db9e354f76", "is_chatting": 1, "label_rate": 2, "log_seq": "bad0b149780e4c83bbfa74a99ff1fec7", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "110766160"}', '2025-04-14 21:56:05', 1744638965000, '2025-04-14 21:56:05'),
('sql_screenshots', 16, '2025-04-14 21:57:05', 'id_8e46e53dfdc64b39', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110876251_1744639025000_105503656_1744639025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e448fcc808eb40899df5f0c9ebd2e77b.jpg", "device_id": "c50ab3fe-d042-4b71-bf14-df214f79f81b", "is_chatting": 1, "label_rate": 0, "log_seq": "f147ac64d48a4785a00cad4ec0d9339c", "phone_model": "VIVO_X60", "rate": 5, "target_id": "110876251"}', '2025-04-14 21:57:05', 1744639025000, '2025-04-14 21:57:05'),
('sql_screenshots', 16, '2025-04-14 21:58:05', 'id_472d1bc71a4b4c7a', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "81479540_1744639085000_28230174_1744639085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/780f8848408d4f978f33b43dd881beae.jpg", "device_id": "45f71fb3-e764-4380-b3c0-f3235ed4b892", "is_chatting": 1, "label_rate": 1, "log_seq": "076e2eadfff8471b94af49ee54c9fe0f", "phone_model": "VIVO_X60", "rate": 1, "target_id": "81479540"}', '2025-04-14 21:58:05', 1744639085000, '2025-04-14 21:58:05'),
('sql_screenshots', 16, '2025-04-14 21:59:05', 'id_7cbef6bdddd04f9c', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109407413_1744639145000_110890469_1744639145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8c97dc76cfc04b39af3beb730ddd6e10.jpg", "device_id": "96d8acbd-70b2-43fc-82ad-522251bfad9e", "is_chatting": 1, "label_rate": 1, "log_seq": "37a1fae0f7ed4a6faf68fe89b9aad93b", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "109407413"}', '2025-04-14 21:59:05', 1744639145000, '2025-04-14 21:59:05'),
('sql_screenshots', 16, '2025-04-14 22:00:05', 'id_7e635fd656514518', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "32970671_1744639205000_57649476_1744639205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ab09115261244a4d94bbd934539b0eaf.jpg", "device_id": "93a6835b-04fd-4550-8bdf-47b6f73d7bde", "is_chatting": 1, "label_rate": 0, "log_seq": "e3424bfe903b4e439d1e804391543145", "phone_model": "Huawei_P40", "rate": 0, "target_id": "32970671"}', '2025-04-14 22:00:05', 1744639205000, '2025-04-14 22:00:05'),
('sql_screenshots', 16, '2025-04-14 22:01:05', 'id_3547e456d63748da', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109744448_1744639265000_32970671_1744639265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a361c7eaa35c41d6bafee3776d6769ee.jpg", "device_id": "caeed948-a40b-4446-9ec4-23835b67bcde", "is_chatting": 1, "label_rate": 0, "log_seq": "204c70da24d04af1a26eb6f66b0d7a61", "phone_model": "Samsung_S22", "rate": 3, "target_id": "109744448"}', '2025-04-14 22:01:05', 1744639265000, '2025-04-14 22:01:05'),
('sql_screenshots', 16, '2025-04-14 22:02:05', 'id_0bbf1586ae594995', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744639325000_110766160_1744639325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2ce5e4629be147329280da722455667c.jpg", "device_id": "251054e1-8c4c-431e-a3e9-d9cb49e0abe8", "is_chatting": 1, "label_rate": 2, "log_seq": "d2c617562e5f45c19728d6efd4fe0f92", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "32970671"}', '2025-04-14 22:02:05', 1744639325000, '2025-04-14 22:02:05'),
('sql_screenshots', 16, '2025-04-14 22:03:05', 'id_d9747dcc06a94929', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108870508_1744639385000_54675542_1744639385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4aef83d54f9946818eb4229963dc3bc8.jpg", "device_id": "844274cf-8314-4658-a010-9cfecd878eeb", "is_chatting": 1, "label_rate": 2, "log_seq": "8781478ffb7c4a508b3a8982ee4970d9", "phone_model": "Huawei_P40", "rate": 5, "target_id": "108870508"}', '2025-04-14 22:03:05', 1744639385000, '2025-04-14 22:03:05'),
('sql_screenshots', 16, '2025-04-14 22:04:05', 'id_bd8f961046584c87', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110215081_1744639445000_105503656_1744639445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4d0aeda31dc340b4ab3a4a6da9fcc8e7.jpg", "device_id": "5d3b958a-36e3-44c9-a50f-1b47be7eb68f", "is_chatting": 1, "label_rate": 0, "log_seq": "f6385593153646f0b2d71fba1a674396", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "110215081"}', '2025-04-14 22:04:05', 1744639445000, '2025-04-14 22:04:05'),
('sql_screenshots', 16, '2025-04-14 22:05:05', 'id_4669f285bac240a6', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109744448_1744639505000_110766160_1744639505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/da978ff8700c4623b4825cc49d0149df.jpg", "device_id": "c0facb11-9619-4301-ab8e-93b718ba5098", "is_chatting": 1, "label_rate": 1, "log_seq": "3972c59b1ce546a6ad4a5941af9e1ec9", "phone_model": "OnePlus_9", "rate": 4, "target_id": "109744448"}', '2025-04-14 22:05:05', 1744639505000, '2025-04-14 22:05:05'),
('sql_screenshots', 16, '2025-04-14 22:06:05', 'id_b0f35dda769e4a34', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "57649476_1744639565000_105503656_1744639565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9c7ad66daaaf4c28a89055aa79ce7c2e.jpg", "device_id": "55c96513-ad91-474e-9f74-e4dd0903dc7d", "is_chatting": 1, "label_rate": 0, "log_seq": "ff0e3cfdee794eac8176654cccdc93ae", "phone_model": "OnePlus_9", "rate": 1, "target_id": "57649476"}', '2025-04-14 22:06:05', 1744639565000, '2025-04-14 22:06:05'),
('sql_screenshots', 16, '2025-04-14 22:07:05', 'id_21786aa2f8524ea8', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744639625000_104844318_1744639625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/41f35bf95d414908815d1d524b966763.jpg", "device_id": "b7c9b2b1-ef14-405e-8bdb-be34f64e2836", "is_chatting": 1, "label_rate": 1, "log_seq": "9e8b5a82afd44ae9a0d5286987bf1319", "phone_model": "VIVO_X60", "rate": 3, "target_id": "32970671"}', '2025-04-14 22:07:05', 1744639625000, '2025-04-14 22:07:05'),
('sql_screenshots', 16, '2025-04-14 22:08:05', 'id_1e0ad782fabd4010', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744639685000_83341608_1744639685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b68cebaeaecf4a2581d912d3a1a7ce62.jpg", "device_id": "b07413f7-1243-4203-a6cf-434ac808ff2c", "is_chatting": 1, "label_rate": 2, "log_seq": "b0084417e37c4619ae8d2d414ef4a4a8", "phone_model": "Samsung_S22", "rate": 5, "target_id": "87571440"}', '2025-04-14 22:08:05', 1744639685000, '2025-04-14 22:08:05'),
('sql_screenshots', 16, '2025-04-14 22:09:05', 'id_fc9551b85bfb4a17', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "83341608_1744639745000_104844318_1744639745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f6887902466a4ee999c7a7f11ad49bb3.jpg", "device_id": "d95677a8-5f49-4714-993b-652d735fe7ab", "is_chatting": 1, "label_rate": 0, "log_seq": "35ad24f93f544926906930e00a3abe5b", "phone_model": "Samsung_S22", "rate": 4, "target_id": "83341608"}', '2025-04-14 22:09:05', 1744639745000, '2025-04-14 22:09:05'),
('sql_screenshots', 16, '2025-04-14 22:10:05', 'id_3c426f48ac164786', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "64280379_1744639805000_83341608_1744639805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9b4e3c29c01249298f833a894dff293b.jpg", "device_id": "c0c9dcf8-1b9a-43bc-a773-291aeb681478", "is_chatting": 1, "label_rate": 2, "log_seq": "d8603525787d4bd3a28369a14e08ec84", "phone_model": "OnePlus_9", "rate": 1, "target_id": "64280379"}', '2025-04-14 22:10:05', 1744639805000, '2025-04-14 22:10:05'),
('sql_screenshots', 16, '2025-04-14 22:11:05', 'id_0ec8b04c7e0b43c7', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "87571440_1744639865000_94369556_1744639865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f69958ae724e43df92b98a1f6dc091d4.jpg", "device_id": "d1851543-8901-4a07-ab92-6a34031e93f8", "is_chatting": 1, "label_rate": 0, "log_seq": "662b5b8520704079bea7b9c0febc6291", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "87571440"}', '2025-04-14 22:11:05', 1744639865000, '2025-04-14 22:11:05'),
('sql_screenshots', 16, '2025-04-14 22:12:05', 'id_45c8250d851c40d4', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110890469_1744639925000_109980113_1744639925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f5469ecb008b43eb8cd8075f3f7bc260.jpg", "device_id": "2822b35f-b025-4266-be7f-6024be2dfd63", "is_chatting": 1, "label_rate": 1, "log_seq": "df4df377b018427b95648ab1a781aca3", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "110890469"}', '2025-04-14 22:12:05', 1744639925000, '2025-04-14 22:12:05'),
('sql_screenshots', 16, '2025-04-14 22:13:05', 'id_ad60b078ec2e4ee6', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744639985000_54675542_1744639985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e9acde530a4f4d16910c3032bf142248.jpg", "device_id": "86d375d9-881e-487f-87c2-7c4eeac92b4b", "is_chatting": 1, "label_rate": 2, "log_seq": "c275cefe38b4418ab4a6d3cabbf31849", "phone_model": "Samsung_S21", "rate": 3, "target_id": "110766160"}', '2025-04-14 22:13:05', 1744639985000, '2025-04-14 22:13:05'),
('sql_screenshots', 16, '2025-04-14 22:14:05', 'id_f103f1a2c7824418', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744640045000_110892617_1744640045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/319f351c7421457d9d421bfe03d408ee.jpg", "device_id": "fe176671-d842-40a0-8069-e46fe34bd09b", "is_chatting": 1, "label_rate": 1, "log_seq": "4b7626e323254f0a953007c8e1066b21", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "82365582"}', '2025-04-14 22:14:05', 1744640045000, '2025-04-14 22:14:05'),
('sql_screenshots', 16, '2025-04-14 22:15:05', 'id_9e072b655c5549e2', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "94369556_1744640105000_107039703_1744640105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a41e5935749544929fcde822f74d68f6.jpg", "device_id": "a3884f44-31ed-430a-bd2c-0d913227f797", "is_chatting": 1, "label_rate": 2, "log_seq": "1f0088eefaf548c8b8304ec838b23ced", "phone_model": "iPhone_13", "rate": 1, "target_id": "94369556"}', '2025-04-14 22:15:05', 1744640105000, '2025-04-14 22:15:05'),
('sql_screenshots', 16, '2025-04-14 22:16:05', 'id_cd00c3243d444e2b', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "104844318_1744640165000_108466147_1744640165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e9a08ee6c02446969c82dfd511a1508a.jpg", "device_id": "cbc64220-30bc-4507-b66a-3abb8c67e9d4", "is_chatting": 1, "label_rate": 0, "log_seq": "975ce2ee2a71485a9fb10c13af9a47cb", "phone_model": "Samsung_S22", "rate": 1, "target_id": "104844318"}', '2025-04-14 22:16:05', 1744640165000, '2025-04-14 22:16:05'),
('sql_screenshots', 16, '2025-04-14 22:17:05', 'id_f41dc50bda844dfb', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "101553185_1744640225000_110892617_1744640225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/15703b6046a1405898fd92af3b127b8e.jpg", "device_id": "14452233-85fa-4043-92de-ff5dd5ed4ca1", "is_chatting": 1, "label_rate": 1, "log_seq": "9c78374aa68a4838a421016fd99b7786", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "101553185"}', '2025-04-14 22:17:05', 1744640225000, '2025-04-14 22:17:05'),
('sql_screenshots', 16, '2025-04-14 22:18:05', 'id_ac1bb12473a74559', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744640285000_110890469_1744640285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f1f06c6c34ae4c16ac4c5b62216f1b1f.jpg", "device_id": "e2068545-8144-4fcb-a7c5-929c8150def8", "is_chatting": 1, "label_rate": 0, "log_seq": "c3ebf510f907498caa1569213e9b2722", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "108466147"}', '2025-04-14 22:18:05', 1744640285000, '2025-04-14 22:18:05'),
('sql_screenshots', 16, '2025-04-14 22:19:05', 'id_8a9e69d14e124b14', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "94369556_1744640345000_87571440_1744640345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a48907b686524884b87497bf26e3bea0.jpg", "device_id": "c709af63-6285-4605-a449-309c603fe67b", "is_chatting": 1, "label_rate": 2, "log_seq": "287905160ce442589b770930417d0722", "phone_model": "Huawei_P40", "rate": 4, "target_id": "94369556"}', '2025-04-14 22:19:05', 1744640345000, '2025-04-14 22:19:05'),
('sql_screenshots', 16, '2025-04-14 22:20:05', 'id_3d86bf274f634dfe', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "94369556_1744640405000_32970671_1744640405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ba4dc20d78c743dcbdffc91a359cf596.jpg", "device_id": "8566292e-5383-43cc-9b87-667556b7d057", "is_chatting": 1, "label_rate": 0, "log_seq": "958f5452bea64ed3bddebc3fe6ea4e11", "phone_model": "OnePlus_9", "rate": 1, "target_id": "94369556"}', '2025-04-14 22:20:05', 1744640405000, '2025-04-14 22:20:05'),
('sql_screenshots', 16, '2025-04-14 22:21:05', 'id_9f8a7615aafe4936', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744640465000_54675542_1744640465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/28145ef6080b49e087e533cfe6297e2d.jpg", "device_id": "bc1fd050-0aa3-4654-9d90-0aa78bd5a057", "is_chatting": 1, "label_rate": 2, "log_seq": "e6dd3e3626cd4718b511303a1bf38bc2", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "110876251"}', '2025-04-14 22:21:05', 1744640465000, '2025-04-14 22:21:05'),
('sql_screenshots', 16, '2025-04-14 22:22:05', 'id_11d48b0c7ed44f1d', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "101553185_1744640525000_57649476_1744640525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6db0e61190e845bb9e20245b73658a4d.jpg", "device_id": "13606dbd-8efb-4ade-a741-f99c9921f317", "is_chatting": 1, "label_rate": 1, "log_seq": "fbe931025c2140f7bad87561db0af7d9", "phone_model": "VIVO_X60", "rate": 5, "target_id": "101553185"}', '2025-04-14 22:22:05', 1744640525000, '2025-04-14 22:22:05'),
('sql_screenshots', 16, '2025-04-14 22:23:05', 'id_d471335bd7c7400b', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110873051_1744640585000_110876251_1744640585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/871fcd01072c452c918f2bcc9200f96d.jpg", "device_id": "44bb5fec-19f4-4d27-a862-cf60cbdd65c8", "is_chatting": 1, "label_rate": 2, "log_seq": "6d1f78cf309e41dfac517b81951859b3", "phone_model": "Huawei_P40", "rate": 5, "target_id": "110873051"}', '2025-04-14 22:23:05', 1744640585000, '2025-04-14 22:23:05'),
('sql_screenshots', 16, '2025-04-14 22:24:05', 'id_25529ff1d1ac4e3e', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109744448_1744640645000_110873051_1744640645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/554eba484f064948a7f9f2e36bf2fa5e.jpg", "device_id": "38122730-b965-44f6-8e6e-cc8b01b91dde", "is_chatting": 1, "label_rate": 1, "log_seq": "4501635f19a94d4db2125f6de3e0f9b5", "phone_model": "Samsung_S22", "rate": 3, "target_id": "109744448"}', '2025-04-14 22:24:05', 1744640645000, '2025-04-14 22:24:05'),
('sql_screenshots', 16, '2025-04-14 22:25:05', 'id_222ff42d74004cad', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105083641_1744640705000_110892617_1744640705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c61dccd46f074cf1bad1a336c6fbebd3.jpg", "device_id": "77e9b93c-4df2-4d33-a970-9764ac095586", "is_chatting": 1, "label_rate": 0, "log_seq": "55379c861141469a98a34de4adf4bf54", "phone_model": "OnePlus_9", "rate": 1, "target_id": "105083641"}', '2025-04-14 22:25:05', 1744640705000, '2025-04-14 22:25:05'),
('sql_screenshots', 16, '2025-04-14 22:26:05', 'id_ae7566f549274e1c', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "101553185_1744640765000_109744448_1744640765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f1abf7f2490741879b772743246b8f27.jpg", "device_id": "e7772c67-fc54-402e-9233-86db3ca2fb30", "is_chatting": 1, "label_rate": 0, "log_seq": "c998a428ff574b4daeea27f72f77e3f3", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "101553185"}', '2025-04-14 22:26:05', 1744640765000, '2025-04-14 22:26:05'),
('sql_screenshots', 16, '2025-04-14 22:27:05', 'id_52aa4be1452a4244', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109980113_1744640825000_28230174_1744640825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b7392dbe967e4615bec26d630caecfdb.jpg", "device_id": "42c9e43b-6513-4622-ad39-30ae8e45a839", "is_chatting": 1, "label_rate": 2, "log_seq": "00ee5d9a452d40f48561b1d12b548787", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "109980113"}', '2025-04-14 22:27:05', 1744640825000, '2025-04-14 22:27:05'),
('sql_screenshots', 16, '2025-04-14 22:28:05', 'id_6c2278db766848e1', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "32970671_1744640885000_110890469_1744640885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f148c4636ae94d11a88fa0264110b7ee.jpg", "device_id": "23dd0f55-14a4-462e-b772-495c582a5c7b", "is_chatting": 1, "label_rate": 1, "log_seq": "81af95147bdf40259eef9dc27bb5a0b6", "phone_model": "Samsung_S22", "rate": 2, "target_id": "32970671"}', '2025-04-14 22:28:05', 1744640885000, '2025-04-14 22:28:05'),
('sql_screenshots', 16, '2025-04-14 22:29:05', 'id_d5d805effe184616', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744640945000_64280379_1744640945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/fbc928a2e6524c63aebd1a60e79ebb57.jpg", "device_id": "c95df6ea-182d-4a32-b4e4-15782ba16e43", "is_chatting": 1, "label_rate": 2, "log_seq": "65bdf8e0a9c94b9e89b9e9c37e29f756", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "110876251"}', '2025-04-14 22:29:05', 1744640945000, '2025-04-14 22:29:05'),
('sql_screenshots', 16, '2025-04-14 22:30:05', 'id_5248ef9c5e1042ea', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105503656_1744641005000_109744448_1744641005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3a862e06ce964041aa24a1b8027e3796.jpg", "device_id": "6b61594f-d5bb-4790-96b5-cc4e813c4acd", "is_chatting": 1, "label_rate": 1, "log_seq": "3c6e68e4a643492f9010dfc15ee178ac", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "105503656"}', '2025-04-14 22:30:05', 1744641005000, '2025-04-14 22:30:05'),
('sql_screenshots', 16, '2025-04-14 22:31:05', 'id_e0e2e3c1881b4057', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108870508_1744641065000_109980113_1744641065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/414b40ca23ec4e8296e4183edd63df71.jpg", "device_id": "6ac26e92-2f6f-42d7-8128-34840acde674", "is_chatting": 1, "label_rate": 1, "log_seq": "ddee129fc14d44cca2c09bb9f4a91ef0", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "108870508"}', '2025-04-14 22:31:05', 1744641065000, '2025-04-14 22:31:05'),
('sql_screenshots', 16, '2025-04-14 22:32:05', 'id_3467769a6e0e434c', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110215081_1744641125000_28230174_1744641125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3b04e27294f54667bc6a418830b4d726.jpg", "device_id": "27678cbd-a2f5-45f5-908b-e05f939a0940", "is_chatting": 1, "label_rate": 0, "log_seq": "25f3af842fef42c38ae5e005d5164e11", "phone_model": "Huawei_P40", "rate": 5, "target_id": "110215081"}', '2025-04-14 22:32:05', 1744641125000, '2025-04-14 22:32:05'),
('sql_screenshots', 16, '2025-04-14 22:33:05', 'id_7c98de783aca4374', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110873051_1744641185000_108466147_1744641185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9030e7a39c664e6ba6976bf352366a85.jpg", "device_id": "95e6e20b-ede7-46bb-92ae-cb0141ab0db3", "is_chatting": 1, "label_rate": 2, "log_seq": "6ab79294d36c49f28ad659213a727295", "phone_model": "OnePlus_9", "rate": 3, "target_id": "110873051"}', '2025-04-14 22:33:05', 1744641185000, '2025-04-14 22:33:05'),
('sql_screenshots', 16, '2025-04-14 22:34:05', 'id_85e25ddcf6984e5d', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744641245000_110890469_1744641245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4a9e18f3461b42cfb1e459d05d423735.jpg", "device_id": "0889c858-d940-4bdd-8980-e46ffc7c4f95", "is_chatting": 1, "label_rate": 1, "log_seq": "6c6a4e7609c147749b03ae1ae05e571b", "phone_model": "Samsung_S21", "rate": 0, "target_id": "109744448"}', '2025-04-14 22:34:05', 1744641245000, '2025-04-14 22:34:05'),
('sql_screenshots', 16, '2025-04-14 22:35:05', 'id_5c87d1c954ba4c48', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105503656_1744641305000_82365582_1744641305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b858c6a3b1f64ba69715595bd65d6e1a.jpg", "device_id": "cb791945-7aba-4f4b-a34d-80db6eec5008", "is_chatting": 1, "label_rate": 1, "log_seq": "3f32ee21d40b422e92b18c517f59c3e8", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "105503656"}', '2025-04-14 22:35:05', 1744641305000, '2025-04-14 22:35:05'),
('sql_screenshots', 16, '2025-04-14 22:36:05', 'id_2840f0a217b94e8e', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105503656_1744641365000_110215081_1744641365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/24f1545482f34e4a951152cb761dd354.jpg", "device_id": "6d2da34e-e454-4172-91af-9ece0bed5bdc", "is_chatting": 1, "label_rate": 2, "log_seq": "29bd9e0a85324e15a54d963513fa3871", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "105503656"}', '2025-04-14 22:36:05', 1744641365000, '2025-04-14 22:36:05'),
('sql_screenshots', 16, '2025-04-14 22:37:05', 'id_ebf226a0bc724172', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109744448_1744641425000_110215081_1744641425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3659793b0d90434982878b34431b0714.jpg", "device_id": "f1b378bc-b706-4b15-abef-1c6abe69c05f", "is_chatting": 1, "label_rate": 2, "log_seq": "a32bd02d9ab048c89acfcc035c02768c", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "109744448"}', '2025-04-14 22:37:05', 1744641425000, '2025-04-14 22:37:05'),
('sql_screenshots', 16, '2025-04-14 22:38:05', 'id_14b650d3635940a4', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109407413_1744641485000_108466147_1744641485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b87676ea958043459967655a09a626f6.jpg", "device_id": "acbb4649-2e00-4ab3-85c0-645c93f5e81c", "is_chatting": 1, "label_rate": 0, "log_seq": "bc0c18e0229043639170cbc2bc76f176", "phone_model": "iPhone_13", "rate": 0, "target_id": "109407413"}', '2025-04-14 22:38:05', 1744641485000, '2025-04-14 22:38:05'),
('sql_screenshots', 16, '2025-04-14 22:39:05', 'id_8168e02499cd44b9', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "82365582_1744641545000_32970671_1744641545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/54091a8359ed4e638cab8eae8df0a39a.jpg", "device_id": "13a1e328-0b4b-44fa-a673-97289eb0b96c", "is_chatting": 1, "label_rate": 0, "log_seq": "7ed017e20de74327bfeba7e46068e5aa", "phone_model": "Huawei_P40", "rate": 1, "target_id": "82365582"}', '2025-04-14 22:39:05', 1744641545000, '2025-04-14 22:39:05'),
('sql_screenshots', 16, '2025-04-14 22:40:05', 'id_b950402d16cc4a12', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "57649476_1744641605000_101553185_1744641605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ca51e2cf7eca470aaea4ccb4e2ff8d95.jpg", "device_id": "81a79527-41ba-4332-bbfa-e0b5a47cd171", "is_chatting": 1, "label_rate": 0, "log_seq": "3b9244f6b0d5422fafa14152e096d3f7", "phone_model": "Samsung_S22", "rate": 4, "target_id": "57649476"}', '2025-04-14 22:40:05', 1744641605000, '2025-04-14 22:40:05'),
('sql_screenshots', 16, '2025-04-14 22:41:05', 'id_1bd320db89804aca', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110766160_1744641665000_107039703_1744641665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d9b72b0b7aa64d1594e85319ee45c0e3.jpg", "device_id": "3f9af231-2a5b-4d0d-b094-35914f68a2eb", "is_chatting": 1, "label_rate": 0, "log_seq": "c7668d0a851d4814b9726b4f5cb427f2", "phone_model": "OnePlus_9", "rate": 5, "target_id": "110766160"}', '2025-04-14 22:41:05', 1744641665000, '2025-04-14 22:41:05'),
('sql_screenshots', 16, '2025-04-14 22:42:05', 'id_cd8b57cd93f44013', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744641725000_83341608_1744641725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8d50e9b208ce4f25accd9b6d0a3286dc.jpg", "device_id": "e286819b-14cb-46e1-b3c3-a3ba803a67d1", "is_chatting": 1, "label_rate": 0, "log_seq": "5b31c77b6ea54705a6a2fce57d91c234", "phone_model": "Samsung_S22", "rate": 2, "target_id": "110766160"}', '2025-04-14 22:42:05', 1744641725000, '2025-04-14 22:42:05'),
('sql_screenshots', 16, '2025-04-14 22:43:05', 'id_b069b33a0b74434d', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109744448_1744641785000_109657261_1744641785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5f748270154a400db9fa4a96b7eb734f.jpg", "device_id": "c5dc57f2-46a5-409a-bec1-c66711745f22", "is_chatting": 1, "label_rate": 0, "log_seq": "bdb0a1a76a804367b4f8f1fed9d289b4", "phone_model": "iPhone_13", "rate": 5, "target_id": "109744448"}', '2025-04-14 22:43:05', 1744641785000, '2025-04-14 22:43:05'),
('sql_screenshots', 16, '2025-04-14 22:44:05', 'id_6832ddb2208440e6', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "87571440_1744641845000_28230174_1744641845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/af453308453a46cfa74668687b353077.jpg", "device_id": "a4511d3b-7be1-4e3c-8581-00e922a5ec01", "is_chatting": 1, "label_rate": 2, "log_seq": "1c5552d2aa9b49659ea50411b314a8c7", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "87571440"}', '2025-04-14 22:44:05', 1744641845000, '2025-04-14 22:44:05'),
('sql_screenshots', 16, '2025-04-14 22:45:05', 'id_8ea56220e8ec4069', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "83341608_1744641905000_109980113_1744641905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/385e50f1a578420ea03f01433059a034.jpg", "device_id": "c7bd11c9-70ff-42f2-a0a2-40811091a1c4", "is_chatting": 1, "label_rate": 1, "log_seq": "769d44e0bd594c7f824fe5e9fd99a7f8", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "83341608"}', '2025-04-14 22:45:05', 1744641905000, '2025-04-14 22:45:05'),
('sql_screenshots', 16, '2025-04-14 22:46:05', 'id_0e95b979e74d4a33', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "81479540_1744641965000_109657261_1744641965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/04720147849544be8fcebcc69e4bd23d.jpg", "device_id": "d0bc9720-f4d7-4013-ba43-0bbb9e2cbd0a", "is_chatting": 1, "label_rate": 0, "log_seq": "100ebf9164d7494586f4ebeb6d5f0ae2", "phone_model": "OnePlus_9", "rate": 2, "target_id": "81479540"}', '2025-04-14 22:46:05', 1744641965000, '2025-04-14 22:46:05'),
('sql_screenshots', 16, '2025-04-14 22:47:05', 'id_942d7257ec1945de', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110876251_1744642025000_64280379_1744642025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/823a1b2fe96e49ffba2914ea3cb85028.jpg", "device_id": "3c793d01-d03f-4d6d-b82c-420041eceb48", "is_chatting": 1, "label_rate": 2, "log_seq": "cd3593c758734222ad787c0b55ae59b5", "phone_model": "VIVO_X60", "rate": 2, "target_id": "110876251"}', '2025-04-14 22:47:05', 1744642025000, '2025-04-14 22:47:05'),
('sql_screenshots', 16, '2025-04-14 22:48:05', 'id_aac9323598d8428a', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "82365582_1744642085000_57649476_1744642085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/98c333edb9d643ee995de5599be22d4f.jpg", "device_id": "57594791-b403-49f4-8180-4717adb20b4f", "is_chatting": 1, "label_rate": 0, "log_seq": "ca0cb8bb04e844bab39f50d6f7ded493", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "82365582"}', '2025-04-14 22:48:05', 1744642085000, '2025-04-14 22:48:05'),
('sql_screenshots', 16, '2025-04-14 22:49:05', 'id_0d18a2744a7f4f08', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105503656_1744642145000_82365582_1744642145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cb8000c78b554b9fa8ae2f6b0da6838d.jpg", "device_id": "c9ec1f61-791e-4dc0-bd7f-b60911b92bba", "is_chatting": 1, "label_rate": 2, "log_seq": "d219c9cb13a94d21b4cc924ceede6a87", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "105503656"}', '2025-04-14 22:49:05', 1744642145000, '2025-04-14 22:49:05'),
('sql_screenshots', 16, '2025-04-14 22:50:05', 'id_ed69baf421f74847', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109980113_1744642205000_28230174_1744642205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c79a29ab79144476981239430828e5ba.jpg", "device_id": "e76cc44d-2eb9-4be3-9397-87c8779b2b0c", "is_chatting": 1, "label_rate": 1, "log_seq": "c29a79c6a2464c7fb53895928ddba2f2", "phone_model": "Samsung_S21", "rate": 4, "target_id": "109980113"}', '2025-04-14 22:50:05', 1744642205000, '2025-04-14 22:50:05'),
('sql_screenshots', 16, '2025-04-14 22:51:05', 'id_aa35f8b82a0a48fa', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110873051_1744642265000_109657261_1744642265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/24b9b128f00c41838cc2a29e20674875.jpg", "device_id": "a9798cda-877c-47c6-9da1-f9feb38508eb", "is_chatting": 1, "label_rate": 2, "log_seq": "428116c3c0324674b0eff33c561e0f0f", "phone_model": "VIVO_X60", "rate": 1, "target_id": "110873051"}', '2025-04-14 22:51:05', 1744642265000, '2025-04-14 22:51:05'),
('sql_screenshots', 16, '2025-04-14 22:52:05', 'id_c1d85498b7c74e34', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109744448_1744642325000_82365582_1744642325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/316c880192b148af91d7a78052377ced.jpg", "device_id": "d506af4c-f038-42f0-9f20-1b2d669d82ae", "is_chatting": 1, "label_rate": 1, "log_seq": "e6d721daea1b41c392c36ccd65a91246", "phone_model": "Huawei_P40", "rate": 0, "target_id": "109744448"}', '2025-04-14 22:52:05', 1744642325000, '2025-04-14 22:52:05'),
('sql_screenshots', 16, '2025-04-14 22:53:05', 'id_e5689cb6eb9d4bb0', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744642385000_83341608_1744642385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cc876f0e46c5484bb8c0f1d0ebf63c3f.jpg", "device_id": "c9600562-2d39-447c-a301-5e3150064622", "is_chatting": 1, "label_rate": 2, "log_seq": "a091ecd4a65e4edb87b1b506435f6a6e", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "110876251"}', '2025-04-14 22:53:05', 1744642385000, '2025-04-14 22:53:05'),
('sql_screenshots', 16, '2025-04-14 22:54:05', 'id_e48c88ead3124032', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "101553185_1744642445000_110873051_1744642445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bade84a621d549b0aec497283e4118d5.jpg", "device_id": "06b9aabc-0ee2-4185-890b-46f4cc9c9962", "is_chatting": 1, "label_rate": 2, "log_seq": "97e5a162b77f44ed94d5b4f7e97e5e2b", "phone_model": "Samsung_S21", "rate": 0, "target_id": "101553185"}', '2025-04-14 22:54:05', 1744642445000, '2025-04-14 22:54:05'),
('sql_screenshots', 16, '2025-04-14 22:55:05', 'id_d54c5fee33b64e66', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744642505000_105503656_1744642505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9b06cee5d21249cbadfe1339826c4231.jpg", "device_id": "770126be-5104-407a-8b91-a8c87ba80942", "is_chatting": 1, "label_rate": 1, "log_seq": "ec0cbf2393b94943be6556ee2c6a90cb", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "109744448"}', '2025-04-14 22:55:05', 1744642505000, '2025-04-14 22:55:05'),
('sql_screenshots', 16, '2025-04-14 22:56:05', 'id_423511b7499e404e', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744642565000_110215081_1744642565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/03272dc895bb42b6aba155347e6304d4.jpg", "device_id": "1a857cc8-2ae2-4d41-b3a6-1aa4f07ff695", "is_chatting": 1, "label_rate": 2, "log_seq": "10bbab90043e4b92987ffe8969e7c5fd", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "109657261"}', '2025-04-14 22:56:05', 1744642565000, '2025-04-14 22:56:05'),
('sql_screenshots', 16, '2025-04-14 22:57:05', 'id_dcfd7a1546224955', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "101553185_1744642625000_109407413_1744642625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b6fe225ea2e14386b6db0217c9eb7d85.jpg", "device_id": "97f4f8f7-760e-43b1-ae46-2fe742eb45ac", "is_chatting": 1, "label_rate": 0, "log_seq": "c8dd996703484b0ba30600b4af20e359", "phone_model": "OnePlus_9", "rate": 0, "target_id": "101553185"}', '2025-04-14 22:57:05', 1744642625000, '2025-04-14 22:57:05'),
('sql_screenshots', 16, '2025-04-14 22:58:05', 'id_a464d32427c9495a', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "32970671_1744642685000_107039703_1744642685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6dee3289905b4b298015821c967f8af6.jpg", "device_id": "7ec73d89-4bf0-42a3-a888-d6ce832f8f40", "is_chatting": 1, "label_rate": 2, "log_seq": "36d81d4254c64f87875570cbce01810b", "phone_model": "Huawei_P40", "rate": 5, "target_id": "32970671"}', '2025-04-14 22:58:05', 1744642685000, '2025-04-14 22:58:05'),
('sql_screenshots', 16, '2025-04-14 22:59:05', 'id_1811ddafab7e43c3', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "104844318_1744642745000_109657261_1744642745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9a0dbf99ea764f5a8f77d1dbc3582364.jpg", "device_id": "35e6c58b-5ee4-40d7-b98c-efed73b5f9d6", "is_chatting": 1, "label_rate": 1, "log_seq": "f072db45c129452f82444b1b2c76460b", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "104844318"}', '2025-04-14 22:59:05', 1744642745000, '2025-04-14 22:59:05'),
('sql_screenshots', 16, '2025-04-14 23:00:05', 'id_bca8b84a0d7e4994', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "81479540_1744642805000_64280379_1744642805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ec9f6a12b00a45c1bca82c50025250fc.jpg", "device_id": "bd91d010-a3e9-4889-8c90-eb2b0878f99e", "is_chatting": 1, "label_rate": 2, "log_seq": "46d892cb81bd4f6b9965d44b2a1b722d", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "81479540"}', '2025-04-14 23:00:05', 1744642805000, '2025-04-14 23:00:05'),
('sql_screenshots', 16, '2025-04-14 23:01:05', 'id_c5293296e8914e10', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "107039703_1744642865000_110890469_1744642865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/39a3a4a9072741d795f0df711227947d.jpg", "device_id": "c5a69b96-358f-408e-b1ac-2c85e91d042a", "is_chatting": 1, "label_rate": 2, "log_seq": "147b18cf26cf48078c059b84044d2d4d", "phone_model": "VIVO_X60", "rate": 1, "target_id": "107039703"}', '2025-04-14 23:01:05', 1744642865000, '2025-04-14 23:01:05'),
('sql_screenshots', 16, '2025-04-14 23:02:05', 'id_6ad80831c7014003', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110766160_1744642925000_94369556_1744642925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1d86af71960d40c695778db192debe68.jpg", "device_id": "1c746b9f-5dd6-4b70-840d-78fcb263c2ca", "is_chatting": 1, "label_rate": 1, "log_seq": "6853cc7331de42afb15c4a8ce0dfc77e", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "110766160"}', '2025-04-14 23:02:05', 1744642925000, '2025-04-14 23:02:05'),
('sql_screenshots', 16, '2025-04-14 23:03:05', 'id_b9d2eb15884648b0', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "64280379_1744642985000_109744448_1744642985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3e581740796e40fa9cb665edc0846134.jpg", "device_id": "47805869-1200-40a6-8253-f0fcabfeb962", "is_chatting": 1, "label_rate": 1, "log_seq": "e1bf511623d8459389d753ade89d0129", "phone_model": "OnePlus_9", "rate": 3, "target_id": "64280379"}', '2025-04-14 23:03:05', 1744642985000, '2025-04-14 23:03:05'),
('sql_screenshots', 16, '2025-04-14 23:04:05', 'id_ba4343649a6046e4', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110876251_1744643045000_109980113_1744643045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/74a98876164443e79358d470ef665e87.jpg", "device_id": "a10fd456-0d85-4150-ae95-51af968cf0c3", "is_chatting": 1, "label_rate": 1, "log_seq": "09f50e7039594feabc106a192d1e3675", "phone_model": "Samsung_S21", "rate": 0, "target_id": "110876251"}', '2025-04-14 23:04:05', 1744643045000, '2025-04-14 23:04:05'),
('sql_screenshots', 16, '2025-04-14 23:05:05', 'id_bffa0cef021b426a', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "104844318_1744643105000_82365582_1744643105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9743dc1c232c497598b11d995f5616ed.jpg", "device_id": "3459f6dd-743b-44aa-964e-b1865a86ae33", "is_chatting": 1, "label_rate": 1, "log_seq": "7075137dea484b2b952f84ea0b1925a3", "phone_model": "OnePlus_9", "rate": 3, "target_id": "104844318"}', '2025-04-14 23:05:05', 1744643105000, '2025-04-14 23:05:05'),
('sql_screenshots', 16, '2025-04-14 23:06:05', 'id_62c686c607ef4e7e', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110890469_1744643165000_109657261_1744643165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f8bfb17ee4b94c9fa3c2530a7b2ff592.jpg", "device_id": "471be175-64de-4e5c-9391-a87004d47613", "is_chatting": 1, "label_rate": 0, "log_seq": "acc322fd7f7140afa5d0b90cdb7dafd5", "phone_model": "VIVO_X60", "rate": 0, "target_id": "110890469"}', '2025-04-14 23:06:05', 1744643165000, '2025-04-14 23:06:05'),
('sql_screenshots', 16, '2025-04-14 23:07:05', 'id_e5a422ef178e45e7', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744643225000_109407413_1744643225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9ddbaeecb25045ba8978c57bc4e335dd.jpg", "device_id": "c1710809-803c-4a56-9e82-205587d5da19", "is_chatting": 1, "label_rate": 0, "log_seq": "ccf06d0260e14ba592653a2235d547ef", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "110890469"}', '2025-04-14 23:07:05', 1744643225000, '2025-04-14 23:07:05'),
('sql_screenshots', 16, '2025-04-14 23:08:05', 'id_b257d059230a47f7', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "87571440_1744643285000_109657261_1744643285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/15126eccd1624a7b9657d10a3e4ad7ae.jpg", "device_id": "15298622-d28b-4bc9-8bf6-4cb88c55e2ac", "is_chatting": 1, "label_rate": 0, "log_seq": "f4ad50db16ec458fbfcaa51a659115ae", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "87571440"}', '2025-04-14 23:08:05', 1744643285000, '2025-04-14 23:08:05'),
('sql_screenshots', 16, '2025-04-14 23:09:05', 'id_823d80148197404f', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109407413_1744643345000_109980113_1744643345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d67657c99a4848c69f59d1814aab6382.jpg", "device_id": "51fe7eb0-3dca-41ca-916a-ed6145a34eb0", "is_chatting": 1, "label_rate": 0, "log_seq": "5e7d663d38a94d0abb3dc1a3428f7f8f", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "109407413"}', '2025-04-14 23:09:05', 1744643345000, '2025-04-14 23:09:05'),
('sql_screenshots', 16, '2025-04-14 23:10:05', 'id_2982deff09574d17', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "32970671_1744643405000_57649476_1744643405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/08ebd87c02ef49c6aee675150cea60de.jpg", "device_id": "dcfec7ff-197d-48ad-bad6-6c59a8c68b3c", "is_chatting": 1, "label_rate": 0, "log_seq": "3f1e3882552a4c44834a260cdcc23e4c", "phone_model": "Samsung_S22", "rate": 0, "target_id": "32970671"}', '2025-04-14 23:10:05', 1744643405000, '2025-04-14 23:10:05'),
('sql_screenshots', 16, '2025-04-14 23:11:05', 'id_08eab84401144719', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "83341608_1744643465000_110892617_1744643465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/33537002ef624167b4e2b68bb6152f7f.jpg", "device_id": "3db025a2-8415-4389-a118-f4e88514442d", "is_chatting": 1, "label_rate": 0, "log_seq": "68abbb5ea99b426a89fb5c33bd08ac30", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "83341608"}', '2025-04-14 23:11:05', 1744643465000, '2025-04-14 23:11:05'),
('sql_screenshots', 16, '2025-04-14 23:12:05', 'id_ec49f17490024645', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105083641_1744643525000_94369556_1744643525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/04f6ffe500444442babaac72f389118f.jpg", "device_id": "46a85b8a-5c12-499b-b662-3a0abe2ecae5", "is_chatting": 1, "label_rate": 1, "log_seq": "89693bedeba142e6b8c5218d3078ea71", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "105083641"}', '2025-04-14 23:12:05', 1744643525000, '2025-04-14 23:12:05'),
('sql_screenshots', 16, '2025-04-14 23:13:05', 'id_408aaf1829a8498b', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110876251_1744643585000_32970671_1744643585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d872d54faabb423b937bbabadf39e91d.jpg", "device_id": "c6445da4-dbf6-481b-bed5-2dde9027fffc", "is_chatting": 1, "label_rate": 0, "log_seq": "70116c8b1e4f43a99a586a3e5f82b56b", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "110876251"}', '2025-04-14 23:13:05', 1744643585000, '2025-04-14 23:13:05'),
('sql_screenshots', 16, '2025-04-14 23:14:05', 'id_7dbbefec4d4145f4', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744643645000_109657261_1744643645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/56eaa899475d4248ac83ba01ddf868c4.jpg", "device_id": "a6b6233e-23a9-4bf2-a9d9-65e4b9e8a035", "is_chatting": 1, "label_rate": 0, "log_seq": "701059d4762e4553881bc43bc18203d8", "phone_model": "iPhone_13", "rate": 3, "target_id": "110890469"}', '2025-04-14 23:14:05', 1744643645000, '2025-04-14 23:14:05'),
('sql_screenshots', 16, '2025-04-14 23:15:05', 'id_af6d842303234e9e', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110892617_1744643705000_110890469_1744643705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e7a167e9243f43fab7709424919f4487.jpg", "device_id": "ad817f6c-67f6-43de-9746-4f7a474e9174", "is_chatting": 1, "label_rate": 2, "log_seq": "b9830ad2722d46619c55b2863b919fbd", "phone_model": "Samsung_S22", "rate": 3, "target_id": "110892617"}', '2025-04-14 23:15:05', 1744643705000, '2025-04-14 23:15:05'),
('sql_screenshots', 16, '2025-04-14 23:16:05', 'id_e8ea9346bd15422c', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110215081_1744643765000_109407413_1744643765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1dc9da0ed6a64baabfc173614688abc5.jpg", "device_id": "a5c4e8c9-cdef-4188-9a57-611ef9bcd1fa", "is_chatting": 1, "label_rate": 1, "log_seq": "c3097d56c0cc4fbe8a1b444abade495f", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "110215081"}', '2025-04-14 23:16:05', 1744643765000, '2025-04-14 23:16:05'),
('sql_screenshots', 16, '2025-04-14 23:17:05', 'id_c0c5bb8610f946a7', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "82365582_1744643825000_94369556_1744643825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d8204f91d86f4388ba0b8ccd89e5091d.jpg", "device_id": "bdbaa3ea-61bc-49bf-ab93-1dfae081ca0e", "is_chatting": 1, "label_rate": 1, "log_seq": "b2e7865637e04d3a920232354e9f9019", "phone_model": "Huawei_P40", "rate": 0, "target_id": "82365582"}', '2025-04-14 23:17:05', 1744643825000, '2025-04-14 23:17:05'),
('sql_screenshots', 16, '2025-04-14 23:18:05', 'id_96f9b37cdba04007', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108466147_1744643885000_54675542_1744643885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/dbbc8aaf68d34318ba92af2932d55baf.jpg", "device_id": "263c0f79-84e9-4524-9e97-a78c5ab96ab5", "is_chatting": 1, "label_rate": 1, "log_seq": "5b50c081c2bc4f08b92cf46b40e1fdd5", "phone_model": "Huawei_P40", "rate": 4, "target_id": "108466147"}', '2025-04-14 23:18:05', 1744643885000, '2025-04-14 23:18:05'),
('sql_screenshots', 16, '2025-04-14 23:19:05', 'id_02abda0db1a74170', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109744448_1744643945000_94369556_1744643945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b82ce271a7394b2e8405d4625b295288.jpg", "device_id": "45e77ec0-cf71-421e-b1e4-c28bffb26642", "is_chatting": 1, "label_rate": 1, "log_seq": "cb04de382a754fae8ac6c1aeffa42eb2", "phone_model": "iPhone_13", "rate": 2, "target_id": "109744448"}', '2025-04-14 23:19:05', 1744643945000, '2025-04-14 23:19:05'),
('sql_screenshots', 16, '2025-04-14 23:20:05', 'id_22167501dfb64de1', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "83341608_1744644005000_108870508_1744644005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/10c743c982dc49af9fd1946860fef756.jpg", "device_id": "9bad77da-f012-48d7-8658-c818e54e2399", "is_chatting": 1, "label_rate": 1, "log_seq": "301215fc69694d89b06dd3a650170f86", "phone_model": "Samsung_S22", "rate": 0, "target_id": "83341608"}', '2025-04-14 23:20:05', 1744644005000, '2025-04-14 23:20:05'),
('sql_screenshots', 16, '2025-04-14 23:21:05', 'id_ae4ebe29c3df4dfc', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110873051_1744644065000_110890469_1744644065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e28472135bb04ad09a48c0ef9f4650a2.jpg", "device_id": "d45db901-1c22-464c-a02e-4c1558016807", "is_chatting": 1, "label_rate": 2, "log_seq": "ce0ec83216664f77b73593413e6401fc", "phone_model": "iPhone_13", "rate": 4, "target_id": "110873051"}', '2025-04-14 23:21:05', 1744644065000, '2025-04-14 23:21:05'),
('sql_screenshots', 16, '2025-04-14 23:22:05', 'id_ddf3a256218d4b0c', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "94369556_1744644125000_109407413_1744644125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5eddc863cd454d32b07ebde2776a2d34.jpg", "device_id": "f91b93ce-4a6b-4bff-a7c1-b6e3a65e4e91", "is_chatting": 1, "label_rate": 0, "log_seq": "e83be6b4b269434db667e9fe5fa2a8db", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "94369556"}', '2025-04-14 23:22:05', 1744644125000, '2025-04-14 23:22:05'),
('sql_screenshots', 16, '2025-04-14 23:23:05', 'id_eaed297b46e54235', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110215081_1744644185000_107039703_1744644185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/99719b029f4b4160ba2ddf8b1c68843d.jpg", "device_id": "018d925e-917b-4712-a3f2-6edfaa331f3a", "is_chatting": 1, "label_rate": 2, "log_seq": "8b7eaa46467c4057b16998fb8c96f419", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "110215081"}', '2025-04-14 23:23:05', 1744644185000, '2025-04-14 23:23:05'),
('sql_screenshots', 16, '2025-04-14 23:24:05', 'id_ba091c03d74d4dc4', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "104844318_1744644245000_32970671_1744644245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2fb554ef673a48c2b7f4169402fcd1c3.jpg", "device_id": "3ea10ba4-9e99-42f1-8459-f60e5a66dd37", "is_chatting": 1, "label_rate": 2, "log_seq": "a9fce445c27941fd8c55fb6b772822dd", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "104844318"}', '2025-04-14 23:24:05', 1744644245000, '2025-04-14 23:24:05'),
('sql_screenshots', 16, '2025-04-14 23:25:05', 'id_8cd5273467f649d3', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "28230174_1744644305000_110876251_1744644305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9d4b31a03cfb49baa570e748135ffad2.jpg", "device_id": "1d845cfc-8d27-45dd-91a0-348319a27b45", "is_chatting": 1, "label_rate": 1, "log_seq": "d01e8e041a154bada07c721717c3b72e", "phone_model": "OnePlus_9", "rate": 5, "target_id": "28230174"}', '2025-04-14 23:25:05', 1744644305000, '2025-04-14 23:25:05'),
('sql_screenshots', 16, '2025-04-14 23:26:05', 'id_f70bb19e623a47d2', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "28230174_1744644365000_83341608_1744644365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/72f19d023d75484390f10309e3a00a5a.jpg", "device_id": "17db8846-0fe5-4aae-bb49-8e8944294f4b", "is_chatting": 1, "label_rate": 0, "log_seq": "f5acc14d1b1149f18f7286fcecef1528", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "28230174"}', '2025-04-14 23:26:05', 1744644365000, '2025-04-14 23:26:05'),
('sql_screenshots', 16, '2025-04-14 23:27:05', 'id_57e446d691a24aef', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109980113_1744644425000_110766160_1744644425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/62f0f283613f4fb1a353c4f45940c759.jpg", "device_id": "6a0acc3f-e4a3-412e-93f3-99117880ad69", "is_chatting": 1, "label_rate": 1, "log_seq": "3003c004f55e47e9a6a22c28d0c61299", "phone_model": "Samsung_S21", "rate": 0, "target_id": "109980113"}', '2025-04-14 23:27:05', 1744644425000, '2025-04-14 23:27:05'),
('sql_screenshots', 16, '2025-04-14 23:28:05', 'id_a731d1640c8e4155', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "32970671_1744644485000_82365582_1744644485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d5784a14f38e4bf3bac3c59737b4368d.jpg", "device_id": "0c791241-4716-4a21-b7f0-df13093667e4", "is_chatting": 1, "label_rate": 1, "log_seq": "9179852f6c4442cf9c0aa5193ce5bf11", "phone_model": "OPPO_CPH1937", "rate": 0, "target_id": "32970671"}', '2025-04-14 23:28:05', 1744644485000, '2025-04-14 23:28:05'),
('sql_screenshots', 16, '2025-04-14 23:29:05', 'id_9a96ea9079584708', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "107039703_1744644545000_32970671_1744644545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ea92b41bda134a788382ef4ac756768a.jpg", "device_id": "2d8f42e8-4f5d-4b4c-b26b-f5861710fd18", "is_chatting": 1, "label_rate": 0, "log_seq": "aaea2e9bce294f24860683079fa60a23", "phone_model": "Huawei_P40", "rate": 5, "target_id": "107039703"}', '2025-04-14 23:29:05', 1744644545000, '2025-04-14 23:29:05'),
('sql_screenshots', 16, '2025-04-14 23:30:05', 'id_eea49dfc57034655', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110892617_1744644605000_54675542_1744644605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c10f1d44c37548448333fcbc26377ea1.jpg", "device_id": "e0dc589c-6b92-455e-a525-533a62f5ddad", "is_chatting": 1, "label_rate": 1, "log_seq": "afaa2e3d656045d5bfd8273aab9024af", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "110892617"}', '2025-04-14 23:30:05', 1744644605000, '2025-04-14 23:30:05'),
('sql_screenshots', 16, '2025-04-14 23:31:05', 'id_dea9210d5a71421c', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "87571440_1744644665000_104844318_1744644665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/53204d1d73f34e09beb5860068b7018b.jpg", "device_id": "9b954f44-85cf-4e77-b943-1ff997b22bf9", "is_chatting": 1, "label_rate": 1, "log_seq": "2b251c2abe504f8fa3096f25c5b12516", "phone_model": "VIVO_X60", "rate": 0, "target_id": "87571440"}', '2025-04-14 23:31:05', 1744644665000, '2025-04-14 23:31:05'),
('sql_screenshots', 16, '2025-04-14 23:32:05', 'id_a08b29fc33874ed7', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110766160_1744644725000_105083641_1744644725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b3a0b0dabce4405d9187fd60356a2e99.jpg", "device_id": "f4a6b1a0-791a-43e5-9dea-5581eba54232", "is_chatting": 1, "label_rate": 2, "log_seq": "e2ba5207eea34c6883a3c44575bb20f0", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "110766160"}', '2025-04-14 23:32:05', 1744644725000, '2025-04-14 23:32:05'),
('sql_screenshots', 16, '2025-04-14 23:33:05', 'id_60cca1167398466c', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110873051_1744644785000_104844318_1744644785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6f9babb2fadb4f3cb7dbb26bc0d49a2d.jpg", "device_id": "ef5432cf-6c0c-4da1-93cf-aed053af5ec8", "is_chatting": 1, "label_rate": 1, "log_seq": "0c66f52bdaf44bfca3d1ab4203ac2542", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "110873051"}', '2025-04-14 23:33:05', 1744644785000, '2025-04-14 23:33:05'),
('sql_screenshots', 16, '2025-04-14 23:34:05', 'id_ed15a08992d14e2a', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109980113_1744644845000_101553185_1744644845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b3e8f2952f8440568c6d206ad5efcfc6.jpg", "device_id": "cdae983a-6d23-455d-90ce-dfb25a0bcdec", "is_chatting": 1, "label_rate": 0, "log_seq": "ea1beedd24654556b599cc41219d0e32", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "109980113"}', '2025-04-14 23:34:05', 1744644845000, '2025-04-14 23:34:05'),
('sql_screenshots', 16, '2025-04-14 23:35:05', 'id_0a5e2507480c45c0', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "104844318_1744644905000_110215081_1744644905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5b876950eb8d45b5b187d574bce142d1.jpg", "device_id": "69731b7f-54b3-463d-9521-9461271770d0", "is_chatting": 1, "label_rate": 2, "log_seq": "84ae404db0ba43a483809caa0b1ebe17", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "104844318"}', '2025-04-14 23:35:05', 1744644905000, '2025-04-14 23:35:05'),
('sql_screenshots', 16, '2025-04-14 23:36:05', 'id_5aad89cbdcb242be', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110873051_1744644965000_109657261_1744644965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bdb6efa4724940038a69e083dfdec82b.jpg", "device_id": "763c3243-5042-4d77-9c11-d8a9020133b4", "is_chatting": 1, "label_rate": 1, "log_seq": "463b9fb7474f4830901008ca7f6ecc83", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "110873051"}', '2025-04-14 23:36:05', 1744644965000, '2025-04-14 23:36:05'),
('sql_screenshots', 16, '2025-04-14 23:37:05', 'id_256aab1088924498', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "104844318_1744645025000_109980113_1744645025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9a626ad7d63d4ba799c1ba22e2729e18.jpg", "device_id": "c26c0e89-bb28-4e81-a87b-cd6625717b67", "is_chatting": 1, "label_rate": 0, "log_seq": "fd0d8e560ef24ce291d182a65d35a9df", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "104844318"}', '2025-04-14 23:37:05', 1744645025000, '2025-04-14 23:37:05'),
('sql_screenshots', 16, '2025-04-14 23:38:05', 'id_66f81ac6b0934b42', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110873051_1744645085000_105083641_1744645085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/da8702eb7c9647739d5e142fad10174e.jpg", "device_id": "be5c5b16-fbd6-4cfc-8171-fe49d365c2a4", "is_chatting": 1, "label_rate": 2, "log_seq": "34c60f5113234a2e926ab23a136414e2", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "110873051"}', '2025-04-14 23:38:05', 1744645085000, '2025-04-14 23:38:05'),
('sql_screenshots', 16, '2025-04-14 23:39:05', 'id_4e1f97598b054cf3', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109744448_1744645145000_105503656_1744645145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8b8272edf3cc4ed39705b3a3c28a6172.jpg", "device_id": "67240af0-4092-46ba-9911-40f75b1df56b", "is_chatting": 1, "label_rate": 0, "log_seq": "6a28973a962a4e299094ba9cb2d4ffba", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "109744448"}', '2025-04-14 23:39:05', 1744645145000, '2025-04-14 23:39:05'),
('sql_screenshots', 16, '2025-04-14 23:40:05', 'id_977eaad8efd442db', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744645205000_105083641_1744645205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/38f31c86af1c4dcd9208aa7cd0e37454.jpg", "device_id": "5f376235-fe78-40fa-b197-48fbaaad3fa2", "is_chatting": 1, "label_rate": 2, "log_seq": "ca38cdfeaafa4da980100362c1363ac7", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "109744448"}', '2025-04-14 23:40:05', 1744645205000, '2025-04-14 23:40:05'),
('sql_screenshots', 16, '2025-04-14 23:41:05', 'id_6a3bd16d82cb47f2', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "107039703_1744645265000_64280379_1744645265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b2dcc18ec95b4fbd99cd92f335be80ab.jpg", "device_id": "5814b9ed-24cd-4582-b74b-95e32da78008", "is_chatting": 1, "label_rate": 1, "log_seq": "67980d903fd740c892d957a8437985e2", "phone_model": "OnePlus_9", "rate": 2, "target_id": "107039703"}', '2025-04-14 23:41:05', 1744645265000, '2025-04-14 23:41:05'),
('sql_screenshots', 16, '2025-04-14 23:42:05', 'id_b6ffe815c06b48cb', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "57649476_1744645325000_94369556_1744645325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/62bbb7280c4541c79e3f1f64fd3d0d76.jpg", "device_id": "ae30ca70-acef-455e-90ce-b523e36eedb5", "is_chatting": 1, "label_rate": 2, "log_seq": "e22fde1027ea484d917ec81fee69b5fd", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "57649476"}', '2025-04-14 23:42:05', 1744645325000, '2025-04-14 23:42:05'),
('sql_screenshots', 16, '2025-04-14 23:43:05', 'id_992550152c174114', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744645385000_105083641_1744645385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7f49d8950d60473b931c5eb7713dc400.jpg", "device_id": "2d170042-cdb5-459d-906e-970e1fe6a7e0", "is_chatting": 1, "label_rate": 2, "log_seq": "cef4ff2e64ea40c7bb1162283e927bc9", "phone_model": "VIVO_X60", "rate": 1, "target_id": "81479540"}', '2025-04-14 23:43:05', 1744645385000, '2025-04-14 23:43:05'),
('sql_screenshots', 16, '2025-04-14 23:44:05', 'id_7d5ed3ac15b040fc', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744645445000_110890469_1744645445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f18a0fd535eb48ac84e89385415d7a05.jpg", "device_id": "661ed05c-cd86-4893-b0ab-996b1027e573", "is_chatting": 1, "label_rate": 1, "log_seq": "f09e748ef1dd4f7eaddff6f11e5585fb", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "107039703"}', '2025-04-14 23:44:05', 1744645445000, '2025-04-14 23:44:05'),
('sql_screenshots', 16, '2025-04-14 23:45:05', 'id_4678819fb77a4b2e', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "28230174_1744645505000_109407413_1744645505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/fd7170afdfcc4f9fa93cef00b4710a39.jpg", "device_id": "7d769a20-ec9b-4919-bda2-f78b46ec0c06", "is_chatting": 1, "label_rate": 1, "log_seq": "2cfeabadf6b24a84b3a045f01a1a3359", "phone_model": "iPhone_13", "rate": 3, "target_id": "28230174"}', '2025-04-14 23:45:05', 1744645505000, '2025-04-14 23:45:05'),
('sql_screenshots', 16, '2025-04-14 23:46:05', 'id_e70d9f5f8f3a4d61', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744645565000_110215081_1744645565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a69805197bb84828bf30be1be2160f77.jpg", "device_id": "cf26d426-15fa-45b1-9fb0-3c3673bfbfa5", "is_chatting": 1, "label_rate": 0, "log_seq": "9ef674e6bc414f089a058eb1a367a9c6", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "108466147"}', '2025-04-14 23:46:05', 1744645565000, '2025-04-14 23:46:05'),
('sql_screenshots', 16, '2025-04-14 23:47:05', 'id_77c183b8639c4c90', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105503656_1744645625000_57649476_1744645625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/deb0aec859e94c8caad235562e551aa2.jpg", "device_id": "6f8fd22c-8b90-43c1-bc24-74a515afc1b2", "is_chatting": 1, "label_rate": 1, "log_seq": "f7cdf3f3eaaa418c87f8190ac682d114", "phone_model": "VIVO_X60", "rate": 0, "target_id": "105503656"}', '2025-04-14 23:47:05', 1744645625000, '2025-04-14 23:47:05'),
('sql_screenshots', 16, '2025-04-14 23:48:05', 'id_1bb2ce2f532546ec', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "64280379_1744645685000_101553185_1744645685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f16a520ae9f249c09ee6a34426cb49ca.jpg", "device_id": "4dbcd3b1-4845-4f4d-bab7-afca52833ea5", "is_chatting": 1, "label_rate": 0, "log_seq": "750b544ba3ee4223bcbe3218a1ae128d", "phone_model": "VIVO_X60", "rate": 2, "target_id": "64280379"}', '2025-04-14 23:48:05', 1744645685000, '2025-04-14 23:48:05'),
('sql_screenshots', 16, '2025-04-14 23:49:05', 'id_4f2ef3c262e14d06', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "64280379_1744645745000_108466147_1744645745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/edd5506b4fb941b1b9e8b624e1052459.jpg", "device_id": "feba993a-5512-4497-a255-417bcd1bd990", "is_chatting": 1, "label_rate": 0, "log_seq": "075b36e00ac747be94297bc595c3daa0", "phone_model": "iPhone_13", "rate": 5, "target_id": "64280379"}', '2025-04-14 23:49:05', 1744645745000, '2025-04-14 23:49:05'),
('sql_screenshots', 16, '2025-04-14 23:50:05', 'id_ecefee2f87d5411c', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110873051_1744645805000_32970671_1744645805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3ab97646b0d944c9b5137c2c77b809ea.jpg", "device_id": "61be9b8e-132e-4367-8162-e1995af68b52", "is_chatting": 1, "label_rate": 1, "log_seq": "4964fbebc94840e782d9b095bec050e3", "phone_model": "VIVO_X60", "rate": 2, "target_id": "110873051"}', '2025-04-14 23:50:05', 1744645805000, '2025-04-14 23:50:05'),
('sql_screenshots', 16, '2025-04-14 23:51:05', 'id_da40293b17ab47b0', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744645865000_83341608_1744645865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d006793fa5b14fdb87d1248aca7e090d.jpg", "device_id": "93fd9c6f-2982-40cc-926b-628b46878464", "is_chatting": 1, "label_rate": 2, "log_seq": "ea1d6f7bdeee4e54991120a7d688d541", "phone_model": "Samsung_S21", "rate": 5, "target_id": "81479540"}', '2025-04-14 23:51:05', 1744645865000, '2025-04-14 23:51:05'),
('sql_screenshots', 16, '2025-04-14 23:52:05', 'id_f698f699b53a42c1', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110892617_1744645925000_109657261_1744645925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/19367846427a42f68461728f042d64d8.jpg", "device_id": "37eab521-955f-4749-b3b7-f92e6a43ec5d", "is_chatting": 1, "label_rate": 1, "log_seq": "a80cc6aabf7946408d06dfbcdb2f5643", "phone_model": "Samsung_S21", "rate": 5, "target_id": "110892617"}', '2025-04-14 23:52:05', 1744645925000, '2025-04-14 23:52:05'),
('sql_screenshots', 16, '2025-04-14 23:53:05', 'id_1f37c19ad1b24bd0', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "107039703_1744645985000_104844318_1744645985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a383e8d7833242dfbbc814bc61b9d3de.jpg", "device_id": "25260fc7-2ac4-4859-b119-43c0292260f5", "is_chatting": 1, "label_rate": 0, "log_seq": "9e4723a189df4c9c85805c02f43fcf3c", "phone_model": "VIVO_X60", "rate": 3, "target_id": "107039703"}', '2025-04-14 23:53:05', 1744645985000, '2025-04-14 23:53:05'),
('sql_screenshots', 16, '2025-04-14 23:54:05', 'id_c155533b6fc4409d', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108466147_1744646045000_57649476_1744646045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/14b43dab2d4140ef988f0035a837b4c2.jpg", "device_id": "3f12c784-aa1c-4354-bca8-7baeb7d00ff0", "is_chatting": 1, "label_rate": 2, "log_seq": "d9ed7092a8fa4529addd84ab0c5367e6", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "108466147"}', '2025-04-14 23:54:05', 1744646045000, '2025-04-14 23:54:05'),
('sql_screenshots', 16, '2025-04-14 23:55:05', 'id_c8b55feb0b2041d3', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109657261_1744646105000_104844318_1744646105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9893a81b3bd84110820a4ce1b0eb1783.jpg", "device_id": "86acdfa3-78b8-43ba-9671-c7fed7327092", "is_chatting": 1, "label_rate": 0, "log_seq": "60268050926342558088a9fcf1416b91", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "109657261"}', '2025-04-14 23:55:05', 1744646105000, '2025-04-14 23:55:05'),
('sql_screenshots', 16, '2025-04-14 23:56:05', 'id_b562faf6abbe4bda', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110215081_1744646165000_108870508_1744646165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/382f3df6478d46e4bb86f2893787985f.jpg", "device_id": "37a19a17-a7d5-4cee-bd3e-1efb0d0c6c92", "is_chatting": 1, "label_rate": 0, "log_seq": "574fa9a4ee234fcf95cf8da84c69f3dc", "phone_model": "Samsung_S22", "rate": 4, "target_id": "110215081"}', '2025-04-14 23:56:05', 1744646165000, '2025-04-14 23:56:05'),
('sql_screenshots', 16, '2025-04-14 23:57:05', 'id_6da5788e0fea4ab5', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "32970671_1744646225000_107039703_1744646225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/416a6d97767446b8a8719a921c8f978b.jpg", "device_id": "6822acac-4f05-47fb-be03-b80e25a09f7a", "is_chatting": 1, "label_rate": 2, "log_seq": "7df3f874b6104fb4a8bd84a28e7000bd", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "32970671"}', '2025-04-14 23:57:05', 1744646225000, '2025-04-14 23:57:05'),
('sql_screenshots', 16, '2025-04-14 23:58:05', 'id_f9b3b20b1cf141a8', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110873051_1744646285000_32970671_1744646285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c8eb2846404740d49c33000a4c600144.jpg", "device_id": "7e75c4a2-0093-4257-bd62-2c881c0bfa39", "is_chatting": 1, "label_rate": 2, "log_seq": "0cbca76ce3f741ac873c48a1d0bcbcac", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "110873051"}', '2025-04-14 23:58:05', 1744646285000, '2025-04-14 23:58:05'),
('sql_screenshots', 16, '2025-04-14 23:59:05', 'id_2955bdec08ce4f9c', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "28230174_1744646345000_57649476_1744646345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bd75323ba83f423abca25981968d9bdb.jpg", "device_id": "76396038-9865-425a-9549-bd22aa677cfd", "is_chatting": 1, "label_rate": 0, "log_seq": "ac0e53bc0b7a4a2bbb574d56e1d2ccca", "phone_model": "iPhone_13", "rate": 3, "target_id": "28230174"}', '2025-04-14 23:59:05', 1744646345000, '2025-04-14 23:59:05'),
('sql_screenshots', 16, '2025-04-15 00:00:05', 'id_96a25082728e4d75', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744646405000_57649476_1744646405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4e056c9822cf464589619a7a41fd7e7c.jpg", "device_id": "3e194850-6475-4110-8ba4-f5334e607b90", "is_chatting": 1, "label_rate": 2, "log_seq": "d29f63175cb4472990ae6f92497c9fb2", "phone_model": "Samsung_S21", "rate": 1, "target_id": "110766160"}', '2025-04-15 00:00:05', 1744646405000, '2025-04-15 00:00:05'),
('sql_screenshots', 16, '2025-04-15 00:01:05', 'id_9aabe0d35ae24e1c', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110876251_1744646465000_104844318_1744646465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/61f4f98467c24a52b73e67795ee4e3aa.jpg", "device_id": "ce13286b-3023-47cf-806c-13c452d8bbfc", "is_chatting": 1, "label_rate": 0, "log_seq": "58f80673102e418098c7cc3d1462dcff", "phone_model": "OnePlus_9", "rate": 5, "target_id": "110876251"}', '2025-04-15 00:01:05', 1744646465000, '2025-04-15 00:01:05'),
('sql_screenshots', 16, '2025-04-15 00:02:05', 'id_ddeab59a7c6d4b1a', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "94369556_1744646525000_108870508_1744646525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/fc5f4ebbee16405fba094d35b3652f4d.jpg", "device_id": "4604cd43-bfa2-49b3-badd-f63c6b6c1c88", "is_chatting": 1, "label_rate": 2, "log_seq": "45bc149670664c219fc5c5a65ff981da", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "94369556"}', '2025-04-15 00:02:05', 1744646525000, '2025-04-15 00:02:05'),
('sql_screenshots', 16, '2025-04-15 00:03:05', 'id_854e75cfe3df4085', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108870508_1744646585000_94369556_1744646585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1aa961842a1b4537a77005af1adebadd.jpg", "device_id": "59a19603-e8bb-4848-87ce-b2dff5714e23", "is_chatting": 1, "label_rate": 2, "log_seq": "e53054073b384030aaa62a259d2e785f", "phone_model": "Samsung_S22", "rate": 3, "target_id": "108870508"}', '2025-04-15 00:03:05', 1744646585000, '2025-04-15 00:03:05'),
('sql_screenshots', 16, '2025-04-15 00:04:05', 'id_04b5101175334cc3', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "64280379_1744646645000_87571440_1744646645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d677593813ed4451bf4d601eac529b73.jpg", "device_id": "0318cfc3-592d-46c8-a577-a9ac96bae801", "is_chatting": 1, "label_rate": 1, "log_seq": "6d5442bfaca74530840e08d272b1e50e", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "64280379"}', '2025-04-15 00:04:05', 1744646645000, '2025-04-15 00:04:05'),
('sql_screenshots', 16, '2025-04-15 00:05:05', 'id_15a3b058e3284e97', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108870508_1744646705000_101553185_1744646705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0709c7dfad414ed1915f783225b1b7c9.jpg", "device_id": "ceefe92c-db4d-4990-bd15-5c7129164d91", "is_chatting": 1, "label_rate": 2, "log_seq": "0ec929cef0e143dcbfb43f1b31f14492", "phone_model": "Samsung_S21", "rate": 0, "target_id": "108870508"}', '2025-04-15 00:05:05', 1744646705000, '2025-04-15 00:05:05'),
('sql_screenshots', 16, '2025-04-15 00:06:05', 'id_c66f50fbd8854627', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "64280379_1744646765000_109657261_1744646765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/da8a6279367f4c74998c19797f7d0b21.jpg", "device_id": "a3f4258b-b180-4e9b-8376-f3cbce7609fa", "is_chatting": 1, "label_rate": 0, "log_seq": "1a21ca445ba144d1a4f64a20ef6bd837", "phone_model": "VIVO_X60", "rate": 1, "target_id": "64280379"}', '2025-04-15 00:06:05', 1744646765000, '2025-04-15 00:06:05'),
('sql_screenshots', 16, '2025-04-15 00:07:05', 'id_adb7b21abd7249cc', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "101553185_1744646825000_105083641_1744646825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/316c88ab63f948ca9e6ff5dcf7ce1e6d.jpg", "device_id": "0edb6082-58bc-4b4b-90a5-7b339a2e8459", "is_chatting": 1, "label_rate": 1, "log_seq": "38d32f3981574cdd8d1b8532b8930ce7", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "101553185"}', '2025-04-15 00:07:05', 1744646825000, '2025-04-15 00:07:05'),
('sql_screenshots', 16, '2025-04-15 00:08:05', 'id_d327444bf49f4220', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744646885000_109407413_1744646885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7b552b0267eb4660a0d8c0e0066c7623.jpg", "device_id": "f18d8a0d-1946-46dd-b397-2bd3da345f78", "is_chatting": 1, "label_rate": 2, "log_seq": "3bf64f7f0c074532b294175841426f73", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "110766160"}', '2025-04-15 00:08:05', 1744646885000, '2025-04-15 00:08:05'),
('sql_screenshots', 16, '2025-04-15 00:09:05', 'id_30acf8e014b94b22', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "64280379_1744646945000_107039703_1744646945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cef07469f0ff4f57a590d5efc4567bac.jpg", "device_id": "76012665-6dc0-4ae6-9af9-e0ce751ffe90", "is_chatting": 1, "label_rate": 1, "log_seq": "1b087f47b153448c8ac44d7e4c1961ac", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "64280379"}', '2025-04-15 00:09:05', 1744646945000, '2025-04-15 00:09:05'),
('sql_screenshots', 16, '2025-04-15 00:10:05', 'id_2b1ec2cda90a4041', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110892617_1744647005000_110215081_1744647005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/08b2d7a5330549bdab07a487727bec49.jpg", "device_id": "099f44ba-b563-4cc2-b27a-652a47d97fcb", "is_chatting": 1, "label_rate": 1, "log_seq": "0a0ed2a501fe46a4b94a3a22720c4d56", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "110892617"}', '2025-04-15 00:10:05', 1744647005000, '2025-04-15 00:10:05'),
('sql_screenshots', 16, '2025-04-15 00:11:05', 'id_72a3990187b54c0d', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108466147_1744647065000_87571440_1744647065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0321c495ed424a71929b9924a33bece3.jpg", "device_id": "cd2130df-b452-4071-b6e5-989f3d80cbde", "is_chatting": 1, "label_rate": 2, "log_seq": "da411b97bc6b494f81806c9288a259ce", "phone_model": "OPPO_CPH1937", "rate": 0, "target_id": "108466147"}', '2025-04-15 00:11:05', 1744647065000, '2025-04-15 00:11:05'),
('sql_screenshots', 16, '2025-04-15 00:12:05', 'id_f939d509b0204373', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "94369556_1744647125000_109407413_1744647125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/17f1928cf8b24b7c9a3dc516e0762822.jpg", "device_id": "79163d4b-0cd1-4108-97de-10ba6106ec09", "is_chatting": 1, "label_rate": 0, "log_seq": "6955eb7ce2ba4fcd96245fe93d0b5864", "phone_model": "OPPO_CPH1937", "rate": 0, "target_id": "94369556"}', '2025-04-15 00:12:05', 1744647125000, '2025-04-15 00:12:05'),
('sql_screenshots', 16, '2025-04-15 00:13:05', 'id_219ade3dd2024c6f', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110873051_1744647185000_101553185_1744647185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9740d6978ec44bffb9ea58bf2235bf57.jpg", "device_id": "327d13fc-ef15-4181-86a8-e6194f077e5d", "is_chatting": 1, "label_rate": 2, "log_seq": "f706a91134c142bd8b0294eb60281636", "phone_model": "VIVO_X60", "rate": 1, "target_id": "110873051"}', '2025-04-15 00:13:05', 1744647185000, '2025-04-15 00:13:05'),
('sql_screenshots', 16, '2025-04-15 00:14:05', 'id_df2c830af7be41ca', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744647245000_110892617_1744647245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2aa3bae9433942e08ff0c66380f55dc3.jpg", "device_id": "99c5b232-8e5d-4c88-b6c3-f3756ad9c34e", "is_chatting": 1, "label_rate": 2, "log_seq": "5220486a2401444787047508c74a1912", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "110890469"}', '2025-04-15 00:14:05', 1744647245000, '2025-04-15 00:14:05'),
('sql_screenshots', 16, '2025-04-15 00:15:05', 'id_c73f81b9d6fe4ed7', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109657261_1744647305000_83341608_1744647305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/540714535556456384d6edaaf40800e8.jpg", "device_id": "9fd2a92e-d9b5-4177-9d09-cd7fc28d0f78", "is_chatting": 1, "label_rate": 0, "log_seq": "319c71dd4c93477ca17df6ef815c277f", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "109657261"}', '2025-04-15 00:15:05', 1744647305000, '2025-04-15 00:15:05'),
('sql_screenshots', 16, '2025-04-15 00:16:05', 'id_3b3dba93f4984b9c', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744647365000_108466147_1744647365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ee855beaa8d04ea284848c820573798a.jpg", "device_id": "7ad14a26-62c2-46e0-9810-d7d14e97c89f", "is_chatting": 1, "label_rate": 0, "log_seq": "2888826140ea4c489e69ffd13baef88a", "phone_model": "VIVO_X60", "rate": 2, "target_id": "82365582"}', '2025-04-15 00:16:05', 1744647365000, '2025-04-15 00:16:05'),
('sql_screenshots', 16, '2025-04-15 00:17:05', 'id_be67b90e0caf4ec8', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "64280379_1744647425000_105083641_1744647425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8cac12fabe7d491d8dcd52213696762c.jpg", "device_id": "91819eec-9e95-4f9c-a452-cda05336566f", "is_chatting": 1, "label_rate": 1, "log_seq": "b191414c01e74a2faa9d61351e0331bb", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "64280379"}', '2025-04-15 00:17:05', 1744647425000, '2025-04-15 00:17:05'),
('sql_screenshots', 16, '2025-04-15 00:18:05', 'id_53856f057d2a4b82', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744647485000_94369556_1744647485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4d44ecccd06f45d3a69cc8489363979b.jpg", "device_id": "0bfdc299-79a4-45aa-b247-26c7751a8994", "is_chatting": 1, "label_rate": 1, "log_seq": "4330ce6b105e4327a0c462473d2b6848", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "110890469"}', '2025-04-15 00:18:05', 1744647485000, '2025-04-15 00:18:05'),
('sql_screenshots', 16, '2025-04-15 00:19:05', 'id_a3120831b6024622', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744647545000_110890469_1744647545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6d5924a29f3b4a38b0a4afefe6ba6529.jpg", "device_id": "c58d9c49-167c-4f64-837d-ef8e635812ae", "is_chatting": 1, "label_rate": 1, "log_seq": "2363ec1c2ed742b0a7b374e6a9616c68", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "110873051"}', '2025-04-15 00:19:05', 1744647545000, '2025-04-15 00:19:05'),
('sql_screenshots', 16, '2025-04-15 00:20:05', 'id_bcf1ae5caeef4483', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "28230174_1744647605000_32970671_1744647605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/14db2eb727824a3b938940d52593d7c3.jpg", "device_id": "0b06d00b-eebd-4c14-aedb-9a666bbe3166", "is_chatting": 1, "label_rate": 1, "log_seq": "1bad79904de94337940cadf054ecd821", "phone_model": "iPhone_13", "rate": 2, "target_id": "28230174"}', '2025-04-15 00:20:05', 1744647605000, '2025-04-15 00:20:05'),
('sql_screenshots', 16, '2025-04-15 00:21:05', 'id_edd302b8453447f1', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108466147_1744647665000_108870508_1744647665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5609d777955f4debb88854993e6b7fe5.jpg", "device_id": "c56ed530-e627-432b-8354-cfc982a0450a", "is_chatting": 1, "label_rate": 1, "log_seq": "600649d8312f4dd1aa50f998bbf0b3f1", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "108466147"}', '2025-04-15 00:21:05', 1744647665000, '2025-04-15 00:21:05'),
('sql_screenshots', 16, '2025-04-15 00:22:05', 'id_a1455601c65147ef', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744647725000_108466147_1744647725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9f6e1f5ffd364f639fea01ccf44868f8.jpg", "device_id": "5bf11448-08f6-4ddd-9f09-d42aca579211", "is_chatting": 1, "label_rate": 0, "log_seq": "33f0774407564770b0313840cb70d8ab", "phone_model": "iPhone_13", "rate": 3, "target_id": "107039703"}', '2025-04-15 00:22:05', 1744647725000, '2025-04-15 00:22:05'),
('sql_screenshots', 16, '2025-04-15 00:23:05', 'id_367644a642f34046', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105503656_1744647785000_94369556_1744647785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/81c5a0bc43204b5cb8c0e220a7b29d22.jpg", "device_id": "d01fb522-0cb2-40c2-962d-6e84b1d84f5d", "is_chatting": 1, "label_rate": 0, "log_seq": "e2296a3f95ba4b27920af08a3840e5c1", "phone_model": "VIVO_X60", "rate": 3, "target_id": "105503656"}', '2025-04-15 00:23:05', 1744647785000, '2025-04-15 00:23:05'),
('sql_screenshots', 16, '2025-04-15 00:24:05', 'id_9bb1924d7b954cf0', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "94369556_1744647845000_82365582_1744647845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2a35481a767345518e77b033b129704a.jpg", "device_id": "f7fcf4df-56f6-455d-a391-c9ca6235f4a4", "is_chatting": 1, "label_rate": 1, "log_seq": "aa77899d40bf4aa0bffbf53a12812c9f", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "94369556"}', '2025-04-15 00:24:05', 1744647845000, '2025-04-15 00:24:05'),
('sql_screenshots', 16, '2025-04-15 00:25:05', 'id_823028d5e1734584', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "82365582_1744647905000_28230174_1744647905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ef5e93eb54294e3780b6fbb5ea1bf266.jpg", "device_id": "0f2e570f-863f-4eed-a5a7-148e300d2d9f", "is_chatting": 1, "label_rate": 0, "log_seq": "6f9f440d88e14edf8899e74b002d67aa", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "82365582"}', '2025-04-15 00:25:05', 1744647905000, '2025-04-15 00:25:05'),
('sql_screenshots', 16, '2025-04-15 00:26:05', 'id_7cda3b7e86f44cc3', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109980113_1744647965000_104844318_1744647965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8aa2f68ea226479d84742a864ba34b1f.jpg", "device_id": "1db90304-2e79-40e7-9246-f0e0672d49fd", "is_chatting": 1, "label_rate": 0, "log_seq": "b1e9509992ee478ba73c4e3992302112", "phone_model": "iPhone_13", "rate": 4, "target_id": "109980113"}', '2025-04-15 00:26:05', 1744647965000, '2025-04-15 00:26:05'),
('sql_screenshots', 16, '2025-04-15 00:27:05', 'id_1eaef5cc65c04593', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "87571440_1744648025000_110766160_1744648025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4e5f1bade4cc4a10bf5d7fb9cc19997a.jpg", "device_id": "1c56829c-6834-4a28-bc08-769ce31a9890", "is_chatting": 1, "label_rate": 0, "log_seq": "ec526906bc4c4b44879cdd4d498804c3", "phone_model": "VIVO_X60", "rate": 2, "target_id": "87571440"}', '2025-04-15 00:27:05', 1744648025000, '2025-04-15 00:27:05'),
('sql_screenshots', 16, '2025-04-15 00:28:05', 'id_aab97ba9cdc04fda', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744648085000_110215081_1744648085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/53c8567d295949b4841c63ac3600b867.jpg", "device_id": "a8cefd92-c066-4961-9f5d-e5f6e0df0722", "is_chatting": 1, "label_rate": 0, "log_seq": "ab478ec75dc246ef9092285968d8d917", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "110876251"}', '2025-04-15 00:28:05', 1744648085000, '2025-04-15 00:28:05'),
('sql_screenshots', 16, '2025-04-15 00:29:05', 'id_8ae120ff480f41c3', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744648145000_104844318_1744648145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4239a93477484c339e73e8583a319259.jpg", "device_id": "5b84df28-9579-41de-abb1-b329543559ea", "is_chatting": 1, "label_rate": 2, "log_seq": "2dfd66a74a224e98b904ff22e4fb8df4", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "109744448"}', '2025-04-15 00:29:05', 1744648145000, '2025-04-15 00:29:05'),
('sql_screenshots', 16, '2025-04-15 00:30:05', 'id_07c44a6cb2d5438e', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744648205000_110215081_1744648205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/569c1374331b498a9b476501f837c998.jpg", "device_id": "045566f3-0cbe-4e86-a379-57d6c9ce3eb2", "is_chatting": 1, "label_rate": 0, "log_seq": "7e1d7c4aa1914d5ea4b65fbc04dbd519", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "107039703"}', '2025-04-15 00:30:05', 1744648205000, '2025-04-15 00:30:05'),
('sql_screenshots', 16, '2025-04-15 00:31:05', 'id_348a6b2f4f044dd7', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105083641_1744648265000_110215081_1744648265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cb28842489db44fd84ab2df762eb4e0a.jpg", "device_id": "edd72f38-9de9-491d-b988-1a8ecc76ad30", "is_chatting": 1, "label_rate": 0, "log_seq": "7f919d7cdd8d43a9b1e3d1f0969ee700", "phone_model": "Samsung_S22", "rate": 2, "target_id": "105083641"}', '2025-04-15 00:31:05', 1744648265000, '2025-04-15 00:31:05'),
('sql_screenshots', 16, '2025-04-15 00:32:05', 'id_1cf02caad2d64835', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105503656_1744648325000_110873051_1744648325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/df87a49eb2c2473f948fb699be6ac0d9.jpg", "device_id": "0bc7e37c-b342-44c6-9380-b506d8b36ba0", "is_chatting": 1, "label_rate": 0, "log_seq": "156654427da947dabc0a7e2bc6ef944a", "phone_model": "Huawei_P40", "rate": 4, "target_id": "105503656"}', '2025-04-15 00:32:05', 1744648325000, '2025-04-15 00:32:05'),
('sql_screenshots', 16, '2025-04-15 00:33:05', 'id_233d4932b5dd434a', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110215081_1744648385000_105083641_1744648385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/47a7d135a4df4008930297ba2d728bbd.jpg", "device_id": "289aab0e-996d-487d-8f83-460c2f3ac42f", "is_chatting": 1, "label_rate": 0, "log_seq": "c428579b097340429d59f171a6e06db6", "phone_model": "Samsung_S21", "rate": 4, "target_id": "110215081"}', '2025-04-15 00:33:05', 1744648385000, '2025-04-15 00:33:05'),
('sql_screenshots', 16, '2025-04-15 00:34:05', 'id_9e096f75339e4504', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "64280379_1744648445000_94369556_1744648445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/70e96396fb3f409cb018ea30bd408bd5.jpg", "device_id": "876dc213-b6dd-433d-9514-da4055dcee86", "is_chatting": 1, "label_rate": 0, "log_seq": "7f23a687cefa42c5b7d83ad398fa8fd6", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "64280379"}', '2025-04-15 00:34:05', 1744648445000, '2025-04-15 00:34:05'),
('sql_screenshots', 16, '2025-04-15 00:35:05', 'id_44c2aabdeb364c3b', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744648505000_110876251_1744648505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0cc8a6b42e4d41aabaed4908a1ba4890.jpg", "device_id": "62e2ede4-8427-47bd-a479-1b748f05f727", "is_chatting": 1, "label_rate": 2, "log_seq": "d5d473eb227f4d6bb8dda50bc54713fc", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "108466147"}', '2025-04-15 00:35:05', 1744648505000, '2025-04-15 00:35:05'),
('sql_screenshots', 16, '2025-04-15 00:36:05', 'id_d9b8860771ce44dc', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109407413_1744648565000_109980113_1744648565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a924eda9e33b4b78a411f19804b41d29.jpg", "device_id": "79d4db1e-bb97-41a9-8049-912c72119f74", "is_chatting": 1, "label_rate": 0, "log_seq": "83fc57f9a4064a3c9a05284bfa1b6214", "phone_model": "Samsung_S21", "rate": 2, "target_id": "109407413"}', '2025-04-15 00:36:05', 1744648565000, '2025-04-15 00:36:05'),
('sql_screenshots', 16, '2025-04-15 00:37:05', 'id_f8eb2d0aa70a48b2', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "104844318_1744648625000_83341608_1744648625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d0428613fcd54a869c29ef8bc88762cf.jpg", "device_id": "e6442bc0-5b90-405e-b3e1-ab4cd084d4ec", "is_chatting": 1, "label_rate": 0, "log_seq": "85d97d1887aa42178273df9de4c6e025", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "104844318"}', '2025-04-15 00:37:05', 1744648625000, '2025-04-15 00:37:05'),
('sql_screenshots', 16, '2025-04-15 00:38:05', 'id_9581a03646074e3c', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744648685000_110892617_1744648685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/628a42ab687b4d85a771c8a8c2c50195.jpg", "device_id": "b88cfc48-07a6-435f-ae89-6d89d2b808d8", "is_chatting": 1, "label_rate": 2, "log_seq": "70f8007ef4434233abf41784ef2aeb38", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "110873051"}', '2025-04-15 00:38:05', 1744648685000, '2025-04-15 00:38:05'),
('sql_screenshots', 16, '2025-04-15 00:39:05', 'id_c438cbbdd32b48f8', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744648745000_109744448_1744648745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6caf61372e67400581c27fdad9225cfc.jpg", "device_id": "84ea5d79-5a4d-4184-8ba4-fe0c0876d36c", "is_chatting": 1, "label_rate": 2, "log_seq": "b47c73270cdf4524b8a65c3d86af3acd", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "110890469"}', '2025-04-15 00:39:05', 1744648745000, '2025-04-15 00:39:05'),
('sql_screenshots', 16, '2025-04-15 00:40:05', 'id_618a64a4507d4d45', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110873051_1744648805000_28230174_1744648805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7a93dad699f04d77ac24715514566f8b.jpg", "device_id": "341a7a9f-3515-404a-9b5e-a623e281fb8c", "is_chatting": 1, "label_rate": 1, "log_seq": "ae38b460519740a1bda3ffc4c3ab15d0", "phone_model": "OnePlus_9", "rate": 3, "target_id": "110873051"}', '2025-04-15 00:40:05', 1744648805000, '2025-04-15 00:40:05'),
('sql_screenshots', 16, '2025-04-15 00:41:05', 'id_a6a29afc70434c67', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110892617_1744648865000_108466147_1744648865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a3da2f19eaaf4bf5b543bda3069a7b8f.jpg", "device_id": "e86d1c90-3cd5-4ad1-9d53-8bc73fdf94a6", "is_chatting": 1, "label_rate": 0, "log_seq": "987130ec0d1d4c4ca33fa59d9d714742", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "110892617"}', '2025-04-15 00:41:05', 1744648865000, '2025-04-15 00:41:05'),
('sql_screenshots', 16, '2025-04-15 00:42:05', 'id_e28f000fc20a4584', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109980113_1744648925000_110876251_1744648925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7066b6b47ab6416db4763bab1cdc565a.jpg", "device_id": "d629cc81-886f-4cab-8691-b92a9c50446a", "is_chatting": 1, "label_rate": 2, "log_seq": "b3c448b9b4c948d8bf503e73fa85aa57", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "109980113"}', '2025-04-15 00:42:05', 1744648925000, '2025-04-15 00:42:05'),
('sql_screenshots', 16, '2025-04-15 00:43:05', 'id_678616781e8c4206', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "28230174_1744648985000_94369556_1744648985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a872b88863fa4f0f97eb05e06f247e46.jpg", "device_id": "0d69df12-ac53-40a4-934b-0b97ebb0f827", "is_chatting": 1, "label_rate": 0, "log_seq": "17d0873146294eadb731552e90578b6f", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "28230174"}', '2025-04-15 00:43:05', 1744648985000, '2025-04-15 00:43:05'),
('sql_screenshots', 16, '2025-04-15 00:44:05', 'id_4c4149a4258d4b79', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744649045000_110876251_1744649045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bc2a32c048304c7d8d39d457664d7388.jpg", "device_id": "f8e295eb-7636-4cd6-a6a0-50cd9e490792", "is_chatting": 1, "label_rate": 0, "log_seq": "eb4ff46f308442c5a17c055504f740c6", "phone_model": "OnePlus_9", "rate": 1, "target_id": "109744448"}', '2025-04-15 00:44:05', 1744649045000, '2025-04-15 00:44:05'),
('sql_screenshots', 16, '2025-04-15 00:45:05', 'id_51835b97301c46c9', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744649105000_64280379_1744649105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/56035051c5dd48aab77f06c46a96dfff.jpg", "device_id": "b4bc2d1d-4257-4328-9254-3bc0f93a853f", "is_chatting": 1, "label_rate": 1, "log_seq": "5be03f955e8742bd97d03b7325ef204b", "phone_model": "iPhone_13", "rate": 4, "target_id": "81479540"}', '2025-04-15 00:45:05', 1744649105000, '2025-04-15 00:45:05'),
('sql_screenshots', 16, '2025-04-15 00:46:05', 'id_59d7b09ef59849bd', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110890469_1744649165000_108466147_1744649165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/fc8fdd07908b44f4afd88ca5dcbe62b0.jpg", "device_id": "d26c89e0-9701-4c48-a4c9-08e1a2a27f13", "is_chatting": 1, "label_rate": 1, "log_seq": "4acac4847c82447498742929329fe936", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "110890469"}', '2025-04-15 00:46:05', 1744649165000, '2025-04-15 00:46:05'),
('sql_screenshots', 16, '2025-04-15 00:47:05', 'id_9e88ba2e8877452e', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109407413_1744649225000_108870508_1744649225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ba9bed9ea46940a4aa3d6d3fc2ac8c92.jpg", "device_id": "e34cf8b8-8f93-4b6f-b6ad-2868bb20940e", "is_chatting": 1, "label_rate": 2, "log_seq": "b9f49938f04a40e9a33a80c31c693945", "phone_model": "Samsung_S21", "rate": 5, "target_id": "109407413"}', '2025-04-15 00:47:05', 1744649225000, '2025-04-15 00:47:05'),
('sql_screenshots', 16, '2025-04-15 00:48:05', 'id_417ac00af3914740', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "81479540_1744649285000_110876251_1744649285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/68fda3bc05eb4625a375137f4ae89650.jpg", "device_id": "9d282117-c173-49fa-9d86-e8aafddc9271", "is_chatting": 1, "label_rate": 0, "log_seq": "a8f7bc141b3c4eb58ed05824a2566ad2", "phone_model": "Samsung_S21", "rate": 3, "target_id": "81479540"}', '2025-04-15 00:48:05', 1744649285000, '2025-04-15 00:48:05'),
('sql_screenshots', 16, '2025-04-15 00:49:05', 'id_3b7c27f516a64a81', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "94369556_1744649345000_110890469_1744649345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0339653777c543b795d6440398717af3.jpg", "device_id": "36443f78-d9d2-4152-ab34-2a56fb1817f0", "is_chatting": 1, "label_rate": 1, "log_seq": "6d55605c752544fa84c967e789d57c15", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "94369556"}', '2025-04-15 00:49:05', 1744649345000, '2025-04-15 00:49:05'),
('sql_screenshots', 16, '2025-04-15 00:50:05', 'id_36aee11e2cfc400b', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "82365582_1744649405000_28230174_1744649405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b9a2481271324c29b23082fd0d4eb461.jpg", "device_id": "abb1d887-6959-4887-a64c-1475df52e996", "is_chatting": 1, "label_rate": 2, "log_seq": "877e5bb238824fba9eb4102eb2aacedc", "phone_model": "Samsung_S21", "rate": 2, "target_id": "82365582"}', '2025-04-15 00:50:05', 1744649405000, '2025-04-15 00:50:05'),
('sql_screenshots', 16, '2025-04-15 00:51:05', 'id_151ac4716b314340', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110873051_1744649465000_109407413_1744649465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e230b363034e4425815bbdbac6403a74.jpg", "device_id": "e1ab263a-d74b-455a-89b0-4a922a337346", "is_chatting": 1, "label_rate": 2, "log_seq": "4965bab9765f44cfa7133fa23e649457", "phone_model": "Huawei_P40", "rate": 3, "target_id": "110873051"}', '2025-04-15 00:51:05', 1744649465000, '2025-04-15 00:51:05'),
('sql_screenshots', 16, '2025-04-15 00:52:05', 'id_1218c27611614857', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109407413_1744649525000_101553185_1744649525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d8338b6798bb4716a17261b51326cd8a.jpg", "device_id": "cee75367-8304-4949-88da-1bc9edc4a202", "is_chatting": 1, "label_rate": 2, "log_seq": "f07a4b9ecf66405c9bbf2a0bffb20ac1", "phone_model": "Samsung_S22", "rate": 5, "target_id": "109407413"}', '2025-04-15 00:52:05', 1744649525000, '2025-04-15 00:52:05'),
('sql_screenshots', 16, '2025-04-15 00:53:05', 'id_6c6fd6c683934b11', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105083641_1744649585000_101553185_1744649585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3cb0cd45d0b248298dc3ef80d4ecc592.jpg", "device_id": "c7773296-aeef-46e6-acfe-a39389ce6349", "is_chatting": 1, "label_rate": 2, "log_seq": "1cda12adc4d34657b3dba21f94d11e48", "phone_model": "iPhone_13", "rate": 2, "target_id": "105083641"}', '2025-04-15 00:53:05', 1744649585000, '2025-04-15 00:53:05'),
('sql_screenshots', 16, '2025-04-15 00:54:05', 'id_fcfe1ac832894567', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "101553185_1744649645000_104844318_1744649645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/497b0eaf66b241318207632a55efe473.jpg", "device_id": "aaa49c8d-47d4-4dd3-9007-83751aa12d9a", "is_chatting": 1, "label_rate": 0, "log_seq": "4a8f11f5c962493abeacfd519c3a77c9", "phone_model": "Samsung_S21", "rate": 4, "target_id": "101553185"}', '2025-04-15 00:54:05', 1744649645000, '2025-04-15 00:54:05'),
('sql_screenshots', 16, '2025-04-15 00:55:05', 'id_4f6e4a1a1baf4083', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744649705000_110215081_1744649705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/46379fadfb6a409390db4188e5e83629.jpg", "device_id": "3dd8b0af-cfaa-4326-ab90-d7ba314e7a7d", "is_chatting": 1, "label_rate": 0, "log_seq": "9a6068f6156845b98c1aad2df3674d0a", "phone_model": "Samsung_S22", "rate": 1, "target_id": "110876251"}', '2025-04-15 00:55:05', 1744649705000, '2025-04-15 00:55:05'),
('sql_screenshots', 16, '2025-04-15 00:56:05', 'id_05911e45d8bb4061', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744649765000_110890469_1744649765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9a79e01e50dd40a9ac65bdd988e8bd69.jpg", "device_id": "76ed9bc5-050c-4e6b-9440-59322e9ad3f6", "is_chatting": 1, "label_rate": 2, "log_seq": "5c384bdf33534b6aa071cb570014bdcf", "phone_model": "Huawei_P40", "rate": 0, "target_id": "110876251"}', '2025-04-15 00:56:05', 1744649765000, '2025-04-15 00:56:05'),
('sql_screenshots', 16, '2025-04-15 00:57:05', 'id_ae2c8c76bd9849ab', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "83341608_1744649825000_28230174_1744649825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7e937ce9a2f247b8a4d66803a8b77e27.jpg", "device_id": "f86d42a4-3e0b-4cf7-a643-23e9b54cbef9", "is_chatting": 1, "label_rate": 1, "log_seq": "83cc350c419743d1a66cb8274d36a6fb", "phone_model": "VIVO_X60", "rate": 2, "target_id": "83341608"}', '2025-04-15 00:57:05', 1744649825000, '2025-04-15 00:57:05'),
('sql_screenshots', 16, '2025-04-15 00:58:05', 'id_a6cdfef7ac9c4bc6', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "54675542_1744649885000_104844318_1744649885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/08ece5292b254a6fbde4719544f04501.jpg", "device_id": "347f3e06-8c6a-45bd-9d4e-742ff4ba7814", "is_chatting": 1, "label_rate": 2, "log_seq": "e15567f30a924661840488a6dd5ee0f1", "phone_model": "VIVO_X60", "rate": 2, "target_id": "54675542"}', '2025-04-15 00:58:05', 1744649885000, '2025-04-15 00:58:05'),
('sql_screenshots', 16, '2025-04-15 00:59:05', 'id_46fab61f01d3412e', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "101553185_1744649945000_64280379_1744649945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/794a9e5b720642448687544d4625031e.jpg", "device_id": "4f82ebfe-000c-4945-89e9-6fcdf08d93ee", "is_chatting": 1, "label_rate": 2, "log_seq": "8029d320618845c38fe2d89ef97717ad", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "101553185"}', '2025-04-15 00:59:05', 1744649945000, '2025-04-15 00:59:05'),
('sql_screenshots', 16, '2025-04-15 01:00:05', 'id_69f9acc949214222', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "83341608_1744650005000_107039703_1744650005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0d20a9d14edf4bca9ef2fc572b1939c9.jpg", "device_id": "b9afa37a-7fd6-4600-8e9d-02c4a1ac06b6", "is_chatting": 1, "label_rate": 1, "log_seq": "e88e9181e76a4c14b1b0cc74b598248e", "phone_model": "VIVO_X60", "rate": 3, "target_id": "83341608"}', '2025-04-15 01:00:05', 1744650005000, '2025-04-15 01:00:05'),
('sql_screenshots', 16, '2025-04-15 01:01:05', 'id_4c6f6c958f464f27', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109407413_1744650065000_28230174_1744650065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1a9802421be047409554374179774401.jpg", "device_id": "a5b34977-aae8-498b-a0e2-49e99fe49f67", "is_chatting": 1, "label_rate": 0, "log_seq": "17670dadfece4b63b076310901af3722", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "109407413"}', '2025-04-15 01:01:05', 1744650065000, '2025-04-15 01:01:05'),
('sql_screenshots', 16, '2025-04-15 01:02:05', 'id_041f907d13404088', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109744448_1744650125000_108870508_1744650125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/37892eb9ff89409d9bec23a65eebcaae.jpg", "device_id": "4f97afb8-4d64-4479-a077-990adde70a17", "is_chatting": 1, "label_rate": 0, "log_seq": "2d8ae7c96371483bb506db785f032bc7", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "109744448"}', '2025-04-15 01:02:05', 1744650125000, '2025-04-15 01:02:05'),
('sql_screenshots', 16, '2025-04-15 01:03:05', 'id_6db06f1759734197', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "28230174_1744650185000_57649476_1744650185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7a445b0f565a4510b9943c008cc985e8.jpg", "device_id": "5bc53117-0ce9-40cf-8578-b01854bd261e", "is_chatting": 1, "label_rate": 2, "log_seq": "df0a70af5c6e4c298a7e659a8e9ab2dc", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "28230174"}', '2025-04-15 01:03:05', 1744650185000, '2025-04-15 01:03:05'),
('sql_screenshots', 16, '2025-04-15 01:04:05', 'id_59a13650781241cf', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "101553185_1744650245000_107039703_1744650245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c59d29b8d88b47cd9591c7ebe7050775.jpg", "device_id": "d013cc14-535c-4923-a22e-4a7a30fbd314", "is_chatting": 1, "label_rate": 1, "log_seq": "daf135d6d8de40739d115ed57662e2a0", "phone_model": "iPhone_13", "rate": 1, "target_id": "101553185"}', '2025-04-15 01:04:05', 1744650245000, '2025-04-15 01:04:05'),
('sql_screenshots', 16, '2025-04-15 01:05:05', 'id_4f8144595a094f53', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "81479540_1744650305000_32970671_1744650305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8936ae475dd5475ea16ff5de940836bb.jpg", "device_id": "d4c5b625-1716-4906-996e-4652fba805c4", "is_chatting": 1, "label_rate": 0, "log_seq": "293edec42e2e4fca83fafd3213ecadbf", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "81479540"}', '2025-04-15 01:05:05', 1744650305000, '2025-04-15 01:05:05'),
('sql_screenshots', 16, '2025-04-15 01:06:05', 'id_e2bc2ff02b8045b0', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "101553185_1744650365000_32970671_1744650365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/70a94cd134d540b9836565e4ce79ccba.jpg", "device_id": "2a2ae92b-9ee6-4533-a5e8-c7ca56e9ca84", "is_chatting": 1, "label_rate": 0, "log_seq": "d58d57ae8733480b938c73ea3a521f89", "phone_model": "OnePlus_9", "rate": 5, "target_id": "101553185"}', '2025-04-15 01:06:05', 1744650365000, '2025-04-15 01:06:05'),
('sql_screenshots', 16, '2025-04-15 01:07:05', 'id_0799451b22004681', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "94369556_1744650425000_82365582_1744650425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6366a582500a4e05970a35d62fd16741.jpg", "device_id": "384d1457-894e-4608-86a3-5b945e1af9f0", "is_chatting": 1, "label_rate": 2, "log_seq": "fe2a44c1cf024908ab042fa61fa08dc5", "phone_model": "iPhone_13", "rate": 5, "target_id": "94369556"}', '2025-04-15 01:07:05', 1744650425000, '2025-04-15 01:07:05'),
('sql_screenshots', 16, '2025-04-15 01:08:05', 'id_0ff9f73b2eea471c', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108870508_1744650485000_110873051_1744650485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4b879be252304cfcbca1c4e5b3b09efc.jpg", "device_id": "a74ad58f-e721-4f42-b09b-a4f02f6e1548", "is_chatting": 1, "label_rate": 1, "log_seq": "e9e397d90d5a4a0e8fad3e46bd5effae", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "108870508"}', '2025-04-15 01:08:05', 1744650485000, '2025-04-15 01:08:05'),
('sql_screenshots', 16, '2025-04-15 01:09:05', 'id_091ce5705a944045', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744650545000_64280379_1744650545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/318cf7f07b2c41efbb6a5959caf7678b.jpg", "device_id": "c8bbf151-b5cc-49bb-8194-a7178608ddfb", "is_chatting": 1, "label_rate": 1, "log_seq": "f9d1b9139af3470fa3dedbb4213306fe", "phone_model": "iPhone_13", "rate": 3, "target_id": "110873051"}', '2025-04-15 01:09:05', 1744650545000, '2025-04-15 01:09:05'),
('sql_screenshots', 16, '2025-04-15 01:10:05', 'id_2da66a715113492d', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744650605000_108466147_1744650605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6a752f99ce1140bb8743b754f5fccbd8.jpg", "device_id": "39c5bf6a-74f9-47fe-a8ff-5d7834f75784", "is_chatting": 1, "label_rate": 1, "log_seq": "4e8ee72a092d4e3fb376b16dd70841a1", "phone_model": "VIVO_X60", "rate": 0, "target_id": "81479540"}', '2025-04-15 01:10:05', 1744650605000, '2025-04-15 01:10:05'),
('sql_screenshots', 16, '2025-04-15 01:11:05', 'id_72470e402c904cab', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110876251_1744650665000_54675542_1744650665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f94904efdce34cafb2cf36987a6f9748.jpg", "device_id": "2ed31a2e-4444-4598-8c25-fde857ebf68c", "is_chatting": 1, "label_rate": 2, "log_seq": "b4b666e02eed446fbe2328d7df5d2d22", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "110876251"}', '2025-04-15 01:11:05', 1744650665000, '2025-04-15 01:11:05'),
('sql_screenshots', 16, '2025-04-15 01:12:05', 'id_7b7212fbbd87412a', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "54675542_1744650725000_87571440_1744650725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/edcdf75842494f4cad458365b7e0a462.jpg", "device_id": "89de5ae0-cdd1-49d4-a7b7-49e0b12e422c", "is_chatting": 1, "label_rate": 2, "log_seq": "5afc70ae1ce34561a87b9b89131e4f49", "phone_model": "Samsung_S21", "rate": 5, "target_id": "54675542"}', '2025-04-15 01:12:05', 1744650725000, '2025-04-15 01:12:05'),
('sql_screenshots', 16, '2025-04-15 01:13:05', 'id_4ac115c0f1a84f40', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110890469_1744650785000_110876251_1744650785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/23b59fec7b6044a0bcbae9d0075e429a.jpg", "device_id": "9e73779f-54ad-42c7-b5cb-37b13e9780ba", "is_chatting": 1, "label_rate": 0, "log_seq": "994a264a874845758cc7071eac24d792", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "110890469"}', '2025-04-15 01:13:05', 1744650785000, '2025-04-15 01:13:05'),
('sql_screenshots', 16, '2025-04-15 01:14:05', 'id_1fc65b26ea8841b4', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108466147_1744650845000_110890469_1744650845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/460c176b149741dabd6c81a6e19fa613.jpg", "device_id": "16e4e051-318e-4305-8c0b-9c2b33e5fc7c", "is_chatting": 1, "label_rate": 0, "log_seq": "8b1fbb8bdd78445fbe4176c0f9f610cd", "phone_model": "Samsung_S21", "rate": 0, "target_id": "108466147"}', '2025-04-15 01:14:05', 1744650845000, '2025-04-15 01:14:05'),
('sql_screenshots', 16, '2025-04-15 01:15:05', 'id_615f991ed4614515', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "57649476_1744650905000_108466147_1744650905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6f5602903b8147fe87f434b5319e8db9.jpg", "device_id": "35158a99-4a0e-44b6-8bfc-c12c8129a065", "is_chatting": 1, "label_rate": 0, "log_seq": "6f4a97ebab164d9f94a4375079309d3c", "phone_model": "OnePlus_9", "rate": 3, "target_id": "57649476"}', '2025-04-15 01:15:05', 1744650905000, '2025-04-15 01:15:05'),
('sql_screenshots', 16, '2025-04-15 01:16:05', 'id_fa895dd65aee44b5', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "107039703_1744650965000_110215081_1744650965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/988c39365f87442389d40d52d18fd968.jpg", "device_id": "1b269edf-59af-44ff-81fa-a139bf42c490", "is_chatting": 1, "label_rate": 1, "log_seq": "19b1b78dfcf54680979375b0c322415a", "phone_model": "OnePlus_9", "rate": 3, "target_id": "107039703"}', '2025-04-15 01:16:05', 1744650965000, '2025-04-15 01:16:05'),
('sql_screenshots', 16, '2025-04-15 01:17:05', 'id_32180e4fd71b4679', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744651025000_105083641_1744651025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/aac6d1e37e83480ba37194eab31c9be1.jpg", "device_id": "3e5e715b-41c0-4733-8e0b-da7f05135a21", "is_chatting": 1, "label_rate": 1, "log_seq": "b976b3da3e4e434fa5f322e2d8c5e14d", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "109657261"}', '2025-04-15 01:17:05', 1744651025000, '2025-04-15 01:17:05'),
('sql_screenshots', 16, '2025-04-15 01:18:05', 'id_cdb94ec61f9648e4', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109657261_1744651085000_109980113_1744651085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8ca3961dd5c5470e9ef17d5123e9af41.jpg", "device_id": "1e88dd52-b288-4aca-b0b4-ea353eb13d7a", "is_chatting": 1, "label_rate": 2, "log_seq": "732e23fd2a0548cbaf5c0e738108dcbb", "phone_model": "OnePlus_9", "rate": 3, "target_id": "109657261"}', '2025-04-15 01:18:05', 1744651085000, '2025-04-15 01:18:05'),
('sql_screenshots', 16, '2025-04-15 01:19:05', 'id_72be895be7e246b3', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "28230174_1744651145000_109744448_1744651145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7a006316d040434cbca83b6c7e6d2334.jpg", "device_id": "d5d36095-ed49-49aa-b483-b9423ebfb602", "is_chatting": 1, "label_rate": 1, "log_seq": "aca5768d1b274e00baf6928d76707bb1", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "28230174"}', '2025-04-15 01:19:05', 1744651145000, '2025-04-15 01:19:05'),
('sql_screenshots', 16, '2025-04-15 01:20:05', 'id_e3187bab01944fe7', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "64280379_1744651205000_109407413_1744651205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f4d505fe4015470a8faebe6ef522fa14.jpg", "device_id": "c41eef3c-e6a9-44fb-9b03-1a1fcfef9dd7", "is_chatting": 1, "label_rate": 2, "log_seq": "3212f93579344314ba23618b2b6287f4", "phone_model": "iPhone_13", "rate": 4, "target_id": "64280379"}', '2025-04-15 01:20:05', 1744651205000, '2025-04-15 01:20:05'),
('sql_screenshots', 16, '2025-04-15 01:21:05', 'id_38250a8165fe447f', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109657261_1744651265000_104844318_1744651265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d9724068fb1947eabba696153abf5538.jpg", "device_id": "3a96a546-eddb-448b-8960-8efb41926396", "is_chatting": 1, "label_rate": 2, "log_seq": "4d425962fb9a409e937eab3c2c3c8ab6", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "109657261"}', '2025-04-15 01:21:05', 1744651265000, '2025-04-15 01:21:05'),
('sql_screenshots', 16, '2025-04-15 01:22:05', 'id_9341dea9e9554cd6', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110892617_1744651325000_109657261_1744651325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/fac893efd0e242fd92517377b27cfc9d.jpg", "device_id": "d02c2cb8-7ed2-4e81-819a-de9a8b98bdba", "is_chatting": 1, "label_rate": 0, "log_seq": "475bd46cf6e04c0ba0f7934b909ec497", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "110892617"}', '2025-04-15 01:22:05', 1744651325000, '2025-04-15 01:22:05'),
('sql_screenshots', 16, '2025-04-15 01:23:05', 'id_1ebe909cbdda4915', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "104844318_1744651385000_107039703_1744651385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/648d437676134ad7911a4513d7469ad5.jpg", "device_id": "11df54e0-c52e-4bee-884c-f4412f836471", "is_chatting": 1, "label_rate": 0, "log_seq": "bf714577cb5e43a69a468cc7896df2bf", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "104844318"}', '2025-04-15 01:23:05', 1744651385000, '2025-04-15 01:23:05'),
('sql_screenshots', 16, '2025-04-15 01:24:05', 'id_7cadf73d54794cd1', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "57649476_1744651445000_110890469_1744651445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e111c70225de414b8ad7ed16728762a6.jpg", "device_id": "597f849e-bd54-4917-9099-b4c46771c48c", "is_chatting": 1, "label_rate": 0, "log_seq": "33169bb1f97445aa83926821f9b5be99", "phone_model": "Samsung_S22", "rate": 3, "target_id": "57649476"}', '2025-04-15 01:24:05', 1744651445000, '2025-04-15 01:24:05'),
('sql_screenshots', 16, '2025-04-15 01:25:05', 'id_9a65c6b92aeb4482', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744651505000_101553185_1744651505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/72110450bb24497197a37a7ff1521c6d.jpg", "device_id": "98b98ea0-9f09-49f6-b7f1-372be4fbdc0d", "is_chatting": 1, "label_rate": 2, "log_seq": "ddc0f44b51f74a67acaee048b8a22f11", "phone_model": "VIVO_X60", "rate": 5, "target_id": "107039703"}', '2025-04-15 01:25:05', 1744651505000, '2025-04-15 01:25:05'),
('sql_screenshots', 16, '2025-04-15 01:26:05', 'id_c1fbc2a05f244e4b', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "32970671_1744651565000_110873051_1744651565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7fd1dbedc45d42c3bcad15999d0869c7.jpg", "device_id": "6089c478-9e45-4b99-931d-ac9a2ec6d857", "is_chatting": 1, "label_rate": 0, "log_seq": "d53ab868028c4b5f8f85b1ada96bea11", "phone_model": "iPhone_13", "rate": 0, "target_id": "32970671"}', '2025-04-15 01:26:05', 1744651565000, '2025-04-15 01:26:05'),
('sql_screenshots', 16, '2025-04-15 01:27:05', 'id_aadb008cb41348da', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "32970671_1744651625000_110890469_1744651625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1f89b4944eec446bbace30d59cdf2fda.jpg", "device_id": "815ae1f4-82a0-422c-a229-096aa38efc3d", "is_chatting": 1, "label_rate": 1, "log_seq": "70784db8585f4db8ac463483722dc9dd", "phone_model": "VIVO_X60", "rate": 0, "target_id": "32970671"}', '2025-04-15 01:27:05', 1744651625000, '2025-04-15 01:27:05'),
('sql_screenshots', 16, '2025-04-15 01:28:05', 'id_5f956d0bfa0c499f', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105503656_1744651685000_28230174_1744651685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8f4760cc2ede4ea6b6155dca61ca7e48.jpg", "device_id": "763533cd-bc12-45d5-90b3-aeb676a523de", "is_chatting": 1, "label_rate": 0, "log_seq": "c6c68262a5164237a05f28435fb4e144", "phone_model": "Samsung_S22", "rate": 4, "target_id": "105503656"}', '2025-04-15 01:28:05', 1744651685000, '2025-04-15 01:28:05'),
('sql_screenshots', 16, '2025-04-15 01:29:05', 'id_2fe6383216e34007', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "83341608_1744651745000_87571440_1744651745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/935a31400bb0494da7c20c36fe7e9ab0.jpg", "device_id": "2bf82b55-3784-4517-a628-1027b06b50d9", "is_chatting": 1, "label_rate": 0, "log_seq": "f5ad0986dd384f319667477170905592", "phone_model": "Huawei_P40", "rate": 1, "target_id": "83341608"}', '2025-04-15 01:29:05', 1744651745000, '2025-04-15 01:29:05'),
('sql_screenshots', 16, '2025-04-15 01:30:05', 'id_5c14ce89671f4fc8', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "104844318_1744651805000_107039703_1744651805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a17220f5cc7d4f3eae5257ad6696dcb1.jpg", "device_id": "a1d9378e-4d5e-44ea-ba1f-44db5294df7c", "is_chatting": 1, "label_rate": 0, "log_seq": "80b3f76f77dd4d7ab254175ccae81162", "phone_model": "VIVO_X60", "rate": 1, "target_id": "104844318"}', '2025-04-15 01:30:05', 1744651805000, '2025-04-15 01:30:05'),
('sql_screenshots', 16, '2025-04-15 01:31:05', 'id_183382835f7f48bf', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744651865000_81479540_1744651865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bd6d127615774c51a40b35b6fb21493f.jpg", "device_id": "8f6da60a-36bd-4718-b053-22feb172521a", "is_chatting": 1, "label_rate": 2, "log_seq": "5211c5e35a8143f1995c80fea2587fdb", "phone_model": "Samsung_S21", "rate": 3, "target_id": "107039703"}', '2025-04-15 01:31:05', 1744651865000, '2025-04-15 01:31:05'),
('sql_screenshots', 16, '2025-04-15 01:32:05', 'id_4551e915b1e14d1b', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "32970671_1744651925000_87571440_1744651925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a4866f2a13fc43748a642cd397c85b6b.jpg", "device_id": "07fec520-4cbe-46ca-9b91-054ba87e80b6", "is_chatting": 1, "label_rate": 1, "log_seq": "7cc3c21f77284991b62d27c1b955b025", "phone_model": "VIVO_X60", "rate": 0, "target_id": "32970671"}', '2025-04-15 01:32:05', 1744651925000, '2025-04-15 01:32:05'),
('sql_screenshots', 16, '2025-04-15 01:33:05', 'id_9d9423a354ba4fa5', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "82365582_1744651985000_109980113_1744651985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/af4d9e5fe42c40f48d02ef37957a0c14.jpg", "device_id": "4b9f256e-200a-428e-a554-5ad712c677ab", "is_chatting": 1, "label_rate": 1, "log_seq": "d338d862b2674fd89401233f83023ba0", "phone_model": "iPhone_13", "rate": 0, "target_id": "82365582"}', '2025-04-15 01:33:05', 1744651985000, '2025-04-15 01:33:05'),
('sql_screenshots', 16, '2025-04-15 01:34:05', 'id_a27b8195240f4dc5', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "83341608_1744652045000_101553185_1744652045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8b911aa0fb4e46008a3b09211612d8ff.jpg", "device_id": "1289946b-c06e-4cac-b7e2-a921aa273adb", "is_chatting": 1, "label_rate": 2, "log_seq": "ba9c4721a2a147c98e2c63dfe248ef5a", "phone_model": "Samsung_S22", "rate": 0, "target_id": "83341608"}', '2025-04-15 01:34:05', 1744652045000, '2025-04-15 01:34:05'),
('sql_screenshots', 16, '2025-04-15 01:35:05', 'id_d828385590914019', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "83341608_1744652105000_104844318_1744652105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8f772a09ca1246b982d1c949eeff885c.jpg", "device_id": "dd3906a5-b7d1-4135-b8e9-fe8a38e396b3", "is_chatting": 1, "label_rate": 1, "log_seq": "3b7ba0ccead548b394acfde13a608c34", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "83341608"}', '2025-04-15 01:35:05', 1744652105000, '2025-04-15 01:35:05'),
('sql_screenshots', 16, '2025-04-15 01:36:05', 'id_b6a7e18ca6174e57', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "81479540_1744652165000_110890469_1744652165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f054f48525184086b08a597fb6665103.jpg", "device_id": "0fa5c0a8-19ba-4ed7-b19d-22501d023283", "is_chatting": 1, "label_rate": 1, "log_seq": "d0ce212aea8f4c1cacb2d60ab073d01f", "phone_model": "VIVO_X60", "rate": 1, "target_id": "81479540"}', '2025-04-15 01:36:05', 1744652165000, '2025-04-15 01:36:05'),
('sql_screenshots', 16, '2025-04-15 01:37:05', 'id_d954ff0a572949a1', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105083641_1744652225000_108466147_1744652225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c5c862d5f53144238e69dd0af189750b.jpg", "device_id": "5b599ae1-779e-40ec-ab90-b8a6f999841a", "is_chatting": 1, "label_rate": 2, "log_seq": "293ff19ad3024444bd15c03262281738", "phone_model": "Huawei_P40", "rate": 5, "target_id": "105083641"}', '2025-04-15 01:37:05', 1744652225000, '2025-04-15 01:37:05'),
('sql_screenshots', 16, '2025-04-15 01:38:05', 'id_56f813ec5a2f4555', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744652285000_110890469_1744652285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3187d443bfa345a0b622655933d86a08.jpg", "device_id": "e02de635-7268-4f47-a649-d21af2859927", "is_chatting": 1, "label_rate": 2, "log_seq": "e1832047325f46b2a0d6638fe79ddf51", "phone_model": "iPhone_13", "rate": 4, "target_id": "110876251"}', '2025-04-15 01:38:05', 1744652285000, '2025-04-15 01:38:05'),
('sql_screenshots', 16, '2025-04-15 01:39:05', 'id_b967595ccb73424e', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110892617_1744652345000_83341608_1744652345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9acbdb31901d49ec88c40a7fc49c1a70.jpg", "device_id": "e8a00f1c-287d-4556-9bef-feade1aa91aa", "is_chatting": 1, "label_rate": 0, "log_seq": "1f5cd17ce1c841b191778e36cca332ff", "phone_model": "Samsung_S22", "rate": 1, "target_id": "110892617"}', '2025-04-15 01:39:05', 1744652345000, '2025-04-15 01:39:05'),
('sql_screenshots', 16, '2025-04-15 01:40:05', 'id_4cf077c5ddf74321', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "82365582_1744652405000_110892617_1744652405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b7b10798670b43c39f5fe2f56bcb9f92.jpg", "device_id": "7eb9895d-fb0d-496e-8144-590970939de4", "is_chatting": 1, "label_rate": 2, "log_seq": "275d8b7b60f340669390e2a2072da0fc", "phone_model": "Huawei_P40", "rate": 0, "target_id": "82365582"}', '2025-04-15 01:40:05', 1744652405000, '2025-04-15 01:40:05'),
('sql_screenshots', 16, '2025-04-15 01:41:05', 'id_bd8ed03c3e8f4feb', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109744448_1744652465000_108466147_1744652465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4af701bf03394e5b99fa292f0f70e236.jpg", "device_id": "12ac1f45-92a5-42fb-9f58-9b633d4ddf46", "is_chatting": 1, "label_rate": 0, "log_seq": "a896d766fec845eb99a461783cee3ca4", "phone_model": "iPhone_13", "rate": 1, "target_id": "109744448"}', '2025-04-15 01:41:05', 1744652465000, '2025-04-15 01:41:05'),
('sql_screenshots', 16, '2025-04-15 01:42:05', 'id_79cdb57a5b2049a1', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108870508_1744652525000_81479540_1744652525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/46db0f54903040e29d744e1a2d772e18.jpg", "device_id": "920b34ea-8482-49eb-9725-254d0c16564a", "is_chatting": 1, "label_rate": 0, "log_seq": "de2bb8e616654ae6afe118648a76efcf", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "108870508"}', '2025-04-15 01:42:05', 1744652525000, '2025-04-15 01:42:05'),
('sql_screenshots', 16, '2025-04-15 01:43:05', 'id_f4b3a5c3f0b045f3', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744652585000_110890469_1744652585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/57ee222c4cbe45da8628f9f524d2f966.jpg", "device_id": "8b5bd853-4aa1-4345-bb8a-00274e1ee64d", "is_chatting": 1, "label_rate": 0, "log_seq": "7b8e586503d14dc28b8ea6a088c53bc4", "phone_model": "VIVO_X60", "rate": 0, "target_id": "110873051"}', '2025-04-15 01:43:05', 1744652585000, '2025-04-15 01:43:05'),
('sql_screenshots', 16, '2025-04-15 01:44:05', 'id_73676bee964f4e62', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744652645000_57649476_1744652645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3148d9620e6248abac1128074778df23.jpg", "device_id": "a91045a1-77a8-4360-ae12-d5c99ed176c0", "is_chatting": 1, "label_rate": 0, "log_seq": "1ea667e83c0c4b4e890324514c2eea5d", "phone_model": "iPhone_13", "rate": 4, "target_id": "82365582"}', '2025-04-15 01:44:05', 1744652645000, '2025-04-15 01:44:05'),
('sql_screenshots', 16, '2025-04-15 01:45:05', 'id_c76128da8ae240de', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105503656_1744652705000_110890469_1744652705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7af53d806f924101bd42c7e9d97f0359.jpg", "device_id": "13a522d7-f0c3-4339-9a93-2dcc166e34ff", "is_chatting": 1, "label_rate": 1, "log_seq": "aa0767c107934e248e75ac66709debe4", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "105503656"}', '2025-04-15 01:45:05', 1744652705000, '2025-04-15 01:45:05'),
('sql_screenshots', 16, '2025-04-15 01:46:05', 'id_eb12205cfba94a7e', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109657261_1744652765000_83341608_1744652765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/062e3defb7d0413abc77bb80f647c619.jpg", "device_id": "0e375241-cc0c-4a45-ba23-fdef4ef63d3a", "is_chatting": 1, "label_rate": 2, "log_seq": "bf538d7d2d0943f0b842c32d8b9481f7", "phone_model": "OnePlus_9", "rate": 0, "target_id": "109657261"}', '2025-04-15 01:46:05', 1744652765000, '2025-04-15 01:46:05'),
('sql_screenshots', 16, '2025-04-15 01:47:05', 'id_52c11617fcef4a82', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "94369556_1744652825000_110873051_1744652825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2b71042e28184ea8ac9a1af9ad3cbdf3.jpg", "device_id": "ced201a3-28af-4a59-9981-11280b80edea", "is_chatting": 1, "label_rate": 2, "log_seq": "6af2a8e67cef4bcc8a21f8f072acfb02", "phone_model": "OnePlus_9", "rate": 1, "target_id": "94369556"}', '2025-04-15 01:47:05', 1744652825000, '2025-04-15 01:47:05'),
('sql_screenshots', 16, '2025-04-15 01:48:05', 'id_98f62cbbb9744f36', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110892617_1744652885000_64280379_1744652885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/995caaf5f3544261930f6f9f3d419491.jpg", "device_id": "1851d6b8-07aa-4a99-957d-352a78d6c292", "is_chatting": 1, "label_rate": 2, "log_seq": "46ad3073f1834e59aefa4a31e51a8803", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "110892617"}', '2025-04-15 01:48:05', 1744652885000, '2025-04-15 01:48:05'),
('sql_screenshots', 16, '2025-04-15 01:49:05', 'id_25f0af7c282a46f0', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108870508_1744652945000_108466147_1744652945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/db4d077a902447dd81dbc55e443c77f9.jpg", "device_id": "4262e360-d9e6-493e-9a06-16ae345dce07", "is_chatting": 1, "label_rate": 1, "log_seq": "244bdba35ccb4b79b3dc0727c95af144", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "108870508"}', '2025-04-15 01:49:05', 1744652945000, '2025-04-15 01:49:05'),
('sql_screenshots', 16, '2025-04-15 01:50:05', 'id_dc0c0c4dc90c4730', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744653005000_54675542_1744653005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/06a9542fe0bc4681aa4ff4d40a7ddbfd.jpg", "device_id": "713636c9-8b2b-4a27-a78b-2d7dedb5f8ba", "is_chatting": 1, "label_rate": 2, "log_seq": "5a44150cb24444fe85d798a7f5115ece", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "110873051"}', '2025-04-15 01:50:05', 1744653005000, '2025-04-15 01:50:05'),
('sql_screenshots', 16, '2025-04-15 01:51:05', 'id_fd163aa333fd4edd', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "54675542_1744653065000_105083641_1744653065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bebd24e51571451f8c89eaa0ad54409a.jpg", "device_id": "84aa5d2d-0121-4577-8499-3f158b1b95dc", "is_chatting": 1, "label_rate": 1, "log_seq": "62c630d639584310a296f84800fe4420", "phone_model": "VIVO_X60", "rate": 3, "target_id": "54675542"}', '2025-04-15 01:51:05', 1744653065000, '2025-04-15 01:51:05'),
('sql_screenshots', 16, '2025-04-15 01:52:05', 'id_5dd77b245b994a5a', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110215081_1744653125000_109657261_1744653125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2cea081ab9bd47aeb7a6efd83972ce11.jpg", "device_id": "50558a45-2167-4eb0-9c7b-3d7af84828d8", "is_chatting": 1, "label_rate": 2, "log_seq": "0fb168e7ca804e95b3dd2cffd44252b8", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "110215081"}', '2025-04-15 01:52:05', 1744653125000, '2025-04-15 01:52:05'),
('sql_screenshots', 16, '2025-04-15 01:53:05', 'id_fa6e153b9497478a', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110876251_1744653185000_54675542_1744653185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a5aa3be94b9640adaf122a39e93d2bf7.jpg", "device_id": "6108682f-9ef0-444b-9c23-049629f9f9bc", "is_chatting": 1, "label_rate": 2, "log_seq": "df19df2b1e78488d9186ce259960ab39", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "110876251"}', '2025-04-15 01:53:05', 1744653185000, '2025-04-15 01:53:05'),
('sql_screenshots', 16, '2025-04-15 01:54:05', 'id_cb44970cc4d841e8', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744653245000_105083641_1744653245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ab6e82ba90584d5c9a8c38138b9c85c5.jpg", "device_id": "a79badcb-0d95-474e-ac7c-7d853cc934eb", "is_chatting": 1, "label_rate": 1, "log_seq": "7f1a634f11c846f28ef5ec063c3e6938", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "108466147"}', '2025-04-15 01:54:05', 1744653245000, '2025-04-15 01:54:05'),
('sql_screenshots', 16, '2025-04-15 01:55:05', 'id_441200895ee84173', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110890469_1744653305000_109744448_1744653305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f4a50a6b986a4793acfc5f9c0ec3e6fd.jpg", "device_id": "2f556576-bcae-4c77-bf56-ca9508e8db2f", "is_chatting": 1, "label_rate": 2, "log_seq": "53c4261069fa4422895f9c30b06b3a54", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "110890469"}', '2025-04-15 01:55:05', 1744653305000, '2025-04-15 01:55:05'),
('sql_screenshots', 16, '2025-04-15 01:56:05', 'id_e9bbdbc962b74463', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109980113_1744653365000_81479540_1744653365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c64c7a15a7694cb5a7d197c8b3163acf.jpg", "device_id": "a636010c-be0f-4926-b604-0e814b267d57", "is_chatting": 1, "label_rate": 1, "log_seq": "fc87b6e623ef485585952a2c9179d9aa", "phone_model": "iPhone_13", "rate": 2, "target_id": "109980113"}', '2025-04-15 01:56:05', 1744653365000, '2025-04-15 01:56:05'),
('sql_screenshots', 16, '2025-04-15 01:57:05', 'id_75df004560b64c39', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110892617_1744653425000_108466147_1744653425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/24878cdc88d046e2885bbc407cf94d34.jpg", "device_id": "51386c2c-bb81-4166-8e45-219fabb6a4ce", "is_chatting": 1, "label_rate": 2, "log_seq": "0b4e4ca398d9456d94827fb4f7bccf2e", "phone_model": "Samsung_S21", "rate": 5, "target_id": "110892617"}', '2025-04-15 01:57:05', 1744653425000, '2025-04-15 01:57:05'),
('sql_screenshots', 16, '2025-04-15 01:58:05', 'id_453747ce13ee4d10', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105083641_1744653485000_107039703_1744653485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0778cac86e984788871ae0d93571d619.jpg", "device_id": "4bd1c056-0b1a-470d-8f37-87684ad4c8c9", "is_chatting": 1, "label_rate": 1, "log_seq": "215a365f56fb46fd96da44fdb863ff46", "phone_model": "iPhone_13", "rate": 3, "target_id": "105083641"}', '2025-04-15 01:58:05', 1744653485000, '2025-04-15 01:58:05'),
('sql_screenshots', 16, '2025-04-15 01:59:05', 'id_91b148015cdc46dc', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110215081_1744653545000_82365582_1744653545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/275862fe646944078e11e14f5be50bb8.jpg", "device_id": "f43a468b-5c1e-4cb5-978a-cf7401208d85", "is_chatting": 1, "label_rate": 2, "log_seq": "d4a6033e1522405690905152ac7fe8aa", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "110215081"}', '2025-04-15 01:59:05', 1744653545000, '2025-04-15 01:59:05'),
('sql_screenshots', 16, '2025-04-15 02:00:05', 'id_070a601d3f8c4c72', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "94369556_1744653605000_28230174_1744653605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2d1c0788c47b473b8cbb165f1ab3de3c.jpg", "device_id": "69aad343-5343-4b3b-9b14-b32e059ccff2", "is_chatting": 1, "label_rate": 0, "log_seq": "e69f55fbef2b4d8b8a55e065505b1303", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "94369556"}', '2025-04-15 02:00:05', 1744653605000, '2025-04-15 02:00:05'),
('sql_screenshots', 16, '2025-04-15 02:01:05', 'id_154513643ded4818', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "104844318_1744653665000_109657261_1744653665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8520e21133204f698a0211f6992be8a4.jpg", "device_id": "551f7597-910f-4c14-895e-04266550ec99", "is_chatting": 1, "label_rate": 0, "log_seq": "33cda5ef920b4e13b185e7724b3c5241", "phone_model": "Samsung_S21", "rate": 3, "target_id": "104844318"}', '2025-04-15 02:01:05', 1744653665000, '2025-04-15 02:01:05'),
('sql_screenshots', 16, '2025-04-15 02:02:05', 'id_6983119f4ca84e8c', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105503656_1744653725000_57649476_1744653725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b1bd746cac59495485b5ec13584ff57a.jpg", "device_id": "4b2c9cd0-b90e-409a-a43d-03b85e18aee8", "is_chatting": 1, "label_rate": 1, "log_seq": "86e92bdb21ac4a08832537d9954b6e7f", "phone_model": "Samsung_S22", "rate": 0, "target_id": "105503656"}', '2025-04-15 02:02:05', 1744653725000, '2025-04-15 02:02:05'),
('sql_screenshots', 16, '2025-04-15 02:03:05', 'id_cb27d437e3354beb', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108870508_1744653785000_109407413_1744653785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6655ef66d1cd4ecaa0cfbf52340bb48b.jpg", "device_id": "35cee738-7922-4f58-b9c6-62d2905117ea", "is_chatting": 1, "label_rate": 2, "log_seq": "bc8fef6dc2fb4baca1b35486f647bb5d", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "108870508"}', '2025-04-15 02:03:05', 1744653785000, '2025-04-15 02:03:05'),
('sql_screenshots', 16, '2025-04-15 02:04:05', 'id_2c92e50a081d4ab1', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105083641_1744653845000_110892617_1744653845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/20fd6a8c458a485a98d044d937c892fd.jpg", "device_id": "01962835-554b-48c1-be22-4a084defa74c", "is_chatting": 1, "label_rate": 1, "log_seq": "381926b79e524322bc0dc9a295c6bb5b", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "105083641"}', '2025-04-15 02:04:05', 1744653845000, '2025-04-15 02:04:05'),
('sql_screenshots', 16, '2025-04-15 02:05:05', 'id_4f556fe05bdb495b', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744653905000_110873051_1744653905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/29da8202da0545c88aee670f72ec0ed6.jpg", "device_id": "3b7235e0-d7f9-42f8-99f0-af5d740e8a48", "is_chatting": 1, "label_rate": 2, "log_seq": "a890771d801b4eb6bba8620192624bd4", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "110876251"}', '2025-04-15 02:05:05', 1744653905000, '2025-04-15 02:05:05'),
('sql_screenshots', 16, '2025-04-15 02:06:05', 'id_fd445026613243b3', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "57649476_1744653965000_109980113_1744653965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5fd32d5eb02b4633bcade58202948175.jpg", "device_id": "2e2df2b3-e026-48fb-89c5-52935923ade7", "is_chatting": 1, "label_rate": 0, "log_seq": "19904673a7cf4543a1ae413e7c8d2bae", "phone_model": "OnePlus_9", "rate": 4, "target_id": "57649476"}', '2025-04-15 02:06:05', 1744653965000, '2025-04-15 02:06:05'),
('sql_screenshots', 16, '2025-04-15 02:07:05', 'id_c20fed5a8e77477a', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "81479540_1744654025000_110215081_1744654025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/36781e25eca440728e22bb77ccd417b9.jpg", "device_id": "ceb6cc32-d5f8-40ba-ac2b-6226a6eaf392", "is_chatting": 1, "label_rate": 2, "log_seq": "288e68a46ce74cae9ad9cd423fab8c7d", "phone_model": "Samsung_S22", "rate": 1, "target_id": "81479540"}', '2025-04-15 02:07:05', 1744654025000, '2025-04-15 02:07:05'),
('sql_screenshots', 16, '2025-04-15 02:08:05', 'id_1ae88722a61a4be4', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "104844318_1744654085000_110873051_1744654085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/91e9e02406484439a9129479ad61c3ee.jpg", "device_id": "31fa6c24-3af9-4672-b8c3-81bee485cd2d", "is_chatting": 1, "label_rate": 0, "log_seq": "4fa7f35c72194d92bf34d258ba60a5c6", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "104844318"}', '2025-04-15 02:08:05', 1744654085000, '2025-04-15 02:08:05'),
('sql_screenshots', 16, '2025-04-15 02:09:05', 'id_18ce84b3e6124c55', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "104844318_1744654145000_105503656_1744654145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/73d5a458e4ac44928c8bab1a71d6596a.jpg", "device_id": "69338a60-43b8-4e91-9436-9092f5c6d9b3", "is_chatting": 1, "label_rate": 2, "log_seq": "14ef01a712284f6a974463287ca80c0a", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "104844318"}', '2025-04-15 02:09:05', 1744654145000, '2025-04-15 02:09:05'),
('sql_screenshots', 16, '2025-04-15 02:10:05', 'id_fb4510b58f554112', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744654205000_109744448_1744654205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/98d7e14b909847b383c414315d390f9f.jpg", "device_id": "284dbb42-96cd-4408-92fd-288a17580af3", "is_chatting": 1, "label_rate": 2, "log_seq": "7afc11cde9bf4a4aabb9d7d410bd5879", "phone_model": "Huawei_P40", "rate": 3, "target_id": "110766160"}', '2025-04-15 02:10:05', 1744654205000, '2025-04-15 02:10:05'),
('sql_screenshots', 16, '2025-04-15 02:11:05', 'id_624ca10ed310403a', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108466147_1744654265000_87571440_1744654265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/48338d09799e4b34988e5256a94cee3e.jpg", "device_id": "99716f8b-e5b8-4ee1-9fe1-e28b4a0b7c95", "is_chatting": 1, "label_rate": 2, "log_seq": "9e4049ca924147edab325cf04e327216", "phone_model": "Samsung_S21", "rate": 1, "target_id": "108466147"}', '2025-04-15 02:11:05', 1744654265000, '2025-04-15 02:11:05'),
('sql_screenshots', 16, '2025-04-15 02:12:05', 'id_2f0e9fffce694d63', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "57649476_1744654325000_109744448_1744654325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f49f5d47cbe946608d48d4dfdd581cb6.jpg", "device_id": "035699c3-e52c-4871-9c11-7cd6fd8d65bd", "is_chatting": 1, "label_rate": 0, "log_seq": "7f48e67408cd4f00a029c1e7fe2b358b", "phone_model": "Samsung_S22", "rate": 5, "target_id": "57649476"}', '2025-04-15 02:12:05', 1744654325000, '2025-04-15 02:12:05'),
('sql_screenshots', 16, '2025-04-15 02:13:05', 'id_5109a5566b324c14', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744654385000_28230174_1744654385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2c1bf795bda44a21afe08bc44ea54179.jpg", "device_id": "1b0708be-4a5b-46e0-a6b6-2dadef1a7a82", "is_chatting": 1, "label_rate": 2, "log_seq": "32402f5132674bb7b6be7343f7ed70ec", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "107039703"}', '2025-04-15 02:13:05', 1744654385000, '2025-04-15 02:13:05'),
('sql_screenshots', 16, '2025-04-15 02:14:05', 'id_a7de5f50533a4783', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "54675542_1744654445000_32970671_1744654445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/71d4a78b02bf4abdb36e2a69c8810c3e.jpg", "device_id": "cc01c5bf-ebc7-4408-a3af-011c90fcf50b", "is_chatting": 1, "label_rate": 2, "log_seq": "692caa15d5204499b923ade709bcfab0", "phone_model": "iPhone_13", "rate": 4, "target_id": "54675542"}', '2025-04-15 02:14:05', 1744654445000, '2025-04-15 02:14:05'),
('sql_screenshots', 16, '2025-04-15 02:15:05', 'id_b05c4b3bfe7347a0', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110890469_1744654505000_57649476_1744654505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ca78b8ed02f04ffc9275567080485e66.jpg", "device_id": "eece3b7b-3506-4981-ac3e-09aae57de9ae", "is_chatting": 1, "label_rate": 0, "log_seq": "9cf60fed2839453ba5e98057333373d5", "phone_model": "Huawei_P40", "rate": 5, "target_id": "110890469"}', '2025-04-15 02:15:05', 1744654505000, '2025-04-15 02:15:05'),
('sql_screenshots', 16, '2025-04-15 02:16:05', 'id_92f6d75aaae843fa', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "104844318_1744654565000_82365582_1744654565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b4dabacc23a44d14a4501ab70ad56a6c.jpg", "device_id": "79385b5b-a8bd-4d48-b1cc-237d4af38ecc", "is_chatting": 1, "label_rate": 0, "log_seq": "481a27a7170f4615b1ae14fbcc5eaadc", "phone_model": "OnePlus_9", "rate": 5, "target_id": "104844318"}', '2025-04-15 02:16:05', 1744654565000, '2025-04-15 02:16:05'),
('sql_screenshots', 16, '2025-04-15 02:17:05', 'id_bfbec7fe249c44a5', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "82365582_1744654625000_105083641_1744654625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/92722f145cef4a5dbf7db607eb116da3.jpg", "device_id": "eb2ebc25-f1bf-4146-ac64-b32d866ec764", "is_chatting": 1, "label_rate": 0, "log_seq": "142484c5d6d84f0cad84099bc317cb7d", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "82365582"}', '2025-04-15 02:17:05', 1744654625000, '2025-04-15 02:17:05'),
('sql_screenshots', 16, '2025-04-15 02:18:05', 'id_3130a3d293bc4e96', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105083641_1744654685000_109657261_1744654685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a4948c112c694be8bdf804db0337f589.jpg", "device_id": "ff2d56da-8a68-4e52-ba1e-b4fb0a670e56", "is_chatting": 1, "label_rate": 1, "log_seq": "ab68e0c7b34d4eeb826fea7dc42e3408", "phone_model": "Samsung_S21", "rate": 0, "target_id": "105083641"}', '2025-04-15 02:18:05', 1744654685000, '2025-04-15 02:18:05'),
('sql_screenshots', 16, '2025-04-15 02:19:05', 'id_1fea2516bd514e46', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "104844318_1744654745000_110890469_1744654745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/09fde2f1c7294ff2b9695aebfec45f48.jpg", "device_id": "463380d3-0bba-49c5-9808-7d63a8c0b3db", "is_chatting": 1, "label_rate": 1, "log_seq": "420f4cddfd074308982f50d34d81856c", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "104844318"}', '2025-04-15 02:19:05', 1744654745000, '2025-04-15 02:19:05'),
('sql_screenshots', 16, '2025-04-15 02:20:05', 'id_5139162532324743', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "83341608_1744654805000_110766160_1744654805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c0b6417a34e34513950e82af50705ea7.jpg", "device_id": "e2d93e9c-72cc-4923-97e0-9ed3205366d1", "is_chatting": 1, "label_rate": 2, "log_seq": "6ed35fa7fd2e464eb0078cb6fd8e10b5", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "83341608"}', '2025-04-15 02:20:05', 1744654805000, '2025-04-15 02:20:05'),
('sql_screenshots', 16, '2025-04-15 02:21:05', 'id_e7ba8f90b9514b1c', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110766160_1744654865000_105083641_1744654865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c9fa19e7ddfa48c99cd4a1547cc0815b.jpg", "device_id": "76835f9c-3af6-4b15-93f3-ab7028fae085", "is_chatting": 1, "label_rate": 2, "log_seq": "383d7867827f46ff94f435eda7bb8be6", "phone_model": "VIVO_X60", "rate": 0, "target_id": "110766160"}', '2025-04-15 02:21:05', 1744654865000, '2025-04-15 02:21:05'),
('sql_screenshots', 16, '2025-04-15 02:22:05', 'id_99ac232165184bbb', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "57649476_1744654925000_82365582_1744654925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/44e20ffb37ed4be3b057d85c6b559263.jpg", "device_id": "fe10de0b-aa73-4e6f-8527-261deb7a42fd", "is_chatting": 1, "label_rate": 2, "log_seq": "c3074af950df4409bee9db2884b756a5", "phone_model": "OnePlus_9", "rate": 4, "target_id": "57649476"}', '2025-04-15 02:22:05', 1744654925000, '2025-04-15 02:22:05'),
('sql_screenshots', 16, '2025-04-15 02:23:05', 'id_5ce0fe5f6e5f4fd7', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109744448_1744654985000_104844318_1744654985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ebf8c875f5464be8831c993d2c471d0d.jpg", "device_id": "97b6771a-85e7-4f4e-b1cb-4bf49e536b47", "is_chatting": 1, "label_rate": 1, "log_seq": "f1ab38e4aea8427aa461d80518c0c8bb", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "109744448"}', '2025-04-15 02:23:05', 1744654985000, '2025-04-15 02:23:05'),
('sql_screenshots', 16, '2025-04-15 02:24:05', 'id_7dd3d06acbe84430', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "32970671_1744655045000_28230174_1744655045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ff13db42246541ffa17225cbd21f4e9a.jpg", "device_id": "884c767e-65c9-48b0-a8f7-e424ebab135d", "is_chatting": 1, "label_rate": 0, "log_seq": "1a5e950983ec4319afa11c467ca7fddb", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "32970671"}', '2025-04-15 02:24:05', 1744655045000, '2025-04-15 02:24:05'),
('sql_screenshots', 16, '2025-04-15 02:25:05', 'id_c68e20371eac446b', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744655105000_110876251_1744655105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4556973aa78940f08e8eef550f14f7c8.jpg", "device_id": "416fd9f7-376c-435e-b09e-d0ee2561fa45", "is_chatting": 1, "label_rate": 1, "log_seq": "72dac1568ab44239861fc1c1020a5250", "phone_model": "OnePlus_9", "rate": 1, "target_id": "82365582"}', '2025-04-15 02:25:05', 1744655105000, '2025-04-15 02:25:05'),
('sql_screenshots', 16, '2025-04-15 02:26:05', 'id_bf6ceb115e5e4fe9', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "82365582_1744655165000_107039703_1744655165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1bc7898405e146bc9c5d56fbd9ba7f17.jpg", "device_id": "befb63db-9d46-474d-af03-9ca3cbebd67d", "is_chatting": 1, "label_rate": 2, "log_seq": "8c3b3c7ad61d41549b6b498b4be04c50", "phone_model": "Samsung_S22", "rate": 1, "target_id": "82365582"}', '2025-04-15 02:26:05', 1744655165000, '2025-04-15 02:26:05'),
('sql_screenshots', 16, '2025-04-15 02:27:05', 'id_5114b232e36d4259', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744655225000_109980113_1744655225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c9382179aab0417098da815496113b37.jpg", "device_id": "1dfdeccf-d8a5-4ccb-9c95-e59b2e0c9558", "is_chatting": 1, "label_rate": 1, "log_seq": "6e762cb8770f4f618d9da9be0f222061", "phone_model": "Samsung_S21", "rate": 0, "target_id": "32970671"}', '2025-04-15 02:27:05', 1744655225000, '2025-04-15 02:27:05'),
('sql_screenshots', 16, '2025-04-15 02:28:05', 'id_1bd716a300e84b06', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110766160_1744655285000_110876251_1744655285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9c3fa8a70ced451d8871ca69438091f3.jpg", "device_id": "cba8bfbb-c8c4-4eb1-a490-22508820c4d0", "is_chatting": 1, "label_rate": 0, "log_seq": "94e594e5ed4b4435a072c8faf5911806", "phone_model": "OPPO_CPH1937", "rate": 0, "target_id": "110766160"}', '2025-04-15 02:28:05', 1744655285000, '2025-04-15 02:28:05'),
('sql_screenshots', 16, '2025-04-15 02:29:05', 'id_92ad0e0e31584012', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110890469_1744655345000_64280379_1744655345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/02c9c27bc3ca4346bbbe366af8eb5ac2.jpg", "device_id": "da1a0e94-9538-4ea5-b499-19bc824d000f", "is_chatting": 1, "label_rate": 2, "log_seq": "9e1184dbc2204e2d90cea19ca9e3a304", "phone_model": "VIVO_X60", "rate": 2, "target_id": "110890469"}', '2025-04-15 02:29:05', 1744655345000, '2025-04-15 02:29:05'),
('sql_screenshots', 16, '2025-04-15 02:30:05', 'id_c8de8d4ae3104659', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744655405000_57649476_1744655405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9022558407bf4ceca1ba33890f9a66df.jpg", "device_id": "2042fa44-7f84-415c-9e93-e24c70355b22", "is_chatting": 1, "label_rate": 2, "log_seq": "808615234a6d436ea212ef78b6a2fb59", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "108466147"}', '2025-04-15 02:30:05', 1744655405000, '2025-04-15 02:30:05'),
('sql_screenshots', 16, '2025-04-15 02:31:05', 'id_20a1c9212b114e47', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110215081_1744655465000_110766160_1744655465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d1fa272183c245ec816abb15311efdf5.jpg", "device_id": "3c9997b2-8bb3-4fdc-942e-b8ec2b104eec", "is_chatting": 1, "label_rate": 0, "log_seq": "b0c1bf356759460781016d65fe50730a", "phone_model": "Samsung_S21", "rate": 0, "target_id": "110215081"}', '2025-04-15 02:31:05', 1744655465000, '2025-04-15 02:31:05'),
('sql_screenshots', 16, '2025-04-15 02:32:05', 'id_dc1a644bf0d44d6e', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "94369556_1744655525000_105083641_1744655525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6068def5270b40a39f2bc1e393137440.jpg", "device_id": "ee3d82bb-6fe1-4a63-bdff-61f2a56b8e64", "is_chatting": 1, "label_rate": 1, "log_seq": "2e0c28db18184cffaf917c3b25558e6d", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "94369556"}', '2025-04-15 02:32:05', 1744655525000, '2025-04-15 02:32:05'),
('sql_screenshots', 16, '2025-04-15 02:33:05', 'id_0ee05cf8bffc4c31', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109980113_1744655585000_81479540_1744655585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/09ceefbdabde4af68759d501ece9c8c3.jpg", "device_id": "514b5793-8c5f-4b32-b9da-600833c51e95", "is_chatting": 1, "label_rate": 0, "log_seq": "0a96167e650743b896a14f55612d3666", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "109980113"}', '2025-04-15 02:33:05', 1744655585000, '2025-04-15 02:33:05'),
('sql_screenshots', 16, '2025-04-15 02:34:05', 'id_8cc1f2229c3b4376', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109744448_1744655645000_107039703_1744655645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/35d1d29a6d0f4a90ab4e40482d86b7e5.jpg", "device_id": "d3138f7b-dd90-4b2a-8a02-7c0123c36864", "is_chatting": 1, "label_rate": 1, "log_seq": "35402bb8b2f94e6ba1ee340694396143", "phone_model": "VIVO_X60", "rate": 3, "target_id": "109744448"}', '2025-04-15 02:34:05', 1744655645000, '2025-04-15 02:34:05'),
('sql_screenshots', 16, '2025-04-15 02:35:05', 'id_ff2f0c001db5417c', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105503656_1744655705000_107039703_1744655705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/780b99a123954c4db9de4a9daa8458c0.jpg", "device_id": "104743be-588d-465c-a1b3-91ac0c47fb14", "is_chatting": 1, "label_rate": 0, "log_seq": "3fc2b7d5ad6d4652a69e37a2c3cb5662", "phone_model": "Samsung_S21", "rate": 3, "target_id": "105503656"}', '2025-04-15 02:35:05', 1744655705000, '2025-04-15 02:35:05'),
('sql_screenshots', 16, '2025-04-15 02:36:05', 'id_5aeddd4597cc4fa6', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "83341608_1744655765000_57649476_1744655765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c9787716f974469a80604a6a8dfa5e25.jpg", "device_id": "3b9a7389-7ea0-4a23-81af-1b3c4057c23a", "is_chatting": 1, "label_rate": 0, "log_seq": "5f2674cdb1904db6b8524cb4e21d9ab6", "phone_model": "Samsung_S22", "rate": 2, "target_id": "83341608"}', '2025-04-15 02:36:05', 1744655765000, '2025-04-15 02:36:05'),
('sql_screenshots', 16, '2025-04-15 02:37:05', 'id_5b72c209d94b4e1e', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109980113_1744655825000_104844318_1744655825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9fd601b1c79c4408b53e1dd5382e6de1.jpg", "device_id": "c8f7c042-a2f1-422e-b17f-1e40c7e3ed9a", "is_chatting": 1, "label_rate": 1, "log_seq": "1e35e9286cdb4ad6bb388b57f18add34", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "109980113"}', '2025-04-15 02:37:05', 1744655825000, '2025-04-15 02:37:05'),
('sql_screenshots', 16, '2025-04-15 02:38:05', 'id_2cfd97cd32464a87', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744655885000_108870508_1744655885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9ee03938da8547ca8b9c3a544a5bd334.jpg", "device_id": "9e9c2cf5-98a4-451e-b2b7-dd469dedb5c5", "is_chatting": 1, "label_rate": 1, "log_seq": "7c377894bc254a61af27fabb9254fd14", "phone_model": "Samsung_S21", "rate": 4, "target_id": "110876251"}', '2025-04-15 02:38:05', 1744655885000, '2025-04-15 02:38:05'),
('sql_screenshots', 16, '2025-04-15 02:39:05', 'id_ada53459a72841ab', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "81479540_1744655945000_54675542_1744655945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/03154e387eaf44a0b22b5098f251b3fd.jpg", "device_id": "c171da60-dd4d-4f6f-bfb2-e00b2d5b0603", "is_chatting": 1, "label_rate": 1, "log_seq": "6879f5ce22cd452b941a87dca33e6a20", "phone_model": "iPhone_13", "rate": 3, "target_id": "81479540"}', '2025-04-15 02:39:05', 1744655945000, '2025-04-15 02:39:05'),
('sql_screenshots', 16, '2025-04-15 02:40:05', 'id_84b6fca990f646c2', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109657261_1744656005000_108466147_1744656005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/012015f62458462ba3cdc0db0fa83f81.jpg", "device_id": "909ebaa9-62b8-4628-b436-f58ec13c5cfe", "is_chatting": 1, "label_rate": 2, "log_seq": "833e9dc1519f4813bd0de371a6a0f022", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "109657261"}', '2025-04-15 02:40:05', 1744656005000, '2025-04-15 02:40:05'),
('sql_screenshots', 16, '2025-04-15 02:41:05', 'id_3b3fd019abb14985', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110873051_1744656065000_101553185_1744656065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8d04eb255aee447c8ac7d14570455fc0.jpg", "device_id": "8d78ddd8-a9fe-4e8b-a6ce-3db8531406f2", "is_chatting": 1, "label_rate": 0, "log_seq": "b1cd10e5abc04b0c9c68154dafc2d790", "phone_model": "VIVO_X60", "rate": 2, "target_id": "110873051"}', '2025-04-15 02:41:05', 1744656065000, '2025-04-15 02:41:05'),
('sql_screenshots', 16, '2025-04-15 02:42:05', 'id_cd415a0542194964', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110892617_1744656125000_87571440_1744656125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ba590834e5ce448c87b5371cd0a74f6f.jpg", "device_id": "64962240-940f-4ff6-9f7c-57e125a4f41e", "is_chatting": 1, "label_rate": 2, "log_seq": "9b3d121e44f44fe58aeaddf931a3b098", "phone_model": "Samsung_S21", "rate": 1, "target_id": "110892617"}', '2025-04-15 02:42:05', 1744656125000, '2025-04-15 02:42:05'),
('sql_screenshots', 16, '2025-04-15 02:43:05', 'id_0279eddd55fa492f', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105503656_1744656185000_81479540_1744656185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6fd37374eb184dc2b68b7da6f33c00ca.jpg", "device_id": "5cf0dbb2-a7f7-498e-a24c-8f605a52b6e0", "is_chatting": 1, "label_rate": 2, "log_seq": "d6f18ca8a7a145f697f0532d1ec462bc", "phone_model": "Samsung_S22", "rate": 4, "target_id": "105503656"}', '2025-04-15 02:43:05', 1744656185000, '2025-04-15 02:43:05'),
('sql_screenshots', 16, '2025-04-15 02:44:05', 'id_8f43435924434e72', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108870508_1744656245000_109980113_1744656245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f440fbe23389490189d2166eab482aee.jpg", "device_id": "c9656a21-a93d-4e85-b1c0-15f5b53280cc", "is_chatting": 1, "label_rate": 2, "log_seq": "5435ec523a07410b8fb66d95de477fa3", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "108870508"}', '2025-04-15 02:44:05', 1744656245000, '2025-04-15 02:44:05'),
('sql_screenshots', 16, '2025-04-15 02:45:05', 'id_1276ee65e4754ec3', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110215081_1744656305000_57649476_1744656305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9df050faf88340a595e010be971e94fb.jpg", "device_id": "8b260976-76a6-4593-af9a-0b1e33ba7fff", "is_chatting": 1, "label_rate": 1, "log_seq": "464a54b7957a4121848e23c06e6830a4", "phone_model": "VIVO_X60", "rate": 4, "target_id": "110215081"}', '2025-04-15 02:45:05', 1744656305000, '2025-04-15 02:45:05'),
('sql_screenshots', 16, '2025-04-15 02:46:05', 'id_44bc2aa7371b4250', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744656365000_105083641_1744656365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/998bd3c4e4414622a6af46c25cf7025b.jpg", "device_id": "6169fc25-bbf1-4f50-b319-e34299e7dd8f", "is_chatting": 1, "label_rate": 2, "log_seq": "0dc8c9764e8f4762850f88746eabc358", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "81479540"}', '2025-04-15 02:46:05', 1744656365000, '2025-04-15 02:46:05'),
('sql_screenshots', 16, '2025-04-15 02:47:05', 'id_609aaaeb9d11438b', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110873051_1744656425000_110876251_1744656425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/83338982823c45fabe1b5d2268e9a9f7.jpg", "device_id": "310d62ef-fabc-45fa-b853-c55599469f61", "is_chatting": 1, "label_rate": 1, "log_seq": "12f0a346699a4e619b6ddb8aed0b13cd", "phone_model": "Samsung_S22", "rate": 1, "target_id": "110873051"}', '2025-04-15 02:47:05', 1744656425000, '2025-04-15 02:47:05'),
('sql_screenshots', 16, '2025-04-15 02:48:05', 'id_a35d003358c44942', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "64280379_1744656485000_110873051_1744656485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ba2bb04c4f3e4f1599db604e08b77265.jpg", "device_id": "3014498d-129f-42ce-b176-c3eac9292f53", "is_chatting": 1, "label_rate": 1, "log_seq": "4517fd79141e466bbc96e4c6dcbea025", "phone_model": "VIVO_X60", "rate": 5, "target_id": "64280379"}', '2025-04-15 02:48:05', 1744656485000, '2025-04-15 02:48:05'),
('sql_screenshots', 16, '2025-04-15 02:49:05', 'id_ff7fdb606bf54256', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109980113_1744656545000_105083641_1744656545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1924330ff3a04f0ba6f4f939a626d5fd.jpg", "device_id": "bf23cada-5471-4ab8-bbd8-cf4b7fd78a48", "is_chatting": 1, "label_rate": 2, "log_seq": "4adf1bdcbebf4199b1243c087435f7d8", "phone_model": "OnePlus_9", "rate": 5, "target_id": "109980113"}', '2025-04-15 02:49:05', 1744656545000, '2025-04-15 02:49:05'),
('sql_screenshots', 16, '2025-04-15 02:50:05', 'id_610c32f0f2c2445b', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105083641_1744656605000_108870508_1744656605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4be1e341d99640a78bb1f8c157e48b7c.jpg", "device_id": "2c4f503f-73fc-4cb3-9eb3-053714d59ead", "is_chatting": 1, "label_rate": 0, "log_seq": "09471537ab3b421c8141ba9322928bae", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "105083641"}', '2025-04-15 02:50:05', 1744656605000, '2025-04-15 02:50:05'),
('sql_screenshots', 16, '2025-04-15 02:51:05', 'id_54887bd40ea04887', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110873051_1744656665000_109980113_1744656665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bc5cef2c949c4d0cb1c16b98567b2878.jpg", "device_id": "5cf2cf76-4baa-4a23-8f74-1d8b5a658956", "is_chatting": 1, "label_rate": 1, "log_seq": "2b00ffe24cbf4c1b8e4a6cff18b657da", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "110873051"}', '2025-04-15 02:51:05', 1744656665000, '2025-04-15 02:51:05'),
('sql_screenshots', 16, '2025-04-15 02:52:05', 'id_dc94b126e70e4c90', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109744448_1744656725000_108870508_1744656725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4ff6a95a2a7544c1b49bf7cd76dedaa1.jpg", "device_id": "5af448c1-c3ef-419d-a6b0-0fc4290ce475", "is_chatting": 1, "label_rate": 1, "log_seq": "cda41addce8048b08edbe337669b9725", "phone_model": "Samsung_S22", "rate": 0, "target_id": "109744448"}', '2025-04-15 02:52:05', 1744656725000, '2025-04-15 02:52:05'),
('sql_screenshots', 16, '2025-04-15 02:53:05', 'id_f7f4a8c875ea4391', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110876251_1744656785000_57649476_1744656785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c18b4cb9cecb4c488a66140d2a93baa8.jpg", "device_id": "526e5de3-1057-4dc3-b5ca-44d3b942b020", "is_chatting": 1, "label_rate": 0, "log_seq": "75435abd5e73420aaf8cce14be177903", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "110876251"}', '2025-04-15 02:53:05', 1744656785000, '2025-04-15 02:53:05'),
('sql_screenshots', 16, '2025-04-15 02:54:05', 'id_2a0d4a62afde4557', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "64280379_1744656845000_109657261_1744656845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ef037329f4a64591a4afe10157fd8f19.jpg", "device_id": "12860897-1f34-4916-a210-1b8e728f04e8", "is_chatting": 1, "label_rate": 1, "log_seq": "2749d43f88aa43739250821950a8a67a", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "64280379"}', '2025-04-15 02:54:05', 1744656845000, '2025-04-15 02:54:05'),
('sql_screenshots', 16, '2025-04-15 02:55:05', 'id_61500326b4154c37', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "83341608_1744656905000_82365582_1744656905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/58738a0ec6df4bb1971aaa3e0ded3915.jpg", "device_id": "8c2c35bd-6532-4e7a-b463-114dd63a0190", "is_chatting": 1, "label_rate": 0, "log_seq": "1468ee39c2644ef7aefe2d2d757b8e1f", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "83341608"}', '2025-04-15 02:55:05', 1744656905000, '2025-04-15 02:55:05'),
('sql_screenshots', 16, '2025-04-15 02:56:05', 'id_187008e469b448b7', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "54675542_1744656965000_32970671_1744656965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c72c2283508b406eb3a9d93d5cb02ffb.jpg", "device_id": "22c388bd-4e19-4dfa-9193-be65ab6337d8", "is_chatting": 1, "label_rate": 1, "log_seq": "d8ac27008c4b48b0a570cb76e0a8182c", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "54675542"}', '2025-04-15 02:56:05', 1744656965000, '2025-04-15 02:56:05'),
('sql_screenshots', 16, '2025-04-15 02:57:05', 'id_257bdd0af6934e27', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108466147_1744657025000_94369556_1744657025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/21ccd799a565492bbe3ec7b08b0bddab.jpg", "device_id": "e2cc6ff3-4c9d-4532-8d0e-cb683e83f744", "is_chatting": 1, "label_rate": 0, "log_seq": "5c9ddc5af6cc4e72a6515c2fcbdbb238", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "108466147"}', '2025-04-15 02:57:05', 1744657025000, '2025-04-15 02:57:05'),
('sql_screenshots', 16, '2025-04-15 02:58:05', 'id_4c98910fe2ce4f6a', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "64280379_1744657085000_87571440_1744657085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/47508d07c97147dda92a64dbae62b313.jpg", "device_id": "c9954588-b7c3-45f3-a6d8-c0c6ade7f82e", "is_chatting": 1, "label_rate": 0, "log_seq": "7f648ff56fc542ad91390ea3cf107513", "phone_model": "Huawei_P40", "rate": 5, "target_id": "64280379"}', '2025-04-15 02:58:05', 1744657085000, '2025-04-15 02:58:05'),
('sql_screenshots', 16, '2025-04-15 02:59:05', 'id_6fb4c6da03204861', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "82365582_1744657145000_105083641_1744657145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/088001cd5513405fb8ad8d54ff03a40d.jpg", "device_id": "47f5a3a2-30db-43db-8246-c8e3a017bf8d", "is_chatting": 1, "label_rate": 2, "log_seq": "700cd89f3a894d1eb7b1cf8e46d647e8", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "82365582"}', '2025-04-15 02:59:05', 1744657145000, '2025-04-15 02:59:05'),
('sql_screenshots', 16, '2025-04-15 03:00:05', 'id_4908b02873cc442b', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108870508_1744657205000_109744448_1744657205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f506e5c86c8d45b49b29377d41cc9cbd.jpg", "device_id": "21349ce4-6f0f-4f6b-b538-dfc9735e4d89", "is_chatting": 1, "label_rate": 1, "log_seq": "15efcacf1b494add95e8557e79c1f3c8", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "108870508"}', '2025-04-15 03:00:05', 1744657205000, '2025-04-15 03:00:05'),
('sql_screenshots', 16, '2025-04-15 03:01:05', 'id_f05665a0a4fe4f47', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110876251_1744657265000_54675542_1744657265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b7cd8258e5d244acb0e66018d26ed7ba.jpg", "device_id": "c0aaedab-81fa-416e-9455-59453424c462", "is_chatting": 1, "label_rate": 2, "log_seq": "6ea748f7a2df424dbbfd485383a8d481", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "110876251"}', '2025-04-15 03:01:05', 1744657265000, '2025-04-15 03:01:05'),
('sql_screenshots', 16, '2025-04-15 03:02:05', 'id_2df99a5b84e549a4', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744657325000_105503656_1744657325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/406af52220d04b15887a41bc9b6b591b.jpg", "device_id": "e1982f21-9cfd-43b2-ac31-ae3e0ba923fb", "is_chatting": 1, "label_rate": 0, "log_seq": "fdd49f51b5b644baa6009a65a659366d", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "110876251"}', '2025-04-15 03:02:05', 1744657325000, '2025-04-15 03:02:05'),
('sql_screenshots', 16, '2025-04-15 03:03:05', 'id_ece68d70d818481c', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744657385000_107039703_1744657385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7dc721465edc4a98ac0e6a432eef3286.jpg", "device_id": "3d84c93d-ae4f-4912-9ecf-cc7a09da88a0", "is_chatting": 1, "label_rate": 2, "log_seq": "b0f4f3e3c38848c6bbfdc134a407882e", "phone_model": "VIVO_X60", "rate": 0, "target_id": "87571440"}', '2025-04-15 03:03:05', 1744657385000, '2025-04-15 03:03:05'),
('sql_screenshots', 16, '2025-04-15 03:04:05', 'id_375ba66aff2a4f18', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744657445000_108466147_1744657445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/06a96ee1dfe14d3b9c4de21ff75457c6.jpg", "device_id": "1481a38a-7beb-4144-ad35-cd5997a86ec2", "is_chatting": 1, "label_rate": 2, "log_seq": "d354ff73e2784d3b818785e62ecf82e5", "phone_model": "Samsung_S21", "rate": 5, "target_id": "109657261"}', '2025-04-15 03:04:05', 1744657445000, '2025-04-15 03:04:05'),
('sql_screenshots', 16, '2025-04-15 03:05:05', 'id_2590c52163fe4b06', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744657505000_28230174_1744657505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bf74ff38ff3f4aed8f588200ba577a16.jpg", "device_id": "a3a73458-77da-4de2-b71e-3ecd9ad8863a", "is_chatting": 1, "label_rate": 2, "log_seq": "2d24e1faf4f243129cc86d5351db3acb", "phone_model": "Samsung_S22", "rate": 1, "target_id": "64280379"}', '2025-04-15 03:05:05', 1744657505000, '2025-04-15 03:05:05'),
('sql_screenshots', 16, '2025-04-15 03:06:05', 'id_2708a274164a4c78', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108870508_1744657565000_109657261_1744657565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5410a44a3369439fa2c3be3e3fb06aad.jpg", "device_id": "24cb8400-485d-4f46-aaf7-cb3840e40ffb", "is_chatting": 1, "label_rate": 0, "log_seq": "2c0fe27bd34c4063b09f25f9ed36ca7f", "phone_model": "Samsung_S22", "rate": 1, "target_id": "108870508"}', '2025-04-15 03:06:05', 1744657565000, '2025-04-15 03:06:05'),
('sql_screenshots', 16, '2025-04-15 03:07:05', 'id_05c6001e31ac41d4', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110892617_1744657625000_105083641_1744657625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/373dd034a22442098478faba86051e63.jpg", "device_id": "fe2f81a8-82d2-42c8-9328-d39b4f9cc451", "is_chatting": 1, "label_rate": 0, "log_seq": "82e5a0fadd5144fe82e06f8e435b1bad", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "110892617"}', '2025-04-15 03:07:05', 1744657625000, '2025-04-15 03:07:05'),
('sql_screenshots', 16, '2025-04-15 03:08:05', 'id_440a7c77320d4c32', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744657685000_105083641_1744657685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e2e691c4351d4e1aae207ac9d491ff70.jpg", "device_id": "f179dba8-31c2-425e-91b0-483aa66f4860", "is_chatting": 1, "label_rate": 0, "log_seq": "d82e17d93b5a42dab3367cd641c3bfba", "phone_model": "OnePlus_9", "rate": 1, "target_id": "110876251"}', '2025-04-15 03:08:05', 1744657685000, '2025-04-15 03:08:05'),
('sql_screenshots', 16, '2025-04-15 03:09:05', 'id_65721dee72844f4c', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108466147_1744657745000_64280379_1744657745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/af59669a43bf4478bd0e79e33e2435f1.jpg", "device_id": "327902a4-f610-4171-9390-9aebb39092c6", "is_chatting": 1, "label_rate": 2, "log_seq": "f294372657d94c2aa290283e3fca8cfc", "phone_model": "Samsung_S22", "rate": 2, "target_id": "108466147"}', '2025-04-15 03:09:05', 1744657745000, '2025-04-15 03:09:05'),
('sql_screenshots', 16, '2025-04-15 03:10:05', 'id_73598b07e7d44ac3', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "28230174_1744657805000_87571440_1744657805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8c44e35b68204a9ba3f4eec5e7d98090.jpg", "device_id": "a3db591a-ceb7-4595-93f1-bfa099d7c2f5", "is_chatting": 1, "label_rate": 0, "log_seq": "3bc74a94a7b949ce996857953ff80f47", "phone_model": "OnePlus_9", "rate": 5, "target_id": "28230174"}', '2025-04-15 03:10:05', 1744657805000, '2025-04-15 03:10:05'),
('sql_screenshots', 16, '2025-04-15 03:11:05', 'id_39dd0969d8b241ad', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109744448_1744657865000_109407413_1744657865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7610073837a34c8d8c109d3a22cb2418.jpg", "device_id": "30342923-4dbc-40ab-9e01-96607d14044e", "is_chatting": 1, "label_rate": 0, "log_seq": "d9d8d3c913d14079928f920dc1f0f0d6", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "109744448"}', '2025-04-15 03:11:05', 1744657865000, '2025-04-15 03:11:05'),
('sql_screenshots', 16, '2025-04-15 03:12:05', 'id_1def18db85cc4436', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "94369556_1744657925000_109657261_1744657925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b7fa6e050a21414bb96f7fdd552614f8.jpg", "device_id": "b762b271-4ab6-49c5-a909-4c03950bcad7", "is_chatting": 1, "label_rate": 0, "log_seq": "d5520bb02dcb49ab89d8e91f1d1afcad", "phone_model": "VIVO_X60", "rate": 5, "target_id": "94369556"}', '2025-04-15 03:12:05', 1744657925000, '2025-04-15 03:12:05'),
('sql_screenshots', 16, '2025-04-15 03:13:05', 'id_d188de5054354ddd', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "64280379_1744657985000_108870508_1744657985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/29fe322c624d4402a3a6eeb18067b3eb.jpg", "device_id": "95e99d89-8b6f-400c-b794-18cf07c42ecc", "is_chatting": 1, "label_rate": 1, "log_seq": "9b3ee7f476304fbe9eb515aec623d33e", "phone_model": "iPhone_13", "rate": 5, "target_id": "64280379"}', '2025-04-15 03:13:05', 1744657985000, '2025-04-15 03:13:05'),
('sql_screenshots', 16, '2025-04-15 03:14:05', 'id_c5daa4506a4e40fc', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744658045000_94369556_1744658045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f42fda68e9b9472685108be959d2502a.jpg", "device_id": "f0ba075f-8e6b-4f86-828b-a57a73a01357", "is_chatting": 1, "label_rate": 1, "log_seq": "e9182f438b0e4f54b99eb43a108bbb77", "phone_model": "Samsung_S21", "rate": 5, "target_id": "110876251"}', '2025-04-15 03:14:05', 1744658045000, '2025-04-15 03:14:05'),
('sql_screenshots', 16, '2025-04-15 03:15:05', 'id_2a8934d2821e4b7a', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "32970671_1744658105000_82365582_1744658105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f89a8d072dfb456592c4720ff53cfb00.jpg", "device_id": "47be39e9-abd7-4b09-b254-90d78a60130e", "is_chatting": 1, "label_rate": 0, "log_seq": "380940d6a8504234ade1aa8c021d2508", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "32970671"}', '2025-04-15 03:15:05', 1744658105000, '2025-04-15 03:15:05'),
('sql_screenshots', 16, '2025-04-15 03:16:05', 'id_a6937d43a3184414', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109407413_1744658165000_110892617_1744658165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d2b852a63b4141eda211f8cd9b381bb9.jpg", "device_id": "36080fc2-29f6-42b0-8be2-5cc81f2d4eab", "is_chatting": 1, "label_rate": 1, "log_seq": "7861bd05147b40f58b9d59742d5e52ca", "phone_model": "Samsung_S21", "rate": 1, "target_id": "109407413"}', '2025-04-15 03:16:05', 1744658165000, '2025-04-15 03:16:05'),
('sql_screenshots', 16, '2025-04-15 03:17:05', 'id_77af02328b38495b', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "101553185_1744658225000_94369556_1744658225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2022d1ecf00d422abe3a92ac1bbbee25.jpg", "device_id": "212055f3-5aa0-4fc7-8e47-18c04226319c", "is_chatting": 1, "label_rate": 1, "log_seq": "d0170062db67497f831e2622996e6f9e", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "101553185"}', '2025-04-15 03:17:05', 1744658225000, '2025-04-15 03:17:05'),
('sql_screenshots', 16, '2025-04-15 03:18:05', 'id_cf7d98f6d76743ea', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110766160_1744658285000_104844318_1744658285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2b7efb935f274373aac389dffeb0f9b3.jpg", "device_id": "cb4eebb7-894d-49d8-8cf2-4b8802358c1a", "is_chatting": 1, "label_rate": 2, "log_seq": "7ed89034250c4ac79e4669e6c0d26839", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "110766160"}', '2025-04-15 03:18:05', 1744658285000, '2025-04-15 03:18:05'),
('sql_screenshots', 16, '2025-04-15 03:19:05', 'id_ff9bbb863ef94d1b', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110876251_1744658345000_110215081_1744658345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c493f476331a4633a7eb4f5ac6fe4219.jpg", "device_id": "e9b9f081-7e30-432b-89be-47a82c9a93e1", "is_chatting": 1, "label_rate": 2, "log_seq": "11ba4c1b92044c62b65476e243f3db44", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "110876251"}', '2025-04-15 03:19:05', 1744658345000, '2025-04-15 03:19:05'),
('sql_screenshots', 16, '2025-04-15 03:20:05', 'id_2906b7ab76d34a2b', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110890469_1744658405000_101553185_1744658405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0485820864df49eead7c405f7173e878.jpg", "device_id": "d6fa6de0-d145-4501-a613-5e9303769f26", "is_chatting": 1, "label_rate": 0, "log_seq": "c8fd711075684363b9b02ab3031f0d3f", "phone_model": "iPhone_13", "rate": 1, "target_id": "110890469"}', '2025-04-15 03:20:05', 1744658405000, '2025-04-15 03:20:05'),
('sql_screenshots', 16, '2025-04-15 03:21:05', 'id_9a7268da5bca43bd', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "104844318_1744658465000_109744448_1744658465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bd49554897b04f9db42ea01d2b712dc6.jpg", "device_id": "388380b2-20a8-4406-9256-f016bd136ea7", "is_chatting": 1, "label_rate": 1, "log_seq": "2e2796dc23dd487998bb8d6619ecb25e", "phone_model": "OnePlus_9", "rate": 0, "target_id": "104844318"}', '2025-04-15 03:21:05', 1744658465000, '2025-04-15 03:21:05'),
('sql_screenshots', 16, '2025-04-15 03:22:05', 'id_c89023f5dd1f4a0f', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110890469_1744658525000_110215081_1744658525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8e3f1690370d43819f60de5655c2c9ce.jpg", "device_id": "c6c69f35-e439-4216-8c7c-6be9ba8b33df", "is_chatting": 1, "label_rate": 0, "log_seq": "b3305f91bd7b4546b5ca6d27ef1ef751", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "110890469"}', '2025-04-15 03:22:05', 1744658525000, '2025-04-15 03:22:05'),
('sql_screenshots', 16, '2025-04-15 03:23:05', 'id_d4d24f2d9bf747e8', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "101553185_1744658585000_108870508_1744658585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d90c85a647134d49b88cc37329fc04df.jpg", "device_id": "a4c092b3-2cbd-461e-9929-ba579aa780fd", "is_chatting": 1, "label_rate": 1, "log_seq": "ad2650b402404d41b6b6f85d6740b7c3", "phone_model": "Samsung_S21", "rate": 3, "target_id": "101553185"}', '2025-04-15 03:23:05', 1744658585000, '2025-04-15 03:23:05'),
('sql_screenshots', 16, '2025-04-15 03:24:05', 'id_14c36ef6acca4455', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110215081_1744658645000_104844318_1744658645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d7fc88cd61e442c4bb5c091a0a9d0da1.jpg", "device_id": "f2d78734-d6c3-42f8-afb4-ecda33db8653", "is_chatting": 1, "label_rate": 2, "log_seq": "50c856dd4ba145b9b7e5225a1856e3bf", "phone_model": "Huawei_P40", "rate": 5, "target_id": "110215081"}', '2025-04-15 03:24:05', 1744658645000, '2025-04-15 03:24:05'),
('sql_screenshots', 16, '2025-04-15 03:25:05', 'id_29acd4ffbc3a47fb', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108870508_1744658705000_105083641_1744658705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/33c3b5c2a6364a2d9b24e7b2f8625bbb.jpg", "device_id": "d121789d-1a8b-4355-ab8a-0f575ebfd0c1", "is_chatting": 1, "label_rate": 0, "log_seq": "667e8711367d419f9fdcf445e2712b4f", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "108870508"}', '2025-04-15 03:25:05', 1744658705000, '2025-04-15 03:25:05'),
('sql_screenshots', 16, '2025-04-15 03:26:05', 'id_87cd0b4fac2c4d0c', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108870508_1744658765000_87571440_1744658765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b497372ed80e4805bf2d8ca304e3d96a.jpg", "device_id": "0a3b6d44-5dde-4597-848a-3ea12c445e31", "is_chatting": 1, "label_rate": 1, "log_seq": "e6647dbecd974e9e9d101c28eef75789", "phone_model": "iPhone_13", "rate": 1, "target_id": "108870508"}', '2025-04-15 03:26:05', 1744658765000, '2025-04-15 03:26:05'),
('sql_screenshots', 16, '2025-04-15 03:27:05', 'id_6539354a1a1c4d5d', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110215081_1744658825000_109657261_1744658825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a0debe997a9f4b03af8d8d7531a0e609.jpg", "device_id": "ac63a5c0-4d41-43fc-ae78-3807b5581b5b", "is_chatting": 1, "label_rate": 1, "log_seq": "f898c3c3896c41dbb2cd96989d136f5d", "phone_model": "Samsung_S22", "rate": 5, "target_id": "110215081"}', '2025-04-15 03:27:05', 1744658825000, '2025-04-15 03:27:05'),
('sql_screenshots', 16, '2025-04-15 03:28:05', 'id_37a18a17e7724c73', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109657261_1744658885000_110876251_1744658885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5c08a6afd41f4d98b150b991c780f464.jpg", "device_id": "12928e79-6150-45f2-92b5-20b4e651f3b1", "is_chatting": 1, "label_rate": 2, "log_seq": "8eb56f335fe14a99bbe18d74a37aec86", "phone_model": "Samsung_S22", "rate": 2, "target_id": "109657261"}', '2025-04-15 03:28:05', 1744658885000, '2025-04-15 03:28:05'),
('sql_screenshots', 16, '2025-04-15 03:29:05', 'id_8c2830131b1c4239', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744658945000_110890469_1744658945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/78e7891757e145e1b208c8b407e51a14.jpg", "device_id": "4d5ce702-192b-4e76-9b87-b5614342b688", "is_chatting": 1, "label_rate": 2, "log_seq": "db993b1b17634d2eba493dac04be3cc9", "phone_model": "Huawei_P40", "rate": 4, "target_id": "82365582"}', '2025-04-15 03:29:05', 1744658945000, '2025-04-15 03:29:05'),
('sql_screenshots', 16, '2025-04-15 03:30:05', 'id_790ba5fdea3e43ad', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105503656_1744659005000_87571440_1744659005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2169c1ee93374a538cefde177b6cf3e9.jpg", "device_id": "916b7cd1-d6c4-4c87-8a92-0940e078399e", "is_chatting": 1, "label_rate": 1, "log_seq": "90a5389e5bee4d46896309f54e9cac9d", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "105503656"}', '2025-04-15 03:30:05', 1744659005000, '2025-04-15 03:30:05'),
('sql_screenshots', 16, '2025-04-15 03:31:05', 'id_da96b671e2fc42dd', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "87571440_1744659065000_32970671_1744659065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0d2a8599bf3246e48cbeb3d258703bb6.jpg", "device_id": "7d12f1a8-98c9-4580-b25b-b7fc01e696ae", "is_chatting": 1, "label_rate": 2, "log_seq": "30bff8430db74725b2e4a172aa0c29e4", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "87571440"}', '2025-04-15 03:31:05', 1744659065000, '2025-04-15 03:31:05'),
('sql_screenshots', 16, '2025-04-15 03:32:05', 'id_18b42a09b4cf4090', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "94369556_1744659125000_108870508_1744659125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/eb7661fee3df494289c8e32eb459e2f4.jpg", "device_id": "2c80235f-2598-4328-939a-55d6077382fc", "is_chatting": 1, "label_rate": 1, "log_seq": "51726761d0ba46158a88f1f80ecbe734", "phone_model": "Samsung_S22", "rate": 2, "target_id": "94369556"}', '2025-04-15 03:32:05', 1744659125000, '2025-04-15 03:32:05'),
('sql_screenshots', 16, '2025-04-15 03:33:05', 'id_e688720344c24866', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "28230174_1744659185000_109407413_1744659185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/34cf44d9c3c94c90839c99f1279b032e.jpg", "device_id": "8d471471-99fd-4448-b636-8e359fcdc412", "is_chatting": 1, "label_rate": 1, "log_seq": "fbda6332965042179907c1b8697a903a", "phone_model": "OnePlus_9", "rate": 2, "target_id": "28230174"}', '2025-04-15 03:33:05', 1744659185000, '2025-04-15 03:33:05'),
('sql_screenshots', 16, '2025-04-15 03:34:05', 'id_85e04c4a2327447d', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "64280379_1744659245000_94369556_1744659245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e17cd5593aea495297f3018a9eaf4978.jpg", "device_id": "6daea5d4-a3ed-4b52-8518-b396c68f761a", "is_chatting": 1, "label_rate": 1, "log_seq": "dd53e135e51749aca83cad893815a13f", "phone_model": "Samsung_S21", "rate": 0, "target_id": "64280379"}', '2025-04-15 03:34:05', 1744659245000, '2025-04-15 03:34:05'),
('sql_screenshots', 16, '2025-04-15 03:35:05', 'id_ce53de758be244fc', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109744448_1744659305000_64280379_1744659305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/496fdcee523f49e8a95d9e2a22091448.jpg", "device_id": "0be537b4-4bc0-4687-8271-32b9dba238aa", "is_chatting": 1, "label_rate": 1, "log_seq": "28dada5d01454229b833066f34ddbd8a", "phone_model": "OnePlus_9", "rate": 0, "target_id": "109744448"}', '2025-04-15 03:35:05', 1744659305000, '2025-04-15 03:35:05'),
('sql_screenshots', 16, '2025-04-15 03:36:05', 'id_06ef10e8fdb1429a', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105503656_1744659365000_110890469_1744659365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/535b9b6539ff4b718d60957482249559.jpg", "device_id": "fb553cda-11f4-4278-9af9-472869c6dfa1", "is_chatting": 1, "label_rate": 1, "log_seq": "746ab4e5ab8f4d9b8c3343c120d17e21", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "105503656"}', '2025-04-15 03:36:05', 1744659365000, '2025-04-15 03:36:05'),
('sql_screenshots', 16, '2025-04-15 03:37:05', 'id_0d7932d83d2248e9', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "32970671_1744659425000_105083641_1744659425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4281b01b2fa845728bc6297691a7ed6b.jpg", "device_id": "6a0d235d-c02e-436d-8eb5-4a8a0a4b37bb", "is_chatting": 1, "label_rate": 2, "log_seq": "69d19f7e9df64d89a493cb623f50697d", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "32970671"}', '2025-04-15 03:37:05', 1744659425000, '2025-04-15 03:37:05'),
('sql_screenshots', 16, '2025-04-15 03:38:05', 'id_014e1d9ced5a4c42', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "104844318_1744659485000_109980113_1744659485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2fc314c26576495c8f965676aab0e214.jpg", "device_id": "91ae369a-635b-4c53-a1ca-fb4f983dd488", "is_chatting": 1, "label_rate": 0, "log_seq": "9240bf22f43d4b4aa044e458e6eff48f", "phone_model": "VIVO_X60", "rate": 0, "target_id": "104844318"}', '2025-04-15 03:38:05', 1744659485000, '2025-04-15 03:38:05'),
('sql_screenshots', 16, '2025-04-15 03:39:05', 'id_0131ae5f45e84b2c', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110873051_1744659545000_105503656_1744659545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2d10aa48a9db440da1544ba608451ad4.jpg", "device_id": "a4274e4c-49e7-4af5-bbf0-bdc7f99db221", "is_chatting": 1, "label_rate": 2, "log_seq": "47d278428f324951a5fbb43aa3d7b67b", "phone_model": "iPhone_13", "rate": 1, "target_id": "110873051"}', '2025-04-15 03:39:05', 1744659545000, '2025-04-15 03:39:05'),
('sql_screenshots', 16, '2025-04-15 03:40:05', 'id_85790ae4b33b43af', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "94369556_1744659605000_28230174_1744659605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/53eab578aaec42ad816b7145d6292d1c.jpg", "device_id": "3a01da21-2025-482a-bfdb-f545951f9905", "is_chatting": 1, "label_rate": 1, "log_seq": "853391802f71412f9eb7dd93245425f0", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "94369556"}', '2025-04-15 03:40:05', 1744659605000, '2025-04-15 03:40:05'),
('sql_screenshots', 16, '2025-04-15 03:41:05', 'id_2b3c39708bc44563', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "87571440_1744659665000_108870508_1744659665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/82fd0cd88cc34293ac812a24696f4e89.jpg", "device_id": "5cc28341-f035-4d31-87f2-dd60eb306d40", "is_chatting": 1, "label_rate": 2, "log_seq": "4998bbd1d7c9473981af53c36e768c0c", "phone_model": "Samsung_S22", "rate": 4, "target_id": "87571440"}', '2025-04-15 03:41:05', 1744659665000, '2025-04-15 03:41:05'),
('sql_screenshots', 16, '2025-04-15 03:42:05', 'id_54c0b3cd630744f8', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744659725000_28230174_1744659725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/854b0b7127704d6891911a5ae7253750.jpg", "device_id": "10100933-a99e-45d8-8cd9-c34c2ca229f4", "is_chatting": 1, "label_rate": 1, "log_seq": "3423bed602274826be470c57af7eb300", "phone_model": "iPhone_13", "rate": 2, "target_id": "82365582"}', '2025-04-15 03:42:05', 1744659725000, '2025-04-15 03:42:05'),
('sql_screenshots', 16, '2025-04-15 03:43:05', 'id_e7e7952c2c84484b', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744659785000_110766160_1744659785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/12fa34bf8dcf4596a73276bad0a0a903.jpg", "device_id": "dd745bf6-d194-4b4c-b484-dfc415b64e0d", "is_chatting": 1, "label_rate": 0, "log_seq": "a1b049543b1c4fc18cb18f5a58ad0256", "phone_model": "VIVO_X60", "rate": 0, "target_id": "108466147"}', '2025-04-15 03:43:05', 1744659785000, '2025-04-15 03:43:05'),
('sql_screenshots', 16, '2025-04-15 03:44:05', 'id_ff0f7d58d4eb4d6b', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110873051_1744659845000_110215081_1744659845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/efef23bf8564403f97aba2c0a2184e59.jpg", "device_id": "025777dd-5030-47c5-b8ac-a6951483047e", "is_chatting": 1, "label_rate": 1, "log_seq": "ba7e7bceb141443f96cf2a5952e10d8b", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "110873051"}', '2025-04-15 03:44:05', 1744659845000, '2025-04-15 03:44:05'),
('sql_screenshots', 16, '2025-04-15 03:45:05', 'id_a30315c2a4f142de', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108466147_1744659905000_28230174_1744659905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/68ca3605369c4f529423a03c388020e3.jpg", "device_id": "80a65d90-1fd2-4fb6-89cf-9f7feb216523", "is_chatting": 1, "label_rate": 1, "log_seq": "7993f17f4fa44d47913457ccfa81ec74", "phone_model": "OnePlus_9", "rate": 2, "target_id": "108466147"}', '2025-04-15 03:45:05', 1744659905000, '2025-04-15 03:45:05'),
('sql_screenshots', 16, '2025-04-15 03:46:05', 'id_669769873a0d4a4e', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110892617_1744659965000_32970671_1744659965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f28d30d7b47246099b06657b9ef6988b.jpg", "device_id": "8adf1abe-007f-47b8-95ae-ddb5aa92cd46", "is_chatting": 1, "label_rate": 2, "log_seq": "49a6dce69af049138de7bb575ab02a09", "phone_model": "Samsung_S21", "rate": 3, "target_id": "110892617"}', '2025-04-15 03:46:05', 1744659965000, '2025-04-15 03:46:05'),
('sql_screenshots', 16, '2025-04-15 03:47:05', 'id_330675ef3556482b', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744660025000_110873051_1744660025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9cb1d536c6dd4abba8ae2981ff5dfb69.jpg", "device_id": "992eab62-0895-4081-ab1e-94ebb1309ac9", "is_chatting": 1, "label_rate": 0, "log_seq": "a25016fa90c14de28502c990ea7da7f1", "phone_model": "Huawei_P40", "rate": 3, "target_id": "110876251"}', '2025-04-15 03:47:05', 1744660025000, '2025-04-15 03:47:05'),
('sql_screenshots', 16, '2025-04-15 03:48:05', 'id_4688c6f004b84f3a', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744660085000_81479540_1744660085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ef3c3509de0a4a84b1fd5a29113fc99b.jpg", "device_id": "ab8d2052-1eca-4fc1-9883-cfdda31b314c", "is_chatting": 1, "label_rate": 2, "log_seq": "e45b55ac3af94c709f155fa79d43f24f", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "82365582"}', '2025-04-15 03:48:05', 1744660085000, '2025-04-15 03:48:05'),
('sql_screenshots', 16, '2025-04-15 03:49:05', 'id_412e5f2f17224610', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744660145000_110892617_1744660145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/390ebcad60c94142a22a055af9211a29.jpg", "device_id": "5f5b3a1c-5552-4bea-9a9a-74b5d794c37e", "is_chatting": 1, "label_rate": 0, "log_seq": "67be935f362a4d6791264f31708dca75", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "81479540"}', '2025-04-15 03:49:05', 1744660145000, '2025-04-15 03:49:05'),
('sql_screenshots', 16, '2025-04-15 03:50:05', 'id_a416069d70944566', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744660205000_81479540_1744660205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/997f9a9cb5ee47c5b8161b7f21cb445b.jpg", "device_id": "8a063798-9e33-4a1e-bc6a-c64b81b16a18", "is_chatting": 1, "label_rate": 2, "log_seq": "0b0e3ae02fdc471d8e2d4e66213a76b1", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "87571440"}', '2025-04-15 03:50:05', 1744660205000, '2025-04-15 03:50:05'),
('sql_screenshots', 16, '2025-04-15 03:51:05', 'id_87613e3359b14f4d', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "101553185_1744660265000_110766160_1744660265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b8c1e24a3a8147cda579e8c048508465.jpg", "device_id": "bc7e08f4-5184-4394-83d5-9661df9b5afc", "is_chatting": 1, "label_rate": 2, "log_seq": "c1e47c331b8140f68a21779d0fd61692", "phone_model": "OnePlus_9", "rate": 4, "target_id": "101553185"}', '2025-04-15 03:51:05', 1744660265000, '2025-04-15 03:51:05'),
('sql_screenshots', 16, '2025-04-15 03:52:05', 'id_ca9e3e29fefa4e83', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744660325000_105083641_1744660325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8dc01b933d8a4740957bc24d881e4d5b.jpg", "device_id": "3b71c96a-809c-4d1a-9fc1-85185f7c1726", "is_chatting": 1, "label_rate": 0, "log_seq": "0f3aa118f1574592b3e9fabcd2375988", "phone_model": "Samsung_S22", "rate": 2, "target_id": "87571440"}', '2025-04-15 03:52:05', 1744660325000, '2025-04-15 03:52:05'),
('sql_screenshots', 16, '2025-04-15 03:53:05', 'id_4d5c11964bab4960', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "57649476_1744660385000_110876251_1744660385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/93048fbac8b848c19deb9bf0dd290011.jpg", "device_id": "4a196d42-119d-4436-8ebd-a9479a9b7534", "is_chatting": 1, "label_rate": 0, "log_seq": "7e2626d372904896b6e25eda8f5349d4", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "57649476"}', '2025-04-15 03:53:05', 1744660385000, '2025-04-15 03:53:05'),
('sql_screenshots', 16, '2025-04-15 03:54:05', 'id_a63c65d6a5a34fc9', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "101553185_1744660445000_110215081_1744660445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6d642a3c1e874ae5af219a4259f89442.jpg", "device_id": "7b4f1c16-ca97-447f-9f52-31d90b385e3e", "is_chatting": 1, "label_rate": 0, "log_seq": "19426888cfc843f7b4f40d453a794532", "phone_model": "iPhone_13", "rate": 3, "target_id": "101553185"}', '2025-04-15 03:54:05', 1744660445000, '2025-04-15 03:54:05'),
('sql_screenshots', 16, '2025-04-15 03:55:05', 'id_df555d1114e04428', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "57649476_1744660505000_28230174_1744660505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1a6511026c5341f0b0abc4fa3fd65e7d.jpg", "device_id": "b1c094f7-b071-4a3f-afdc-efd4ab37153e", "is_chatting": 1, "label_rate": 0, "log_seq": "382e32e03fb34cffa52777c9d8dfc5ce", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "57649476"}', '2025-04-15 03:55:05', 1744660505000, '2025-04-15 03:55:05'),
('sql_screenshots', 16, '2025-04-15 03:56:05', 'id_44d546b70ed64078', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "83341608_1744660565000_57649476_1744660565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7768ff3a53c04fdbb0f5229a03e39af2.jpg", "device_id": "8d1dd596-dce1-4813-ba65-9482ad095b93", "is_chatting": 1, "label_rate": 2, "log_seq": "6109c965a9ad4af28784434b05feace2", "phone_model": "Huawei_P40", "rate": 2, "target_id": "83341608"}', '2025-04-15 03:56:05', 1744660565000, '2025-04-15 03:56:05'),
('sql_screenshots', 16, '2025-04-15 03:57:05', 'id_5a9b37cf20f44b13', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109407413_1744660625000_82365582_1744660625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6862921bca0b46d195c57c2aad914fdf.jpg", "device_id": "e7f407e7-b9d5-42d3-94dc-2bd7a193cddc", "is_chatting": 1, "label_rate": 1, "log_seq": "b646c79a8b33430bad9676702fd72d2c", "phone_model": "iPhone_13", "rate": 2, "target_id": "109407413"}', '2025-04-15 03:57:05', 1744660625000, '2025-04-15 03:57:05'),
('sql_screenshots', 16, '2025-04-15 03:58:05', 'id_b9a25e5cec86425c', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108870508_1744660685000_81479540_1744660685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2da85204e3d14fef8f2bb593194ce329.jpg", "device_id": "d462dc14-e590-4cb0-947b-0fbd94b43c16", "is_chatting": 1, "label_rate": 2, "log_seq": "c073240e340b4924927bc4572f763dd9", "phone_model": "Samsung_S21", "rate": 4, "target_id": "108870508"}', '2025-04-15 03:58:05', 1744660685000, '2025-04-15 03:58:05'),
('sql_screenshots', 16, '2025-04-15 03:59:05', 'id_4f98dcc8fee04966', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "101553185_1744660745000_28230174_1744660745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/39f51cb5c8d34bafb8f90c4f8371a62e.jpg", "device_id": "840815bd-4af2-4b38-980c-8129d7a06ff8", "is_chatting": 1, "label_rate": 1, "log_seq": "18b834b57cfe42728718c9c64741933c", "phone_model": "VIVO_X60", "rate": 0, "target_id": "101553185"}', '2025-04-15 03:59:05', 1744660745000, '2025-04-15 03:59:05'),
('sql_screenshots', 16, '2025-04-15 04:00:05', 'id_722ac120bcba48e7', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105503656_1744660805000_94369556_1744660805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/212c02c3c2664118b49b176e73a0339d.jpg", "device_id": "bc0a2c20-433c-432b-bf4f-8c010edc5b3e", "is_chatting": 1, "label_rate": 1, "log_seq": "c2b0f17661734b0b93a528f783dd5190", "phone_model": "Huawei_P40", "rate": 2, "target_id": "105503656"}', '2025-04-15 04:00:05', 1744660805000, '2025-04-15 04:00:05'),
('sql_screenshots', 16, '2025-04-15 04:01:05', 'id_ea695a382fa34ffc', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "64280379_1744660865000_57649476_1744660865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cb2b8165bde0417f837c838a78cf9c59.jpg", "device_id": "c2b1d065-57a7-4ec3-9d78-f47c9b35905f", "is_chatting": 1, "label_rate": 1, "log_seq": "5445675baf844011a29b5f6c2d37b4f0", "phone_model": "Samsung_S21", "rate": 2, "target_id": "64280379"}', '2025-04-15 04:01:05', 1744660865000, '2025-04-15 04:01:05'),
('sql_screenshots', 16, '2025-04-15 04:02:05', 'id_2e548c617f164240', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108870508_1744660925000_83341608_1744660925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5238347edecf48c19ea7a9d51269e2f1.jpg", "device_id": "998128ed-fb66-40fd-8c12-73d5fd4e1367", "is_chatting": 1, "label_rate": 0, "log_seq": "16542dd6db864fa4ba1ee045057ec4ee", "phone_model": "OnePlus_9", "rate": 0, "target_id": "108870508"}', '2025-04-15 04:02:05', 1744660925000, '2025-04-15 04:02:05'),
('sql_screenshots', 16, '2025-04-15 04:03:05', 'id_be74f00726b843d1', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110215081_1744660985000_32970671_1744660985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f2db33ed02d946e692e939793892347d.jpg", "device_id": "9d9ba795-688f-41dc-baaf-1de88179de4e", "is_chatting": 1, "label_rate": 0, "log_seq": "bc3ffdd330a64a3b8cb3d7ccb29da988", "phone_model": "Samsung_S21", "rate": 5, "target_id": "110215081"}', '2025-04-15 04:03:05', 1744660985000, '2025-04-15 04:03:05'),
('sql_screenshots', 16, '2025-04-15 04:04:05', 'id_2f49431084c84950', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "104844318_1744661045000_82365582_1744661045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/774a4a4792f947ceb32ca0f57bd3bbb9.jpg", "device_id": "f5b5d3ef-74a7-44f9-a3eb-6042f3c91dfa", "is_chatting": 1, "label_rate": 1, "log_seq": "96f978ea201342dab87ae2e10faf7ea3", "phone_model": "Samsung_S21", "rate": 5, "target_id": "104844318"}', '2025-04-15 04:04:05', 1744661045000, '2025-04-15 04:04:05'),
('sql_screenshots', 16, '2025-04-15 04:05:05', 'id_c9258bb2c8f04bc6', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744661105000_110873051_1744661105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2c84db41e54042aa814266671f419da9.jpg", "device_id": "58d20ac2-9b61-4a44-861b-3dca4c7825d1", "is_chatting": 1, "label_rate": 1, "log_seq": "747e05a29f3f48eab1ec490edb0d2bc1", "phone_model": "Samsung_S22", "rate": 4, "target_id": "87571440"}', '2025-04-15 04:05:05', 1744661105000, '2025-04-15 04:05:05'),
('sql_screenshots', 16, '2025-04-15 04:06:05', 'id_8df87ce9013d4412', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "64280379_1744661165000_32970671_1744661165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b1e6ec0ac3814511a2f42fe45c3b7f83.jpg", "device_id": "885b6f34-8020-4871-8baa-29301a2e8212", "is_chatting": 1, "label_rate": 0, "log_seq": "47618c3c161244619c892dd8b8125d94", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "64280379"}', '2025-04-15 04:06:05', 1744661165000, '2025-04-15 04:06:05'),
('sql_screenshots', 16, '2025-04-15 04:07:05', 'id_becc3ddf10e74631', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "94369556_1744661225000_83341608_1744661225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0f438619462e46ba9dd579d8e81abd48.jpg", "device_id": "f16ec5df-3353-47e9-896f-701d3081d363", "is_chatting": 1, "label_rate": 2, "log_seq": "5745abaf279c44feaf9d0f3765b03981", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "94369556"}', '2025-04-15 04:07:05', 1744661225000, '2025-04-15 04:07:05'),
('sql_screenshots', 16, '2025-04-15 04:08:05', 'id_805050cb2512457c', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "83341608_1744661285000_105503656_1744661285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d6346ebb3a12423caef10c7d14dd54d5.jpg", "device_id": "311ad8f7-91a1-4fec-946c-a31ceb8f7293", "is_chatting": 1, "label_rate": 0, "log_seq": "63c05962e5394fea8007d2c6113c8877", "phone_model": "iPhone_13", "rate": 5, "target_id": "83341608"}', '2025-04-15 04:08:05', 1744661285000, '2025-04-15 04:08:05'),
('sql_screenshots', 16, '2025-04-15 04:09:05', 'id_80ea4768d47d4d2b', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "94369556_1744661345000_108870508_1744661345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/20ac0296a9534bd1a571e3ab25a806a8.jpg", "device_id": "09ec9318-f08d-450b-98a2-0a50c928aedd", "is_chatting": 1, "label_rate": 0, "log_seq": "91337126c82a488b892d4eabf289fe13", "phone_model": "Samsung_S21", "rate": 0, "target_id": "94369556"}', '2025-04-15 04:09:05', 1744661345000, '2025-04-15 04:09:05'),
('sql_screenshots', 16, '2025-04-15 04:10:05', 'id_4edf861db5404eae', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109744448_1744661405000_54675542_1744661405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/534ba431795940e99c76c94d2ad59576.jpg", "device_id": "5790710e-533c-46b1-85e9-cc8024b00334", "is_chatting": 1, "label_rate": 0, "log_seq": "71c044321a38483399403e269a7886ae", "phone_model": "iPhone_13", "rate": 5, "target_id": "109744448"}', '2025-04-15 04:10:05', 1744661405000, '2025-04-15 04:10:05'),
('sql_screenshots', 16, '2025-04-15 04:11:05', 'id_47f12bd936644774', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105503656_1744661465000_107039703_1744661465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/16b46493833c4bb79190c28c28663972.jpg", "device_id": "3cc445ef-8a48-4a2c-8564-ad0947a5fc00", "is_chatting": 1, "label_rate": 0, "log_seq": "be421192a20547a38252d104dff81e3e", "phone_model": "OnePlus_9", "rate": 5, "target_id": "105503656"}', '2025-04-15 04:11:05', 1744661465000, '2025-04-15 04:11:05'),
('sql_screenshots', 16, '2025-04-15 04:12:05', 'id_7b9755888c054fd6', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744661525000_57649476_1744661525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f4ca10d623814785ac8de3731035c218.jpg", "device_id": "05f8bb6b-3e73-4cde-a008-10147dc96626", "is_chatting": 1, "label_rate": 0, "log_seq": "97f76c2090a04bada9ce8937a49460a2", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "110876251"}', '2025-04-15 04:12:05', 1744661525000, '2025-04-15 04:12:05'),
('sql_screenshots', 16, '2025-04-15 04:13:05', 'id_7064f499647d49f0', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "94369556_1744661585000_109657261_1744661585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/80e8598a52d44ab4a4b570cb4be457d9.jpg", "device_id": "07d6c142-081f-4cea-9761-f097fabd6a05", "is_chatting": 1, "label_rate": 1, "log_seq": "9bcbd25d9cb347cba9a606d1f4179fd2", "phone_model": "Samsung_S21", "rate": 4, "target_id": "94369556"}', '2025-04-15 04:13:05', 1744661585000, '2025-04-15 04:13:05'),
('sql_screenshots', 16, '2025-04-15 04:14:05', 'id_2597ec04e8b042b8', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "82365582_1744661645000_110892617_1744661645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e2af7e3f159e45609d992346b30d3ca7.jpg", "device_id": "19c30313-4937-466e-907e-04c97558171e", "is_chatting": 1, "label_rate": 2, "log_seq": "3ca9703c82a041a6b33324b187b34f58", "phone_model": "Huawei_P40", "rate": 0, "target_id": "82365582"}', '2025-04-15 04:14:05', 1744661645000, '2025-04-15 04:14:05'),
('sql_screenshots', 16, '2025-04-15 04:15:05', 'id_47a9d796cdd34f02', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "28230174_1744661705000_94369556_1744661705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0efd205b52754d12b0e7a185f3a29465.jpg", "device_id": "63453ba1-e970-432a-bf1e-9424ac25a7d3", "is_chatting": 1, "label_rate": 2, "log_seq": "a560474f2866410ba27645e8f4748111", "phone_model": "Samsung_S22", "rate": 4, "target_id": "28230174"}', '2025-04-15 04:15:05', 1744661705000, '2025-04-15 04:15:05'),
('sql_screenshots', 16, '2025-04-15 04:16:05', 'id_d3e3e87ec6c24219', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105503656_1744661765000_110876251_1744661765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/53b33d6b643549a68417fe57c24bcfd6.jpg", "device_id": "01239dda-52b9-470e-b73c-aa5b85009e9e", "is_chatting": 1, "label_rate": 1, "log_seq": "0868ecff2d294aa4ab6205c73e7227cf", "phone_model": "VIVO_X60", "rate": 0, "target_id": "105503656"}', '2025-04-15 04:16:05', 1744661765000, '2025-04-15 04:16:05'),
('sql_screenshots', 16, '2025-04-15 04:17:05', 'id_28462fcbef97428c', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110890469_1744661825000_108466147_1744661825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c9a23dc0aa7f4ea1b58cc84db1794d93.jpg", "device_id": "eef351bd-4586-4fc7-9294-163cae63511d", "is_chatting": 1, "label_rate": 1, "log_seq": "baa4484537cb4c60a1ec8cd39080c047", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "110890469"}', '2025-04-15 04:17:05', 1744661825000, '2025-04-15 04:17:05'),
('sql_screenshots', 16, '2025-04-15 04:18:05', 'id_82a12d0bb60147d5', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744661885000_108466147_1744661885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4ad9bb37322e4d1fb6d9f9121d67488c.jpg", "device_id": "8df07395-97dc-4dcd-b5ce-4e0c290ebdfc", "is_chatting": 1, "label_rate": 0, "log_seq": "aa15b1c6827c4d848f687cda10bd0804", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "110766160"}', '2025-04-15 04:18:05', 1744661885000, '2025-04-15 04:18:05'),
('sql_screenshots', 16, '2025-04-15 04:19:05', 'id_3e932712fa12457f', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110876251_1744661945000_109657261_1744661945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/156118fbfb6b4234b264a56f24900d0c.jpg", "device_id": "ac3f92dc-a89b-4062-8403-dfee7784858f", "is_chatting": 1, "label_rate": 2, "log_seq": "a9fa80869cd84694ad45e9d8d16167fb", "phone_model": "OPPO_CPH1937", "rate": 0, "target_id": "110876251"}', '2025-04-15 04:19:05', 1744661945000, '2025-04-15 04:19:05'),
('sql_screenshots', 16, '2025-04-15 04:20:05', 'id_0b0e280834e0499e', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744662005000_110766160_1744662005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7e73de3bc38c4a05ad750094c1c79748.jpg", "device_id": "e32256cd-66fc-4fce-87f8-eb3dead521a2", "is_chatting": 1, "label_rate": 0, "log_seq": "216b94fcf99645919532c3a8c7a51f28", "phone_model": "iPhone_13", "rate": 0, "target_id": "32970671"}', '2025-04-15 04:20:05', 1744662005000, '2025-04-15 04:20:06'),
('sql_screenshots', 16, '2025-04-15 04:21:05', 'id_7dcffe3c9f3b419b', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "82365582_1744662065000_101553185_1744662065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1b05e532b21d45d4851a602796b6ea43.jpg", "device_id": "35065ff5-6a40-487b-984e-19378fbb8257", "is_chatting": 1, "label_rate": 2, "log_seq": "be06a22ba24b485db4fdc3e45bbe984f", "phone_model": "Huawei_P40", "rate": 2, "target_id": "82365582"}', '2025-04-15 04:21:05', 1744662065000, '2025-04-15 04:21:05'),
('sql_screenshots', 16, '2025-04-15 04:22:05', 'id_873b00c5ddb041b6', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744662125000_64280379_1744662125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4bbb4079a69343cbb4eb71b2563516a1.jpg", "device_id": "8098a20b-036d-4df8-ae79-29ffdc180893", "is_chatting": 1, "label_rate": 1, "log_seq": "de84cd7cf2a54bed9cc3b8233cec256a", "phone_model": "Samsung_S22", "rate": 2, "target_id": "82365582"}', '2025-04-15 04:22:05', 1744662125000, '2025-04-15 04:22:05'),
('sql_screenshots', 16, '2025-04-15 04:23:05', 'id_7920b4213a8245d8', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "83341608_1744662185000_107039703_1744662185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9796929806dc4325bfa2e47ea81f5d5c.jpg", "device_id": "41bd4fec-a482-4b1f-8cf8-a389fbc8355d", "is_chatting": 1, "label_rate": 1, "log_seq": "4cea1601079949e3b2c79d7d2471fa07", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "83341608"}', '2025-04-15 04:23:05', 1744662185000, '2025-04-15 04:23:05'),
('sql_screenshots', 16, '2025-04-15 04:24:05', 'id_d05678469c0442dd', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "107039703_1744662245000_28230174_1744662245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1c1151ccb47b4675831b9b26966e0d8b.jpg", "device_id": "a6cddf0b-0e0a-4881-acdf-6c455fb1a498", "is_chatting": 1, "label_rate": 1, "log_seq": "c48af7e511eb4966854ef859475cdfbc", "phone_model": "Samsung_S22", "rate": 3, "target_id": "107039703"}', '2025-04-15 04:24:05', 1744662245000, '2025-04-15 04:24:05'),
('sql_screenshots', 16, '2025-04-15 04:25:05', 'id_06d331845f8c45d9', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "87571440_1744662305000_105503656_1744662305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/74d5d616ad3f42759d7c97847adf357f.jpg", "device_id": "ff987eec-5b46-49e4-a0ed-6b2de9752630", "is_chatting": 1, "label_rate": 2, "log_seq": "5fb7a7ddf2ec4522bf85abbfcc1b6d1f", "phone_model": "Huawei_P40", "rate": 3, "target_id": "87571440"}', '2025-04-15 04:25:05', 1744662305000, '2025-04-15 04:25:05'),
('sql_screenshots', 16, '2025-04-15 04:26:05', 'id_04ad1f944084446b', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "81479540_1744662365000_109980113_1744662365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e68c9f2c1eec4370aff25986b68af9fb.jpg", "device_id": "142f0bb6-2c2e-49e7-86a0-12db7e4c7abc", "is_chatting": 1, "label_rate": 2, "log_seq": "801e806a6473472396c6d63b76a29ad8", "phone_model": "OnePlus_9", "rate": 4, "target_id": "81479540"}', '2025-04-15 04:26:05', 1744662365000, '2025-04-15 04:26:05'),
('sql_screenshots', 16, '2025-04-15 04:27:05', 'id_b4aafa6da1cd45bc', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "87571440_1744662425000_105503656_1744662425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9622f4ca35214dae8808dc5888e18541.jpg", "device_id": "3f2197f2-9dd8-4721-9e7d-29585978a698", "is_chatting": 1, "label_rate": 2, "log_seq": "5805a09844c3478987e187476007eb55", "phone_model": "VIVO_X60", "rate": 0, "target_id": "87571440"}', '2025-04-15 04:27:05', 1744662425000, '2025-04-15 04:27:05'),
('sql_screenshots', 16, '2025-04-15 04:28:05', 'id_6b79f544b33543dc', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "104844318_1744662485000_57649476_1744662485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9baf0c36e38848868e5f36c19cb6500f.jpg", "device_id": "1458f9f8-3d4a-4ed7-b272-e01cf1c37f20", "is_chatting": 1, "label_rate": 1, "log_seq": "196e66d1da3949b3b47d5b5dfce57ce7", "phone_model": "Samsung_S22", "rate": 3, "target_id": "104844318"}', '2025-04-15 04:28:05', 1744662485000, '2025-04-15 04:28:05'),
('sql_screenshots', 16, '2025-04-15 04:29:05', 'id_093823f45fd14022', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "107039703_1744662545000_28230174_1744662545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5ebcbd80650f45449ae1d73355e2c8a1.jpg", "device_id": "2a4feaab-fd62-4833-bb17-d4d58dd0b84b", "is_chatting": 1, "label_rate": 0, "log_seq": "330c8698a7f6401e8b4a02ac1485a9d5", "phone_model": "Samsung_S22", "rate": 2, "target_id": "107039703"}', '2025-04-15 04:29:05', 1744662545000, '2025-04-15 04:29:05'),
('sql_screenshots', 16, '2025-04-15 04:30:05', 'id_92e7c991687f4899', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109744448_1744662605000_107039703_1744662605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/90077a44ee7644c69a04884f9e45fd38.jpg", "device_id": "66fe39aa-9e9f-4479-a1ca-00c2aa652a76", "is_chatting": 1, "label_rate": 0, "log_seq": "821f52f623b6460d899d1c806d02bbf6", "phone_model": "VIVO_X60", "rate": 4, "target_id": "109744448"}', '2025-04-15 04:30:05', 1744662605000, '2025-04-15 04:30:05'),
('sql_screenshots', 16, '2025-04-15 04:31:05', 'id_6d7d5e1408b7400b', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "28230174_1744662665000_110890469_1744662665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/47acbb69c2984a9a9fda02b393695eb1.jpg", "device_id": "83184cf6-4524-42c1-ae19-eaf317d4f679", "is_chatting": 1, "label_rate": 2, "log_seq": "851220d62f9a48e7a83976e87e1c277c", "phone_model": "VIVO_X60", "rate": 5, "target_id": "28230174"}', '2025-04-15 04:31:05', 1744662665000, '2025-04-15 04:31:05'),
('sql_screenshots', 16, '2025-04-15 04:32:05', 'id_d801200b5f9d4db7', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "32970671_1744662725000_108870508_1744662725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c082b0d0909f411fb6dd0d12857d4191.jpg", "device_id": "3b77a3fd-62ba-4b9b-a04a-68f3c3b23f8b", "is_chatting": 1, "label_rate": 1, "log_seq": "e8f6302aadae47e7a14f4fa56b716d9e", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "32970671"}', '2025-04-15 04:32:05', 1744662725000, '2025-04-15 04:32:05'),
('sql_screenshots', 16, '2025-04-15 04:33:05', 'id_656fbc7517d14191', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "82365582_1744662785000_110873051_1744662785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ca5fe377ee284b2982218a54d8427708.jpg", "device_id": "cfe0ade7-c23f-4b10-af3a-32e4f11d31b8", "is_chatting": 1, "label_rate": 2, "log_seq": "e8a41d3b5e8b4fe9892b26704445042e", "phone_model": "VIVO_X60", "rate": 0, "target_id": "82365582"}', '2025-04-15 04:33:05', 1744662785000, '2025-04-15 04:33:05'),
('sql_screenshots', 16, '2025-04-15 04:34:05', 'id_736a74d22e814c85', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "104844318_1744662845000_105503656_1744662845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/865a9b400525405e934b5bffd989afbd.jpg", "device_id": "881b5498-510f-47e9-8ef2-c3f76fff2203", "is_chatting": 1, "label_rate": 1, "log_seq": "befceb9be35f455c87c96e6503ba7714", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "104844318"}', '2025-04-15 04:34:05', 1744662845000, '2025-04-15 04:34:05'),
('sql_screenshots', 16, '2025-04-15 04:35:05', 'id_f866ae890b6c42c9', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105503656_1744662905000_109744448_1744662905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9efb4f0730bd41d69fbd5bbcc1541896.jpg", "device_id": "79084119-8ccb-4ec1-b33e-1e527369f472", "is_chatting": 1, "label_rate": 1, "log_seq": "d59df2eba63a4550b882c1689add99c9", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "105503656"}', '2025-04-15 04:35:05', 1744662905000, '2025-04-15 04:35:05'),
('sql_screenshots', 16, '2025-04-15 04:36:05', 'id_a537ff4b97e94ec6', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105083641_1744662965000_110876251_1744662965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0f77b2862296477ba0a105c971df2157.jpg", "device_id": "680b9a25-5cc4-4b2e-9f15-595d0ab799bc", "is_chatting": 1, "label_rate": 0, "log_seq": "cb34721fbc3f4c3598bdb612d911f5cc", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "105083641"}', '2025-04-15 04:36:05', 1744662965000, '2025-04-15 04:36:05'),
('sql_screenshots', 16, '2025-04-15 04:37:05', 'id_d526ee4c30dc405c', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110766160_1744663025000_81479540_1744663025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d7dbc3bf23d34557b9b7abba2700a772.jpg", "device_id": "27c11dbc-5cc4-43c3-af7c-8fadea67332f", "is_chatting": 1, "label_rate": 1, "log_seq": "5d1d56b54af14e269e8b967a13ff7cd6", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "110766160"}', '2025-04-15 04:37:05', 1744663025000, '2025-04-15 04:37:05'),
('sql_screenshots', 16, '2025-04-15 04:38:05', 'id_cebe4b35307f413f', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110890469_1744663085000_101553185_1744663085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a0ee56d8650746ff8c1d839bcf999c7e.jpg", "device_id": "925b652a-502e-4394-8c47-90cb138c7e1d", "is_chatting": 1, "label_rate": 0, "log_seq": "c11ffc7d085d4a51aa907e5ecfde5f35", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "110890469"}', '2025-04-15 04:38:05', 1744663085000, '2025-04-15 04:38:05'),
('sql_screenshots', 16, '2025-04-15 04:39:05', 'id_2715a52be9d04bf8', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "57649476_1744663145000_109407413_1744663145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a176744301824a828e744bfe22c9dbf9.jpg", "device_id": "905de589-5814-4f92-9d3c-881b383aeec7", "is_chatting": 1, "label_rate": 1, "log_seq": "a6e753d689784c7fbdbf4a1d5fe6ee71", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "57649476"}', '2025-04-15 04:39:05', 1744663145000, '2025-04-15 04:39:05'),
('sql_screenshots', 16, '2025-04-15 04:40:05', 'id_6af648a4fdb849ab', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "54675542_1744663205000_57649476_1744663205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/038ee0b182714abaa2d5f66db859a47c.jpg", "device_id": "8b000a6f-05bc-4c36-b200-fc6db82a96ca", "is_chatting": 1, "label_rate": 2, "log_seq": "dbb769d3bb0641c4b9fef200bb215cad", "phone_model": "Samsung_S22", "rate": 5, "target_id": "54675542"}', '2025-04-15 04:40:05', 1744663205000, '2025-04-15 04:40:05'),
('sql_screenshots', 16, '2025-04-15 04:41:05', 'id_61efcd7afeb64d79', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108870508_1744663265000_28230174_1744663265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4cb25b4fe11342dab1d7fac176384e6e.jpg", "device_id": "af4b4c7b-54fa-41eb-8734-b0a19951a0a9", "is_chatting": 1, "label_rate": 2, "log_seq": "72856579c23c466b8602ffe61ac679df", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "108870508"}', '2025-04-15 04:41:05', 1744663265000, '2025-04-15 04:41:05'),
('sql_screenshots', 16, '2025-04-15 04:42:05', 'id_d872ef1272fc496a', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109407413_1744663325000_108870508_1744663325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/befa2501abe14dc4bcf8cf4117f3ea11.jpg", "device_id": "44665700-1cf6-4657-b8f1-8c67aaea6ecc", "is_chatting": 1, "label_rate": 1, "log_seq": "2fcb3732a2e74474bdbd9d5d0daf0013", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "109407413"}', '2025-04-15 04:42:05', 1744663325000, '2025-04-15 04:42:05'),
('sql_screenshots', 16, '2025-04-15 04:43:05', 'id_42c475a180024355', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110215081_1744663385000_32970671_1744663385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bb3865811daa490e98e178c9ae68981b.jpg", "device_id": "94b19bb4-e6d9-4a00-8933-4d0117fd790e", "is_chatting": 1, "label_rate": 1, "log_seq": "e905c29fe6694f69ac59b979c1343deb", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "110215081"}', '2025-04-15 04:43:05', 1744663385000, '2025-04-15 04:43:05'),
('sql_screenshots', 16, '2025-04-15 04:44:05', 'id_9e808cce69094800', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "87571440_1744663445000_110876251_1744663445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2f28f5b7fed24b93b952409f095c5270.jpg", "device_id": "8a17d239-4f63-4063-b9bc-96888bcfd922", "is_chatting": 1, "label_rate": 0, "log_seq": "2321db013b9f4c388b92f22842727b80", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "87571440"}', '2025-04-15 04:44:05', 1744663445000, '2025-04-15 04:44:05'),
('sql_screenshots', 16, '2025-04-15 04:45:05', 'id_2df31d1f6936428a', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "64280379_1744663505000_109657261_1744663505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e1937ffb119145458715f2d9c90ad1bf.jpg", "device_id": "15c16833-8e30-4fb2-8a56-7e10ec407d50", "is_chatting": 1, "label_rate": 1, "log_seq": "333611fb6cda4cc3a76d5e58c715e49e", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "64280379"}', '2025-04-15 04:45:05', 1744663505000, '2025-04-15 04:45:05'),
('sql_screenshots', 16, '2025-04-15 04:46:05', 'id_1a79ac32123b475b', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108870508_1744663565000_82365582_1744663565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/af8f756a58a140abb2fcb97a938a8a66.jpg", "device_id": "f0aa4044-6af3-4586-be28-0332a862ce48", "is_chatting": 1, "label_rate": 0, "log_seq": "7031a27dfd374db1ac07568a224c1488", "phone_model": "Huawei_P40", "rate": 3, "target_id": "108870508"}', '2025-04-15 04:46:05', 1744663565000, '2025-04-15 04:46:05'),
('sql_screenshots', 16, '2025-04-15 04:47:05', 'id_e510d331365c4e25', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "57649476_1744663625000_104844318_1744663625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6e683910a584418c9bfadbd070fc281b.jpg", "device_id": "df94568d-2bff-4dcf-abe2-03a8f5ac832f", "is_chatting": 1, "label_rate": 2, "log_seq": "d961d1b94128451e81304e2741c2b0dd", "phone_model": "VIVO_X60", "rate": 2, "target_id": "57649476"}', '2025-04-15 04:47:05', 1744663625000, '2025-04-15 04:47:05'),
('sql_screenshots', 16, '2025-04-15 04:48:05', 'id_727fc839b6ee4087', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110892617_1744663685000_109407413_1744663685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/52d8221fa807498b9decf3ca38662b85.jpg", "device_id": "2097dfec-63c4-4010-8206-4a11274ade59", "is_chatting": 1, "label_rate": 2, "log_seq": "b84e0e19e3034df1abc4c0fdb676b415", "phone_model": "Samsung_S22", "rate": 3, "target_id": "110892617"}', '2025-04-15 04:48:05', 1744663685000, '2025-04-15 04:48:05'),
('sql_screenshots', 16, '2025-04-15 04:49:05', 'id_dca07e2d58e34742', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110766160_1744663745000_110215081_1744663745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9156cc161a724eeca7230eae4cc5838a.jpg", "device_id": "5c468d44-81e4-47bc-9b1f-ec635a20a466", "is_chatting": 1, "label_rate": 2, "log_seq": "1fd8317670544bc6b58ad6b49737077c", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "110766160"}', '2025-04-15 04:49:05', 1744663745000, '2025-04-15 04:49:05'),
('sql_screenshots', 16, '2025-04-15 04:50:05', 'id_61ed0140795b4bcf', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110873051_1744663805000_87571440_1744663805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bd52018c9f0d47eca0f069a1f4b85096.jpg", "device_id": "92f0d377-bd5e-43d9-a270-107a8dcd4108", "is_chatting": 1, "label_rate": 1, "log_seq": "6877f5224ed64fb081cf01a398863ca1", "phone_model": "Samsung_S22", "rate": 3, "target_id": "110873051"}', '2025-04-15 04:50:05', 1744663805000, '2025-04-15 04:50:05'),
('sql_screenshots', 16, '2025-04-15 04:51:05', 'id_37ee2588a39449f6', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "54675542_1744663865000_83341608_1744663865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/dcf0fcf2f1b047d1a89519cf4e8d886d.jpg", "device_id": "c12232ff-63a4-49b1-95a7-a30608babde2", "is_chatting": 1, "label_rate": 2, "log_seq": "360a517925364a048ce3e076c3324b03", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "54675542"}', '2025-04-15 04:51:05', 1744663865000, '2025-04-15 04:51:05'),
('sql_screenshots', 16, '2025-04-15 04:52:05', 'id_35ee76a085294946', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105083641_1744663925000_110876251_1744663925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/15d3bfb156d441f2b404b53e1b534639.jpg", "device_id": "b9b24dea-439b-4b5a-807b-d06f60d3124f", "is_chatting": 1, "label_rate": 0, "log_seq": "887f5769a29c49bc96b82745af8362fd", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "105083641"}', '2025-04-15 04:52:05', 1744663925000, '2025-04-15 04:52:05'),
('sql_screenshots', 16, '2025-04-15 04:53:05', 'id_6be983ebfdd94db0', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "107039703_1744663985000_109657261_1744663985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1e6d40a873f744f9baef55a0507442b3.jpg", "device_id": "3c017239-4458-4701-a745-358cd43ad84e", "is_chatting": 1, "label_rate": 1, "log_seq": "e8003335e57f425d89d6c051ebe11e66", "phone_model": "VIVO_X60", "rate": 5, "target_id": "107039703"}', '2025-04-15 04:53:05', 1744663985000, '2025-04-15 04:53:05'),
('sql_screenshots', 16, '2025-04-15 04:54:05', 'id_b9313c8252294da6', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "94369556_1744664045000_105503656_1744664045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/99885d9814e84afda5fc46925c7c6c29.jpg", "device_id": "9040379c-ed4e-457c-8ed2-df3e730ca861", "is_chatting": 1, "label_rate": 2, "log_seq": "59ce41a49f544190a83e11843e0d60c3", "phone_model": "Samsung_S21", "rate": 3, "target_id": "94369556"}', '2025-04-15 04:54:05', 1744664045000, '2025-04-15 04:54:05'),
('sql_screenshots', 16, '2025-04-15 04:55:05', 'id_e8d0f36491c64c24', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744664105000_110215081_1744664105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/52583386850d4d03806043812bb4c5ba.jpg", "device_id": "da349638-de99-4da5-b63a-007aa6f07eb8", "is_chatting": 1, "label_rate": 0, "log_seq": "eb412607fda74a78b2078cafe20b6093", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "82365582"}', '2025-04-15 04:55:05', 1744664105000, '2025-04-15 04:55:05'),
('sql_screenshots', 16, '2025-04-15 04:56:05', 'id_310636b038104bf0', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744664165000_110215081_1744664165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9a8b7f422e174e3d8ce04275057fa3a8.jpg", "device_id": "7db92430-a2a1-477b-b3ac-c22d9a0fb1b6", "is_chatting": 1, "label_rate": 0, "log_seq": "2d4f9fbaf4ec4d8d8f66524c3d76813a", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "82365582"}', '2025-04-15 04:56:05', 1744664165000, '2025-04-15 04:56:05'),
('sql_screenshots', 16, '2025-04-15 04:57:05', 'id_c8aed39196ef4ae1', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744664225000_64280379_1744664225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5eb7584042744c6b901f068c1c5c8926.jpg", "device_id": "84f425b7-4eaa-414e-ab6d-9b2cf91ec1c4", "is_chatting": 1, "label_rate": 0, "log_seq": "ed1bce94e0514314b174fc9f6f2f8075", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "81479540"}', '2025-04-15 04:57:05', 1744664225000, '2025-04-15 04:57:05'),
('sql_screenshots', 16, '2025-04-15 04:58:05', 'id_8a7f101269da420c', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "101553185_1744664285000_110215081_1744664285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6f72b1906ee340558e120c0dced2397c.jpg", "device_id": "27cf3b26-8024-4d28-b27e-9e8252fbcca2", "is_chatting": 1, "label_rate": 2, "log_seq": "47328a23b24948e58a20aae0009e7b43", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "101553185"}', '2025-04-15 04:58:05', 1744664285000, '2025-04-15 04:58:05'),
('sql_screenshots', 16, '2025-04-15 04:59:05', 'id_6336dac04ff94e18', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109407413_1744664345000_87571440_1744664345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/867e5e220c2c4843a53c52da6fad252c.jpg", "device_id": "ed0c2172-f775-40a4-b9c4-b82153c9f7a1", "is_chatting": 1, "label_rate": 0, "log_seq": "cb45413ff7d54c6bb9f1229ba5b1fd54", "phone_model": "Samsung_S21", "rate": 5, "target_id": "109407413"}', '2025-04-15 04:59:05', 1744664345000, '2025-04-15 04:59:05'),
('sql_screenshots', 16, '2025-04-15 05:00:05', 'id_934fe005a8374cb6', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "54675542_1744664405000_57649476_1744664405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/128d19814ac24c858f0056cbe2749eb8.jpg", "device_id": "8343dce3-dc59-4666-bbe3-4a9e292d0ac9", "is_chatting": 1, "label_rate": 0, "log_seq": "78f333a13b9b47e287352270f479ecb4", "phone_model": "Huawei_P40", "rate": 3, "target_id": "54675542"}', '2025-04-15 05:00:05', 1744664405000, '2025-04-15 05:00:05'),
('sql_screenshots', 16, '2025-04-15 05:01:05', 'id_f4f99160fd17404b', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744664465000_82365582_1744664465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5a871b8812f248498119046d6b0b8864.jpg", "device_id": "486e6aba-6ce0-4b22-a2ae-28482c8a6335", "is_chatting": 1, "label_rate": 0, "log_seq": "7028b8e0be2f45a293fee2dccd11b99d", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "109744448"}', '2025-04-15 05:01:05', 1744664465000, '2025-04-15 05:01:05'),
('sql_screenshots', 16, '2025-04-15 05:02:05', 'id_fe3e879fb10c4186', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744664525000_110215081_1744664525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/76572be5d56a4fff8734d7f7db271fcc.jpg", "device_id": "c32fb310-d214-43e9-a8b5-220f680c7675", "is_chatting": 1, "label_rate": 1, "log_seq": "6bd1b8d45c1f471f8b1cbc20acbc29b8", "phone_model": "iPhone_13", "rate": 0, "target_id": "107039703"}', '2025-04-15 05:02:05', 1744664525000, '2025-04-15 05:02:05'),
('sql_screenshots', 16, '2025-04-15 05:03:05', 'id_57deb65b169d4f20', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "107039703_1744664585000_104844318_1744664585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/026f09f7315a4ed3943fd0921fac7b0f.jpg", "device_id": "1e73031c-3c64-490c-92e8-e098dbb1c9b9", "is_chatting": 1, "label_rate": 0, "log_seq": "5e65aca6d0504aba9ced360936487e69", "phone_model": "Samsung_S21", "rate": 4, "target_id": "107039703"}', '2025-04-15 05:03:05', 1744664585000, '2025-04-15 05:03:05'),
('sql_screenshots', 16, '2025-04-15 05:04:05', 'id_deec7f1cec554b91', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "28230174_1744664645000_94369556_1744664645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/71e0d0d689ab4950be6c42dc7f7b707e.jpg", "device_id": "7164fbdc-c49d-45b0-aea4-4b3c51dcf33f", "is_chatting": 1, "label_rate": 0, "log_seq": "3f2fa78856f2484cbe8d3dbf46d9ff08", "phone_model": "OnePlus_9", "rate": 4, "target_id": "28230174"}', '2025-04-15 05:04:05', 1744664645000, '2025-04-15 05:04:05'),
('sql_screenshots', 16, '2025-04-15 05:05:05', 'id_c545d07c50e54964', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "94369556_1744664705000_104844318_1744664705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0ad05ac5ea3f4e359c884c2a05ecfdd7.jpg", "device_id": "ef6547dd-2a34-4e32-95b8-49cfa0c65048", "is_chatting": 1, "label_rate": 0, "log_seq": "20148114eba74d0688d7ac13fbc22078", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "94369556"}', '2025-04-15 05:05:05', 1744664705000, '2025-04-15 05:05:05'),
('sql_screenshots', 16, '2025-04-15 05:06:05', 'id_746a09177cbe4064', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744664765000_82365582_1744664765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9d2617519c5a44cba2bc00b4ffdc9967.jpg", "device_id": "2c85965c-869c-472c-9e5d-04bf534a83ef", "is_chatting": 1, "label_rate": 2, "log_seq": "9bbfc9581fb24572b47d64c69b5f2e4d", "phone_model": "Samsung_S22", "rate": 2, "target_id": "108466147"}', '2025-04-15 05:06:05', 1744664765000, '2025-04-15 05:06:05'),
('sql_screenshots', 16, '2025-04-15 05:07:05', 'id_40a356eff788412a', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109980113_1744664825000_57649476_1744664825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/75e16cb8375246e09d568198abb359a4.jpg", "device_id": "1e3bdb40-2ac7-4cda-99de-94a86d69c7a8", "is_chatting": 1, "label_rate": 0, "log_seq": "6efea61ccf944237a1e8f316105815fa", "phone_model": "Huawei_P40", "rate": 2, "target_id": "109980113"}', '2025-04-15 05:07:05', 1744664825000, '2025-04-15 05:07:05'),
('sql_screenshots', 16, '2025-04-15 05:08:05', 'id_26ea814190504906', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "57649476_1744664885000_54675542_1744664885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4a9778f46bac4e22acc71c0e8f6aff5d.jpg", "device_id": "fc04c413-348f-46dd-bc2a-4da865e65a3c", "is_chatting": 1, "label_rate": 0, "log_seq": "243e8f3121d24f059438f06a1107f9b3", "phone_model": "Samsung_S21", "rate": 2, "target_id": "57649476"}', '2025-04-15 05:08:05', 1744664885000, '2025-04-15 05:08:05'),
('sql_screenshots', 16, '2025-04-15 05:09:05', 'id_a78ea6e81df54a60', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110890469_1744664945000_57649476_1744664945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1fe28b2100e74d0398f8af10104e507d.jpg", "device_id": "08f3ce0a-7a56-4a7f-9aec-fdac6b785210", "is_chatting": 1, "label_rate": 1, "log_seq": "26517530d7244b1c914dc9b696eaa517", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "110890469"}', '2025-04-15 05:09:05', 1744664945000, '2025-04-15 05:09:05'),
('sql_screenshots', 16, '2025-04-15 05:10:05', 'id_10a6e1d23a444a57', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "83341608_1744665005000_64280379_1744665005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/462404c56b504bb2851327f897bba3eb.jpg", "device_id": "ba3d7684-3aee-43af-bc4c-e3cfebb40416", "is_chatting": 1, "label_rate": 2, "log_seq": "f3bed1d7ef124f56b031d94bbe5a06c6", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "83341608"}', '2025-04-15 05:10:05', 1744665005000, '2025-04-15 05:10:05'),
('sql_screenshots', 16, '2025-04-15 05:11:05', 'id_7ce9458fdbf94d15', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109407413_1744665065000_109744448_1744665065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/baceea2855b542459847c7ee01dbee7d.jpg", "device_id": "d0fb59d6-1272-45cf-a33b-22291519a9c6", "is_chatting": 1, "label_rate": 0, "log_seq": "8d9143b9fe4549d396f274c81378f297", "phone_model": "VIVO_X60", "rate": 0, "target_id": "109407413"}', '2025-04-15 05:11:05', 1744665065000, '2025-04-15 05:11:05'),
('sql_screenshots', 16, '2025-04-15 05:12:05', 'id_4754cc96a29e4765', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "28230174_1744665125000_109744448_1744665125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/95c4282472524dc8a23d93e834ee2bfd.jpg", "device_id": "d98344d2-5da0-4d05-97b6-96bf4a5aada8", "is_chatting": 1, "label_rate": 0, "log_seq": "b59adece7fe14c3aba2f539982adbf36", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "28230174"}', '2025-04-15 05:12:05', 1744665125000, '2025-04-15 05:12:05'),
('sql_screenshots', 16, '2025-04-15 05:13:05', 'id_cf8844bfec49485b', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "28230174_1744665185000_104844318_1744665185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/18e48ad088ea46e9b94a5194d01b763a.jpg", "device_id": "a95abae5-bdac-4cc5-ad49-a906300f26b3", "is_chatting": 1, "label_rate": 0, "log_seq": "92f927d04f394a9a8c79ca9c112d1512", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "28230174"}', '2025-04-15 05:13:05', 1744665185000, '2025-04-15 05:13:05'),
('sql_screenshots', 16, '2025-04-15 05:14:05', 'id_9110fac7d2304a38', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110215081_1744665245000_109744448_1744665245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/992630f8b6d74ced9abd1c59e9f7a35b.jpg", "device_id": "f16354ca-bf66-4396-8af5-483f3aa4eb8e", "is_chatting": 1, "label_rate": 2, "log_seq": "34147477bfe44763b9868b93f21d4c0a", "phone_model": "OnePlus_9", "rate": 0, "target_id": "110215081"}', '2025-04-15 05:14:05', 1744665245000, '2025-04-15 05:14:05'),
('sql_screenshots', 16, '2025-04-15 05:15:05', 'id_85a4846a7a0140b4', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "104844318_1744665305000_110873051_1744665305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/73aae2dfdb0544c98dba10f35ba31a89.jpg", "device_id": "7d67c785-9e41-4631-b12e-47922d260f19", "is_chatting": 1, "label_rate": 0, "log_seq": "081aa6870ff5454eba43946257bafe38", "phone_model": "Samsung_S22", "rate": 3, "target_id": "104844318"}', '2025-04-15 05:15:05', 1744665305000, '2025-04-15 05:15:05'),
('sql_screenshots', 16, '2025-04-15 05:16:05', 'id_8904ccc8b44f40de', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "104844318_1744665365000_110892617_1744665365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/98fc456d2e4a44ec811c0d765c3adbc0.jpg", "device_id": "2f530ce9-9290-4505-bd83-a0fd62e9999a", "is_chatting": 1, "label_rate": 0, "log_seq": "2bc7b1e3b73b428d8f19a8843c8d3f8f", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "104844318"}', '2025-04-15 05:16:05', 1744665365000, '2025-04-15 05:16:05'),
('sql_screenshots', 16, '2025-04-15 05:17:05', 'id_be68f2c9a0fc4d09', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109744448_1744665425000_64280379_1744665425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b154fa4f3c194fd99d1750b5b8c19cf7.jpg", "device_id": "3a9005ce-0b5c-4de1-8506-d56d0b6f3aa1", "is_chatting": 1, "label_rate": 1, "log_seq": "7b2d6b8156d744cdaf55cabebee9c24e", "phone_model": "OPPO_CPH1937", "rate": 0, "target_id": "109744448"}', '2025-04-15 05:17:05', 1744665425000, '2025-04-15 05:17:05'),
('sql_screenshots', 16, '2025-04-15 05:18:05', 'id_9912b7bc294942c1', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "104844318_1744665485000_83341608_1744665485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/580063e996d04d2dbd9e5ac5e6c8eaaf.jpg", "device_id": "dddde169-605e-4595-a635-6c11ef666cb9", "is_chatting": 1, "label_rate": 2, "log_seq": "791265d9e1004ec9887ab1d9aae2906e", "phone_model": "Samsung_S22", "rate": 1, "target_id": "104844318"}', '2025-04-15 05:18:05', 1744665485000, '2025-04-15 05:18:05'),
('sql_screenshots', 16, '2025-04-15 05:19:05', 'id_4d7da8dbc9994b41', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "54675542_1744665545000_108466147_1744665545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6c78bf71081346a08b57882e3435b965.jpg", "device_id": "ad122d8f-2d82-436d-b136-689b9871abe9", "is_chatting": 1, "label_rate": 2, "log_seq": "e6b786542b074d85868cdc96eeec2687", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "54675542"}', '2025-04-15 05:19:05', 1744665545000, '2025-04-15 05:19:05'),
('sql_screenshots', 16, '2025-04-15 05:20:05', 'id_26cf378bc8db4631', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "32970671_1744665605000_87571440_1744665605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/92190e1342874035a8c03da0e03fee99.jpg", "device_id": "33518b4c-61cb-4f97-9e4b-f54161960d1d", "is_chatting": 1, "label_rate": 1, "log_seq": "756a8c4a4a6f4448b8a6f66fa98f80c0", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "32970671"}', '2025-04-15 05:20:05', 1744665605000, '2025-04-15 05:20:05'),
('sql_screenshots', 16, '2025-04-15 05:21:05', 'id_9593295bb9ec4a34', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110873051_1744665665000_110215081_1744665665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/17333bfdac1349a48f99b121af75bc98.jpg", "device_id": "68eeeaca-a2d7-43a5-9f28-cd09e879c521", "is_chatting": 1, "label_rate": 0, "log_seq": "1a3908bed5cf428b9f12ae198a39eb76", "phone_model": "iPhone_13", "rate": 5, "target_id": "110873051"}', '2025-04-15 05:21:05', 1744665665000, '2025-04-15 05:21:05'),
('sql_screenshots', 16, '2025-04-15 05:22:05', 'id_83968f9b24f14ede', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "94369556_1744665725000_110890469_1744665725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0fefb6c4ce6345209fdbad3309453758.jpg", "device_id": "bc633d7e-7fb9-42a6-8b76-9e23c2002104", "is_chatting": 1, "label_rate": 2, "log_seq": "87dc579a4ef24a4fa8723aefa5094375", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "94369556"}', '2025-04-15 05:22:05', 1744665725000, '2025-04-15 05:22:05'),
('sql_screenshots', 16, '2025-04-15 05:23:05', 'id_1bd8007366424434', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105503656_1744665785000_28230174_1744665785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e7a94d6ee3a74ca8ba38a75993670e19.jpg", "device_id": "5f57c8c9-3fd4-48e0-8560-81289421394d", "is_chatting": 1, "label_rate": 1, "log_seq": "e0a47589e3094e61aba654f00d3d9850", "phone_model": "iPhone_13", "rate": 5, "target_id": "105503656"}', '2025-04-15 05:23:05', 1744665785000, '2025-04-15 05:23:05'),
('sql_screenshots', 16, '2025-04-15 05:24:05', 'id_c48eeaed23a94208', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "104844318_1744665845000_87571440_1744665845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a55abe671a644bccaae5653dbb6d16e3.jpg", "device_id": "34aa0ea9-8cda-42e5-9d1e-6d13a148ee36", "is_chatting": 1, "label_rate": 1, "log_seq": "d27bcd51f55a4deda3f6f31ea83555d6", "phone_model": "iPhone_13", "rate": 1, "target_id": "104844318"}', '2025-04-15 05:24:05', 1744665845000, '2025-04-15 05:24:05'),
('sql_screenshots', 16, '2025-04-15 05:25:05', 'id_fa550da7c6f94b80', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "101553185_1744665905000_94369556_1744665905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f0bdf827e5964a41817615aa9799f9b0.jpg", "device_id": "f87f83cd-74f3-443d-892c-a40b2104e62b", "is_chatting": 1, "label_rate": 1, "log_seq": "a45d412467314232b0705bbce7a5d9ba", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "101553185"}', '2025-04-15 05:25:05', 1744665905000, '2025-04-15 05:25:05'),
('sql_screenshots', 16, '2025-04-15 05:26:05', 'id_62304d6ca1214fd2', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "82365582_1744665965000_110876251_1744665965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/320002d063724f699a6185be3f577110.jpg", "device_id": "0d9f4acb-5674-4865-b1ce-1bb0c39fbbb8", "is_chatting": 1, "label_rate": 2, "log_seq": "a5710282f2e143aaa61ce805dfbd8b59", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "82365582"}', '2025-04-15 05:26:05', 1744665965000, '2025-04-15 05:26:05'),
('sql_screenshots', 16, '2025-04-15 05:27:05', 'id_53d1cf10dc1c40e4', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109744448_1744666025000_110873051_1744666025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/064229172c6148efa8300cbdf126de15.jpg", "device_id": "0b579e8d-3467-487d-bb0f-7feb4536204a", "is_chatting": 1, "label_rate": 2, "log_seq": "ad3737574b604c1192351bc7f8e049a2", "phone_model": "Samsung_S22", "rate": 1, "target_id": "109744448"}', '2025-04-15 05:27:05', 1744666025000, '2025-04-15 05:27:05'),
('sql_screenshots', 16, '2025-04-15 05:28:05', 'id_b87f33c02c7b4a19', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110766160_1744666085000_110215081_1744666085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/652f9994fba24846ae192ef78426680f.jpg", "device_id": "bf3a47cf-67f7-4e12-82e1-c4b896363170", "is_chatting": 1, "label_rate": 0, "log_seq": "ca56e279cc334f8382973c0f5b27e879", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "110766160"}', '2025-04-15 05:28:05', 1744666085000, '2025-04-15 05:28:05'),
('sql_screenshots', 16, '2025-04-15 05:29:05', 'id_328acf0b2c9147ea', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "57649476_1744666145000_109407413_1744666145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d3d28ec5ea0d41a49c3b036527731814.jpg", "device_id": "06917c8b-6f37-48be-a521-f19f14e541d1", "is_chatting": 1, "label_rate": 0, "log_seq": "5fa03d9c7c544e34ba8b0dbb317d86d5", "phone_model": "VIVO_X60", "rate": 3, "target_id": "57649476"}', '2025-04-15 05:29:05', 1744666145000, '2025-04-15 05:29:05'),
('sql_screenshots', 16, '2025-04-15 05:30:05', 'id_10e4265621c04c51', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744666205000_109657261_1744666205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/717eebbb7efb49aca7916f997db1d110.jpg", "device_id": "6e3dbbfa-e9d7-42d1-aed9-25aebf819af1", "is_chatting": 1, "label_rate": 1, "log_seq": "c1d085c2da094b3792a5c22adf6f465f", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "81479540"}', '2025-04-15 05:30:05', 1744666205000, '2025-04-15 05:30:05'),
('sql_screenshots', 16, '2025-04-15 05:31:05', 'id_070d389b0106400e', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108466147_1744666265000_107039703_1744666265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1695a551fd8745b58faf41c188b144eb.jpg", "device_id": "99f09277-b2fa-496d-9eca-2d280218443f", "is_chatting": 1, "label_rate": 1, "log_seq": "d366707989c34ad2afef0bcaed26ea73", "phone_model": "VIVO_X60", "rate": 5, "target_id": "108466147"}', '2025-04-15 05:31:05', 1744666265000, '2025-04-15 05:31:05'),
('sql_screenshots', 16, '2025-04-15 05:32:05', 'id_979e2ea029fe4efc', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "94369556_1744666325000_110892617_1744666325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4e969349a95643e0af35fb4a7dc2214c.jpg", "device_id": "ed17a06e-0491-45ce-ad16-92aaccdf4b91", "is_chatting": 1, "label_rate": 0, "log_seq": "3e938f4afaf54a4cb28673e9ee613c95", "phone_model": "VIVO_X60", "rate": 4, "target_id": "94369556"}', '2025-04-15 05:32:05', 1744666325000, '2025-04-15 05:32:05'),
('sql_screenshots', 16, '2025-04-15 05:33:05', 'id_543329da93784bcb', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "107039703_1744666385000_110766160_1744666385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/576e45e0626b4623bbec0362f9db6fb5.jpg", "device_id": "e3688ec8-9fd5-487a-8d5b-b2fb065dd1c4", "is_chatting": 1, "label_rate": 0, "log_seq": "67e8c57ba00e4937be8dfabbbbc1bada", "phone_model": "OnePlus_9", "rate": 0, "target_id": "107039703"}', '2025-04-15 05:33:05', 1744666385000, '2025-04-15 05:33:05'),
('sql_screenshots', 16, '2025-04-15 05:34:05', 'id_709704a7492244c9', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744666445000_64280379_1744666445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/15573d5444064a2e92ab5aa229cc2ca0.jpg", "device_id": "c1b640e8-6d8e-4609-9cf6-1ea32b027eb1", "is_chatting": 1, "label_rate": 1, "log_seq": "8866c8979baf4771b808c50063141c92", "phone_model": "VIVO_X60", "rate": 4, "target_id": "108466147"}', '2025-04-15 05:34:05', 1744666445000, '2025-04-15 05:34:05'),
('sql_screenshots', 16, '2025-04-15 05:35:05', 'id_2913f93cd46c4b01', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108466147_1744666505000_107039703_1744666505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1333685d8a014e5b870accb312d64da4.jpg", "device_id": "61e4148e-e5c1-4de9-bd7b-b50c228b787e", "is_chatting": 1, "label_rate": 0, "log_seq": "75c51e6d8519461282955ec3c9a0f806", "phone_model": "OPPO_Find_X3", "rate": 3, "target_id": "108466147"}', '2025-04-15 05:35:05', 1744666505000, '2025-04-15 05:35:05'),
('sql_screenshots', 16, '2025-04-15 05:36:05', 'id_eb18df78026d4ee3', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "28230174_1744666565000_94369556_1744666565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/270df3b116ef446db3e9644bae002f53.jpg", "device_id": "5e395c0d-3c53-4b33-9c2a-286b8f70b318", "is_chatting": 1, "label_rate": 2, "log_seq": "2ac915b1680c4665a6df73d42e6c5a4e", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "28230174"}', '2025-04-15 05:36:05', 1744666565000, '2025-04-15 05:36:05'),
('sql_screenshots', 16, '2025-04-15 05:37:05', 'id_a88e8af6a6ed44d6', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "107039703_1744666625000_108870508_1744666625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9fbe029d8187410696f069ac02b883e8.jpg", "device_id": "7b161001-2624-4584-8d8c-240c60ec9bd8", "is_chatting": 1, "label_rate": 0, "log_seq": "cbe7f1e0517343e599a8c078e44af430", "phone_model": "VIVO_X60", "rate": 2, "target_id": "107039703"}', '2025-04-15 05:37:05', 1744666625000, '2025-04-15 05:37:05'),
('sql_screenshots', 16, '2025-04-15 05:38:05', 'id_96b1f440808d49e1', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "64280379_1744666685000_109980113_1744666685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ae17cd3a206c4be3b79ddadafc1f7741.jpg", "device_id": "7582b94b-3a2e-4767-b51f-d895efdcef31", "is_chatting": 1, "label_rate": 2, "log_seq": "fd4a44acb152425f822d17ca342ed825", "phone_model": "OnePlus_9", "rate": 5, "target_id": "64280379"}', '2025-04-15 05:38:05', 1744666685000, '2025-04-15 05:38:05'),
('sql_screenshots', 16, '2025-04-15 05:39:05', 'id_7cabacd15df4423e', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "94369556_1744666745000_28230174_1744666745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1905b0eef1c6427bac0b0997117ec102.jpg", "device_id": "4d720b35-1a2c-49e1-9dcb-7d9d8f108676", "is_chatting": 1, "label_rate": 0, "log_seq": "ae0bd3abf8d94609a59349872e13b0c3", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "94369556"}', '2025-04-15 05:39:05', 1744666745000, '2025-04-15 05:39:05'),
('sql_screenshots', 16, '2025-04-15 05:40:05', 'id_b130a738751b4672', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105083641_1744666805000_109657261_1744666805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/28b63eef55a64ac3b559cc5d6d5348ec.jpg", "device_id": "bbbf1df5-b89f-4b1b-b568-d2cf22b81a63", "is_chatting": 1, "label_rate": 2, "log_seq": "7e01bc55393e4ba0ad4c05170ac4eca0", "phone_model": "VIVO_X60", "rate": 0, "target_id": "105083641"}', '2025-04-15 05:40:05', 1744666805000, '2025-04-15 05:40:05'),
('sql_screenshots', 16, '2025-04-15 05:41:05', 'id_ed9959140ecc4a5b', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744666865000_101553185_1744666865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/74ecd6716764474aa37d99705a176277.jpg", "device_id": "ed403414-e091-4605-aeba-7b803b5d98cd", "is_chatting": 1, "label_rate": 2, "log_seq": "b2628417db6e4b4a8dff471586fa8908", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "110873051"}', '2025-04-15 05:41:05', 1744666865000, '2025-04-15 05:41:05'),
('sql_screenshots', 16, '2025-04-15 05:42:05', 'id_c560ac83bc93454f', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105083641_1744666925000_54675542_1744666925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bf90d68533c6414b8db3aa21b23fca25.jpg", "device_id": "9e312fb1-f823-4734-a067-83d5bcd18de7", "is_chatting": 1, "label_rate": 2, "log_seq": "252b618898c7440883793b04a071aa47", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "105083641"}', '2025-04-15 05:42:05', 1744666925000, '2025-04-15 05:42:05'),
('sql_screenshots', 16, '2025-04-15 05:43:05', 'id_be13ec9ca259484f', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109980113_1744666985000_108870508_1744666985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/51d7ddff88334875be9a808d4a36b3b4.jpg", "device_id": "fd41faad-0a97-4b2d-a713-f871305e028c", "is_chatting": 1, "label_rate": 1, "log_seq": "03c769b4066047578b720ca81d9c2db1", "phone_model": "iPhone_13", "rate": 1, "target_id": "109980113"}', '2025-04-15 05:43:05', 1744666985000, '2025-04-15 05:43:05'),
('sql_screenshots', 16, '2025-04-15 05:44:05', 'id_b8b60fcf5a794719', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108870508_1744667045000_110892617_1744667045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/11c2a570d504435ca155efeb273a8d71.jpg", "device_id": "62391c1a-e61c-4d6d-8317-82491a0462b2", "is_chatting": 1, "label_rate": 2, "log_seq": "7dd7da51f9124ee7943cca4094eb7408", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "108870508"}', '2025-04-15 05:44:05', 1744667045000, '2025-04-15 05:44:05'),
('sql_screenshots', 16, '2025-04-15 05:45:05', 'id_64c1a8d1fb174671', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "107039703_1744667105000_110766160_1744667105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/46039075843d4729a24f4e6fd71c1c49.jpg", "device_id": "bad5cd34-999b-49fc-9eef-c69a75a87c61", "is_chatting": 1, "label_rate": 2, "log_seq": "f300327b2b58448f82c5517df677116d", "phone_model": "Huawei_P40", "rate": 3, "target_id": "107039703"}', '2025-04-15 05:45:05', 1744667105000, '2025-04-15 05:45:05'),
('sql_screenshots', 16, '2025-04-15 05:46:05', 'id_9207c2e4ea514e9d', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "104844318_1744667165000_57649476_1744667165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6bf0b37a482448b1bcccee2d402d643d.jpg", "device_id": "580e9b3e-b6ef-47d5-a617-479612ad4569", "is_chatting": 1, "label_rate": 2, "log_seq": "c9e9e077027e4c15869c7df0d5547af8", "phone_model": "VIVO_X60", "rate": 4, "target_id": "104844318"}', '2025-04-15 05:46:05', 1744667165000, '2025-04-15 05:46:05'),
('sql_screenshots', 16, '2025-04-15 05:47:05', 'id_b77076330a0c425d', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108466147_1744667225000_81479540_1744667225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/70a1b4bab1c24ba987bbefc2e6843b8d.jpg", "device_id": "cbf2ef1b-ca5f-4e1e-9788-315fa13a1605", "is_chatting": 1, "label_rate": 1, "log_seq": "e0a2447af8774cb0aad3e461aee110cf", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "108466147"}', '2025-04-15 05:47:05', 1744667225000, '2025-04-15 05:47:05'),
('sql_screenshots', 16, '2025-04-15 05:48:05', 'id_f94e7652f7a747ec', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744667285000_109407413_1744667285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/daf3854b32bc4d18a05867cd8ebbc023.jpg", "device_id": "2dc48040-5b5f-4610-afa3-6501ffa2c251", "is_chatting": 1, "label_rate": 1, "log_seq": "54ab2d0ca3ee44099c0ef6976b26b03c", "phone_model": "Samsung_S21", "rate": 2, "target_id": "109744448"}', '2025-04-15 05:48:05', 1744667285000, '2025-04-15 05:48:05'),
('sql_screenshots', 16, '2025-04-15 05:49:05', 'id_daac0f58b82c4e62', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "64280379_1744667345000_109407413_1744667345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/21b7b514dafd40e282dbee92cfb25212.jpg", "device_id": "c6d09d33-3839-4165-8712-485811b28bc8", "is_chatting": 1, "label_rate": 2, "log_seq": "26bbb5ad307948c5b9a6607f1a2698b5", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "64280379"}', '2025-04-15 05:49:05', 1744667345000, '2025-04-15 05:49:05'),
('sql_screenshots', 16, '2025-04-15 05:50:05', 'id_83f4c75eca754446', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "94369556_1744667405000_110766160_1744667405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9721da0551024732adf68d23283c87e8.jpg", "device_id": "6fa0b526-a6bf-4910-bc17-99fbe5c10aaf", "is_chatting": 1, "label_rate": 0, "log_seq": "6c1b6fb018d246928c30fd68d83ced4a", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "94369556"}', '2025-04-15 05:50:05', 1744667405000, '2025-04-15 05:50:05'),
('sql_screenshots', 16, '2025-04-15 05:51:05', 'id_d48cc5d0b580474f', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "82365582_1744667465000_57649476_1744667465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bb2c93ac91454054906dc10bb9fa592f.jpg", "device_id": "fe297767-70c4-4a7a-a34b-3a4a80a00794", "is_chatting": 1, "label_rate": 2, "log_seq": "aa0eb55c4fbd4d22957b7e1b69cf5f13", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "82365582"}', '2025-04-15 05:51:05', 1744667465000, '2025-04-15 05:51:05'),
('sql_screenshots', 16, '2025-04-15 05:52:05', 'id_8162a765834d45c5', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105083641_1744667525000_110766160_1744667525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5278ef5ef5bb4ec58eadd73a5e0c4bbd.jpg", "device_id": "f1e45d65-97af-4d83-81bd-f998fb1380bc", "is_chatting": 1, "label_rate": 0, "log_seq": "cf89850b8e934477a7e3794257fc0883", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "105083641"}', '2025-04-15 05:52:05', 1744667525000, '2025-04-15 05:52:05'),
('sql_screenshots', 16, '2025-04-15 05:53:05', 'id_25d636426f6b4b9b', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110892617_1744667585000_104844318_1744667585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/38ea825f1bc74af594314f141f134786.jpg", "device_id": "3f3d3e6f-dcc4-4406-b6bf-b45980b9d49a", "is_chatting": 1, "label_rate": 0, "log_seq": "0abe61c9928c43e7bf322e5cba47c64f", "phone_model": "Samsung_S22", "rate": 2, "target_id": "110892617"}', '2025-04-15 05:53:05', 1744667585000, '2025-04-15 05:53:05'),
('sql_screenshots', 16, '2025-04-15 05:54:05', 'id_5223e56c29f54694', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744667645000_109657261_1744667645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0f454e85acbd49cc9122d4070c0d5f32.jpg", "device_id": "a877229b-b5bb-4651-ad38-d8755ff7be0f", "is_chatting": 1, "label_rate": 2, "log_seq": "408caf7914c94f3d994381b6d9930c1d", "phone_model": "OnePlus_9", "rate": 0, "target_id": "110876251"}', '2025-04-15 05:54:05', 1744667645000, '2025-04-15 05:54:05'),
('sql_screenshots', 16, '2025-04-15 05:55:05', 'id_acef99b71d844649', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "81479540_1744667705000_109657261_1744667705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/91b38a0a27e7423cb7b17f948439673c.jpg", "device_id": "6292cc67-d8d0-44a6-b2d6-93d8e16457e3", "is_chatting": 1, "label_rate": 0, "log_seq": "a2ec5ee9337c4a39a5b15bfac4419801", "phone_model": "iPhone_13", "rate": 4, "target_id": "81479540"}', '2025-04-15 05:55:05', 1744667705000, '2025-04-15 05:55:05'),
('sql_screenshots', 16, '2025-04-15 05:56:05', 'id_fb33885875c84766', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "32970671_1744667765000_82365582_1744667765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2d59c88a77b6464c9ea18ffed12d500f.jpg", "device_id": "9bec9336-b081-41f0-b08b-6211e2b092b9", "is_chatting": 1, "label_rate": 0, "log_seq": "2135a019c02e47068086737b335f8b8a", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "32970671"}', '2025-04-15 05:56:05', 1744667765000, '2025-04-15 05:56:05'),
('sql_screenshots', 16, '2025-04-15 05:57:05', 'id_26177372accb4c61', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110766160_1744667825000_101553185_1744667825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c209e0781c624879b2d51126c67e0a57.jpg", "device_id": "cd20a071-4263-4e8f-b8ed-20f0d74bf014", "is_chatting": 1, "label_rate": 1, "log_seq": "b7eaa8c263dc4277b1ed8756aebd23af", "phone_model": "Samsung_S21", "rate": 5, "target_id": "110766160"}', '2025-04-15 05:57:05', 1744667825000, '2025-04-15 05:57:05'),
('sql_screenshots', 16, '2025-04-15 05:58:05', 'id_d8df47af22924aa5', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109657261_1744667885000_110215081_1744667885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6aaefa9e193145d0908fa1ba239566c9.jpg", "device_id": "bb5a2ce2-567e-401d-95d3-4caf13d4455b", "is_chatting": 1, "label_rate": 2, "log_seq": "95846fa09e1a457195ef6026ca3c5512", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "109657261"}', '2025-04-15 05:58:05', 1744667885000, '2025-04-15 05:58:05'),
('sql_screenshots', 16, '2025-04-15 05:59:05', 'id_bd460804605d4a9f', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105503656_1744667945000_108870508_1744667945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4a905c23bb5a46b995eff5d929e23870.jpg", "device_id": "47845d63-8253-4710-943d-c6337c50d5ca", "is_chatting": 1, "label_rate": 0, "log_seq": "8592a7dd925c420e980fb2a098275fb5", "phone_model": "OnePlus_9", "rate": 1, "target_id": "105503656"}', '2025-04-15 05:59:05', 1744667945000, '2025-04-15 05:59:05'),
('sql_screenshots', 16, '2025-04-15 06:00:05', 'id_2ac5fefb71494d4d', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "87571440_1744668005000_94369556_1744668005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4b483fe1ce0b4ef286fb938d7e1cbb88.jpg", "device_id": "440db225-20fa-40e6-971b-cbb46ddc829c", "is_chatting": 1, "label_rate": 2, "log_seq": "10b1564eb11c48c092eee99f8858f0e8", "phone_model": "VIVO_X60", "rate": 1, "target_id": "87571440"}', '2025-04-15 06:00:05', 1744668005000, '2025-04-15 06:00:05'),
('sql_screenshots', 16, '2025-04-15 06:01:05', 'id_26ff0fda5a0b48b9', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "82365582_1744668065000_28230174_1744668065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5f11062d348e430f8f60497a4d687dd4.jpg", "device_id": "6b7a61c1-a977-420e-b635-8c0ecc196299", "is_chatting": 1, "label_rate": 0, "log_seq": "6163586d43dd4513853748622535c905", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "82365582"}', '2025-04-15 06:01:05', 1744668065000, '2025-04-15 06:01:05'),
('sql_screenshots', 16, '2025-04-15 06:02:05', 'id_f026a3d8ba2f457c', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110215081_1744668125000_82365582_1744668125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0f9c17df89a643a9ae15d03c95fa84b5.jpg", "device_id": "a308ceb0-252d-4a28-9ca0-fff25f12eefd", "is_chatting": 1, "label_rate": 1, "log_seq": "ee71723a309c43e89043b7753e36e995", "phone_model": "OnePlus_9", "rate": 5, "target_id": "110215081"}', '2025-04-15 06:02:05', 1744668125000, '2025-04-15 06:02:05'),
('sql_screenshots', 16, '2025-04-15 06:03:05', 'id_a7eaa4d719f04f80', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109657261_1744668185000_101553185_1744668185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7ecff361416b445094169d41c67e926e.jpg", "device_id": "439beb97-ed97-44ad-ba8d-13b5f86196b6", "is_chatting": 1, "label_rate": 2, "log_seq": "49a3b1b4f9694113b7c4288b5e2a3ce5", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "109657261"}', '2025-04-15 06:03:05', 1744668185000, '2025-04-15 06:03:05'),
('sql_screenshots', 16, '2025-04-15 06:04:05', 'id_c743b668aa3e4cdb', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110766160_1744668245000_110892617_1744668245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/54b7dd839c4440a5bf3f463c24c56f1c.jpg", "device_id": "11bb608f-bdcf-4a6b-ab65-b954d7d751e9", "is_chatting": 1, "label_rate": 2, "log_seq": "21edc3d24a6240248c12077755058cd9", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "110766160"}', '2025-04-15 06:04:05', 1744668245000, '2025-04-15 06:04:05'),
('sql_screenshots', 16, '2025-04-15 06:05:05', 'id_f4789e7d9d294d97', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "83341608_1744668305000_108466147_1744668305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f6690b89f4694dd4afd5e22f87c47b5d.jpg", "device_id": "dfe4e69e-8bc7-404c-b61f-eb2083ddd0b7", "is_chatting": 1, "label_rate": 0, "log_seq": "d9254ca1261545e3a6c982d2079d72b3", "phone_model": "Huawei_P40", "rate": 4, "target_id": "83341608"}', '2025-04-15 06:05:05', 1744668305000, '2025-04-15 06:05:05'),
('sql_screenshots', 16, '2025-04-15 06:06:05', 'id_edd4eea56b824720', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744668365000_109980113_1744668365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b3c961aad44c44d79471447116733914.jpg", "device_id": "dfbbe6c2-3ca7-4183-9bbf-138ceb72020a", "is_chatting": 1, "label_rate": 2, "log_seq": "12b0eb60d3344139a7c24c6b889d8825", "phone_model": "VIVO_X60", "rate": 5, "target_id": "107039703"}', '2025-04-15 06:06:05', 1744668365000, '2025-04-15 06:06:05'),
('sql_screenshots', 16, '2025-04-15 06:07:05', 'id_a4b2744a430144bf', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108870508_1744668425000_110766160_1744668425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/134f07379f8e4f74b703bd0bc9c23a75.jpg", "device_id": "e1efbac6-2d06-4374-9689-ee596e6e76f9", "is_chatting": 1, "label_rate": 2, "log_seq": "c76dda43ee2f43638d45d0f0b0c8c1d8", "phone_model": "Samsung_S22", "rate": 3, "target_id": "108870508"}', '2025-04-15 06:07:05', 1744668425000, '2025-04-15 06:07:05'),
('sql_screenshots', 16, '2025-04-15 06:08:05', 'id_c6a3280b482c4469', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744668485000_83341608_1744668485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/393ef49317c24168816a4b298decaf21.jpg", "device_id": "4435251d-92e6-46e0-9b9b-acf6f5fd0a95", "is_chatting": 1, "label_rate": 1, "log_seq": "cd48869117164f33af5cff7d46c55153", "phone_model": "VIVO_X60", "rate": 3, "target_id": "32970671"}', '2025-04-15 06:08:05', 1744668485000, '2025-04-15 06:08:05'),
('sql_screenshots', 16, '2025-04-15 06:09:05', 'id_bbb7e896082e4c95', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105503656_1744668545000_94369556_1744668545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ca16bef32c2644bf8a5cbd1482edde46.jpg", "device_id": "3468f723-c341-490b-bcb0-621329c07261", "is_chatting": 1, "label_rate": 1, "log_seq": "0102012de95e464ba5a4dbdacddcec1a", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "105503656"}', '2025-04-15 06:09:05', 1744668545000, '2025-04-15 06:09:05'),
('sql_screenshots', 16, '2025-04-15 06:10:05', 'id_74d434351d33453b', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "82365582_1744668605000_110890469_1744668605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b3f7be92859747eabaa84f51eb7854e2.jpg", "device_id": "a682773c-0dc9-46fd-b925-00fd901b1295", "is_chatting": 1, "label_rate": 0, "log_seq": "398cf5d69c544761a124a324de747b46", "phone_model": "VIVO_X60", "rate": 1, "target_id": "82365582"}', '2025-04-15 06:10:05', 1744668605000, '2025-04-15 06:10:05'),
('sql_screenshots', 16, '2025-04-15 06:11:05', 'id_5cd47cab58bc496f', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110215081_1744668665000_110890469_1744668665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/85cd996396734dd0be477aec31a00f30.jpg", "device_id": "892bd346-5e07-451d-8182-9aea4915d4ef", "is_chatting": 1, "label_rate": 1, "log_seq": "c5c124d940c74b16b9e075b0e8201419", "phone_model": "Samsung_S21", "rate": 2, "target_id": "110215081"}', '2025-04-15 06:11:05', 1744668665000, '2025-04-15 06:11:05'),
('sql_screenshots', 16, '2025-04-15 06:12:05', 'id_dea85b80a75f4a92', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "28230174_1744668725000_110766160_1744668725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/abfd97e707a54747850387fb8d33d8ce.jpg", "device_id": "c1bf2260-778c-48b3-8157-24da81ab748f", "is_chatting": 1, "label_rate": 0, "log_seq": "488c9374cecf4e9ca9df79217bbaabd9", "phone_model": "iPhone_13", "rate": 3, "target_id": "28230174"}', '2025-04-15 06:12:05', 1744668725000, '2025-04-15 06:12:05'),
('sql_screenshots', 16, '2025-04-15 06:13:05', 'id_435c949dfcb84495', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "82365582_1744668785000_54675542_1744668785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bc989cf795d5426481dbe68ac514e1d4.jpg", "device_id": "8adaba1f-d4c1-49a5-a6b4-9d1d7be1bfe2", "is_chatting": 1, "label_rate": 1, "log_seq": "485bd08484304911b19158fbb33f0eac", "phone_model": "Samsung_S22", "rate": 1, "target_id": "82365582"}', '2025-04-15 06:13:05', 1744668785000, '2025-04-15 06:13:05'),
('sql_screenshots', 16, '2025-04-15 06:14:05', 'id_a3703ee2593d4f25', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744668845000_110215081_1744668845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bdff8761df18448cbbe5643388b30325.jpg", "device_id": "9f65232e-d8ef-4a31-91c2-f6ed219680ca", "is_chatting": 1, "label_rate": 1, "log_seq": "f97eef9b542849128f32b00619477e20", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "82365582"}', '2025-04-15 06:14:05', 1744668845000, '2025-04-15 06:14:05'),
('sql_screenshots', 16, '2025-04-15 06:15:05', 'id_ac02f63812ef4707', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110892617_1744668905000_110873051_1744668905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/898a58045776487eb9cc37f21143dcad.jpg", "device_id": "26dc716d-1323-4fe4-898d-64753fd62d9e", "is_chatting": 1, "label_rate": 0, "log_seq": "18ec499690b14944b189c66f4e8f835f", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "110892617"}', '2025-04-15 06:15:05', 1744668905000, '2025-04-15 06:15:05'),
('sql_screenshots', 16, '2025-04-15 06:16:05', 'id_468ea8a2cc0c4b09', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "104844318_1744668965000_110873051_1744668965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9b75c703d9684d8da681050f65396fa5.jpg", "device_id": "a08d10d0-6126-42b3-879c-a9a518fc62e1", "is_chatting": 1, "label_rate": 0, "log_seq": "41b3e7bbe6be428c9d27ec249f955eaa", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "104844318"}', '2025-04-15 06:16:05', 1744668965000, '2025-04-15 06:16:05'),
('sql_screenshots', 16, '2025-04-15 06:17:05', 'id_1a46da981a5d456e', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109407413_1744669025000_110892617_1744669025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6e5ecae8adcd40bfbf066768127bfcf8.jpg", "device_id": "8da98550-6274-4c4a-90d6-d864e2a2b99b", "is_chatting": 1, "label_rate": 2, "log_seq": "f5f5fba047db40b99c3ae61ae7df0b86", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "109407413"}', '2025-04-15 06:17:05', 1744669025000, '2025-04-15 06:17:05'),
('sql_screenshots', 16, '2025-04-15 06:18:05', 'id_959489311e664867', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "57649476_1744669085000_108466147_1744669085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2178549b6c8b4cda8921bec008d67638.jpg", "device_id": "1f2d2ce8-5ee4-4484-b18f-ef424b69514c", "is_chatting": 1, "label_rate": 2, "log_seq": "0ccf2687d8a74d378b07ce7c041a5f30", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "57649476"}', '2025-04-15 06:18:05', 1744669085000, '2025-04-15 06:18:05'),
('sql_screenshots', 16, '2025-04-15 06:19:05', 'id_1c52466f8a3f40e0', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110890469_1744669145000_64280379_1744669145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f9efc567dd8949fa89ace0d815f05488.jpg", "device_id": "fa8741bd-679c-4072-8f89-7f6419a7f446", "is_chatting": 1, "label_rate": 0, "log_seq": "81be5a96caf84ba08ede7e9cac8990d5", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "110890469"}', '2025-04-15 06:19:05', 1744669145000, '2025-04-15 06:19:05'),
('sql_screenshots', 16, '2025-04-15 06:20:05', 'id_55f1b5a2406044f1', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "82365582_1744669205000_105083641_1744669205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/37672465af47499abea44a1e1f375a25.jpg", "device_id": "35997ae5-6905-4070-b6df-50fcdd09043e", "is_chatting": 1, "label_rate": 2, "log_seq": "671e005ec434457ab5f465f88fba2650", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "82365582"}', '2025-04-15 06:20:05', 1744669205000, '2025-04-15 06:20:05'),
('sql_screenshots', 16, '2025-04-15 06:21:05', 'id_feb2c852d3624c57', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110215081_1744669265000_110890469_1744669265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5fad0693da414319974db82ed79da547.jpg", "device_id": "6272a2fd-433b-4ea1-9c5f-d8135fc7d147", "is_chatting": 1, "label_rate": 2, "log_seq": "6d105b1f8ecd4478a11f354f8ebd6a0e", "phone_model": "Huawei_P40", "rate": 2, "target_id": "110215081"}', '2025-04-15 06:21:05', 1744669265000, '2025-04-15 06:21:05'),
('sql_screenshots', 16, '2025-04-15 06:22:05', 'id_8b44a28442ad4dfb', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "94369556_1744669325000_108870508_1744669325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/39f79b59fc874a19844aa1c6ed177cae.jpg", "device_id": "90758ccf-8b83-4480-a7a7-edb8158328df", "is_chatting": 1, "label_rate": 0, "log_seq": "6f345a6d83ed40e98ff2cfd26d14304a", "phone_model": "VIVO_X60", "rate": 5, "target_id": "94369556"}', '2025-04-15 06:22:05', 1744669325000, '2025-04-15 06:22:05'),
('sql_screenshots', 16, '2025-04-15 06:23:05', 'id_9a15ee466e6b4c02', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "83341608_1744669385000_110890469_1744669385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2d3e1151425d4ade9184c0a0a8504e99.jpg", "device_id": "8623d33c-6755-4f66-a784-e265b87418dc", "is_chatting": 1, "label_rate": 2, "log_seq": "d08177f57fa24c6eaf706bf2f4953f3d", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "83341608"}', '2025-04-15 06:23:05', 1744669385000, '2025-04-15 06:23:05'),
('sql_screenshots', 16, '2025-04-15 06:24:05', 'id_65681f460073402a', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "101553185_1744669445000_104844318_1744669445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e304daccfb124ff9949463251e331302.jpg", "device_id": "02a7e15d-fd01-4774-8100-6f836aa035c9", "is_chatting": 1, "label_rate": 2, "log_seq": "ebe097416f2a474ea7e49562314e22ea", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "101553185"}', '2025-04-15 06:24:05', 1744669445000, '2025-04-15 06:24:05'),
('sql_screenshots', 16, '2025-04-15 06:25:05', 'id_d95863b43fd04310', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109407413_1744669505000_109980113_1744669505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5580d57a3d7c4751941b56e1b19e3426.jpg", "device_id": "d5d40739-e563-4ef4-9bec-eb68935b134b", "is_chatting": 1, "label_rate": 1, "log_seq": "b4cd9b83c4bf4a33b275329021b07d6d", "phone_model": "Huawei_P40", "rate": 4, "target_id": "109407413"}', '2025-04-15 06:25:05', 1744669505000, '2025-04-15 06:25:05'),
('sql_screenshots', 16, '2025-04-15 06:26:05', 'id_993177ed23e1459d', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105083641_1744669565000_28230174_1744669565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d31fbbceb1a64b7b9047daa481d78ec6.jpg", "device_id": "cfba61ba-2f7f-412a-b021-12ba1ca297ed", "is_chatting": 1, "label_rate": 2, "log_seq": "a2c281fb00db4b03bd2a3abf073933df", "phone_model": "Huawei_P40", "rate": 4, "target_id": "105083641"}', '2025-04-15 06:26:05', 1744669565000, '2025-04-15 06:26:05'),
('sql_screenshots', 16, '2025-04-15 06:27:05', 'id_079c83b6c76c482e', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "28230174_1744669625000_110215081_1744669625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e8d866083ca847b2a40d4106e3197ccc.jpg", "device_id": "62a175cd-9771-41e3-ba48-140f1ffcff28", "is_chatting": 1, "label_rate": 2, "log_seq": "c039e7422f3643dd868d7a0d0bf027ed", "phone_model": "VIVO_X60", "rate": 0, "target_id": "28230174"}', '2025-04-15 06:27:05', 1744669625000, '2025-04-15 06:27:05'),
('sql_screenshots', 16, '2025-04-15 06:28:05', 'id_e8416d3d52274e0f', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110215081_1744669685000_32970671_1744669685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/446e2b004b594979bf5ffab530fa3838.jpg", "device_id": "945f167c-bf8f-4a0e-ad38-5059f53d9d58", "is_chatting": 1, "label_rate": 1, "log_seq": "3f645ef0f0d14a3ea753422c6eb35b88", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "110215081"}', '2025-04-15 06:28:05', 1744669685000, '2025-04-15 06:28:05'),
('sql_screenshots', 16, '2025-04-15 06:29:05', 'id_cdf3850fd8214306', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "94369556_1744669745000_87571440_1744669745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2c828e4bd57f411ebfe4904583131004.jpg", "device_id": "384f9c3d-41f2-4d05-8a3d-719f9e73671c", "is_chatting": 1, "label_rate": 2, "log_seq": "397f800597a8490abefb094786e9a95c", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "94369556"}', '2025-04-15 06:29:05', 1744669745000, '2025-04-15 06:29:05'),
('sql_screenshots', 16, '2025-04-15 06:30:05', 'id_f6796b538e9345f1', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "107039703_1744669805000_110890469_1744669805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7de09aa7a6c64aaeb3d44150c89ea1d3.jpg", "device_id": "5bbe11f1-a018-422c-a62c-f80c2806023d", "is_chatting": 1, "label_rate": 2, "log_seq": "72af486b0eb8494ab6ba71c93940faff", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "107039703"}', '2025-04-15 06:30:05', 1744669805000, '2025-04-15 06:30:05'),
('sql_screenshots', 16, '2025-04-15 06:31:05', 'id_450cd5f2039149e7', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "57649476_1744669865000_110873051_1744669865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/feb4a47b664343f0bd29a95c92068e5d.jpg", "device_id": "87f9e363-13b1-48f0-8753-2c64b975aa01", "is_chatting": 1, "label_rate": 1, "log_seq": "e1e0c04f009f44229357b3ed8aa8835c", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "57649476"}', '2025-04-15 06:31:05', 1744669865000, '2025-04-15 06:31:05'),
('sql_screenshots', 16, '2025-04-15 06:32:05', 'id_7993f08ea3b145de', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "54675542_1744669925000_64280379_1744669925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9d74086aa2764654879507d0823fe5d1.jpg", "device_id": "b563bf1d-693c-4dd7-a8f3-dd9e4d14af8d", "is_chatting": 1, "label_rate": 1, "log_seq": "c5c875fe13d2479ab8bf4355dbfdf331", "phone_model": "VIVO_X60", "rate": 3, "target_id": "54675542"}', '2025-04-15 06:32:05', 1744669925000, '2025-04-15 06:32:05'),
('sql_screenshots', 16, '2025-04-15 06:33:05', 'id_b29979d629ea4c39', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "64280379_1744669985000_104844318_1744669985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/21738e1f1467438e9ec936174e8c830b.jpg", "device_id": "123d2f5e-e670-4236-9f6b-528672eeaa08", "is_chatting": 1, "label_rate": 0, "log_seq": "3cff4a5c438b49d9b13b2a6057014c79", "phone_model": "OnePlus_9", "rate": 1, "target_id": "64280379"}', '2025-04-15 06:33:05', 1744669985000, '2025-04-15 06:33:05'),
('sql_screenshots', 16, '2025-04-15 06:34:05', 'id_04cf3c25c76d4555', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "81479540_1744670045000_110215081_1744670045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/159c1948adb44b558abc659cb2765ddf.jpg", "device_id": "17d9d017-2d5c-4499-a2f3-34c24a905bdc", "is_chatting": 1, "label_rate": 0, "log_seq": "8d155d70ebde4800964114077811f32b", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "81479540"}', '2025-04-15 06:34:05', 1744670045000, '2025-04-15 06:34:05'),
('sql_screenshots', 16, '2025-04-15 06:35:05', 'id_88fd90741cb34a15', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "107039703_1744670105000_110890469_1744670105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/17ce95adf03049beb9bcb8818185d3cc.jpg", "device_id": "d56c8306-9a4d-426b-a180-a74454eefb3e", "is_chatting": 1, "label_rate": 1, "log_seq": "871e3d49965148c3ac82fe692b9cee7a", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "107039703"}', '2025-04-15 06:35:05', 1744670105000, '2025-04-15 06:35:05'),
('sql_screenshots', 16, '2025-04-15 06:36:05', 'id_0e7af39600f849cc', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "28230174_1744670165000_54675542_1744670165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6b27321e9eed4fcc9125fcf19b8fb9d2.jpg", "device_id": "d29bcfd4-0303-4176-a33c-fb7a59750c72", "is_chatting": 1, "label_rate": 0, "log_seq": "5f6343c954d74beea135809f813d042d", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "28230174"}', '2025-04-15 06:36:05', 1744670165000, '2025-04-15 06:36:05'),
('sql_screenshots', 16, '2025-04-15 06:37:05', 'id_683903dbdfb449b7', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110766160_1744670225000_82365582_1744670225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9a85e16cae724ccbaa92aa2638320615.jpg", "device_id": "18d1bd84-f13a-468a-8b55-e2234a79bd8f", "is_chatting": 1, "label_rate": 1, "log_seq": "c996f1adf8a94c0b873b7ac4b24930fd", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "110766160"}', '2025-04-15 06:37:05', 1744670225000, '2025-04-15 06:37:05'),
('sql_screenshots', 16, '2025-04-15 06:38:05', 'id_d0a314c16cfa4a24', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744670285000_110766160_1744670285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d01b7623dac24e959bf900b911c8376e.jpg", "device_id": "cd6c45fd-0c9d-4e91-8a89-a446808fecff", "is_chatting": 1, "label_rate": 1, "log_seq": "15e50e5438b14587939e8dfa6863ae7d", "phone_model": "Samsung_S22", "rate": 2, "target_id": "87571440"}', '2025-04-15 06:38:05', 1744670285000, '2025-04-15 06:38:05'),
('sql_screenshots', 16, '2025-04-15 06:39:05', 'id_2847ed901f8a4042', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109407413_1744670345000_110892617_1744670345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bb76d07c7ca04d17becb6dc02fbceb36.jpg", "device_id": "36242381-6e5f-4c1b-ae4d-37fa3690389e", "is_chatting": 1, "label_rate": 1, "log_seq": "ff6444df8e3943aca31c91373e10d50a", "phone_model": "Samsung_S22", "rate": 1, "target_id": "109407413"}', '2025-04-15 06:39:05', 1744670345000, '2025-04-15 06:39:05'),
('sql_screenshots', 16, '2025-04-15 06:40:05', 'id_2c82684d8ccd4ec7', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "28230174_1744670405000_87571440_1744670405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7476f8ae1a9f4aaba1e4e242444b11e3.jpg", "device_id": "bc1cf4c1-200c-4b8e-be2b-f2ee254bf6c0", "is_chatting": 1, "label_rate": 0, "log_seq": "53b87c2bbc734a7fb11bdf91e032ba5e", "phone_model": "VIVO_X60", "rate": 1, "target_id": "28230174"}', '2025-04-15 06:40:05', 1744670405000, '2025-04-15 06:40:05'),
('sql_screenshots', 16, '2025-04-15 06:41:05', 'id_07b34300440f4e1e', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "82365582_1744670465000_64280379_1744670465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/95f6d0617dd644a2be1267ddf89b069f.jpg", "device_id": "85447d08-ab5f-433f-b471-c0d1ff1350df", "is_chatting": 1, "label_rate": 2, "log_seq": "4f32f4206a43416c8e9d38dec42f474c", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "82365582"}', '2025-04-15 06:41:05', 1744670465000, '2025-04-15 06:41:05'),
('sql_screenshots', 16, '2025-04-15 06:42:05', 'id_dd2fa3c23f2245f8', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105503656_1744670525000_110873051_1744670525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d252cf36463f418ca5c29245a0743647.jpg", "device_id": "2580ac80-5234-43e0-999f-663326c2c7f2", "is_chatting": 1, "label_rate": 1, "log_seq": "47adc6de56eb44dea67c49a55a112250", "phone_model": "iPhone_13", "rate": 2, "target_id": "105503656"}', '2025-04-15 06:42:05', 1744670525000, '2025-04-15 06:42:05'),
('sql_screenshots', 16, '2025-04-15 06:43:05', 'id_7f726b85c1994856', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "94369556_1744670585000_108870508_1744670585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1d6b8717724140928d94f3a9102ad736.jpg", "device_id": "345cff14-2ea3-4976-a4cf-a854920ae4c1", "is_chatting": 1, "label_rate": 2, "log_seq": "7e1ee3975dc04f06899ab985016dd2af", "phone_model": "VIVO_X60", "rate": 2, "target_id": "94369556"}', '2025-04-15 06:43:05', 1744670585000, '2025-04-15 06:43:05'),
('sql_screenshots', 16, '2025-04-15 06:44:05', 'id_cc03ac88643b438b', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "82365582_1744670645000_94369556_1744670645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/04405e5840364cdca93705ef7bbfa332.jpg", "device_id": "7b9ce23e-ffa5-4d5b-b779-8cb2e554b33e", "is_chatting": 1, "label_rate": 0, "log_seq": "cfc755d06c884520a0ea941b0ad1d35d", "phone_model": "VIVO_X60", "rate": 4, "target_id": "82365582"}', '2025-04-15 06:44:05', 1744670645000, '2025-04-15 06:44:05'),
('sql_screenshots', 16, '2025-04-15 06:45:05', 'id_edcd0b45178c47d4', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110876251_1744670705000_110892617_1744670705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/2664f03c30ed420898a7321414605f9c.jpg", "device_id": "82c5430f-cea3-46d3-9364-117c39e4cc16", "is_chatting": 1, "label_rate": 0, "log_seq": "f87c2803ec994eae93636868024bd32c", "phone_model": "Samsung_S21", "rate": 4, "target_id": "110876251"}', '2025-04-15 06:45:05', 1744670705000, '2025-04-15 06:45:05'),
('sql_screenshots', 16, '2025-04-15 06:46:05', 'id_75a1f5c243434fcf', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "104844318_1744670765000_110876251_1744670765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6554916355c84572b048ecd7a7900f6d.jpg", "device_id": "9d965354-63f8-4c23-8f88-337d762b45f8", "is_chatting": 1, "label_rate": 1, "log_seq": "42604aa0107d445391fc438e7cae54b7", "phone_model": "iPhone_13", "rate": 0, "target_id": "104844318"}', '2025-04-15 06:46:05', 1744670765000, '2025-04-15 06:46:05'),
('sql_screenshots', 16, '2025-04-15 06:47:05', 'id_506fac412bf2417b', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "83341608_1744670825000_108466147_1744670825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/71cc99613aaf4803b00b9c3a1f214e93.jpg", "device_id": "15414737-94bc-4a1d-b60d-8c852100c981", "is_chatting": 1, "label_rate": 2, "log_seq": "9e43ef4d17464ba7bbc6a2c191a686e8", "phone_model": "iPhone_13", "rate": 4, "target_id": "83341608"}', '2025-04-15 06:47:05', 1744670825000, '2025-04-15 06:47:05'),
('sql_screenshots', 16, '2025-04-15 06:48:05', 'id_84a95c7817cd4e5b', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "105083641_1744670885000_32970671_1744670885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7208471f0a4c491cade31a73bd44615b.jpg", "device_id": "82c46fbe-2517-4afb-a3ba-0464f0419811", "is_chatting": 1, "label_rate": 0, "log_seq": "ca27a24e2a8e4194bca50696ebc5cc2e", "phone_model": "Huawei_P40", "rate": 2, "target_id": "105083641"}', '2025-04-15 06:48:05', 1744670885000, '2025-04-15 06:48:05'),
('sql_screenshots', 16, '2025-04-15 06:49:05', 'id_8147aace8f51467e', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110766160_1744670945000_110892617_1744670945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4b0372b9aa264077afa424ca7972b56e.jpg", "device_id": "17b8ef88-16bd-47e0-82f8-2063867c27e3", "is_chatting": 1, "label_rate": 2, "log_seq": "82cc5def6fe3492e819ed64883e4c466", "phone_model": "Huawei_P40", "rate": 2, "target_id": "110766160"}', '2025-04-15 06:49:05', 1744670945000, '2025-04-15 06:49:05'),
('sql_screenshots', 16, '2025-04-15 06:50:05', 'id_9572b59c811f44e9', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "54675542_1744671005000_110892617_1744671005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/355bc63469f2414eb94a0503a4070c31.jpg", "device_id": "19da0fb4-7c92-45fc-b68e-9601bc28201f", "is_chatting": 1, "label_rate": 1, "log_seq": "15c8f7b9953c4f6085615dc810d78ec1", "phone_model": "OPPO_Find_X3", "rate": 1, "target_id": "54675542"}', '2025-04-15 06:50:05', 1744671005000, '2025-04-15 06:50:05'),
('sql_screenshots', 16, '2025-04-15 06:51:05', 'id_9bbae543bc4c4a7b', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109407413_1744671065000_28230174_1744671065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ad4e5412bb71478dad3df8536eebdf34.jpg", "device_id": "27c431e7-3227-450f-8fe9-0201d659ced0", "is_chatting": 1, "label_rate": 2, "log_seq": "162a52a4d9484d6b91a6ba8759bc370d", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "109407413"}', '2025-04-15 06:51:05', 1744671065000, '2025-04-15 06:51:05'),
('sql_screenshots', 16, '2025-04-15 06:52:05', 'id_ec3963cf59a54958', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110215081_1744671125000_109657261_1744671125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ae54af56340346f88247eb7f31528bf5.jpg", "device_id": "c68d3bc4-ae85-48c1-a43f-2f5e91ba460b", "is_chatting": 1, "label_rate": 1, "log_seq": "d5ad76386b584996add4c0c3e2faafb7", "phone_model": "Samsung_S21", "rate": 4, "target_id": "110215081"}', '2025-04-15 06:52:05', 1744671125000, '2025-04-15 06:52:05'),
('sql_screenshots', 16, '2025-04-15 06:53:05', 'id_3cb9a2f3ccf6462a', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744671185000_109980113_1744671185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b46f0af91d5f4d35bc1c5c248b0792af.jpg", "device_id": "b0d7f32c-ee2f-4b22-b68a-0e72960020da", "is_chatting": 1, "label_rate": 1, "log_seq": "b33665ffce244829961b355ddb7e5e41", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "110766160"}', '2025-04-15 06:53:05', 1744671185000, '2025-04-15 06:53:05'),
('sql_screenshots', 16, '2025-04-15 06:54:05', 'id_839bce13d0a5498a', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744671245000_101553185_1744671245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0895cd57912e4abcaf0316980f0bf115.jpg", "device_id": "642b0b52-5cd8-4e39-8172-f6126455c93f", "is_chatting": 1, "label_rate": 0, "log_seq": "e293931fd71c4ccf98eb1da7fabd7f54", "phone_model": "OnePlus_9", "rate": 5, "target_id": "81479540"}', '2025-04-15 06:54:05', 1744671245000, '2025-04-15 06:54:05'),
('sql_screenshots', 16, '2025-04-15 06:55:05', 'id_9dde4e03a83f46b3', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "101553185_1744671305000_109657261_1744671305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7a92f30be73a473a88db5e6920b9e2b9.jpg", "device_id": "39f713ff-5e65-41ef-9cbc-5cc2e2b03c0f", "is_chatting": 1, "label_rate": 1, "log_seq": "9ff47d03ef1b464aa47a6bd1435c555a", "phone_model": "Huawei_P40", "rate": 0, "target_id": "101553185"}', '2025-04-15 06:55:05', 1744671305000, '2025-04-15 06:55:05'),
('sql_screenshots', 16, '2025-04-15 06:56:05', 'id_86fe72bc9d5b4f8d', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744671365000_108870508_1744671365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/82e45dd0b6f549689c5bd619f3da5fb8.jpg", "device_id": "f3ad099f-3cc1-43dd-9087-0743afc3dd2c", "is_chatting": 1, "label_rate": 1, "log_seq": "5735ffc9a40548f287711b73192afd91", "phone_model": "Huawei_P40", "rate": 5, "target_id": "109657261"}', '2025-04-15 06:56:05', 1744671365000, '2025-04-15 06:56:05'),
('sql_screenshots', 16, '2025-04-15 06:57:05', 'id_1da5e9cce82e4417', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110215081_1744671425000_110873051_1744671425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/09a72cccfd834152a4b089f0aab37f7b.jpg", "device_id": "3f647328-c342-4233-81d5-10b236e9a175", "is_chatting": 1, "label_rate": 0, "log_seq": "31e5188f61ce45f490ffe40139b4f6c6", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "110215081"}', '2025-04-15 06:57:05', 1744671425000, '2025-04-15 06:57:05'),
('sql_screenshots', 16, '2025-04-15 06:58:05', 'id_ff9f92994e9b4968', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "108466147_1744671485000_107039703_1744671485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5a42ab9181a54e1cbe5684a23db43b49.jpg", "device_id": "f8aab5aa-5f93-4711-a1cf-35b619d6594e", "is_chatting": 1, "label_rate": 2, "log_seq": "09d3b11f716a4af689bd881954dba31c", "phone_model": "VIVO_X60", "rate": 1, "target_id": "108466147"}', '2025-04-15 06:58:05', 1744671485000, '2025-04-15 06:58:05'),
('sql_screenshots', 16, '2025-04-15 06:59:05', 'id_f4e28ace68ca4cb8', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110890469_1744671545000_83341608_1744671545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6c1e14e971c3449581a4da0af42fddd1.jpg", "device_id": "8367473d-041c-4bda-b7b1-6a3e93b2b4ed", "is_chatting": 1, "label_rate": 1, "log_seq": "d82041e6a29f4855b738cbc1685a40fd", "phone_model": "Samsung_S21", "rate": 5, "target_id": "110890469"}', '2025-04-15 06:59:05', 1744671545000, '2025-04-15 06:59:05'),
('sql_screenshots', 16, '2025-04-15 07:00:05', 'id_abb598cd25674330', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110873051_1744671605000_108870508_1744671605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/757e38a499354c28a22535a33eba60e2.jpg", "device_id": "8a429694-bb61-4995-a0c7-14479553d67d", "is_chatting": 1, "label_rate": 2, "log_seq": "a338bf8d03904054a3838de1f288574c", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "110873051"}', '2025-04-15 07:00:05', 1744671605000, '2025-04-15 07:00:05'),
('sql_screenshots', 16, '2025-04-15 07:01:05', 'id_0bf513de24ae47f1', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "108870508_1744671665000_105503656_1744671665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/56401768377742e3802ac35075c1ca9c.jpg", "device_id": "570efba9-e90d-4a44-8efe-9bf160400355", "is_chatting": 1, "label_rate": 1, "log_seq": "3d8995045f2c4fc197a361dc7d241e92", "phone_model": "Huawei_P40", "rate": 4, "target_id": "108870508"}', '2025-04-15 07:01:05', 1744671665000, '2025-04-15 07:01:05'),
('sql_screenshots', 16, '2025-04-15 07:02:05', 'id_03edd86ef8544c5c', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "104844318_1744671725000_109657261_1744671725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/020bca7afaaa42dab646d9c41f16215e.jpg", "device_id": "5bea0eb1-00e2-4a0b-92c1-5cc4da8749f6", "is_chatting": 1, "label_rate": 0, "log_seq": "92719cf8d7be46529372551fb7b28a41", "phone_model": "iPhone_13", "rate": 3, "target_id": "104844318"}', '2025-04-15 07:02:05', 1744671725000, '2025-04-15 07:02:05'),
('sql_screenshots', 16, '2025-04-15 07:03:05', 'id_4d63c63e16a1414b', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744671785000_109980113_1744671785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f5c8e6e18be5474f8fe76a176b797161.jpg", "device_id": "90966ab1-34f8-459b-a870-5c58ee3ed35c", "is_chatting": 1, "label_rate": 2, "log_seq": "e2c2fcce2db546f8b7fada30789f3e8d", "phone_model": "Samsung_S21", "rate": 1, "target_id": "32970671"}', '2025-04-15 07:03:05', 1744671785000, '2025-04-15 07:03:05'),
('sql_screenshots', 16, '2025-04-15 07:04:05', 'id_0d4c1e13a4e54c5e', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110215081_1744671845000_87571440_1744671845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c2d7f4b9dd01475a9443050869924d97.jpg", "device_id": "766a0bf7-1a86-4053-bdbd-480b1c82f9ff", "is_chatting": 1, "label_rate": 1, "log_seq": "27ad54715d514a5d9404ac16bc9de4fc", "phone_model": "iPhone_13", "rate": 2, "target_id": "110215081"}', '2025-04-15 07:04:05', 1744671845000, '2025-04-15 07:04:05'),
('sql_screenshots', 16, '2025-04-15 07:05:05', 'id_67f14e077554491f', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105503656_1744671905000_110890469_1744671905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e027b0dccf844f1aaf4a9b7383ef1df2.jpg", "device_id": "29c06f9b-617a-456a-b849-69f97f91d886", "is_chatting": 1, "label_rate": 0, "log_seq": "a5507eb68db8422a80e6cb9af174dfac", "phone_model": "OPPO_CPH1937", "rate": 4, "target_id": "105503656"}', '2025-04-15 07:05:05', 1744671905000, '2025-04-15 07:05:05'),
('sql_screenshots', 16, '2025-04-15 07:06:05', 'id_d280087fa97f49c9', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "101553185_1744671965000_105083641_1744671965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/39a63fc812454020a1120fa79135842a.jpg", "device_id": "9a1c0790-1981-4113-b8f9-ee7f35660acc", "is_chatting": 1, "label_rate": 2, "log_seq": "5715639b112f439991c5431d738ca411", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "101553185"}', '2025-04-15 07:06:05', 1744671965000, '2025-04-15 07:06:05'),
('sql_screenshots', 16, '2025-04-15 07:07:05', 'id_f0a4415b9bc04607', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "57649476_1744672025000_81479540_1744672025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3381f88a1f384ebfa1bbdf27d209516e.jpg", "device_id": "aa224d84-244b-41d0-9b69-fac62e4c6b8c", "is_chatting": 1, "label_rate": 1, "log_seq": "b4872896a2ba402e8f55545f94f54529", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "57649476"}', '2025-04-15 07:07:05', 1744672025000, '2025-04-15 07:07:05'),
('sql_screenshots', 16, '2025-04-15 07:08:05', 'id_526e3db3dd7c4bd5', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105083641_1744672085000_101553185_1744672085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e275f3df00154941980d9eca46371dbb.jpg", "device_id": "fa87bc91-7c5e-43aa-8fea-db766bb12916", "is_chatting": 1, "label_rate": 1, "log_seq": "e13184d6fcb94ccf878ef9df9ef65ee0", "phone_model": "iPhone_13", "rate": 3, "target_id": "105083641"}', '2025-04-15 07:08:05', 1744672085000, '2025-04-15 07:08:05'),
('sql_screenshots', 16, '2025-04-15 07:09:05', 'id_bc55b0d5e9da4b6f', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "107039703_1744672145000_110890469_1744672145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/afbea9f7befd4e0e9ca6df38387f32e5.jpg", "device_id": "9ff69044-24cf-4bb7-917f-115b6978de6d", "is_chatting": 1, "label_rate": 1, "log_seq": "75671e72968b4dbc9fefe0f5659487d0", "phone_model": "Samsung_S21", "rate": 1, "target_id": "107039703"}', '2025-04-15 07:09:05', 1744672145000, '2025-04-15 07:09:05'),
('sql_screenshots', 16, '2025-04-15 07:10:05', 'id_ebbdb0b33a7c4f1e', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "83341608_1744672205000_104844318_1744672205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e45dc0b18bbd4fc981be427a9674840b.jpg", "device_id": "6fc80436-b7cc-40f6-b302-5fb8b984af8c", "is_chatting": 1, "label_rate": 0, "log_seq": "5012adf67141445588a0a394244dc186", "phone_model": "VIVO_X60", "rate": 2, "target_id": "83341608"}', '2025-04-15 07:10:05', 1744672205000, '2025-04-15 07:10:05'),
('sql_screenshots', 16, '2025-04-15 07:11:05', 'id_2064005124bf46c4', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "104844318_1744672265000_107039703_1744672265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cba3c89e62dd41b689f667b3278aefae.jpg", "device_id": "68c08ec6-5cf4-48c8-997b-595636312711", "is_chatting": 1, "label_rate": 1, "log_seq": "3da4bf6359f942868bd01ba4c486e680", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "104844318"}', '2025-04-15 07:11:05', 1744672265000, '2025-04-15 07:11:05'),
('sql_screenshots', 16, '2025-04-15 07:12:05', 'id_af46770c3e44473c', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "32970671_1744672325000_110766160_1744672325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/dde6b8af4ea7422d896998d905d82778.jpg", "device_id": "20215641-6ea3-43ab-a815-8b24b2ea91d8", "is_chatting": 1, "label_rate": 2, "log_seq": "27cb3af0b3a14b13acbd248646016898", "phone_model": "VIVO_X60", "rate": 2, "target_id": "32970671"}', '2025-04-15 07:12:05', 1744672325000, '2025-04-15 07:12:05'),
('sql_screenshots', 16, '2025-04-15 07:13:05', 'id_4255095f72774a34', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "94369556_1744672385000_105503656_1744672385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5a18aa96123d43af9cdde4c0ac5bd76f.jpg", "device_id": "d0a2f0e5-9fe5-4ba5-8ff9-40290f004441", "is_chatting": 1, "label_rate": 1, "log_seq": "4d8d8d7fd4c04239b5c69f250d334711", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "94369556"}', '2025-04-15 07:13:05', 1744672385000, '2025-04-15 07:13:05'),
('sql_screenshots', 16, '2025-04-15 07:14:05', 'id_c46e607d3d4e47d9', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "83341608_1744672445000_110766160_1744672445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9135807cbcfc49f5ac6d675df5cd1b63.jpg", "device_id": "e1eb30d5-2287-4123-b7e8-d08f3b623f17", "is_chatting": 1, "label_rate": 2, "log_seq": "23199c5e95b14bed86bea2e2c1146551", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "83341608"}', '2025-04-15 07:14:05', 1744672445000, '2025-04-15 07:14:05'),
('sql_screenshots', 16, '2025-04-15 07:15:05', 'id_f2fd80df683e4330', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109407413_1744672505000_105503656_1744672505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/04613698a16647f796c30a7786c70d85.jpg", "device_id": "c1ab1dae-115a-4121-82c2-db77b832d213", "is_chatting": 1, "label_rate": 2, "log_seq": "685ba1be123344f594aedb21cd916dbd", "phone_model": "Samsung_S21", "rate": 4, "target_id": "109407413"}', '2025-04-15 07:15:05', 1744672505000, '2025-04-15 07:15:05'),
('sql_screenshots', 16, '2025-04-15 07:16:05', 'id_bee825ca4db3484b', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "83341608_1744672565000_81479540_1744672565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4e840d28134b46d1ab85e47a878d732c.jpg", "device_id": "d339cc2b-0392-42b5-83d2-51c88a616beb", "is_chatting": 1, "label_rate": 0, "log_seq": "213d7d6ceca64f02a48c464a897bb18c", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "83341608"}', '2025-04-15 07:16:05', 1744672565000, '2025-04-15 07:16:05'),
('sql_screenshots', 16, '2025-04-15 07:17:05', 'id_7021350c5be0497d', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110215081_1744672625000_32970671_1744672625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/15ae37663ebe472ca907e46acb549a94.jpg", "device_id": "8fd6a302-eac0-4048-8af7-e5fc247632f1", "is_chatting": 1, "label_rate": 0, "log_seq": "b6e85e1731104da4a21c90e70cef473f", "phone_model": "iPhone_14_Pro", "rate": 0, "target_id": "110215081"}', '2025-04-15 07:17:05', 1744672625000, '2025-04-15 07:17:05'),
('sql_screenshots', 16, '2025-04-15 07:18:05', 'id_5ff6008aebbe4ce6', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110766160_1744672685000_107039703_1744672685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/48782551ec954882882b8f1371638064.jpg", "device_id": "94ea2f8b-2c2a-4019-a42b-5b9792a1935d", "is_chatting": 1, "label_rate": 0, "log_seq": "d6995c279cf94fd990107a4c9b9f568b", "phone_model": "Huawei_P40", "rate": 2, "target_id": "110766160"}', '2025-04-15 07:18:05', 1744672685000, '2025-04-15 07:18:05'),
('sql_screenshots', 16, '2025-04-15 07:19:05', 'id_ec9e0a9c95e846f6', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110876251_1744672745000_108466147_1744672745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9f55c8aba8f24ee89529a92bcab074bf.jpg", "device_id": "6c887db7-93cd-41d4-9f03-c5c72dbc63e6", "is_chatting": 1, "label_rate": 2, "log_seq": "bbdfe933671b4a208ef795d0624ebe24", "phone_model": "iPhone_13", "rate": 4, "target_id": "110876251"}', '2025-04-15 07:19:05', 1744672745000, '2025-04-15 07:19:05'),
('sql_screenshots', 16, '2025-04-15 07:20:05', 'id_09d2a9e77fa74944', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108870508_1744672805000_107039703_1744672805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/559ccd154da54945b31271db3c158f90.jpg", "device_id": "9720a37a-4c14-4664-bc91-7be69e5d7efd", "is_chatting": 1, "label_rate": 2, "log_seq": "30b94ee34625478597ac941412ed1e73", "phone_model": "VIVO_X60", "rate": 2, "target_id": "108870508"}', '2025-04-15 07:20:05', 1744672805000, '2025-04-15 07:20:05'),
('sql_screenshots', 16, '2025-04-15 07:21:05', 'id_91dd1c642d0d41a8', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "82365582_1744672865000_109657261_1744672865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9c2edeeb38254f4e94be254dc627afed.jpg", "device_id": "0382255b-f343-4599-bbff-e842f55d3727", "is_chatting": 1, "label_rate": 2, "log_seq": "c0d84c6491dd4a36be81c5a55e4630e1", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "82365582"}', '2025-04-15 07:21:05', 1744672865000, '2025-04-15 07:21:05'),
('sql_screenshots', 16, '2025-04-15 07:22:05', 'id_033dd664032b4df8', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "54675542_1744672925000_110873051_1744672925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/46c0a8062f384c8b861136711f7c466b.jpg", "device_id": "ac350e74-e26d-435b-8f1c-2306f5e929cd", "is_chatting": 1, "label_rate": 0, "log_seq": "00679df81f454f91bc8a8e7f84838c75", "phone_model": "OnePlus_9", "rate": 4, "target_id": "54675542"}', '2025-04-15 07:22:05', 1744672925000, '2025-04-15 07:22:05'),
('sql_screenshots', 16, '2025-04-15 07:23:05', 'id_91eef25700ec4c20', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744672985000_110873051_1744672985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bebd025216284c06a0a8a11e0d974c45.jpg", "device_id": "cbba77b8-77ca-44ee-a4fa-a1b8eb211282", "is_chatting": 1, "label_rate": 2, "log_seq": "1c962ab5c4aa49a8a1dcf2d8c7be1f53", "phone_model": "Huawei_P40", "rate": 4, "target_id": "109657261"}', '2025-04-15 07:23:05', 1744672985000, '2025-04-15 07:23:05'),
('sql_screenshots', 16, '2025-04-15 07:24:05', 'id_8cd795b536104bb8', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110766160_1744673045000_101553185_1744673045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d31b621b2e6e465780a91fc08a7a5b5a.jpg", "device_id": "d617bc2a-93dd-4908-b552-67bc02bfaeeb", "is_chatting": 1, "label_rate": 0, "log_seq": "302c91c0228b42ab90e01c3156dfa3c5", "phone_model": "Huawei_P40", "rate": 2, "target_id": "110766160"}', '2025-04-15 07:24:05', 1744673045000, '2025-04-15 07:24:05'),
('sql_screenshots', 16, '2025-04-15 07:25:05', 'id_48921c6465494b8d', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744673105000_94369556_1744673105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5132d549e742470c938dd462f6a31241.jpg", "device_id": "ad287165-0571-43d5-ac46-56347ba99461", "is_chatting": 1, "label_rate": 1, "log_seq": "983b50485e6e44f693605ffd3e09656f", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "109657261"}', '2025-04-15 07:25:05', 1744673105000, '2025-04-15 07:25:05'),
('sql_screenshots', 16, '2025-04-15 07:26:05', 'id_3c3f1a38be944d8e', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "87571440_1744673165000_32970671_1744673165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e55295fd91b84fdb9a07c6f0ce8f33ac.jpg", "device_id": "9dbcc10f-6cdb-4e7a-a978-7d7e147cb877", "is_chatting": 1, "label_rate": 1, "log_seq": "ea9601d25958468d8e6c30db9bc2d42e", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "87571440"}', '2025-04-15 07:26:05', 1744673165000, '2025-04-15 07:26:05'),
('sql_screenshots', 16, '2025-04-15 07:27:05', 'id_ce6606623a5d4bb3', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109657261_1744673225000_83341608_1744673225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f27bca4d85314027a03b7eb8ba1513d3.jpg", "device_id": "a47617ea-dead-465d-b62c-9880a0880aeb", "is_chatting": 1, "label_rate": 1, "log_seq": "46a9281a99464162b172874bd2229a4d", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "109657261"}', '2025-04-15 07:27:05', 1744673225000, '2025-04-15 07:27:05'),
('sql_screenshots', 16, '2025-04-15 07:28:05', 'id_9dba8c4eeabd485c', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744673285000_57649476_1744673285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/80d0f866b8b548ef982fd1a57c6f9c29.jpg", "device_id": "e8812ffc-870c-4754-9b71-4cb80910ab5d", "is_chatting": 1, "label_rate": 1, "log_seq": "8068b363195d487c9b6355ab70ff057e", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "110766160"}', '2025-04-15 07:28:05', 1744673285000, '2025-04-15 07:28:05'),
('sql_screenshots', 16, '2025-04-15 07:29:05', 'id_e653797351164262', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "83341608_1744673345000_109744448_1744673345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/929faf1757cb4a6686b93f09ead05618.jpg", "device_id": "40aecf40-e826-4b13-ad86-f7c1391fe8c7", "is_chatting": 1, "label_rate": 2, "log_seq": "30295ac97bb64346ba5403d43485cacc", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "83341608"}', '2025-04-15 07:29:05', 1744673345000, '2025-04-15 07:29:05'),
('sql_screenshots', 16, '2025-04-15 07:30:05', 'id_87b095fa2bd9424c', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "28230174_1744673405000_110215081_1744673405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a288553b781a466b8b19808aa77b90ab.jpg", "device_id": "a0a6688b-e445-4613-84a9-eeb5335959c7", "is_chatting": 1, "label_rate": 0, "log_seq": "a1e987fe8bc14cef95e902bf06a56f54", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "28230174"}', '2025-04-15 07:30:05', 1744673405000, '2025-04-15 07:30:05'),
('sql_screenshots', 16, '2025-04-15 07:31:05', 'id_7bf846992bdc42d0', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "101553185_1744673465000_83341608_1744673465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e774d2b68000434b889e842dd4a5c330.jpg", "device_id": "7719f921-d554-4ab7-af98-5eaba5b7c26f", "is_chatting": 1, "label_rate": 2, "log_seq": "9b055337d7c24a588c5fda0a686ed285", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "101553185"}', '2025-04-15 07:31:05', 1744673465000, '2025-04-15 07:31:05'),
('sql_screenshots', 16, '2025-04-15 07:32:05', 'id_c2f9f920cc434ad7', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105083641_1744673525000_110876251_1744673525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/57df70476f14418d809e1c316e59e711.jpg", "device_id": "2e2384fd-89d7-48cf-adc3-41bde788a542", "is_chatting": 1, "label_rate": 1, "log_seq": "6fc6dabe42c347979ed5606555760ca6", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "105083641"}', '2025-04-15 07:32:05', 1744673525000, '2025-04-15 07:32:05'),
('sql_screenshots', 16, '2025-04-15 07:33:05', 'id_6f43b8af3e8042e8', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "64280379_1744673585000_87571440_1744673585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a14d31f454254ae881e2b0ee0d0b4d3d.jpg", "device_id": "6c8a45b2-d14e-436d-b61f-6a3e0f86a2e2", "is_chatting": 1, "label_rate": 0, "log_seq": "9a2d024092d3487bbf8abbc8a1250be6", "phone_model": "Samsung_S22", "rate": 1, "target_id": "64280379"}', '2025-04-15 07:33:05', 1744673585000, '2025-04-15 07:33:05'),
('sql_screenshots', 16, '2025-04-15 07:34:05', 'id_ec955fe04e9a4a2b', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110215081_1744673645000_110892617_1744673645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3978d62909544cb180f96b5cf74cb4a4.jpg", "device_id": "5a8661bf-0745-4e7e-b729-501134f18048", "is_chatting": 1, "label_rate": 2, "log_seq": "51bc8b59eba14072a67f9584385c7990", "phone_model": "Huawei_P40", "rate": 0, "target_id": "110215081"}', '2025-04-15 07:34:05', 1744673645000, '2025-04-15 07:34:05'),
('sql_screenshots', 16, '2025-04-15 07:35:05', 'id_ac0967ad06e94742', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110766160_1744673705000_109657261_1744673705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6823114e7e4c4a0891e6d44cda209eef.jpg", "device_id": "5a11e9d3-fc38-44ff-8674-5cd90555c510", "is_chatting": 1, "label_rate": 1, "log_seq": "466faa55a73d4f2fa62576c89ba8e476", "phone_model": "Samsung_S21", "rate": 1, "target_id": "110766160"}', '2025-04-15 07:35:05', 1744673705000, '2025-04-15 07:35:05'),
('sql_screenshots', 16, '2025-04-15 07:36:05', 'id_bf39f57a3507400b', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744673765000_87571440_1744673765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/488aa703c3284f7e9489fc91328a40e5.jpg", "device_id": "b202d357-6d64-46f0-b813-aa085442a135", "is_chatting": 1, "label_rate": 2, "log_seq": "5114ceb1b243409d97101951219c427e", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "64280379"}', '2025-04-15 07:36:05', 1744673765000, '2025-04-15 07:36:05'),
('sql_screenshots', 16, '2025-04-15 07:37:05', 'id_608fa4d513b149ea', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110766160_1744673825000_110890469_1744673825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c3981b0146dd4e969ae0e4d3b7600c25.jpg", "device_id": "4bc5bc28-6eaf-4c26-b8b0-94c1d02876fc", "is_chatting": 1, "label_rate": 0, "log_seq": "ff270a3a844748eab29725507d9c4574", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "110766160"}', '2025-04-15 07:37:05', 1744673825000, '2025-04-15 07:37:05'),
('sql_screenshots', 16, '2025-04-15 07:38:05', 'id_372fc70dd0f54378', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "107039703_1744673885000_110890469_1744673885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1b73341dc3d241339c09e09accc5347d.jpg", "device_id": "77f73f1e-993b-417b-8eca-1ef6a66bf1b4", "is_chatting": 1, "label_rate": 2, "log_seq": "5d950a43ebb3497fa6ea0fe6f07a7d1e", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "107039703"}', '2025-04-15 07:38:05', 1744673885000, '2025-04-15 07:38:05'),
('sql_screenshots', 16, '2025-04-15 07:39:05', 'id_1455b39737934f2f', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109407413_1744673945000_101553185_1744673945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0d24739a83ea47bfbe49c244d6a934b6.jpg", "device_id": "00c7bed5-fadc-4168-bb7f-fb85dbe66223", "is_chatting": 1, "label_rate": 1, "log_seq": "16d020537ed54471a6212901b0d67bd9", "phone_model": "iPhone_13", "rate": 5, "target_id": "109407413"}', '2025-04-15 07:39:05', 1744673945000, '2025-04-15 07:39:05'),
('sql_screenshots', 16, '2025-04-15 07:40:05', 'id_67c22dbd682549ca', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "81479540_1744674005000_104844318_1744674005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/eb917323796a4de1ad6622fe71bddbbf.jpg", "device_id": "776a56f3-e540-44ff-9140-4ff0f6023858", "is_chatting": 1, "label_rate": 1, "log_seq": "2379c11dc24d4b02a6b5b088e465623a", "phone_model": "iPhone_13", "rate": 5, "target_id": "81479540"}', '2025-04-15 07:40:05', 1744674005000, '2025-04-15 07:40:05'),
('sql_screenshots', 16, '2025-04-15 07:41:05', 'id_55ecca42dfa44ff7', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "28230174_1744674065000_57649476_1744674065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5b6b1d3127064980942729afb656a447.jpg", "device_id": "9585c06b-32d8-44b7-87e5-92c89db3ca24", "is_chatting": 1, "label_rate": 1, "log_seq": "ada312e8ca784997b252f5a14d613eb9", "phone_model": "iPhone_13", "rate": 3, "target_id": "28230174"}', '2025-04-15 07:41:05', 1744674065000, '2025-04-15 07:41:05'),
('sql_screenshots', 16, '2025-04-15 07:42:05', 'id_9199afd72bc04a37', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "28230174_1744674125000_87571440_1744674125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b66c93e6fe3440f381995ec4243c9ba6.jpg", "device_id": "536966a8-b357-40c8-9e3a-8e220d071c3a", "is_chatting": 1, "label_rate": 2, "log_seq": "bd5e905c8fd04e4b992bfb2c122ddce0", "phone_model": "iPhone_13", "rate": 1, "target_id": "28230174"}', '2025-04-15 07:42:05', 1744674125000, '2025-04-15 07:42:05'),
('sql_screenshots', 16, '2025-04-15 07:43:05', 'id_c414be5213f047e2', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744674185000_110215081_1744674185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9b0c5d0f8dd541ce9d840f3ca4b39ad0.jpg", "device_id": "c30c0a73-35d9-4497-ae76-13e3054cde40", "is_chatting": 1, "label_rate": 0, "log_seq": "a89dd7da7b7e4487950fbe7d553e2ebb", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "107039703"}', '2025-04-15 07:43:05', 1744674185000, '2025-04-15 07:43:05'),
('sql_screenshots', 16, '2025-04-15 07:44:05', 'id_743b4ccdb53049fd', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110876251_1744674245000_87571440_1744674245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/83f2cb3940f040faa5aa1a9129c0f48c.jpg", "device_id": "bddb52c8-4d9e-429d-8ee3-a5d5de069d13", "is_chatting": 1, "label_rate": 1, "log_seq": "5076ed520cbf4b4db57d6af4918b6e47", "phone_model": "VIVO_X60", "rate": 5, "target_id": "110876251"}', '2025-04-15 07:44:05', 1744674245000, '2025-04-15 07:44:05'),
('sql_screenshots', 16, '2025-04-15 07:45:05', 'id_39644c3931a14606', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "28230174_1744674305000_110876251_1744674305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c2458870f133466ab38a557116f95f15.jpg", "device_id": "a86e0647-577e-44f3-b414-c5967f5e9c4c", "is_chatting": 1, "label_rate": 0, "log_seq": "8e6703b5291f45a4bdc8538990599207", "phone_model": "VIVO_X60", "rate": 0, "target_id": "28230174"}', '2025-04-15 07:45:05', 1744674305000, '2025-04-15 07:45:05'),
('sql_screenshots', 16, '2025-04-15 07:46:05', 'id_23a0cbdb4c974db3', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109744448_1744674365000_105503656_1744674365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e1001c6bb46948a0a3566e252f86273d.jpg", "device_id": "dec2ac6c-2064-43f8-a73e-3dea0de5b433", "is_chatting": 1, "label_rate": 1, "log_seq": "536518bcf9924c7ca99af0d9b747e484", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "109744448"}', '2025-04-15 07:46:05', 1744674365000, '2025-04-15 07:46:05'),
('sql_screenshots', 16, '2025-04-15 07:47:05', 'id_dff7f19585fc4f55', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110873051_1744674425000_107039703_1744674425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/96e11119ab944733b3422225c5fbc71e.jpg", "device_id": "9291fa6a-8061-4d27-bbc3-0826df017ee6", "is_chatting": 1, "label_rate": 2, "log_seq": "ddcf3a663c854866be7daa118f56fdef", "phone_model": "Samsung_S21", "rate": 2, "target_id": "110873051"}', '2025-04-15 07:47:05', 1744674425000, '2025-04-15 07:47:05'),
('sql_screenshots', 16, '2025-04-15 07:48:05', 'id_97056122bb3a4782', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "81479540_1744674485000_104844318_1744674485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/dc9c73b1b2e145fb8f54166c01d1941e.jpg", "device_id": "afe180ca-f183-4014-abd2-bbc3b3ba35e5", "is_chatting": 1, "label_rate": 2, "log_seq": "11884da554d74065abd1252ac3e4e677", "phone_model": "iPhone_14_Pro", "rate": 4, "target_id": "81479540"}', '2025-04-15 07:48:05', 1744674485000, '2025-04-15 07:48:05'),
('sql_screenshots', 16, '2025-04-15 07:49:05', 'id_6665928938c94312', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "108466147_1744674545000_101553185_1744674545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c2ce3bb600214ac99bffa994063fde14.jpg", "device_id": "99c05706-a1a4-497c-ac93-cfbee4d43948", "is_chatting": 1, "label_rate": 0, "log_seq": "dcdaacd14a5d4675b28fa3b951d446e3", "phone_model": "VIVO_X60", "rate": 2, "target_id": "108466147"}', '2025-04-15 07:49:05', 1744674545000, '2025-04-15 07:49:05'),
('sql_screenshots', 16, '2025-04-15 07:50:05', 'id_49c2095bcb62423a', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109407413_1744674605000_105503656_1744674605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/437c62b5f142410aa8eeaf8ca851fd51.jpg", "device_id": "5f004a84-8016-42e3-ad14-78962efa87a7", "is_chatting": 1, "label_rate": 0, "log_seq": "efc383405c7f4a3ba1f9dd0fb61f9a09", "phone_model": "OnePlus_9", "rate": 2, "target_id": "109407413"}', '2025-04-15 07:50:05', 1744674605000, '2025-04-15 07:50:05'),
('sql_screenshots', 16, '2025-04-15 07:51:05', 'id_1a2d6874d9724bbd', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744674665000_109407413_1744674665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7c71f675077349d4b0ad6c7163b3b0ca.jpg", "device_id": "c0e20ebb-8719-453d-afb5-75f105383572", "is_chatting": 1, "label_rate": 2, "log_seq": "5a7e9c4e8e324e0da24b63ccf911893d", "phone_model": "Huawei_P40", "rate": 0, "target_id": "109744448"}', '2025-04-15 07:51:05', 1744674665000, '2025-04-15 07:51:05'),
('sql_screenshots', 16, '2025-04-15 07:52:05', 'id_c4db496e2ae54c56', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109657261_1744674725000_110215081_1744674725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c1f28293a4804edf81c7ad58f0a529fc.jpg", "device_id": "9966b38e-232a-4914-a1e9-358eda876ef8", "is_chatting": 1, "label_rate": 2, "log_seq": "99ebc243e63249df9a14803c93e6f82d", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "109657261"}', '2025-04-15 07:52:05', 1744674725000, '2025-04-15 07:52:05'),
('sql_screenshots', 16, '2025-04-15 07:53:05', 'id_ea0bc12bcbca45f7', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "54675542_1744674785000_110892617_1744674785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3c5a7d9321ef4abb9d8b54d9715f2643.jpg", "device_id": "15a0fd5f-d32f-4dba-b07c-4ef58b41f079", "is_chatting": 1, "label_rate": 2, "log_seq": "31997dd47d814f4b9f58ebdce79bfd22", "phone_model": "Samsung_S21", "rate": 3, "target_id": "54675542"}', '2025-04-15 07:53:05', 1744674785000, '2025-04-15 07:53:05'),
('sql_screenshots', 16, '2025-04-15 07:54:05', 'id_2c4b2df1804c4453', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 110873051], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110873051_1744674845000_64280379_1744674845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cf5a4b0511b04cfc9c216de8457917c2.jpg", "device_id": "edf8fff8-ef46-4ae0-8ed4-0916341c0986", "is_chatting": 1, "label_rate": 0, "log_seq": "59392814bdf949cfa7074fffee01a149", "phone_model": "VIVO_X60", "rate": 3, "target_id": "110873051"}', '2025-04-15 07:54:05', 1744674845000, '2025-04-15 07:54:05'),
('sql_screenshots', 16, '2025-04-15 07:55:05', 'id_21294bb193e74016', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744674905000_110890469_1744674905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/39e85cce60bc4ed594638c113ded40ac.jpg", "device_id": "aaedf3ba-9223-474f-9391-be81e1d77a3e", "is_chatting": 1, "label_rate": 0, "log_seq": "1c7ad1c37b7d42e8b502c3e5351c9001", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "110766160"}', '2025-04-15 07:55:05', 1744674905000, '2025-04-15 07:55:05'),
('sql_screenshots', 16, '2025-04-15 07:56:05', 'id_9267cd74dfee4cc9', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109657261_1744674965000_64280379_1744674965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/60251e4412b340cea4cd867dfc0cbf6c.jpg", "device_id": "dc3e5c2b-8cee-4bd1-9358-275cced6faa7", "is_chatting": 1, "label_rate": 0, "log_seq": "7353e895c9d84d6b94523d17881520f9", "phone_model": "Huawei_P40", "rate": 0, "target_id": "109657261"}', '2025-04-15 07:56:05', 1744674965000, '2025-04-15 07:56:05'),
('sql_screenshots', 16, '2025-04-15 07:57:05', 'id_4c640ebf45f5436a', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744675025000_108466147_1744675025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6318f7939e874542866d83f2f7901d74.jpg", "device_id": "5ea39171-dac6-43ec-8f2b-11a69788b69a", "is_chatting": 1, "label_rate": 0, "log_seq": "0a1ae51f81ef44f2a9867ca205880701", "phone_model": "iPhone_14_Pro", "rate": 3, "target_id": "64280379"}', '2025-04-15 07:57:05', 1744675025000, '2025-04-15 07:57:05'),
('sql_screenshots', 16, '2025-04-15 07:58:05', 'id_216169af28454913', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110892617_1744675085000_28230174_1744675085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8a500a0444ac47e39d9bfbe84d088458.jpg", "device_id": "e10e0ffa-bf31-4ad3-8d25-e8a532abda22", "is_chatting": 1, "label_rate": 0, "log_seq": "ec7d1393a7d94332a07e999b0346ee08", "phone_model": "OPPO_CPH1937", "rate": 2, "target_id": "110892617"}', '2025-04-15 07:58:05', 1744675085000, '2025-04-15 07:58:05'),
('sql_screenshots', 16, '2025-04-15 07:59:05', 'id_b736f749a6b74e3d', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110890469_1744675145000_64280379_1744675145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/45b8cd6c45624e37b38639f2ffce2dfa.jpg", "device_id": "d11e7d53-bfb9-4152-8e72-84add1598436", "is_chatting": 1, "label_rate": 0, "log_seq": "38d9244135f74f8997f70a026f2908bf", "phone_model": "OnePlus_9", "rate": 5, "target_id": "110890469"}', '2025-04-15 07:59:05', 1744675145000, '2025-04-15 07:59:05'),
('sql_screenshots', 16, '2025-04-15 08:00:05', 'id_4dcdff4d02f546a0', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105503656_1744675205000_110873051_1744675205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d911f2408b9b4376b922dafe9f71c375.jpg", "device_id": "5022d690-df0a-4a5b-a415-6ef5c4180e36", "is_chatting": 1, "label_rate": 1, "log_seq": "f4cfcf9fd9c84b399c87ced08ccf3155", "phone_model": "Samsung_S22", "rate": 5, "target_id": "105503656"}', '2025-04-15 08:00:05', 1744675205000, '2025-04-15 08:00:05'),
('sql_screenshots', 16, '2025-04-15 08:01:05', 'id_5f9d8b1796424fc6', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "83341608_1744675265000_57649476_1744675265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1732d4ffbcb0421f80d64ebc9a7512e9.jpg", "device_id": "214acaf4-fbac-4f8d-964c-4d967fa2f5c6", "is_chatting": 1, "label_rate": 0, "log_seq": "eeb96e37323f438393be24c7c4fa771d", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "83341608"}', '2025-04-15 08:01:05', 1744675265000, '2025-04-15 08:01:05'),
('sql_screenshots', 16, '2025-04-15 08:02:05', 'id_3757ea71b9294a99', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "107039703_1744675325000_109657261_1744675325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bd095c34405847de8768da9ad8e1c95d.jpg", "device_id": "596d3a4a-f837-457a-877e-2106d260f90a", "is_chatting": 1, "label_rate": 1, "log_seq": "4809e0a2b98944c4bbf0e8e0cb025d50", "phone_model": "Huawei_P40", "rate": 1, "target_id": "107039703"}', '2025-04-15 08:02:05', 1744675325000, '2025-04-15 08:02:05'),
('sql_screenshots', 16, '2025-04-15 08:03:05', 'id_32040dd4a124496f', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "105083641_1744675385000_83341608_1744675385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a32fe504347948aa990d73d7bc29bfd2.jpg", "device_id": "fc15d7a6-02c4-49b9-8d3d-0affbffec823", "is_chatting": 1, "label_rate": 0, "log_seq": "27ca4cf228ab42059b255577a10e3126", "phone_model": "Samsung_S22", "rate": 4, "target_id": "105083641"}', '2025-04-15 08:03:05', 1744675385000, '2025-04-15 08:03:05'),
('sql_screenshots', 16, '2025-04-15 08:04:05', 'id_239298473e914773', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109407413_1744675445000_110890469_1744675445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f6f94770e7af4af78a55d00e8d25ab50.jpg", "device_id": "76bac6d3-b840-4795-bf42-8b6f3f3aba54", "is_chatting": 1, "label_rate": 1, "log_seq": "b69a58f1098e4d41b27087bb8f70f3d5", "phone_model": "VIVO_X60", "rate": 1, "target_id": "109407413"}', '2025-04-15 08:04:05', 1744675445000, '2025-04-15 08:04:05'),
('sql_screenshots', 16, '2025-04-15 08:05:05', 'id_af8b55e97a33457a', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110892617_1744675505000_110890469_1744675505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ab6f82f9a447420d977b59cee1d3d088.jpg", "device_id": "0a5289a4-dc42-47e2-80a1-9f0735eb0902", "is_chatting": 1, "label_rate": 1, "log_seq": "ec5b6266ff304bdaa403f4d00731faa5", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "110892617"}', '2025-04-15 08:05:05', 1744675505000, '2025-04-15 08:05:05'),
('sql_screenshots', 16, '2025-04-15 08:06:05', 'id_5e2959f207974023', 81479540, 'product_1',  '{"account_id": 81479540, "account_ids": [81479540, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "28230174_1744675565000_81479540_1744675565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/c5ea40ed8e7d4d3d92a0ea45e051540c.jpg", "device_id": "703cf061-9e9d-4887-820d-17bf117beb5b", "is_chatting": 1, "label_rate": 0, "log_seq": "fe74450ede2043d1851c1fa027c8669c", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "28230174"}', '2025-04-15 08:06:05', 1744675565000, '2025-04-15 08:06:05'),
('sql_screenshots', 16, '2025-04-15 08:07:05', 'id_49626dbcee424cf4', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110892617_1744675625000_108466147_1744675625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/445e562f41564848b390059a849624f4.jpg", "device_id": "f8fa8282-40db-4c1b-ac36-2af25a6f72b7", "is_chatting": 1, "label_rate": 1, "log_seq": "9f45d6f124e141ffa90c496900dd7692", "phone_model": "Samsung_S21", "rate": 1, "target_id": "110892617"}', '2025-04-15 08:07:05', 1744675625000, '2025-04-15 08:07:05'),
('sql_screenshots', 16, '2025-04-15 08:08:05', 'id_fc6b68b8b6ce4b20', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744675685000_82365582_1744675685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a8c2ab7fe6a14c55815f1a04c2c498fc.jpg", "device_id": "2f90e018-4ef3-4ab1-a16a-929b605c2544", "is_chatting": 1, "label_rate": 1, "log_seq": "8e351e41b8d047d3a94c86dd33053121", "phone_model": "Huawei_P40", "rate": 4, "target_id": "87571440"}', '2025-04-15 08:08:05', 1744675685000, '2025-04-15 08:08:05'),
('sql_screenshots', 16, '2025-04-15 08:09:05', 'id_f075985c246f47b0', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110892617_1744675745000_32970671_1744675745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a49519e6011a420ebc802e2de3cd27b0.jpg", "device_id": "9e18bedb-0cf9-49db-950c-50c89ac88193", "is_chatting": 1, "label_rate": 1, "log_seq": "bdda70c9be4d4a8f87f3656c4680e484", "phone_model": "Huawei_P40", "rate": 5, "target_id": "110892617"}', '2025-04-15 08:09:05', 1744675745000, '2025-04-15 08:09:05'),
('sql_screenshots', 16, '2025-04-15 08:10:05', 'id_a5916e28855d4da1', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "54675542_1744675805000_32970671_1744675805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f21c1614fa25428f98f02f96fc220378.jpg", "device_id": "0a34010a-b978-44bc-8df1-94d90e28174e", "is_chatting": 1, "label_rate": 2, "log_seq": "572895ef29f349669c1a769c0bd0bcdd", "phone_model": "OnePlus_9", "rate": 4, "target_id": "54675542"}', '2025-04-15 08:10:05', 1744675805000, '2025-04-15 08:10:05'),
('sql_screenshots', 16, '2025-04-15 08:11:05', 'id_4150e3de631e47bc', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "82365582_1744675865000_32970671_1744675865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5de8f83dfc5b45ad8eb4370a7c5529f5.jpg", "device_id": "57284c60-7c82-4df4-8533-2f97508dcbbe", "is_chatting": 1, "label_rate": 0, "log_seq": "3cdf0ac1455f432b83d14ebe4cb1d50c", "phone_model": "VIVO_X60", "rate": 3, "target_id": "82365582"}', '2025-04-15 08:11:05', 1744675865000, '2025-04-15 08:11:05'),
('sql_screenshots', 16, '2025-04-15 08:12:05', 'id_25c203d8c9704cdc', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110766160_1744675925000_108466147_1744675925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/55a00cdba6434ef3b923ee84224c2177.jpg", "device_id": "a5149677-d1cf-409a-86ad-f0f1b82e6d32", "is_chatting": 1, "label_rate": 0, "log_seq": "f9f8c3a0a87e4561894bd54f95645bf5", "phone_model": "OnePlus_9", "rate": 1, "target_id": "110766160"}', '2025-04-15 08:12:05', 1744675925000, '2025-04-15 08:12:05'),
('sql_screenshots', 16, '2025-04-15 08:13:05', 'id_9db323a939f84666', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109744448_1744675985000_82365582_1744675985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d1c6fd7176ee47b1913d6d79ad6e4d89.jpg", "device_id": "b518888b-3e99-488b-90d6-be3963f3f1db", "is_chatting": 1, "label_rate": 1, "log_seq": "5095b8ba483d4375b13a8cfe9635391a", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "109744448"}', '2025-04-15 08:13:05', 1744675985000, '2025-04-15 08:13:05'),
('sql_screenshots', 16, '2025-04-15 08:14:05', 'id_089c838094824b53', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110766160_1744676045000_57649476_1744676045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cdc0b0410c374fb887f9c203318e773a.jpg", "device_id": "04aee434-c97e-46db-a38d-09fe8194b918", "is_chatting": 1, "label_rate": 0, "log_seq": "b156661e989b4472bdec3885e995dda4", "phone_model": "VIVO_X60", "rate": 5, "target_id": "110766160"}', '2025-04-15 08:14:05', 1744676045000, '2025-04-15 08:14:05'),
('sql_screenshots', 16, '2025-04-15 08:15:05', 'id_ef2d89f109fa4184', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109980113_1744676105000_109407413_1744676105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e42be5024bd84335b10e498ad68e0518.jpg", "device_id": "84165897-186c-4b0f-99a7-952b42d7e4ea", "is_chatting": 1, "label_rate": 0, "log_seq": "518c1fbe69504a89b1ae5f3a1246f915", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "109980113"}', '2025-04-15 08:15:05', 1744676105000, '2025-04-15 08:15:05'),
('sql_screenshots', 16, '2025-04-15 08:16:05', 'id_4ee277e17e1f4526', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109407413_1744676165000_57649476_1744676165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/592f7f0b49bb4d109efb1d2b4ecd5ce3.jpg", "device_id": "2ef0bd90-8010-4e68-87ae-6013d08ced87", "is_chatting": 1, "label_rate": 0, "log_seq": "3241bd5a627944e1bba720e91abdee5e", "phone_model": "Xiaomi_12", "rate": 3, "target_id": "109407413"}', '2025-04-15 08:16:05', 1744676165000, '2025-04-15 08:16:05'),
('sql_screenshots', 16, '2025-04-15 08:17:05', 'id_15df2b42bb0546f6', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "104844318_1744676225000_110890469_1744676225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/58ac8693610b4eb7878635402ce2c923.jpg", "device_id": "98fd7a9e-2cf2-4dc3-8444-d0fd347b8bc5", "is_chatting": 1, "label_rate": 0, "log_seq": "8ca665dd97914bd793a4f22a6ca5e52e", "phone_model": "iPhone_14_Pro", "rate": 1, "target_id": "104844318"}', '2025-04-15 08:17:05', 1744676225000, '2025-04-15 08:17:05'),
('sql_screenshots', 16, '2025-04-15 08:18:05', 'id_fe55932792a74ed0', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "109407413_1744676285000_110766160_1744676285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e19885706f7148de90ce95ff1bee51ce.jpg", "device_id": "9e4e19e0-ccd9-42ac-a497-a88139026fcd", "is_chatting": 1, "label_rate": 2, "log_seq": "5d538c68f39e436ea257574d0aee82fc", "phone_model": "Huawei_P40", "rate": 3, "target_id": "109407413"}', '2025-04-15 08:18:05', 1744676285000, '2025-04-15 08:18:05'),
('sql_screenshots', 16, '2025-04-15 08:19:05', 'id_74c73d2e6a7642ec', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "82365582_1744676345000_104844318_1744676345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4f3a7ef9719b41e6ad7d2ff092a7e4ad.jpg", "device_id": "72381997-d12f-4c82-82e5-af958ce293f3", "is_chatting": 1, "label_rate": 1, "log_seq": "df1919a445f94733bfdd8ae03ac55c35", "phone_model": "iPhone_13", "rate": 4, "target_id": "82365582"}', '2025-04-15 08:19:05', 1744676345000, '2025-04-15 08:19:05'),
('sql_screenshots', 16, '2025-04-15 08:20:05', 'id_01f84e08bb3f4a84', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105083641_1744676405000_110766160_1744676405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e04b535a5af349dda871907a9158cb29.jpg", "device_id": "9bd2eab1-029e-4897-bb29-90b82a9cd5f4", "is_chatting": 1, "label_rate": 1, "log_seq": "37f278c59944425fb49358bc6b5ece4a", "phone_model": "Samsung_S21", "rate": 1, "target_id": "105083641"}', '2025-04-15 08:20:05', 1744676405000, '2025-04-15 08:20:05'),
('sql_screenshots', 16, '2025-04-15 08:21:05', 'id_024001c1e4e54275', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "83341608_1744676465000_105083641_1744676465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f56918e2cd2e44559d93c3264af8a2b3.jpg", "device_id": "583c16c7-a42a-4bfd-b71b-7764c11bfefb", "is_chatting": 1, "label_rate": 1, "log_seq": "c038f71e3406471aa4888485b46021f9", "phone_model": "Huawei_P40", "rate": 3, "target_id": "83341608"}', '2025-04-15 08:21:05', 1744676465000, '2025-04-15 08:21:05'),
('sql_screenshots', 16, '2025-04-15 08:22:05', 'id_1bd3029fd5824e39', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 82365582], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "82365582_1744676525000_105083641_1744676525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/a3d23cea82084b2cbc2d5b982e3839f7.jpg", "device_id": "afb1ee58-1b8f-4dde-ad4b-dbde38644417", "is_chatting": 1, "label_rate": 2, "log_seq": "6182ff20e3f4483481280e5a3e9fddfd", "phone_model": "OPPO_Find_X3", "rate": 0, "target_id": "82365582"}', '2025-04-15 08:22:05', 1744676525000, '2025-04-15 08:22:05'),
('sql_screenshots', 16, '2025-04-15 08:23:05', 'id_3d96dd66dba94016', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109407413_1744676585000_105503656_1744676585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/62e90503b7cc43ddb767c2ca3a61cf31.jpg", "device_id": "daad52bf-4af5-4c07-a342-681a61dfa8f4", "is_chatting": 1, "label_rate": 0, "log_seq": "7a1f5a42ce1c40bdaa625e90526ed81e", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "109407413"}', '2025-04-15 08:23:05', 1744676585000, '2025-04-15 08:23:05'),
('sql_screenshots', 16, '2025-04-15 08:24:05', 'id_91e8407a26f34507', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109407413_1744676645000_28230174_1744676645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3663637f757d41fbbc8157103af19f97.jpg", "device_id": "06f8ace9-4ae3-4db2-bc27-13cfcd1f65df", "is_chatting": 1, "label_rate": 0, "log_seq": "8e2a767e17524d2fb1d280903099a423", "phone_model": "OPPO_Find_X3", "rate": 2, "target_id": "109407413"}', '2025-04-15 08:24:05', 1744676645000, '2025-04-15 08:24:05'),
('sql_screenshots', 16, '2025-04-15 08:25:05', 'id_7ae89cb13184440f', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "64280379_1744676705000_32970671_1744676705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9394a171a2b34971bf77a963d666dfec.jpg", "device_id": "bf532db9-0d2a-478d-81e3-a549479ecb5b", "is_chatting": 1, "label_rate": 1, "log_seq": "f55d5695e40b42bb9ee45333ef796972", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "64280379"}', '2025-04-15 08:25:05', 1744676705000, '2025-04-15 08:25:05'),
('sql_screenshots', 16, '2025-04-15 08:26:05', 'id_244826cd8611407a', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744676765000_108870508_1744676765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ed1825e6ef14402ba63779051ed12f07.jpg", "device_id": "70e02f6a-5e80-4d75-8b2b-c98f44d8834a", "is_chatting": 1, "label_rate": 1, "log_seq": "d62c2e9b2ca644cebd7139adf2255197", "phone_model": "Samsung_S21", "rate": 4, "target_id": "32970671"}', '2025-04-15 08:26:05', 1744676765000, '2025-04-15 08:26:05'),
('sql_screenshots', 16, '2025-04-15 08:27:05', 'id_1c867730fa844a95', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110892617_1744676825000_94369556_1744676825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/43511c064ec647c59f6344ed2bd47b96.jpg", "device_id": "dc146de2-7390-4ec4-add3-010af1d6d59d", "is_chatting": 1, "label_rate": 2, "log_seq": "605a9c2c24c642e7bead2f8952a8fb42", "phone_model": "Huawei_P40", "rate": 2, "target_id": "110892617"}', '2025-04-15 08:27:05', 1744676825000, '2025-04-15 08:27:05'),
('sql_screenshots', 16, '2025-04-15 08:28:05', 'id_24db6d4f64524d19', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744676885000_101553185_1744676885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/6a576e0198644b1fbf8ccf566c9d2e75.jpg", "device_id": "a6739348-02b5-472a-aa0f-a8b3c14b1db8", "is_chatting": 1, "label_rate": 1, "log_seq": "19a9c3f695084d06a0cb63736db44f12", "phone_model": "Samsung_S22", "rate": 2, "target_id": "108466147"}', '2025-04-15 08:28:05', 1744676885000, '2025-04-15 08:28:05'),
('sql_screenshots', 16, '2025-04-15 08:29:05', 'id_6c3622e50ea04749', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 64280379], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "64280379_1744676945000_110892617_1744676945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b4a9e0384217441598a33b7609620681.jpg", "device_id": "30c1a767-cac4-4c24-8b35-d6a7e8bc980a", "is_chatting": 1, "label_rate": 2, "log_seq": "02e3f4dae9fa4d6eaa724a1063526c73", "phone_model": "Samsung_S22", "rate": 4, "target_id": "64280379"}', '2025-04-15 08:29:05', 1744676945000, '2025-04-15 08:29:05'),
('sql_screenshots', 16, '2025-04-15 08:30:05', 'id_41c81d89148e4f08', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110892617_1744677005000_28230174_1744677005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/724fbfaab8e249938bc5f1e23ca4aef5.jpg", "device_id": "14ea06cc-03d6-4626-93c5-e7c691897df0", "is_chatting": 1, "label_rate": 1, "log_seq": "9bb28673908c4084b4fa55379638cef4", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "110892617"}', '2025-04-15 08:30:05', 1744677005000, '2025-04-15 08:30:05'),
('sql_screenshots', 16, '2025-04-15 08:31:05', 'id_94c8076e906e40b9', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110215081_1744677065000_83341608_1744677065000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b1e02e68f0be4a03afe7b3b9a86acc0f.jpg", "device_id": "6bb90581-0ff4-407c-8aa7-c96e6fd8a285", "is_chatting": 1, "label_rate": 1, "log_seq": "b9ab553838db49818c28e927f28c3bfb", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "110215081"}', '2025-04-15 08:31:05', 1744677065000, '2025-04-15 08:31:05'),
('sql_screenshots', 16, '2025-04-15 08:32:05', 'id_346a623e9433460a', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "81479540_1744677125000_108466147_1744677125000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e0d80d034c704606995e009eac5dfcdc.jpg", "device_id": "d13635ca-c8da-43bb-b5e3-630ccbf8c403", "is_chatting": 1, "label_rate": 1, "log_seq": "4dc5b330ef1046c786d2b485e7ce82d1", "phone_model": "Samsung_S22", "rate": 3, "target_id": "81479540"}', '2025-04-15 08:32:05', 1744677125000, '2025-04-15 08:32:05'),
('sql_screenshots', 16, '2025-04-15 08:33:05', 'id_a6e981f2aed04df5', 83341608, 'product_1',  '{"account_id": 83341608, "account_ids": [83341608, 104844318], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "104844318_1744677185000_83341608_1744677185000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f59424efd94c4aa4ad31a9d61bfb9eca.jpg", "device_id": "93313a86-a36d-42f3-b8bf-77a0e9be5862", "is_chatting": 1, "label_rate": 1, "log_seq": "1ef7c78ee2f84493beae16c3d37a0eab", "phone_model": "Huawei_P40", "rate": 1, "target_id": "104844318"}', '2025-04-15 08:33:05', 1744677185000, '2025-04-15 08:33:05'),
('sql_screenshots', 16, '2025-04-15 08:34:05', 'id_fa9ee44463344728', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110890469_1744677245000_87571440_1744677245000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b868996cd9234cf5adc8a3a95ea0e4f8.jpg", "device_id": "16f5de0d-cedd-42bf-8c7b-bb75d1d791cf", "is_chatting": 1, "label_rate": 0, "log_seq": "8cd0644502754445adf999dccf0d9698", "phone_model": "Samsung_S22", "rate": 3, "target_id": "110890469"}', '2025-04-15 08:34:05', 1744677245000, '2025-04-15 08:34:05'),
('sql_screenshots', 16, '2025-04-15 08:35:05', 'id_775e251e436c46f3', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109980113_1744677305000_110890469_1744677305000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b4f451a3eb0941e2abc241a4e33a9d3d.jpg", "device_id": "6c20feca-1dd5-4054-ae7b-5730e1eb4f5d", "is_chatting": 1, "label_rate": 2, "log_seq": "d004766a78434769ba2c78cfcf374f29", "phone_model": "Samsung_S22", "rate": 4, "target_id": "109980113"}', '2025-04-15 08:35:05', 1744677305000, '2025-04-15 08:35:05'),
('sql_screenshots', 16, '2025-04-15 08:36:05', 'id_0bb8e30c923f4b72', 109657261, 'product_1',  '{"account_id": 109657261, "account_ids": [109657261, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "28230174_1744677365000_109657261_1744677365000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/06c918d502954b8790c12d49141ff1cb.jpg", "device_id": "50a1d326-1008-4120-9c36-b656ce4d6f26", "is_chatting": 1, "label_rate": 0, "log_seq": "c07d8a4c6cac462a9f36b938dbfbbcc2", "phone_model": "OnePlus_9", "rate": 5, "target_id": "28230174"}', '2025-04-15 08:36:05', 1744677365000, '2025-04-15 08:36:05'),
('sql_screenshots', 16, '2025-04-15 08:37:05', 'id_e741144b9a944146', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105503656_1744677425000_64280379_1744677425000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/477796ffd8b04ed7a3b0771643c31b8d.jpg", "device_id": "90b46b91-1bda-4f99-923f-d80a7c067784", "is_chatting": 1, "label_rate": 2, "log_seq": "a7a454a1dc8741b9b1371347c94254cc", "phone_model": "Samsung_S21", "rate": 4, "target_id": "105503656"}', '2025-04-15 08:37:05', 1744677425000, '2025-04-15 08:37:05'),
('sql_screenshots', 16, '2025-04-15 08:38:05', 'id_9d08d80fde7a441e', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "105503656_1744677485000_110892617_1744677485000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b18bfd66c62042f49586489b7d481273.jpg", "device_id": "48a2bb1d-32ff-4def-bc23-799315e2bf53", "is_chatting": 1, "label_rate": 1, "log_seq": "efdcafb2a124487ab332d72744da3812", "phone_model": "iPhone_14_Pro", "rate": 2, "target_id": "105503656"}', '2025-04-15 08:38:05', 1744677485000, '2025-04-15 08:38:05'),
('sql_screenshots', 16, '2025-04-15 08:39:05', 'id_5926fc01c6c64ff3', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110892617_1744677545000_108466147_1744677545000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3652287b19cb4128a9335fb5922c4a8b.jpg", "device_id": "41f1c30d-1280-468a-9f41-789c21c94ded", "is_chatting": 1, "label_rate": 2, "log_seq": "2f208fe25e6b4f39aff8a1fa934cd53e", "phone_model": "Huawei_P40", "rate": 1, "target_id": "110892617"}', '2025-04-15 08:39:05', 1744677545000, '2025-04-15 08:39:05'),
('sql_screenshots', 16, '2025-04-15 08:40:05', 'id_e5437b3e15a548a1', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "54675542_1744677605000_109744448_1744677605000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/de21698ea0e1459e9e31dbaa7564e091.jpg", "device_id": "d4f094cd-09f2-41a2-a945-dcc54dc03d23", "is_chatting": 1, "label_rate": 2, "log_seq": "d0b947a98a9a4058bd33058ebfae7784", "phone_model": "Huawei_P40", "rate": 5, "target_id": "54675542"}', '2025-04-15 08:40:05', 1744677605000, '2025-04-15 08:40:05'),
('sql_screenshots', 16, '2025-04-15 08:41:05', 'id_b98f884da2944f47', 110890469, 'product_1',  '{"account_id": 110890469, "account_ids": [110890469, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110892617_1744677665000_110890469_1744677665000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b395ced4c9a64cddb769f649a1bdcb1a.jpg", "device_id": "ac96869f-5fec-438a-a7a1-049a30c112a9", "is_chatting": 1, "label_rate": 0, "log_seq": "6fbf20190941460fb594fca9c8851c5c", "phone_model": "OnePlus_9", "rate": 3, "target_id": "110892617"}', '2025-04-15 08:41:05', 1744677665000, '2025-04-15 08:41:05'),
('sql_screenshots', 16, '2025-04-15 08:42:05', 'id_8a8712276c95413e', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 83341608], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "83341608_1744677725000_105503656_1744677725000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5b3423945a974e68a34d8dd7b5c3f754.jpg", "device_id": "d6859cec-9840-4293-a672-67f08df3c016", "is_chatting": 1, "label_rate": 1, "log_seq": "abfbe45022df4a53858b33d53a5f3358", "phone_model": "iPhone_13", "rate": 0, "target_id": "83341608"}', '2025-04-15 08:42:05', 1744677725000, '2025-04-15 08:42:05'),
('sql_screenshots', 16, '2025-04-15 08:43:05', 'id_cea163cee9fb4712', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 107039703], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "107039703_1744677785000_108870508_1744677785000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7f070a384ea141719fad758d1ba6fa10.jpg", "device_id": "e595ec2e-4402-4069-9a8b-1ddec5d045a7", "is_chatting": 1, "label_rate": 0, "log_seq": "086b5ed315f04f90a82b2a9dbc12317c", "phone_model": "OPPO_CPH1937", "rate": 5, "target_id": "107039703"}', '2025-04-15 08:43:05', 1744677785000, '2025-04-15 08:43:05'),
('sql_screenshots', 16, '2025-04-15 08:44:05', 'id_0680211879ca4864', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "110766160_1744677845000_104844318_1744677845000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/113234b0684448b29cc12cbde3eb8b7d.jpg", "device_id": "35c0753f-5694-4454-91c8-7f587fbc1eb3", "is_chatting": 1, "label_rate": 0, "log_seq": "ca05db6df5284e11b027682bf774fa50", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "110766160"}', '2025-04-15 08:44:05', 1744677845000, '2025-04-15 08:44:05'),
('sql_screenshots', 16, '2025-04-15 08:45:05', 'id_a6dad746ffd44797', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109657261_1744677905000_105083641_1744677905000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/7b01e02d6757435db8fd3a55867584c3.jpg", "device_id": "fc0205a7-cf50-4194-918f-4b9ca86d939b", "is_chatting": 1, "label_rate": 1, "log_seq": "d2851a904bc5443f9eaa1773d4474fcf", "phone_model": "VIVO_X60", "rate": 4, "target_id": "109657261"}', '2025-04-15 08:45:05', 1744677905000, '2025-04-15 08:45:05'),
('sql_screenshots', 16, '2025-04-15 08:46:05', 'id_8b53088734d84a6f', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 108466147], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108466147_1744677965000_64280379_1744677965000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/50a38115eb3d484ba2698b93892827fb.jpg", "device_id": "e858c3b9-d1fb-40cb-b369-e807f4210f05", "is_chatting": 1, "label_rate": 2, "log_seq": "9cd884d8ac7149b38e749edfaa39211f", "phone_model": "OPPO_CPH1937", "rate": 1, "target_id": "108466147"}', '2025-04-15 08:46:05', 1744677965000, '2025-04-15 08:46:05'),
('sql_screenshots', 16, '2025-04-15 08:47:05', 'id_4cc08dfbd4364730', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 28230174], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "28230174_1744678025000_110876251_1744678025000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/47aa92c511e6486590bf5bee6d9a34c2.jpg", "device_id": "4257b86d-66d0-43e2-a78a-08f78f7d1fc3", "is_chatting": 1, "label_rate": 1, "log_seq": "e7d5df8318b246aaacd4ac77972c3df0", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "28230174"}', '2025-04-15 08:47:05', 1744678025000, '2025-04-15 08:47:05'),
('sql_screenshots', 16, '2025-04-15 08:48:05', 'id_d275d99fa0584e32', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "110215081_1744678085000_82365582_1744678085000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/353b3509a56b4a95b503b18a42533b4e.jpg", "device_id": "5fc689c9-0627-446d-91cd-060d88c76699", "is_chatting": 1, "label_rate": 0, "log_seq": "e427a7e8d21a4ee297b3e0d99090ca63", "phone_model": "Huawei_P40", "rate": 4, "target_id": "110215081"}', '2025-04-15 08:48:05', 1744678085000, '2025-04-15 08:48:05'),
('sql_screenshots', 16, '2025-04-15 08:49:05', 'id_5dfb2bfb3d314902', 109744448, 'product_1',  '{"account_id": 109744448, "account_ids": [109744448, 110890469], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110890469_1744678145000_109744448_1744678145000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/cd995a9cffa34d70843519bacf295542.jpg", "device_id": "2f8aa6d0-9870-47f0-ad92-cc726d0d31d9", "is_chatting": 1, "label_rate": 0, "log_seq": "27dc4d6d989e464399fa76871e817093", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "110890469"}', '2025-04-15 08:49:05', 1744678145000, '2025-04-15 08:49:05'),
('sql_screenshots', 16, '2025-04-15 08:50:05', 'id_93aa62720fc045dc', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "54675542_1744678205000_110876251_1744678205000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8bc7107b963d4857adb0538a5fe2843b.jpg", "device_id": "a0369f04-8190-4f91-aa75-f965e75110f9", "is_chatting": 1, "label_rate": 1, "log_seq": "c7b5c221080046f98f65dbaaaa12e16f", "phone_model": "Samsung_S22", "rate": 0, "target_id": "54675542"}', '2025-04-15 08:50:05', 1744678205000, '2025-04-15 08:50:05'),
('sql_screenshots', 16, '2025-04-15 08:51:05', 'id_4aeaa98ff1484b82', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "54675542_1744678265000_110215081_1744678265000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e419e5117549433d920863ab1434640c.jpg", "device_id": "02b4ab70-b6a5-485d-ba64-2f87431f3047", "is_chatting": 1, "label_rate": 0, "log_seq": "17460c49a5794ada83417b8e3bb28db7", "phone_model": "VIVO_X60", "rate": 2, "target_id": "54675542"}', '2025-04-15 08:51:05', 1744678265000, '2025-04-15 08:51:05'),
('sql_screenshots', 16, '2025-04-15 08:52:05', 'id_818577e07c8c4abf', 110876251, 'product_1',  '{"account_id": 110876251, "account_ids": [110876251, 109407413], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "109407413_1744678325000_110876251_1744678325000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/8767041288c94fd2a02db776a08e2ce3.jpg", "device_id": "e94689a7-f7f4-4c13-8e2e-484c4d1438aa", "is_chatting": 1, "label_rate": 2, "log_seq": "d75aa84ba6504045bf1d115b804543ec", "phone_model": "OnePlus_9", "rate": 4, "target_id": "109407413"}', '2025-04-15 08:52:05', 1744678325000, '2025-04-15 08:52:05'),
('sql_screenshots', 16, '2025-04-15 08:53:05', 'id_7d844445b9d14be0', 110215081, 'product_1',  '{"account_id": 110215081, "account_ids": [110215081, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "32970671_1744678385000_110215081_1744678385000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f7dec6537ae3466a81481edf8890d9a5.jpg", "device_id": "3e3b18c9-362f-4812-877b-86e4e0edbccb", "is_chatting": 1, "label_rate": 0, "log_seq": "8d6324b96bc74c0cbc55deb3d4ecdbbe", "phone_model": "Xiaomi_12", "rate": 1, "target_id": "32970671"}', '2025-04-15 08:53:05', 1744678385000, '2025-04-15 08:53:05'),
('sql_screenshots', 16, '2025-04-15 08:54:05', 'id_620ae58176954c9b', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "87571440_1744678445000_28230174_1744678445000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/b83a60fe52fe43779aa184c69e29764b.jpg", "device_id": "dceb51cc-26d8-49bd-be39-357e59d9cb7e", "is_chatting": 1, "label_rate": 2, "log_seq": "220c4233dd00493895eabe35c7bd0ec5", "phone_model": "Samsung_S21", "rate": 1, "target_id": "87571440"}', '2025-04-15 08:54:05', 1744678445000, '2025-04-15 08:54:05'),
('sql_screenshots', 16, '2025-04-15 08:55:05', 'id_c87b0125e0324c7d', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 110892617], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "110892617_1744678505000_110873051_1744678505000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4cbed5e0957546bfbe2adf88af1fec7b.jpg", "device_id": "57af9202-3afb-4607-ae6e-789a17ace4e0", "is_chatting": 1, "label_rate": 0, "log_seq": "a28570dbdbbc4e01bb4571af2718dc26", "phone_model": "VIVO_X60", "rate": 2, "target_id": "110892617"}', '2025-04-15 08:55:05', 1744678505000, '2025-04-15 08:55:05'),
('sql_screenshots', 16, '2025-04-15 08:56:05', 'id_22136790a2074dca', 101553185, 'product_1',  '{"account_id": 101553185, "account_ids": [101553185, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105083641_1744678565000_101553185_1744678565000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/03ead0f6a0f445fe943a96cdf2d75d6c.jpg", "device_id": "6f0efe93-c507-488e-bcd3-1452ed9d9517", "is_chatting": 1, "label_rate": 2, "log_seq": "d21125c27eab40c58242ebb1140bbb92", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "105083641"}', '2025-04-15 08:56:05', 1744678565000, '2025-04-15 08:56:05'),
('sql_screenshots', 16, '2025-04-15 08:57:05', 'id_181853eb14ec429a', 82365582, 'product_1',  '{"account_id": 82365582, "account_ids": [82365582, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "87571440_1744678625000_82365582_1744678625000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d95dc2eb375a40a0b7104bd91a65b4ce.jpg", "device_id": "dc4273da-457f-489c-9c60-38e13acf5795", "is_chatting": 1, "label_rate": 2, "log_seq": "fcbb3b796de9442e9bbe9668c63d8833", "phone_model": "Huawei_P40", "rate": 4, "target_id": "87571440"}', '2025-04-15 08:57:05', 1744678625000, '2025-04-15 08:57:05'),
('sql_screenshots', 16, '2025-04-15 08:58:05', 'id_e9cfdd32d2f54171', 32970671, 'product_1',  '{"account_id": 32970671, "account_ids": [32970671, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "54675542_1744678685000_32970671_1744678685000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/69e2bc6e13d246279243d0008a989452.jpg", "device_id": "d741397e-c937-42ad-b65e-110c8fd0e511", "is_chatting": 1, "label_rate": 1, "log_seq": "947abe4f84f945c7accada12813be2ce", "phone_model": "VIVO_X60", "rate": 0, "target_id": "54675542"}', '2025-04-15 08:58:05', 1744678685000, '2025-04-15 08:58:05'),
('sql_screenshots', 16, '2025-04-15 08:59:05', 'id_f2bdb362ba3c49ff', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 101553185], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "101553185_1744678745000_105083641_1744678745000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/f9f1fdf2debf473b9aa8020aa3ba99ab.jpg", "device_id": "1e6a138a-b963-4324-9a78-4ed97ba006e9", "is_chatting": 1, "label_rate": 2, "log_seq": "697df58a4ea44fbea60ddc9cb30f515a", "phone_model": "Xiaomi_12", "rate": 0, "target_id": "101553185"}', '2025-04-15 08:59:05', 1744678745000, '2025-04-15 08:59:05'),
('sql_screenshots', 16, '2025-04-15 09:00:05', 'id_66379fce9c7c4271', 110873051, 'product_1',  '{"account_id": 110873051, "account_ids": [110873051, 105083641], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "105083641_1744678805000_110873051_1744678805000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9b03214b42c541cdad65ed58cbee572a.jpg", "device_id": "e1214a4f-1832-4ae9-9742-1bb5480352d9", "is_chatting": 1, "label_rate": 2, "log_seq": "fe714e2a9e98467bbd45c93cc1a8ca45", "phone_model": "Samsung_S22", "rate": 3, "target_id": "105083641"}', '2025-04-15 09:00:05', 1744678805000, '2025-04-15 09:00:05'),
('sql_screenshots', 16, '2025-04-15 09:01:05', 'id_c1a1b6a86ca14cf4', 94369556, 'product_1',  '{"account_id": 94369556, "account_ids": [94369556, 32970671], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "32970671_1744678865000_94369556_1744678865000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1c04d8d2f88645e889934e68fbfb1fdd.jpg", "device_id": "87c22272-078f-46cc-8952-fa74dc607de4", "is_chatting": 1, "label_rate": 1, "log_seq": "69c59294080b49bca0673b40ad37e4a6", "phone_model": "OPPO_CPH1937", "rate": 3, "target_id": "32970671"}', '2025-04-15 09:01:05', 1744678865000, '2025-04-15 09:01:05'),
('sql_screenshots', 16, '2025-04-15 09:02:05', 'id_9a3fdc59fae3459a', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 109744448], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.7", "channel_id": "109744448_1744678925000_104844318_1744678925000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/3260157168b34d0db2195a16ab884ede.jpg", "device_id": "ebe5c4f0-52ea-45f6-a186-2562859aee42", "is_chatting": 1, "label_rate": 2, "log_seq": "ab00bc4e486d47dda8e996972ccbebe4", "phone_model": "VIVO_X60", "rate": 5, "target_id": "109744448"}', '2025-04-15 09:02:05', 1744678925000, '2025-04-15 09:02:05'),
('sql_screenshots', 16, '2025-04-15 09:03:05', 'id_bac67f744f734fb3', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109980113_1744678985000_54675542_1744678985000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5a499994ea394bc69a08648c30429966.jpg", "device_id": "8dc6f75a-6e16-43e9-9621-60b0a293c03e", "is_chatting": 1, "label_rate": 1, "log_seq": "43e388e8a84b48ce821065f3ac5acb54", "phone_model": "Samsung_S22", "rate": 0, "target_id": "109980113"}', '2025-04-15 09:03:05', 1744678985000, '2025-04-15 09:03:05'),
('sql_screenshots', 16, '2025-04-15 09:04:05', 'id_250f9391941748ea', 28230174, 'product_1',  '{"account_id": 28230174, "account_ids": [28230174, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110215081_1744679045000_28230174_1744679045000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/4b648873d4e54e41b6bdbc9e194611de.jpg", "device_id": "a4b6a192-a2f9-4c84-8e77-b0052c8bff48", "is_chatting": 1, "label_rate": 1, "log_seq": "79c6411dd215424dbe02078b33713f21", "phone_model": "Samsung_S21", "rate": 5, "target_id": "110215081"}', '2025-04-15 09:04:05', 1744679045000, '2025-04-15 09:04:05'),
('sql_screenshots', 16, '2025-04-15 09:05:05', 'id_2825f3ba0dd94b5b', 105083641, 'product_1',  '{"account_id": 105083641, "account_ids": [105083641, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110215081_1744679105000_105083641_1744679105000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/90e8b4ad461e4688bed09e6179caf980.jpg", "device_id": "7e05e321-cbbb-47d8-93ef-000c65bc39f6", "is_chatting": 1, "label_rate": 1, "log_seq": "7faebcc634634fa5a6fe9926324b08b9", "phone_model": "Huawei_P40", "rate": 5, "target_id": "110215081"}', '2025-04-15 09:05:05', 1744679105000, '2025-04-15 09:05:05'),
('sql_screenshots', 16, '2025-04-15 09:06:05', 'id_03c15959b6794b6e', 54675542, 'product_1',  '{"account_id": 54675542, "account_ids": [54675542, 110215081], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110215081_1744679165000_54675542_1744679165000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/1664b72654b048cd8ddadb5bbc3efc1e.jpg", "device_id": "54e42c1f-4c27-4fd3-af92-c6f3e3688c78", "is_chatting": 1, "label_rate": 1, "log_seq": "10f9a2adc1c34dac9b4e606cefada2b6", "phone_model": "Huawei_P40", "rate": 3, "target_id": "110215081"}', '2025-04-15 09:06:05', 1744679165000, '2025-04-15 09:06:05'),
('sql_screenshots', 16, '2025-04-15 09:07:05', 'id_0c719293deeb4b84', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 109657261], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "109657261_1744679225000_109407413_1744679225000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/124c935b5b624ca6b53d8b6d5d90a56b.jpg", "device_id": "b31a2a04-10bd-4249-8c86-a8f62a250829", "is_chatting": 1, "label_rate": 0, "log_seq": "127cf84fa971437fabb2e4f5f43383d8", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "109657261"}', '2025-04-15 09:07:05', 1744679225000, '2025-04-15 09:07:05'),
('sql_screenshots', 16, '2025-04-15 09:08:05', 'id_6d4bd2180cba49fb', 104844318, 'product_1',  '{"account_id": 104844318, "account_ids": [104844318, 94369556], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "94369556_1744679285000_104844318_1744679285000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/15d9f4b789204c5fa6d2802e8923764d.jpg", "device_id": "1f0aa816-24a1-411f-a012-dfc373d86300", "is_chatting": 1, "label_rate": 2, "log_seq": "1956b33630404687ace7f9f2d07643e1", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "94369556"}', '2025-04-15 09:08:05', 1744679285000, '2025-04-15 09:08:05'),
('sql_screenshots', 16, '2025-04-15 09:09:05', 'id_8f4391614cef42b7', 109407413, 'product_1',  '{"account_id": 109407413, "account_ids": [109407413, 87571440], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "87571440_1744679345000_109407413_1744679345000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/e8809c69d3454ee1b47c3a55cec0de2a.jpg", "device_id": "ab8c5afd-fe51-4267-b936-6972f45f4aad", "is_chatting": 1, "label_rate": 2, "log_seq": "21f96e56b3464eb89df9855bd2fd0826", "phone_model": "Samsung_S22", "rate": 3, "target_id": "87571440"}', '2025-04-15 09:09:05', 1744679345000, '2025-04-15 09:09:05'),
('sql_screenshots', 16, '2025-04-15 09:10:05', 'id_4d083a19c60944fc', 87571440, 'product_1',  '{"account_id": 87571440, "account_ids": [87571440, 57649476], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "57649476_1744679405000_87571440_1744679405000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/40cc7b8e2e594fec88fa42300eea76af.jpg", "device_id": "3f095d76-8aba-4288-95cb-750ed767efd8", "is_chatting": 1, "label_rate": 1, "log_seq": "40c0e8297a4446d0af81f17b7f047281", "phone_model": "iPhone_14_Pro", "rate": 5, "target_id": "57649476"}', '2025-04-15 09:10:05', 1744679405000, '2025-04-15 09:10:05'),
('sql_screenshots', 16, '2025-04-15 09:11:05', 'id_81029f74589f4d8f', 108870508, 'product_1',  '{"account_id": 108870508, "account_ids": [108870508, 110766160], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110766160_1744679465000_108870508_1744679465000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/01280e16dd4040378c38044de2f0ce63.jpg", "device_id": "ec79713e-2e87-4051-a97c-1e4eb106afca", "is_chatting": 1, "label_rate": 0, "log_seq": "30f861c40db145d7a21097767251dcf0", "phone_model": "OPPO_Find_X3", "rate": 4, "target_id": "110766160"}', '2025-04-15 09:11:05', 1744679465000, '2025-04-15 09:11:05'),
('sql_screenshots', 16, '2025-04-15 09:12:05', 'id_965e95f400424b26', 64280379, 'product_1',  '{"account_id": 64280379, "account_ids": [64280379, 109980113], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "109980113_1744679525000_64280379_1744679525000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/ca3078ba57804b4e82eb142025846a40.jpg", "device_id": "75420ddd-1d15-4d6c-a7a8-0577ee4faada", "is_chatting": 1, "label_rate": 1, "log_seq": "920dcc98786c401493753bd8368a7821", "phone_model": "Samsung_S22", "rate": 5, "target_id": "109980113"}', '2025-04-15 09:12:05', 1744679525000, '2025-04-15 09:12:05'),
('sql_screenshots', 16, '2025-04-15 09:13:05', 'id_b2de08411c0b4e3c', 108466147, 'product_1',  '{"account_id": 108466147, "account_ids": [108466147, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.1", "channel_id": "110876251_1744679585000_108466147_1744679585000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/0b886466107749eab26b81b1ec73bb82.jpg", "device_id": "2ead407e-05dd-44d6-b7d5-29225018204e", "is_chatting": 1, "label_rate": 1, "log_seq": "bffeec68a2014cd5a98a60f975293f56", "phone_model": "OPPO_Find_X3", "rate": 5, "target_id": "110876251"}', '2025-04-15 09:13:05', 1744679585000, '2025-04-15 09:13:05'),
('sql_screenshots', 16, '2025-04-15 09:14:05', 'id_82cf2cd5ccb34315', 110766160, 'product_1',  '{"account_id": 110766160, "account_ids": [110766160, 54675542], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "54675542_1744679645000_110766160_1744679645000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5e5d8a389517495697811c2981289ebb.jpg", "device_id": "cfa6525b-7aee-4622-a42a-0c45e36aac60", "is_chatting": 1, "label_rate": 2, "log_seq": "7d6694ce759a48329cbe59f43afe7cc2", "phone_model": "iPhone_13", "rate": 2, "target_id": "54675542"}', '2025-04-15 09:14:05', 1744679645000, '2025-04-15 09:14:05'),
('sql_screenshots', 16, '2025-04-15 09:15:05', 'id_cc49558b11f542c1', 110892617, 'product_1',  '{"account_id": 110892617, "account_ids": [110892617, 105503656], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "105503656_1744679705000_110892617_1744679705000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9a1d3d6a55d44a77bb4b308571c9a50c.jpg", "device_id": "e17af03f-1e83-4628-99c7-1839c0d4e345", "is_chatting": 1, "label_rate": 2, "log_seq": "574b543e88884b7da332b56219d35e86", "phone_model": "Xiaomi_12", "rate": 5, "target_id": "105503656"}', '2025-04-15 09:15:05', 1744679705000, '2025-04-15 09:15:05'),
('sql_screenshots', 16, '2025-04-15 09:16:05', 'id_810547deb06349ed', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "81479540_1744679765000_105503656_1744679765000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/5efb04308ff84b7ca7f21d5778972dc4.jpg", "device_id": "c9d45ef4-2d79-482f-a0be-c0492c6778ea", "is_chatting": 1, "label_rate": 1, "log_seq": "aa86eb74c46649c3bcafbdf7f409a9d5", "phone_model": "VIVO_X60", "rate": 1, "target_id": "81479540"}', '2025-04-15 09:16:05', 1744679765000, '2025-04-15 09:16:05'),
('sql_screenshots', 16, '2025-04-15 09:17:05', 'id_2d01bd0b444f46c4', 109980113, 'product_1',  '{"account_id": 109980113, "account_ids": [109980113, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "2.0.0", "channel_id": "108870508_1744679825000_109980113_1744679825000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/bcf0cb7f24914ffc89d0210a854295e0.jpg", "device_id": "33ed1153-2e39-442c-a597-3909093d13d3", "is_chatting": 1, "label_rate": 0, "log_seq": "6dac92544bcf48b2afeb3f64bf2530df", "phone_model": "Xiaomi_12", "rate": 2, "target_id": "108870508"}', '2025-04-15 09:17:05', 1744679825000, '2025-04-15 09:17:05'),
('sql_screenshots', 16, '2025-04-15 09:18:05', 'id_b246a15b589e40b3', 57649476, 'product_1',  '{"account_id": 57649476, "account_ids": [57649476, 81479540], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.8", "channel_id": "81479540_1744679885000_57649476_1744679885000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/9e62c881a93e4ee3835f74393a9906a1.jpg", "device_id": "67e8afb8-49cc-4e24-a69e-2f66d774cd06", "is_chatting": 1, "label_rate": 0, "log_seq": "a9b2f5d98ae74636bbcde7a07db02f24", "phone_model": "Samsung_S21", "rate": 1, "target_id": "81479540"}', '2025-04-15 09:18:05', 1744679885000, '2025-04-15 09:18:05'),
('sql_screenshots', 16, '2025-04-15 09:19:05', 'id_f06bb5f91dd944fe', 105503656, 'product_1',  '{"account_id": 105503656, "account_ids": [105503656, 110876251], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "110876251_1744679945000_105503656_1744679945000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/d7be0dd93d93413d99bbacbbe3d35583.jpg", "device_id": "e9d1bc66-43fb-4042-b068-a4fd3082c551", "is_chatting": 1, "label_rate": 2, "log_seq": "a007932de5da47ddb9311ee41a942a8a", "phone_model": "Samsung_S22", "rate": 1, "target_id": "110876251"}', '2025-04-15 09:19:05', 1744679945000, '2025-04-15 09:19:05'),
('sql_screenshots', 16, '2025-04-15 09:20:05', 'id_047b0ff1ca964965', 107039703, 'product_1',  '{"account_id": 107039703, "account_ids": [107039703, 108870508], "active": 1, "app_channel": "mkg", "app_name": "com.matchu.machat", "app_version": "1.9.9", "channel_id": "108870508_1744680005000_107039703_1744680005000", "cover_url": "https://res.matchu.app/image/screenshot/2025-04-14/651092b88e514a1e8e898eb2dcc74a6f.jpg", "device_id": "50d7c99b-6789-438a-a1f8-b2cd265fe5ad", "is_chatting": 1, "label_rate": 2, "log_seq": "8012f60373144b3db93c8bfcf6085e2d", "phone_model": "Xiaomi_12", "rate": 4, "target_id": "108870508"}', '2025-04-15 09:20:05', 1744680005000, '2025-04-15 09:20:05');


WITH a as (SELECT   account_id,  properties['cover_url'] cover_url,  ROW_NUMBER() OVER (PARTITION BY account_id ORDER BY sql_created_time DESC) AS rn  FROM sql_screenshots  WHERE   `sql` = 'sql_screenshots'   AND   account_id in (110892617,105083641,110675452,107039703,54675542,109744448,105503656,110890469,109657261,108466147,108870508,32970671,81479540,101553185,110215081,110873051,82365582,110876251,28230174,57649476,109980113,104844318,109407413,87571440,64280379,110371823,110766160,94369556,83341608,110699258) ) SELECT account_id, GROUP_CONCAT(CAST(cover_url AS CHAR)) cover_url FROM a WHERE rn <= 10 GROUP BY a.account_id order by a.account_id;
