/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io;

import com.github.rvesse.airline.io.ControlCodeSource;
import java.io.IOException;

public abstract class ControlTracker<T> {
    protected final ControlCodeSource<T> provider;
    private T current;
    private T previous;
    private boolean requireWrite = false;

    public ControlTracker(ControlCodeSource<T> provider) {
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        this.provider = provider;
    }

    public final void set(T value) {
        this.current = value;
        this.requireWrite = this.current != null && !this.current.equals(this.previous);
    }

    public final void reset() throws IOException {
        if (this.previous != null) {
            this.resetInternal(this.previous);
            this.previous = null;
        }
    }

    protected abstract void resetInternal(T var1) throws IOException;

    public final void apply() throws IOException {
        if (this.requireWrite) {
            this.applyInternal(this.current);
            this.previous = this.current;
            this.requireWrite = false;
        }
    }

    protected abstract void applyInternal(T var1) throws IOException;
}

