/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.indexing.error.MSQFaultUtils;

public class WorkerRunRef {
    private static final Logger log = new Logger(WorkerRunRef.class);
    private final AtomicReference<Worker> workerRef = new AtomicReference();
    private final AtomicReference<ListenableFuture<?>> futureRef = new AtomicReference();

    public ListenableFuture<?> run(Worker worker, ListeningExecutorService exec) {
        if (!this.workerRef.compareAndSet(null, worker)) {
            throw DruidException.defensive((String)"Already run", (Object[])new Object[0]);
        }
        ListenableFuture<?> priorFuture = this.futureRef.get();
        if (priorFuture != null) {
            return priorFuture;
        }
        ListenableFuture future = exec.submit(() -> {
            String originalThreadName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(StringUtils.format((String)"%s[%s]", (Object[])new Object[]{originalThreadName, worker.id()}));
                worker.run();
            }
            catch (Throwable t) {
                if (Thread.interrupted() || MSQFaultUtils.isCanceledException(t)) {
                    log.debug(t, "Canceled, exiting thread.", new Object[0]);
                } else {
                    log.warn(t, "Worker[%s] failed and stopped.", new Object[]{worker.id()});
                }
            }
            finally {
                Thread.currentThread().setName(originalThreadName);
            }
        });
        if (!this.futureRef.compareAndSet(null, future)) {
            future.cancel(true);
        }
        return this.futureRef.get();
    }

    public Worker worker() {
        Worker worker = this.workerRef.get();
        if (worker == null) {
            throw DruidException.defensive((String)"No worker, not run yet?", (Object[])new Object[0]);
        }
        return worker;
    }

    public void cancel() {
        ListenableFuture existingFuture = this.futureRef.getAndSet(Futures.immediateFuture(null));
        if (existingFuture != null && !existingFuture.isDone()) {
            existingFuture.cancel(true);
        }
    }

    public void awaitStop() {
        ListenableFuture<?> future = this.futureRef.get();
        if (future == null) {
            throw DruidException.defensive((String)"Not running", (Object[])new Object[0]);
        }
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (CancellationException | ExecutionException exception) {
            // empty catch block
        }
    }
}

