/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.prefetch.JsonIterator;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;

public class SqlReader
extends IntermediateRowParsingReader<Map<String, Object>> {
    private final InputRowSchema inputRowSchema;
    private final InputEntity source;
    private final File temporaryDirectory;
    private final ObjectMapper objectMapper;

    SqlReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory, ObjectMapper objectMapper) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
        this.temporaryDirectory = temporaryDirectory;
        this.objectMapper = objectMapper;
    }

    protected CloseableIterator<Map<String, Object>> intermediateRowIterator() throws IOException {
        Closer closer = Closer.create();
        InputEntity.CleanableFile resultFile = (InputEntity.CleanableFile)closer.register((Closeable)this.source.fetch(this.temporaryDirectory, null));
        FileInputStream inputStream = new FileInputStream(resultFile.file());
        JsonIterator jsonIterator = new JsonIterator((TypeReference)new TypeReference<Map<String, Object>>(){}, (InputStream)inputStream, (Closeable)closer, this.objectMapper);
        return jsonIterator;
    }

    protected InputEntity source() {
        return this.source;
    }

    protected List<InputRow> parseInputRows(Map<String, Object> intermediateRow) throws ParseException {
        return Collections.singletonList(MapInputRowParser.parse((InputRowSchema)this.inputRowSchema, intermediateRow));
    }

    protected List<Map<String, Object>> toMap(Map<String, Object> intermediateRow) {
        return Collections.singletonList(intermediateRow);
    }
}

