/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import javax.annotation.Nullable;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.ConstantMatcherType;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorSizeInspector;
import org.apache.druid.segment.vector.VectorValueSelector;

public interface VectorValueMatcher
extends VectorSizeInspector {
    public ReadableVectorMatch match(ReadableVectorMatch var1, boolean var2);

    public static VectorValueMatcher nullMatcher(final VectorValueSelector selector) {
        return new BaseVectorValueMatcher(selector){
            final VectorMatch match;
            {
                super(selector2);
                this.match = VectorMatch.wrap(new int[selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                return VectorValueMatcher.matchNulls(mask, this.match, selector.getNullVector());
            }
        };
    }

    public static VectorValueMatcher allFalseSingleValueDimensionMatcher(final SingleValueDimensionVectorSelector selector) {
        IdLookup idLookup = selector.idLookup();
        final VectorMatch match = VectorMatch.wrap(new int[selector.getMaxVectorSize()]);
        if (idLookup == null || !selector.nameLookupPossibleInAdvance()) {
            return new BaseVectorValueMatcher(selector){

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                    if (includeUnknown) {
                        int[] vector = selector.getRowVector();
                        int[] inputSelection = mask.getSelection();
                        int inputSelectionSize = mask.getSelectionSize();
                        int[] outputSelection = match.getSelection();
                        int outputSelectionSize = 0;
                        for (int i = 0; i < inputSelectionSize; ++i) {
                            int rowNum = inputSelection[i];
                            if (selector.lookupName(vector[rowNum]) != null) continue;
                            outputSelection[outputSelectionSize++] = rowNum;
                        }
                        match.setSelectionSize(outputSelectionSize);
                        return match;
                    }
                    return VectorMatch.allFalse();
                }
            };
        }
        final int nullId = idLookup.lookupId(null);
        if (nullId < 0) {
            return ConstantMatcherType.ALL_FALSE.asVectorMatcher(selector);
        }
        return new BaseVectorValueMatcher(selector){

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                if (includeUnknown) {
                    int[] vector = selector.getRowVector();
                    int[] inputSelection = mask.getSelection();
                    int inputSelectionSize = mask.getSelectionSize();
                    int[] outputSelection = match.getSelection();
                    int outputSelectionSize = 0;
                    for (int i = 0; i < inputSelectionSize; ++i) {
                        int rowNum = inputSelection[i];
                        if (vector[rowNum] != nullId) continue;
                        outputSelection[outputSelectionSize++] = rowNum;
                    }
                    match.setSelectionSize(outputSelectionSize);
                    return match;
                }
                return VectorMatch.allFalse();
            }
        };
    }

    public static VectorValueMatcher allFalseMultiValueDimensionMatcher(final MultiValueDimensionVectorSelector selector) {
        IdLookup idLookup = selector.idLookup();
        final VectorMatch match = VectorMatch.wrap(new int[selector.getMaxVectorSize()]);
        if (idLookup == null || !selector.nameLookupPossibleInAdvance()) {
            return new BaseVectorValueMatcher(selector){

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                    if (includeUnknown) {
                        int numRows = 0;
                        IndexedInts[] vector = selector.getRowVector();
                        int[] selection = match.getSelection();
                        block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                            int rowNum = mask.getSelection()[i];
                            IndexedInts row = vector[rowNum];
                            if (row.size() == 0) {
                                selection[numRows++] = rowNum;
                                continue;
                            }
                            int size = row.size();
                            for (int j = 0; j < size; ++j) {
                                if (selector.lookupName(row.get(j)) != null) continue;
                                selection[numRows++] = rowNum;
                                continue block0;
                            }
                        }
                        match.setSelectionSize(numRows);
                        return match;
                    }
                    return VectorMatch.allFalse();
                }
            };
        }
        final int nullId = idLookup.lookupId(null);
        if (nullId < 0) {
            return ConstantMatcherType.ALL_FALSE.asVectorMatcher(selector);
        }
        return new BaseVectorValueMatcher(selector){

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                if (includeUnknown) {
                    int numRows = 0;
                    IndexedInts[] vector = selector.getRowVector();
                    int[] selection = match.getSelection();
                    block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        int rowNum = mask.getSelection()[i];
                        IndexedInts row = vector[rowNum];
                        if (row.size() == 0) {
                            selection[numRows++] = rowNum;
                            continue;
                        }
                        int size = row.size();
                        for (int j = 0; j < size; ++j) {
                            if (row.get(j) != nullId) continue;
                            selection[numRows++] = rowNum;
                            continue block0;
                        }
                    }
                    match.setSelectionSize(numRows);
                    return match;
                }
                return VectorMatch.allFalse();
            }
        };
    }

    public static BaseVectorValueMatcher allFalseValueMatcher(final VectorValueSelector selector) {
        return new BaseVectorValueMatcher(selector){
            final VectorMatch match;
            {
                super(selector2);
                this.match = VectorMatch.wrap(new int[selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                if (includeUnknown) {
                    return VectorValueMatcher.matchNulls(mask, this.match, selector.getNullVector());
                }
                return VectorMatch.allFalse();
            }
        };
    }

    public static VectorValueMatcher allFalseObjectMatcher(final VectorObjectSelector selector) {
        return new BaseVectorValueMatcher(selector){
            final VectorMatch match;
            {
                super(selector2);
                this.match = VectorMatch.wrap(new int[selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                if (includeUnknown) {
                    Object[] vector = selector.getObjectVector();
                    int[] inputSelection = mask.getSelection();
                    int inputSelectionSize = mask.getSelectionSize();
                    int[] outputSelection = this.match.getSelection();
                    int outputSelectionSize = 0;
                    for (int i = 0; i < inputSelectionSize; ++i) {
                        int rowNum = inputSelection[i];
                        if (vector[rowNum] != null) continue;
                        outputSelection[outputSelectionSize++] = rowNum;
                    }
                    this.match.setSelectionSize(outputSelectionSize);
                    return this.match;
                }
                return VectorMatch.allFalse();
            }
        };
    }

    public static ReadableVectorMatch matchNulls(ReadableVectorMatch mask, VectorMatch match, @Nullable boolean[] nullVector) {
        if (nullVector == null) {
            return VectorMatch.allFalse();
        }
        int[] inputSelection = mask.getSelection();
        int inputSelectionSize = mask.getSelectionSize();
        int[] outputSelection = match.getSelection();
        int outputSelectionSize = 0;
        for (int i = 0; i < inputSelectionSize; ++i) {
            int rowNum = inputSelection[i];
            if (!nullVector[rowNum]) continue;
            outputSelection[outputSelectionSize++] = rowNum;
        }
        match.setSelectionSize(outputSelectionSize);
        return match;
    }
}

