/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.having.HavingSpec;

public class OrHavingSpec
implements HavingSpec {
    private final List<HavingSpec> havingSpecs;

    @JsonCreator
    public OrHavingSpec(@JsonProperty(value="havingSpecs") List<HavingSpec> havingSpecs) {
        this.havingSpecs = havingSpecs == null ? ImmutableList.of() : havingSpecs;
    }

    @JsonProperty(value="havingSpecs")
    public List<HavingSpec> getHavingSpecs() {
        return this.havingSpecs;
    }

    @Override
    public void setQuery(GroupByQuery query) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            havingSpec.setQuery(query);
        }
    }

    @Override
    public boolean eval(ResultRow row) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            if (!havingSpec.eval(row)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrHavingSpec that = (OrHavingSpec)o;
        return !(this.havingSpecs != null ? !this.havingSpecs.equals(that.havingSpecs) : that.havingSpecs != null);
    }

    public int hashCode() {
        return this.havingSpecs != null ? this.havingSpecs.hashCode() : 0;
    }

    public String toString() {
        return "OrHavingSpec{havingSpecs=" + this.havingSpecs + "}";
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(9).appendCacheables(this.havingSpecs).build();
    }
}

