/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeboundary;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.joda.time.DateTime;

public class TimeBoundaryResultValue {
    private final Object value;

    @JsonCreator
    public TimeBoundaryResultValue(Object value) {
        this.value = value;
    }

    @JsonValue
    public Object getBaseObject() {
        return this.value;
    }

    @Nullable
    public DateTime getMaxTime() {
        if (this.value instanceof Map) {
            return this.getDateTimeValue(((Map)this.value).get("maxTime"));
        }
        return this.getDateTimeValue(this.value);
    }

    @Nullable
    public DateTime getMinTime() {
        if (this.value instanceof Map) {
            return this.getDateTimeValue(((Map)this.value).get("minTime"));
        }
        throw new IAE("MinTime not supported!", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeBoundaryResultValue that = (TimeBoundaryResultValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "TimeBoundaryResultValue{value=" + this.value + "}";
    }

    @Nullable
    private DateTime getDateTimeValue(@Nullable Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof DateTime) {
            return (DateTime)val;
        }
        if (val instanceof String) {
            return DateTimes.of((String)val);
        }
        if (val instanceof Long) {
            return DateTimes.utc((Long)val);
        }
        throw new IAE("Cannot get time from type[%s]", val.getClass());
    }
}

