/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.Interval;

public class CursorBuildSpec {
    public static final CursorBuildSpec FULL_SCAN = CursorBuildSpec.builder().build();
    @Nullable
    private final Filter filter;
    private final Interval interval;
    @Nullable
    private final List<String> groupingColumns;
    private final VirtualColumns virtualColumns;
    @Nullable
    private final List<AggregatorFactory> aggregators;
    private final List<OrderBy> preferredOrdering;
    private final QueryContext queryContext;
    private final boolean isAggregate;
    @Nullable
    private final Set<String> physicalColumns;
    @Nullable
    private final QueryMetrics<?> queryMetrics;

    public static CursorBuildSpecBuilder builder() {
        return new CursorBuildSpecBuilder();
    }

    public static CursorBuildSpecBuilder builder(CursorBuildSpec spec) {
        return new CursorBuildSpecBuilder(spec);
    }

    public CursorBuildSpec(@Nullable Filter filter, Interval interval, @Nullable Set<String> physicalColumns, VirtualColumns virtualColumns, @Nullable List<String> groupingColumns, @Nullable List<AggregatorFactory> aggregators, List<OrderBy> preferredOrdering, QueryContext queryContext, @Nullable QueryMetrics<?> queryMetrics) {
        this.filter = filter;
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.virtualColumns = (VirtualColumns)Preconditions.checkNotNull((Object)virtualColumns, (Object)"virtualColumns");
        this.physicalColumns = physicalColumns;
        this.groupingColumns = groupingColumns;
        this.aggregators = aggregators;
        this.preferredOrdering = (List)Preconditions.checkNotNull(preferredOrdering, (Object)"preferredOrdering");
        this.queryContext = (QueryContext)Preconditions.checkNotNull((Object)queryContext, (Object)"queryContext");
        this.queryMetrics = queryMetrics;
        this.isAggregate = !CollectionUtils.isNullOrEmpty(groupingColumns) || !CollectionUtils.isNullOrEmpty(aggregators);
    }

    @Nullable
    public Filter getFilter() {
        return this.filter;
    }

    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    public Set<String> getPhysicalColumns() {
        return this.physicalColumns;
    }

    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @Nullable
    public List<String> getGroupingColumns() {
        return this.groupingColumns;
    }

    @Nullable
    public List<AggregatorFactory> getAggregators() {
        return this.aggregators;
    }

    public List<OrderBy> getPreferredOrdering() {
        return this.preferredOrdering;
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    @Nullable
    public QueryMetrics<?> getQueryMetrics() {
        return this.queryMetrics;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isCompatibleOrdering(List<OrderBy> ordering) {
        if (this.preferredOrdering.isEmpty()) {
            return true;
        }
        if (ordering.size() < this.preferredOrdering.size()) {
            return false;
        }
        boolean exactMatch = ordering.get(0).equals(this.preferredOrdering.get(0));
        if (!exactMatch && !ordering.get(0).isExactReverse(this.preferredOrdering.get(0))) {
            return false;
        }
        for (int i = 1; i < this.preferredOrdering.size(); ++i) {
            if (exactMatch && ordering.get(i).equals(this.preferredOrdering.get(i)) || !exactMatch && ordering.get(i).isExactReverse(this.preferredOrdering.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CursorBuildSpec that = (CursorBuildSpec)o;
        return this.isAggregate == that.isAggregate && Objects.equals(this.filter, that.filter) && Objects.equals(this.interval, that.interval) && Objects.equals(this.groupingColumns, that.groupingColumns) && Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.aggregators, that.aggregators) && Objects.equals(this.preferredOrdering, that.preferredOrdering) && Objects.equals(this.queryContext, that.queryContext) && Objects.equals(this.physicalColumns, that.physicalColumns) && Objects.equals(this.queryMetrics, that.queryMetrics);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.interval, this.groupingColumns, this.virtualColumns, this.aggregators, this.preferredOrdering, this.queryContext, this.isAggregate, this.physicalColumns, this.queryMetrics);
    }

    public String toString() {
        return "CursorBuildSpec{filter=" + this.filter + ", interval=" + this.interval + ", groupingColumns=" + this.groupingColumns + ", virtualColumns=" + this.virtualColumns + ", aggregators=" + this.aggregators + ", preferredOrdering=" + this.preferredOrdering + ", queryContext=" + this.queryContext + ", isAggregate=" + this.isAggregate + ", physicalColumns=" + this.physicalColumns + "}";
    }

    public static class CursorBuildSpecBuilder {
        @Nullable
        private Filter filter;
        private Interval interval = Intervals.ETERNITY;
        private VirtualColumns virtualColumns = VirtualColumns.EMPTY;
        @Nullable
        private Set<String> physicalColumns;
        @Nullable
        private List<String> groupingColumns;
        @Nullable
        private List<AggregatorFactory> aggregators;
        private List<OrderBy> preferredOrdering = Collections.emptyList();
        private QueryContext queryContext = QueryContext.empty();
        @Nullable
        private QueryMetrics<?> queryMetrics;

        private CursorBuildSpecBuilder() {
        }

        private CursorBuildSpecBuilder(CursorBuildSpec buildSpec) {
            this.filter = buildSpec.filter;
            this.interval = buildSpec.interval;
            this.physicalColumns = buildSpec.physicalColumns;
            this.virtualColumns = buildSpec.virtualColumns;
            this.groupingColumns = buildSpec.groupingColumns;
            this.aggregators = buildSpec.aggregators;
            this.preferredOrdering = buildSpec.preferredOrdering;
            this.queryContext = buildSpec.queryContext;
            this.queryMetrics = buildSpec.queryMetrics;
        }

        @Nullable
        public Filter getFilter() {
            return this.filter;
        }

        public CursorBuildSpecBuilder setFilter(@Nullable Filter filter) {
            this.filter = filter;
            return this;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public CursorBuildSpecBuilder setInterval(Interval interval) {
            this.interval = interval;
            return this;
        }

        @Nullable
        public Set<String> getPhysicalColumns() {
            return this.physicalColumns;
        }

        public CursorBuildSpecBuilder setPhysicalColumns(@Nullable Set<String> physicalColumns) {
            this.physicalColumns = physicalColumns;
            return this;
        }

        public VirtualColumns getVirtualColumns() {
            return this.virtualColumns;
        }

        public CursorBuildSpecBuilder setVirtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        @Nullable
        public List<String> getGroupingColumns() {
            return this.groupingColumns;
        }

        public CursorBuildSpecBuilder setGroupingColumns(@Nullable List<String> groupingColumns) {
            this.groupingColumns = groupingColumns;
            return this;
        }

        @Nullable
        public List<AggregatorFactory> getAggregators() {
            return this.aggregators;
        }

        public CursorBuildSpecBuilder setAggregators(@Nullable List<AggregatorFactory> aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public List<OrderBy> getPreferredOrdering() {
            return this.preferredOrdering;
        }

        public CursorBuildSpecBuilder setPreferredOrdering(List<OrderBy> preferredOrdering) {
            this.preferredOrdering = preferredOrdering;
            return this;
        }

        public QueryContext getQueryContext() {
            return this.queryContext;
        }

        public CursorBuildSpecBuilder setQueryContext(QueryContext queryContext) {
            this.queryContext = queryContext;
            return this;
        }

        @Nullable
        public QueryMetrics<?> getQueryMetrics() {
            return this.queryMetrics;
        }

        public CursorBuildSpecBuilder setQueryMetrics(@Nullable QueryMetrics<?> queryMetrics) {
            this.queryMetrics = queryMetrics;
            return this;
        }

        public CursorBuildSpecBuilder andFilter(Filter filterToAdd) {
            HashSet<String> newPhysicalColumns;
            DruidException.conditionalDefensive(filterToAdd != null, "filterToAdd must not be null", new Object[0]);
            Filter newFilter = this.filter == null ? filterToAdd : Filters.and(Arrays.asList(this.filter, filterToAdd));
            if (this.physicalColumns != null) {
                newPhysicalColumns = new HashSet<String>(this.physicalColumns);
                for (String column : filterToAdd.getRequiredColumns()) {
                    if (this.virtualColumns.exists(column)) continue;
                    newPhysicalColumns.add(column);
                }
            } else {
                newPhysicalColumns = null;
            }
            return this.setFilter(newFilter).setPhysicalColumns(newPhysicalColumns);
        }

        public CursorBuildSpec build() {
            return new CursorBuildSpec(this.filter, this.interval, this.physicalColumns, this.virtualColumns, this.groupingColumns, this.aggregators, this.preferredOrdering, this.queryContext, this.queryMetrics);
        }
    }
}

