/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.tasklogs;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.druid.tasklogs.TaskLogStreamer;

public class SwitchingTaskLogStreamer
implements TaskLogStreamer {
    private final TaskLogStreamer taskRunnerTaskLogStreamer;
    private final List<TaskLogStreamer> deepStorageStreamers;

    @Inject
    public SwitchingTaskLogStreamer(@Named(value="taskstreamer") TaskLogStreamer taskRunnerTaskLogStreamer, List<TaskLogStreamer> deepStorageStreamer) {
        this.taskRunnerTaskLogStreamer = taskRunnerTaskLogStreamer;
        this.deepStorageStreamers = ImmutableList.copyOf(deepStorageStreamer);
    }

    public Optional<InputStream> streamTaskLog(String taskid, long offset) throws IOException {
        IOException deferIOException = null;
        try {
            Optional stream = this.taskRunnerTaskLogStreamer.streamTaskLog(taskid, offset);
            if (stream.isPresent()) {
                return stream;
            }
        }
        catch (IOException e) {
            deferIOException = e;
        }
        for (TaskLogStreamer provider : this.deepStorageStreamers) {
            try {
                Optional stream = provider.streamTaskLog(taskid, offset);
                if (!stream.isPresent()) continue;
                return stream;
            }
            catch (IOException e) {
                if (deferIOException != null) {
                    e.addSuppressed(deferIOException);
                }
                throw e;
            }
        }
        if (deferIOException != null) {
            throw deferIOException;
        }
        return Optional.absent();
    }

    public Optional<InputStream> streamTaskReports(String taskid) throws IOException {
        IOException deferIOException = null;
        try {
            Optional stream = this.taskRunnerTaskLogStreamer.streamTaskReports(taskid);
            if (stream.isPresent()) {
                return stream;
            }
        }
        catch (IOException e) {
            deferIOException = e;
        }
        for (TaskLogStreamer provider : this.deepStorageStreamers) {
            try {
                Optional stream = provider.streamTaskReports(taskid);
                if (!stream.isPresent()) continue;
                return stream;
            }
            catch (IOException e) {
                if (deferIOException != null) {
                    e.addSuppressed(deferIOException);
                }
                throw e;
            }
        }
        if (deferIOException != null) {
            throw deferIOException;
        }
        return Optional.absent();
    }
}

