/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.SegmentAllocateRequest;
import org.apache.druid.indexing.common.actions.SegmentAllocateResult;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskLockboxSyncResult;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class GlobalTaskLockbox {
    private static final Logger log = new Logger(GlobalTaskLockbox.class);
    private final TaskStorage taskStorage;
    private final IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private final ConcurrentHashMap<String, DatasourceLockboxResource> datasourceToLockbox = new ConcurrentHashMap();
    private final AtomicBoolean syncComplete = new AtomicBoolean(false);

    @Inject
    public GlobalTaskLockbox(TaskStorage taskStorage, IndexerMetadataStorageCoordinator metadataStorageCoordinator) {
        this.taskStorage = taskStorage;
        this.metadataStorageCoordinator = metadataStorageCoordinator;
    }

    public TaskLockboxSyncResult syncFromStorage() {
        this.shutdown();
        HashMap<String, DatasourceSyncResult> datasourceToSyncResult = new HashMap<String, DatasourceSyncResult>();
        int activeTaskCount = 0;
        int totalLockCount = 0;
        for (Task task : this.taskStorage.getActiveTasks()) {
            ++activeTaskCount;
            DatasourceSyncResult result = datasourceToSyncResult.computeIfAbsent(task.getDataSource(), ds -> new DatasourceSyncResult());
            result.storedActiveTasks.add(task);
            for (TaskLock taskLock : this.taskStorage.getLocks(task.getId())) {
                ++totalLockCount;
                result.storedLocks.add((Pair<Task, TaskLock>)Pair.of((Object)task, (Object)taskLock));
            }
        }
        HashSet<Task> tasksToFail = new HashSet<Task>();
        AtomicInteger taskLockCount = new AtomicInteger(0);
        datasourceToSyncResult.forEach((dataSource, syncResult) -> {
            try (DatasourceLockboxResource lockboxResource = this.getLockboxResource((String)dataSource, false);){
                TaskLockboxSyncResult lockboxSyncResult = lockboxResource.delegate.resetState(syncResult.storedActiveTasks, syncResult.storedLocks);
                tasksToFail.addAll(lockboxSyncResult.getTasksToFail());
                taskLockCount.addAndGet(lockboxSyncResult.getTaskLockCount());
            }
        });
        log.info("Synced [%,d] locks for [%,d] active tasks from storage ([%,d] locks ignored).", new Object[]{taskLockCount.get(), activeTaskCount, totalLockCount - taskLockCount.get()});
        this.syncComplete.set(true);
        return new TaskLockboxSyncResult(tasksToFail, taskLockCount.get());
    }

    public void shutdown() {
        this.syncComplete.set(false);
        Set<String> datasourceNames = Set.copyOf(this.datasourceToLockbox.keySet());
        for (String dataSource : datasourceNames) {
            this.cleanupLockboxResourceIf(dataSource, resource -> true);
        }
        log.info("Removed lockboxes for [%d] datasources, [%d] remaining.", new Object[]{datasourceNames.size(), this.datasourceToLockbox.size()});
    }

    public LockResult lock(Task task, LockRequest request) throws InterruptedException {
        return this.computeForTask(task, lockbox -> lockbox.lock(task, request));
    }

    public LockResult lock(Task task, LockRequest request, long timeoutMs) throws InterruptedException {
        return this.computeForTask(task, lockbox -> lockbox.lock(task, request, timeoutMs));
    }

    public LockResult tryLock(Task task, LockRequest request) {
        return this.computeForTask(task, lockbox -> lockbox.tryLock(task, request));
    }

    public List<SegmentAllocateResult> allocateSegments(List<SegmentAllocateRequest> requests, String dataSource, Interval interval, boolean skipSegmentLineageCheck, LockGranularity lockGranularity, boolean reduceMetadataIO) {
        return this.computeForDatasource(dataSource, lockbox -> lockbox.allocateSegments(requests, dataSource, interval, skipSegmentLineageCheck, lockGranularity, reduceMetadataIO));
    }

    public <T> T doInCriticalSection(Task task, Set<Interval> intervals, CriticalAction<T> action) throws Exception {
        return (T)this.computeForTask(task, lockbox -> lockbox.doInCriticalSection(task, intervals, action));
    }

    @VisibleForTesting
    public void revokeLock(String taskId, TaskLock lock) {
        this.computeForDatasource(lock.getDataSource(), lockbox -> {
            lockbox.revokeLock(taskId, lock);
            return 0;
        });
    }

    protected void cleanupPendingSegments(Task task) {
        this.executeForTask(task, lockbox -> lockbox.cleanupPendingSegments(task));
    }

    public List<TaskLock> findLocksForTask(Task task) {
        return this.computeForTask(task, lockbox -> lockbox.findLocksForTask(task));
    }

    public Set<ReplaceTaskLock> findReplaceLocksForTask(Task task) {
        return this.computeForTask(task, lockbox -> lockbox.findReplaceLocksForTask(task));
    }

    public Set<ReplaceTaskLock> getAllReplaceLocksForDatasource(String datasource) {
        return this.computeForDatasource(datasource, lockbox -> lockbox.getAllReplaceLocksForDatasource(datasource));
    }

    public Map<String, List<Interval>> getLockedIntervals(List<LockFilterPolicy> lockFilterPolicies) {
        HashMap<String, List> datasourceToFilterPolicies = new HashMap<String, List>();
        for (LockFilterPolicy policy : lockFilterPolicies) {
            datasourceToFilterPolicies.computeIfAbsent(policy.getDatasource(), ds -> new ArrayList()).add(policy);
        }
        HashMap<String, List<Interval>> datasourceToLockedIntervals = new HashMap<String, List<Interval>>();
        datasourceToFilterPolicies.forEach((datasource, policies) -> {
            List lockedIntervals = this.computeForDatasource((String)datasource, lockbox -> lockbox.getLockedIntervals((List<LockFilterPolicy>)policies));
            if (!lockedIntervals.isEmpty()) {
                datasourceToLockedIntervals.put((String)datasource, lockedIntervals);
            }
        });
        return datasourceToLockedIntervals;
    }

    public Map<String, List<TaskLock>> getActiveLocks(List<LockFilterPolicy> lockFilterPolicies) {
        HashMap<String, List> datasourceToFilterPolicies = new HashMap<String, List>();
        for (LockFilterPolicy policy : lockFilterPolicies) {
            datasourceToFilterPolicies.computeIfAbsent(policy.getDatasource(), ds -> new ArrayList()).add(policy);
        }
        HashMap<String, List<TaskLock>> datasourceToActiveLocks = new HashMap<String, List<TaskLock>>();
        datasourceToFilterPolicies.forEach((datasource, policies) -> {
            List datasourceLocks = this.computeForDatasource((String)datasource, lockbox -> lockbox.getActiveLocks((List<LockFilterPolicy>)policies));
            if (!datasourceLocks.isEmpty()) {
                datasourceToActiveLocks.put((String)datasource, datasourceLocks);
            }
        });
        return datasourceToActiveLocks;
    }

    public void unlock(Task task, Interval interval) {
        this.executeForTask(task, lockbox -> lockbox.unlock(task, interval));
    }

    public void unlockAll(Task task) {
        this.executeForTask(task, lockbox -> lockbox.unlockAll(task));
    }

    public void add(Task task) {
        this.executeForTask(task, lockbox -> lockbox.add(task));
    }

    public void remove(Task task) {
        boolean isEmpty = this.computeForTask(task, lockbox -> {
            lockbox.remove(task);
            return lockbox.isEmpty();
        });
        if (isEmpty) {
            this.cleanupLockboxResourceIf(task.getDataSource(), resource -> resource.references.get() <= 0);
        }
    }

    @VisibleForTesting
    Optional<TaskLockbox.TaskLockPosse> getOnlyTaskLockPosseContainingInterval(Task task, Interval interval) {
        return this.computeForTask(task, lockbox -> lockbox.getOnlyTaskLockPosseContainingInterval(task, interval));
    }

    @VisibleForTesting
    Set<String> getActiveTasks() {
        HashSet<String> allActiveTasks = new HashSet<String>();
        Set<String> datasourceNames = Set.copyOf(this.datasourceToLockbox.keySet());
        for (String datasource : datasourceNames) {
            allActiveTasks.addAll(this.computeForDatasource(datasource, TaskLockbox::getActiveTasks));
        }
        return allActiveTasks;
    }

    @VisibleForTesting
    Map<String, NavigableMap<DateTime, SortedMap<Interval, List<TaskLockbox.TaskLockPosse>>>> getAllLocks() {
        HashMap<String, NavigableMap<DateTime, SortedMap<Interval, List<TaskLockbox.TaskLockPosse>>>> allLocks = new HashMap<String, NavigableMap<DateTime, SortedMap<Interval, List<TaskLockbox.TaskLockPosse>>>>();
        Set<String> datasourceNames = Set.copyOf(this.datasourceToLockbox.keySet());
        for (String datasource : datasourceNames) {
            NavigableMap datasourceLocks = this.computeForDatasource(datasource, TaskLockbox::getAllLocks);
            if (datasourceLocks.isEmpty()) continue;
            allLocks.put(datasource, datasourceLocks);
        }
        return allLocks;
    }

    private DatasourceLockboxResource getLockboxResource(String datasource, boolean verifySyncComplete) {
        return this.datasourceToLockbox.compute(datasource, (ds, existingResource) -> {
            DatasourceLockboxResource resource = Objects.requireNonNullElseGet(existingResource, () -> new DatasourceLockboxResource(new TaskLockbox((String)ds, this.taskStorage, this.metadataStorageCoordinator)));
            if (verifySyncComplete && !this.syncComplete.get()) {
                throw new ISE("Cannot get TaskLockbox for datasource[%s] as sync with storage has not happened yet.", new Object[]{datasource});
            }
            resource.acquireReference();
            return resource;
        });
    }

    private void cleanupLockboxResourceIf(String dataSource, Predicate<DatasourceLockboxResource> resourcePredicate) {
        this.datasourceToLockbox.compute(dataSource, (ds, resource) -> {
            if (resource != null && resourcePredicate.test((DatasourceLockboxResource)resource)) {
                resource.delegate.clear();
                return null;
            }
            return resource;
        });
    }

    private <R, T extends Throwable> R computeForDatasource(String datasource, LockComputation<R, T> computation) throws T {
        try (DatasourceLockboxResource lockbox = this.getLockboxResource(datasource, true);){
            R r = computation.perform(lockbox.delegate);
            return r;
        }
    }

    private <R, T extends Throwable> R computeForTask(Task task, LockComputation<R, T> computation) throws T {
        return this.computeForDatasource(task.getDataSource(), computation);
    }

    private <T extends Throwable> void executeForTask(Task task, LockOperation<T> operation) throws T {
        this.computeForDatasource(task.getDataSource(), lockbox -> {
            operation.perform(lockbox);
            return 0;
        });
    }

    private static class DatasourceSyncResult {
        final Set<Task> storedActiveTasks = new HashSet<Task>();
        final List<Pair<Task, TaskLock>> storedLocks = new ArrayList<Pair<Task, TaskLock>>();

        private DatasourceSyncResult() {
        }
    }

    @FunctionalInterface
    private static interface LockComputation<R, T extends Throwable> {
        public R perform(TaskLockbox var1) throws T;
    }

    @FunctionalInterface
    private static interface LockOperation<T extends Throwable> {
        public void perform(TaskLockbox var1) throws T;
    }

    private static class DatasourceLockboxResource
    implements AutoCloseable {
        final AtomicInteger references;
        final TaskLockbox delegate;

        DatasourceLockboxResource(TaskLockbox delegate) {
            this.delegate = delegate;
            this.references = new AtomicInteger(0);
        }

        void acquireReference() {
            this.references.incrementAndGet();
        }

        @Override
        public void close() {
            this.references.decrementAndGet();
        }
    }
}

