/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.types.numerics.abbreviated;

import com.github.rvesse.airline.types.numerics.abbreviated.MapAbbreviatedNumericTypeConverter;
import java.util.HashMap;
import java.util.Map;

public class MultiSequenceAbbreviatedNumericTypeConverter
extends MapAbbreviatedNumericTypeConverter {
    public MultiSequenceAbbreviatedNumericTypeConverter(boolean caseSensitive, Map<String, Integer> prefixes, long multiplierBase, String[][] suffixSequences) {
        super(caseSensitive, prefixes, MultiSequenceAbbreviatedNumericTypeConverter.buildSuffixes(multiplierBase, suffixSequences));
    }

    protected static Map<String, Long> buildSuffixes(long base, String[][] suffixSequences) {
        if (base <= 0L) {
            throw new IllegalArgumentException("Base multiplier must be >= 1");
        }
        HashMap<String, Long> suffixMap = new HashMap<String, Long>();
        for (String[] suffixes : suffixSequences) {
            long m = base;
            for (String s : suffixes) {
                suffixMap.put(s, m);
                long nextM = m * base;
                if (nextM < m) {
                    throw new IllegalArgumentException("Too many suffixes leading to numeric overflow");
                }
                m = nextM;
            }
        }
        return suffixMap;
    }
}

