/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core.ranges;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.BigIntegerContent;
import com.google.uzaygezen.core.ranges.Range;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BigIntegerRange
implements Range<BigInteger, BigIntegerContent> {
    private final BigInteger start;
    private final BigInteger end;

    public BigIntegerRange(BigInteger start, BigInteger end) {
        Preconditions.checkArgument((boolean)(end.compareTo(start) > 0 & start.signum() >= 0), (Object)"start must be nonnegative and less than end.");
        this.start = start;
        this.end = end;
    }

    @Override
    public BigInteger getStart() {
        return this.start;
    }

    @Override
    public BigInteger getEnd() {
        return this.end;
    }

    @Override
    public BigIntegerContent length() {
        return new BigIntegerContent(this.end.subtract(this.start));
    }

    public static BigIntegerRange of(long start, long end) {
        return new BigIntegerRange(BigInteger.valueOf(start), BigInteger.valueOf(end));
    }

    public static BigIntegerRange of(BigInteger start, BigInteger end) {
        return new BigIntegerRange(start, end);
    }

    static BigInteger overlap(List<BigIntegerRange> x, List<BigIntegerRange> y) {
        int n = x.size();
        Preconditions.checkArgument((y.size() == n ? 1 : 0) != 0, (Object)"x and y must have the same number of values");
        BigInteger overlap = BigInteger.ONE;
        int i = 0;
        while (i < n & overlap.signum() != 0) {
            BigIntegerRange xRange = x.get(i);
            BigIntegerRange yRange = y.get(i);
            overlap = overlap.multiply(xRange.overlap(yRange));
            ++i;
        }
        return overlap;
    }

    BigInteger overlap(BigIntegerRange other) {
        if (this.start.compareTo(other.getEnd()) >= 0 || this.end.compareTo(other.getStart()) <= 0) {
            return BigInteger.ZERO;
        }
        if (this.start.compareTo(other.getStart()) < 0 || this.end.compareTo(other.getEnd()) > 0) {
            BigInteger x = this.getEnd().min(other.getEnd());
            BigInteger y = this.getStart().max(other.getStart());
            return x.subtract(y);
        }
        return this.end.subtract(this.start);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.end});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigIntegerRange)) {
            return false;
        }
        BigIntegerRange other = (BigIntegerRange)obj;
        return this.start.equals(other.start) && this.end.equals(other.end);
    }

    @Override
    public boolean contains(BigInteger point) {
        return this.start.compareTo(point) <= 0 && this.end.compareTo(point) > 0;
    }
}

