/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.output;

import com.github.rvesse.airline.io.ControlCodeSource;
import com.github.rvesse.airline.io.decorations.BasicDecoration;
import com.github.rvesse.airline.io.decorations.sources.AnsiDecorationSource;
import com.github.rvesse.airline.io.output.AnsiOutputStream;
import com.github.rvesse.airline.io.output.OutputStreamControlTracker;
import java.io.IOException;
import java.io.OutputStream;

public class ColorizedOutputStream<T>
extends AnsiOutputStream {
    protected OutputStreamControlTracker<T> foregroundControl;
    protected OutputStreamControlTracker<T> backgroundControl;
    protected OutputStreamControlTracker<BasicDecoration> bold;
    protected OutputStreamControlTracker<BasicDecoration> italic;
    protected OutputStreamControlTracker<BasicDecoration> underline;
    protected OutputStreamControlTracker<BasicDecoration> strikeThrough;

    public ColorizedOutputStream(OutputStream output, ControlCodeSource<T> foregroundColorSource, ControlCodeSource<T> backgroundColorSource) {
        super(output);
        if (foregroundColorSource == null) {
            throw new NullPointerException("foregroundColorSource cannot be null");
        }
        if (backgroundColorSource == null) {
            throw new NullPointerException("backgroundColorSource cannot be null");
        }
        this.foregroundControl = new OutputStreamControlTracker<T>(output, foregroundColorSource);
        this.backgroundControl = new OutputStreamControlTracker<T>(output, backgroundColorSource);
        this.registerControls(this.foregroundControl, this.backgroundControl);
        AnsiDecorationSource decorationsSource = new AnsiDecorationSource();
        this.bold = new OutputStreamControlTracker(output, decorationsSource);
        this.italic = new OutputStreamControlTracker(output, decorationsSource);
        this.underline = new OutputStreamControlTracker(output, decorationsSource);
        this.strikeThrough = new OutputStreamControlTracker(output, decorationsSource);
        this.registerControls(this.bold, this.italic, this.underline, this.strikeThrough);
    }

    public ColorizedOutputStream<T> setForegroundColor(T color) {
        this.foregroundControl.set(color);
        return this;
    }

    public ColorizedOutputStream<T> resetForegroundColor() {
        try {
            this.foregroundControl.reset();
        }
        catch (IOException e) {
            this.setError();
        }
        return this;
    }

    public ColorizedOutputStream<T> setBackgroundColor(T color) {
        this.backgroundControl.set(color);
        return this;
    }

    public ColorizedOutputStream<T> resetBackgroundColor() {
        try {
            this.backgroundControl.reset();
        }
        catch (IOException e) {
            this.setError();
        }
        return this;
    }

    public ColorizedOutputStream<T> setBold(boolean enabled) {
        this.setDecoration(enabled, BasicDecoration.BOLD, this.bold);
        return this;
    }

    public ColorizedOutputStream<T> setItalic(boolean enabled) {
        this.setDecoration(enabled, BasicDecoration.ITALIC, this.italic);
        return this;
    }

    public ColorizedOutputStream<T> setUnderline(boolean enabled) {
        this.setDecoration(enabled, BasicDecoration.UNDERLINE, this.underline);
        return this;
    }

    public ColorizedOutputStream<T> setStrikeThrough(boolean enabled) {
        this.setDecoration(enabled, BasicDecoration.STRIKE_THROUGH, this.strikeThrough);
        return this;
    }

    protected final void setDecoration(boolean enabled, BasicDecoration decoration, OutputStreamControlTracker<BasicDecoration> control) {
        try {
            if (enabled) {
                control.set(decoration);
            } else {
                control.reset();
            }
        }
        catch (IOException e) {
            this.setError();
        }
    }
}

