/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.metrics.Timer;
import org.apache.calcite.avatica.remote.Handler;
import org.apache.calcite.avatica.remote.JsonHandler;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaJsonHandler;
import org.apache.calcite.avatica.util.UnsynchronizedBuffer;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.DruidNode;
import org.apache.druid.sql.avatica.AvaticaMonitor;
import org.apache.druid.sql.avatica.DruidAvaticaHandler;
import org.apache.druid.sql.avatica.DruidMeta;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class DruidAvaticaJsonHandler
extends DruidAvaticaHandler {
    private static final Logger LOG = new Logger(DruidAvaticaJsonHandler.class);
    public static final String AVATICA_PATH_NO_TRAILING_SLASH = "/druid/v2/sql/avatica";
    public static final String AVATICA_PATH = "/druid/v2/sql/avatica/";
    private final JsonHandler jsonHandler;

    @Inject
    public DruidAvaticaJsonHandler(DruidMeta druidMeta, @Self DruidNode druidNode, AvaticaMonitor avaticaMonitor) {
        super(druidMeta, Objects.requireNonNull(avaticaMonitor), AvaticaJsonHandler.class);
        this.jsonHandler = new JsonHandler(this.service, this.metrics);
        this.setServerRpcMetadata(new Service.RpcMetadataResponse(druidNode.getHostAndPortToUse()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        block21: {
            String requestURI = request.getHttpURI().getPath();
            try (Timer.Context ctx = this.requestTimer.start();){
                Handler.HandlerResponse jsonResponse;
                if (!AVATICA_PATH_NO_TRAILING_SLASH.equals(StringUtils.maybeRemoveTrailingSlash((String)requestURI))) break block21;
                response.getHeaders().put("Content-Type", "application/json;charset=utf-8");
                if (!"POST".equals(request.getMethod())) {
                    response.setStatus(405);
                    response.write(true, ByteBuffer.wrap("This server expects only POST calls.".getBytes(StandardCharsets.UTF_8)), callback);
                    boolean bl = true;
                    return bl;
                }
                String rawRequest = request.getHeaders().get("request");
                if (rawRequest == null) {
                    UnsynchronizedBuffer buffer = (UnsynchronizedBuffer)this.threadLocalBuffer.get();
                    try (InputStream inputStream = Content.Source.asInputStream((Content.Source)request);){
                        byte[] bytes = AvaticaUtils.readFullyToBytes((InputStream)inputStream, (UnsynchronizedBuffer)buffer);
                        String encoding = request.getHeaders().get("Content-Encoding");
                        if (encoding == null) {
                            encoding = "UTF-8";
                        }
                        rawRequest = AvaticaUtils.newString((byte[])bytes, (String)encoding);
                    }
                    finally {
                        buffer.reset();
                    }
                }
                String jsonRequest = rawRequest;
                LOG.trace("request: %s", new Object[]{jsonRequest});
                try {
                    jsonResponse = this.jsonHandler.apply(jsonRequest);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e, "Error invoking request", new Object[0]);
                    jsonResponse = this.jsonHandler.convertToErrorResponse(e);
                }
                LOG.trace("response: %s", new Object[]{jsonResponse});
                response.setStatus(jsonResponse.getStatusCode());
                response.write(true, ByteBuffer.wrap(((String)jsonResponse.getResponse()).getBytes(StandardCharsets.UTF_8)), callback);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void setServerRpcMetadata(Service.RpcMetadataResponse metadata) {
        super.setServerRpcMetadata(metadata);
        if (this.jsonHandler != null) {
            this.jsonHandler.setRpcMetadata(metadata);
        }
    }
}

