/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DataResponse;
import com.amazonaws.services.ec2.model.MetricPoint;
import com.amazonaws.services.ec2.model.transform.MetricPointStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class DataResponseStaxUnmarshaller
implements Unmarshaller<DataResponse, StaxUnmarshallerContext> {
    private static DataResponseStaxUnmarshaller instance;

    public DataResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DataResponse dataResponse = new DataResponse();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dataResponse;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("id", targetDepth)) {
                    dataResponse.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("source", targetDepth)) {
                    dataResponse.setSource(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("destination", targetDepth)) {
                    dataResponse.setDestination(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("metric", targetDepth)) {
                    dataResponse.setMetric(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("statistic", targetDepth)) {
                    dataResponse.setStatistic(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("period", targetDepth)) {
                    dataResponse.setPeriod(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("metricPointSet", targetDepth)) {
                    dataResponse.withMetricPoints(new ArrayList<MetricPoint>());
                    continue;
                }
                if (!context.testExpression("metricPointSet/item", targetDepth)) continue;
                dataResponse.withMetricPoints(MetricPointStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dataResponse;
    }

    public static DataResponseStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DataResponseStaxUnmarshaller();
        }
        return instance;
    }
}

