/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DnsOptionsSpecification;
import com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest;
import com.amazonaws.services.ec2.model.SubnetConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVpcEndpointRequestMarshaller
implements Marshaller<Request<ModifyVpcEndpointRequest>, ModifyVpcEndpointRequest> {
    public Request<ModifyVpcEndpointRequest> marshall(ModifyVpcEndpointRequest modifyVpcEndpointRequest) {
        SdkInternalList modifyVpcEndpointRequestSubnetConfigurationsList;
        DnsOptionsSpecification dnsOptions;
        SdkInternalList modifyVpcEndpointRequestRemoveSecurityGroupIdsList;
        SdkInternalList modifyVpcEndpointRequestAddSecurityGroupIdsList;
        SdkInternalList modifyVpcEndpointRequestRemoveSubnetIdsList;
        SdkInternalList modifyVpcEndpointRequestAddSubnetIdsList;
        SdkInternalList modifyVpcEndpointRequestRemoveRouteTableIdsList;
        SdkInternalList modifyVpcEndpointRequestAddRouteTableIdsList;
        if (modifyVpcEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpcEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcEndpointRequest.getVpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString((String)modifyVpcEndpointRequest.getVpcEndpointId()));
        }
        if (modifyVpcEndpointRequest.getResetPolicy() != null) {
            request.addParameter("ResetPolicy", StringUtils.fromBoolean((Boolean)modifyVpcEndpointRequest.getResetPolicy()));
        }
        if (modifyVpcEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)modifyVpcEndpointRequest.getPolicyDocument()));
        }
        if (!(modifyVpcEndpointRequestAddRouteTableIdsList = (SdkInternalList)modifyVpcEndpointRequest.getAddRouteTableIds()).isEmpty() || !modifyVpcEndpointRequestAddRouteTableIdsList.isAutoConstruct()) {
            int addRouteTableIdsListIndex = 1;
            for (Object modifyVpcEndpointRequestAddRouteTableIdsListValue : modifyVpcEndpointRequestAddRouteTableIdsList) {
                if (modifyVpcEndpointRequestAddRouteTableIdsListValue != null) {
                    request.addParameter("AddRouteTableId." + addRouteTableIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestAddRouteTableIdsListValue));
                }
                ++addRouteTableIdsListIndex;
            }
        }
        if (!(modifyVpcEndpointRequestRemoveRouteTableIdsList = (SdkInternalList)modifyVpcEndpointRequest.getRemoveRouteTableIds()).isEmpty() || !modifyVpcEndpointRequestRemoveRouteTableIdsList.isAutoConstruct()) {
            int removeRouteTableIdsListIndex = 1;
            for (Object modifyVpcEndpointRequestRemoveRouteTableIdsListValue : modifyVpcEndpointRequestRemoveRouteTableIdsList) {
                if (modifyVpcEndpointRequestRemoveRouteTableIdsListValue != null) {
                    request.addParameter("RemoveRouteTableId." + removeRouteTableIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestRemoveRouteTableIdsListValue));
                }
                ++removeRouteTableIdsListIndex;
            }
        }
        if (!(modifyVpcEndpointRequestAddSubnetIdsList = (SdkInternalList)modifyVpcEndpointRequest.getAddSubnetIds()).isEmpty() || !modifyVpcEndpointRequestAddSubnetIdsList.isAutoConstruct()) {
            int addSubnetIdsListIndex = 1;
            for (Object modifyVpcEndpointRequestAddSubnetIdsListValue : modifyVpcEndpointRequestAddSubnetIdsList) {
                if (modifyVpcEndpointRequestAddSubnetIdsListValue != null) {
                    request.addParameter("AddSubnetId." + addSubnetIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestAddSubnetIdsListValue));
                }
                ++addSubnetIdsListIndex;
            }
        }
        if (!(modifyVpcEndpointRequestRemoveSubnetIdsList = (SdkInternalList)modifyVpcEndpointRequest.getRemoveSubnetIds()).isEmpty() || !modifyVpcEndpointRequestRemoveSubnetIdsList.isAutoConstruct()) {
            int removeSubnetIdsListIndex = 1;
            for (Object modifyVpcEndpointRequestRemoveSubnetIdsListValue : modifyVpcEndpointRequestRemoveSubnetIdsList) {
                if (modifyVpcEndpointRequestRemoveSubnetIdsListValue != null) {
                    request.addParameter("RemoveSubnetId." + removeSubnetIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestRemoveSubnetIdsListValue));
                }
                ++removeSubnetIdsListIndex;
            }
        }
        if (!(modifyVpcEndpointRequestAddSecurityGroupIdsList = (SdkInternalList)modifyVpcEndpointRequest.getAddSecurityGroupIds()).isEmpty() || !modifyVpcEndpointRequestAddSecurityGroupIdsList.isAutoConstruct()) {
            int addSecurityGroupIdsListIndex = 1;
            for (Object modifyVpcEndpointRequestAddSecurityGroupIdsListValue : modifyVpcEndpointRequestAddSecurityGroupIdsList) {
                if (modifyVpcEndpointRequestAddSecurityGroupIdsListValue != null) {
                    request.addParameter("AddSecurityGroupId." + addSecurityGroupIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestAddSecurityGroupIdsListValue));
                }
                ++addSecurityGroupIdsListIndex;
            }
        }
        if (!(modifyVpcEndpointRequestRemoveSecurityGroupIdsList = (SdkInternalList)modifyVpcEndpointRequest.getRemoveSecurityGroupIds()).isEmpty() || !modifyVpcEndpointRequestRemoveSecurityGroupIdsList.isAutoConstruct()) {
            int removeSecurityGroupIdsListIndex = 1;
            for (String modifyVpcEndpointRequestRemoveSecurityGroupIdsListValue : modifyVpcEndpointRequestRemoveSecurityGroupIdsList) {
                if (modifyVpcEndpointRequestRemoveSecurityGroupIdsListValue != null) {
                    request.addParameter("RemoveSecurityGroupId." + removeSecurityGroupIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestRemoveSecurityGroupIdsListValue));
                }
                ++removeSecurityGroupIdsListIndex;
            }
        }
        if (modifyVpcEndpointRequest.getIpAddressType() != null) {
            request.addParameter("IpAddressType", StringUtils.fromString((String)modifyVpcEndpointRequest.getIpAddressType()));
        }
        if ((dnsOptions = modifyVpcEndpointRequest.getDnsOptions()) != null) {
            if (dnsOptions.getDnsRecordIpType() != null) {
                request.addParameter("DnsOptions.DnsRecordIpType", StringUtils.fromString((String)dnsOptions.getDnsRecordIpType()));
            }
            if (dnsOptions.getPrivateDnsOnlyForInboundResolverEndpoint() != null) {
                request.addParameter("DnsOptions.PrivateDnsOnlyForInboundResolverEndpoint", StringUtils.fromBoolean((Boolean)dnsOptions.getPrivateDnsOnlyForInboundResolverEndpoint()));
            }
        }
        if (modifyVpcEndpointRequest.getPrivateDnsEnabled() != null) {
            request.addParameter("PrivateDnsEnabled", StringUtils.fromBoolean((Boolean)modifyVpcEndpointRequest.getPrivateDnsEnabled()));
        }
        if (!(modifyVpcEndpointRequestSubnetConfigurationsList = (SdkInternalList)modifyVpcEndpointRequest.getSubnetConfigurations()).isEmpty() || !modifyVpcEndpointRequestSubnetConfigurationsList.isAutoConstruct()) {
            int subnetConfigurationsListIndex = 1;
            for (SubnetConfiguration modifyVpcEndpointRequestSubnetConfigurationsListValue : modifyVpcEndpointRequestSubnetConfigurationsList) {
                if (modifyVpcEndpointRequestSubnetConfigurationsListValue.getSubnetId() != null) {
                    request.addParameter("SubnetConfiguration." + subnetConfigurationsListIndex + ".SubnetId", StringUtils.fromString((String)modifyVpcEndpointRequestSubnetConfigurationsListValue.getSubnetId()));
                }
                if (modifyVpcEndpointRequestSubnetConfigurationsListValue.getIpv4() != null) {
                    request.addParameter("SubnetConfiguration." + subnetConfigurationsListIndex + ".Ipv4", StringUtils.fromString((String)modifyVpcEndpointRequestSubnetConfigurationsListValue.getIpv4()));
                }
                if (modifyVpcEndpointRequestSubnetConfigurationsListValue.getIpv6() != null) {
                    request.addParameter("SubnetConfiguration." + subnetConfigurationsListIndex + ".Ipv6", StringUtils.fromString((String)modifyVpcEndpointRequestSubnetConfigurationsListValue.getIpv6()));
                }
                ++subnetConfigurationsListIndex;
            }
        }
        return request;
    }
}

