/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.write.columnar.NumericArrayFrameColumnWriter;
import org.apache.druid.segment.ColumnValueSelector;

public class LongArrayFrameColumnWriter
extends NumericArrayFrameColumnWriter {
    public LongArrayFrameColumnWriter(ColumnValueSelector selector, MemoryAllocator allocator) {
        super(selector, allocator, (byte)7);
    }

    @Override
    int elementSizeBytes() {
        return 8;
    }

    @Override
    void putNull(WritableMemory memory, long offset) {
        memory.putLong(offset, 0L);
    }

    @Override
    void putArrayElement(WritableMemory memory, long offset, Number element) {
        memory.putLong(offset, element.longValue());
    }
}

