/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import java.io.IOException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.guava.DelegatingYieldingAccumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.guava.YieldingSequenceBase;

public class SkippingSequence<T>
extends YieldingSequenceBase<T> {
    private final Sequence<T> baseSequence;
    private final long skip;

    public SkippingSequence(Sequence<T> baseSequence, long skip) {
        this.baseSequence = baseSequence;
        this.skip = skip;
        if (skip < 1L) {
            throw new IAE("'skip' must be greater than zero", new Object[0]);
        }
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        SkippingYieldingAccumulator<OutType> skippingAccumulator = new SkippingYieldingAccumulator<OutType>(accumulator);
        return this.wrapYielder(this.baseSequence.toYielder(initValue, skippingAccumulator), skippingAccumulator);
    }

    private <OutType> Yielder<OutType> wrapYielder(final Yielder<OutType> yielder, final SkippingYieldingAccumulator<OutType> accumulator) {
        return new Yielder<OutType>(){

            @Override
            public OutType get() {
                return yielder.get();
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                return SkippingSequence.this.wrapYielder(yielder.next(initValue), accumulator);
            }

            @Override
            public boolean isDone() {
                return yielder.isDone();
            }

            @Override
            public void close() throws IOException {
                yielder.close();
            }
        };
    }

    private class SkippingYieldingAccumulator<OutType>
    extends DelegatingYieldingAccumulator<OutType, T> {
        private long skipped;

        public SkippingYieldingAccumulator(YieldingAccumulator<OutType, T> accumulator) {
            super(accumulator);
            this.skipped = 0L;
        }

        @Override
        public OutType accumulate(OutType accumulated, T in) {
            if (this.skipped < SkippingSequence.this.skip) {
                ++this.skipped;
                return accumulated;
            }
            return super.accumulate(accumulated, in);
        }
    }
}

