/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.LeafDataSource;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;

@JsonTypeName(value="table")
public class TableDataSource
extends LeafDataSource {
    private final String name;

    @JsonCreator
    public TableDataSource(@JsonProperty(value="name") String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"'name' must be nonnull");
    }

    @JsonCreator
    public static TableDataSource create(String name) {
        return new TableDataSource(name);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getTableNames() {
        return Collections.singleton(this.name);
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isProcessable() {
        return true;
    }

    @Override
    public DataSource withPolicies(Map<String, Optional<Policy>> policyMap, PolicyEnforcer policyEnforcer) {
        Optional policy = policyMap.getOrDefault(this.name, Optional.empty());
        policyEnforcer.validateOrElseThrow(this, (Policy)policy.orElse(null));
        return policy.isEmpty() ? this : RestrictedDataSource.create(this, (Policy)policy.get());
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(2).appendString(this.getName()).build();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDataSource that = (TableDataSource)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

