/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.segment.serde.cell.IOIterator;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class SerializedStorage<T> {
    private final WriteOutBytes writeOutBytes;
    private final StagedSerde<T> serde;
    private final ByteBuffer itemOffsetsBytes;
    private final IntBuffer itemSizes;
    private final LongArrayList rowChunkOffsets = new LongArrayList();
    private int numStored = 0;
    private int maxSize = 0;

    public SerializedStorage(WriteOutBytes writeOutBytes, StagedSerde<T> serde) {
        this(writeOutBytes, serde, 4096);
    }

    public SerializedStorage(WriteOutBytes writeOutBytes, StagedSerde<T> serde, int chunkSize) {
        this.writeOutBytes = writeOutBytes;
        this.serde = serde;
        this.itemOffsetsBytes = ByteBuffer.allocate(chunkSize * 4).order(ByteOrder.nativeOrder());
        this.itemSizes = this.itemOffsetsBytes.asIntBuffer();
    }

    public void store(@Nullable T value) throws IOException {
        byte[] bytes = this.serde.serialize(value);
        this.maxSize = Math.max(this.maxSize, bytes.length);
        this.itemSizes.put(bytes.length);
        if (bytes.length > 0) {
            this.writeOutBytes.write(bytes);
        }
        ++this.numStored;
        if (this.itemSizes.remaining() == 0) {
            this.rowChunkOffsets.add(this.writeOutBytes.size());
            this.writeOutBytes.write(this.itemOffsetsBytes);
            this.itemOffsetsBytes.clear();
            this.itemSizes.clear();
        }
    }

    public int numStored() {
        return this.numStored;
    }

    public IOIterator<T> iterator() throws IOException {
        if (this.itemSizes.position() != this.itemSizes.limit()) {
            this.rowChunkOffsets.add(this.writeOutBytes.size());
            this.itemOffsetsBytes.limit(this.itemSizes.position() * 4);
            this.writeOutBytes.write(this.itemOffsetsBytes);
            this.itemSizes.limit(this.itemSizes.position());
        }
        return new DeserializingIOIterator<T>(this.writeOutBytes, this.rowChunkOffsets, this.numStored, this.itemSizes.capacity(), this.maxSize, this.serde);
    }

    private static class DeserializingIOIterator<T>
    implements IOIterator<T> {
        private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0).asReadOnlyBuffer();
        private final WriteOutBytes medium;
        private final LongArrayList rowChunkOffsets;
        private final int numEntries;
        private ByteBuffer tmpBuf;
        private final StagedSerde<T> serde;
        private final ByteBuffer itemOffsetsBytes;
        private final int[] itemSizes;
        private long itemStartOffset;
        private int chunkId = 0;
        private int currId = 0;
        private int itemIndex;

        public DeserializingIOIterator(WriteOutBytes medium, LongArrayList rowChunkOffsets, int numEntries, int chunkSize, int maxSize, StagedSerde<T> serde) {
            this.medium = medium;
            this.rowChunkOffsets = rowChunkOffsets;
            this.numEntries = numEntries;
            this.tmpBuf = ByteBuffer.allocate(maxSize).order(ByteOrder.nativeOrder());
            this.serde = serde;
            this.itemOffsetsBytes = ByteBuffer.allocate(chunkSize * 4).order(ByteOrder.nativeOrder());
            this.itemSizes = new int[chunkSize];
            this.itemIndex = chunkSize;
        }

        @Override
        public boolean hasNext() {
            return this.currId < this.numEntries;
        }

        @Override
        public T next() throws IOException {
            T retVal;
            int bytesToRead;
            if (this.currId >= this.numEntries) {
                throw new NoSuchElementException();
            }
            if (this.itemIndex >= this.itemSizes.length) {
                if (this.chunkId == 0) {
                    this.itemStartOffset = 0L;
                } else {
                    if (this.itemStartOffset != this.rowChunkOffsets.getLong(this.chunkId - 1)) {
                        throw DruidException.defensive("Should have read up to the start of the offsets [%,d], but for some reason the values [%,d] don't align.  Possible corruption?", this.rowChunkOffsets.getLong(this.chunkId - 1), this.itemStartOffset);
                    }
                    this.itemStartOffset += (long)this.itemSizes.length * 4L;
                }
                int numToRead = Math.min(this.itemSizes.length, this.numEntries - this.chunkId * this.itemSizes.length);
                long readOffset = this.rowChunkOffsets.getLong(this.chunkId++);
                this.itemOffsetsBytes.clear();
                this.itemOffsetsBytes.limit(numToRead * 4);
                this.medium.readFully(readOffset, this.itemOffsetsBytes);
                this.itemOffsetsBytes.flip();
                this.itemOffsetsBytes.asIntBuffer().get(this.itemSizes, 0, numToRead);
                this.itemIndex = 0;
            }
            if ((bytesToRead = this.itemSizes[this.itemIndex]) == 0) {
                retVal = this.serde.deserialize(EMPTY_BUFFER);
            } else {
                this.tmpBuf.clear();
                this.tmpBuf.limit(bytesToRead);
                this.medium.readFully(this.itemStartOffset, this.tmpBuf);
                this.tmpBuf.flip();
                retVal = this.serde.deserialize(this.tmpBuf);
            }
            this.itemStartOffset += (long)bytesToRead;
            ++this.itemIndex;
            ++this.currId;
            return retVal;
        }

        @Override
        public void close() {
        }
    }
}

