/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;

public class StringPredicateDruidPredicateFactory
implements DruidPredicateFactory {
    @Nullable
    private final DruidObjectPredicate<String> predicate;

    public static StringPredicateDruidPredicateFactory equalTo(@Nullable String value) {
        if (value == null) {
            return new StringPredicateDruidPredicateFactory(DruidObjectPredicate.isNull());
        }
        return new StringPredicateDruidPredicateFactory(DruidObjectPredicate.equalTo(value));
    }

    public static StringPredicateDruidPredicateFactory of(@Nullable DruidObjectPredicate<String> predicate) {
        return new StringPredicateDruidPredicateFactory(predicate);
    }

    private StringPredicateDruidPredicateFactory(DruidObjectPredicate<String> predicate) {
        this.predicate = predicate;
    }

    @Override
    public DruidObjectPredicate<String> makeStringPredicate() {
        return this.predicate;
    }

    @Override
    public DruidLongPredicate makeLongPredicate() {
        throw DruidException.defensive("String equality predicate factory only supports string predicates", new Object[0]);
    }

    @Override
    public DruidFloatPredicate makeFloatPredicate() {
        throw DruidException.defensive("String equality predicate factory only supports string predicates", new Object[0]);
    }

    @Override
    public DruidDoublePredicate makeDoublePredicate() {
        throw DruidException.defensive("String equality predicate factory only supports string predicates", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringPredicateDruidPredicateFactory that = (StringPredicateDruidPredicateFactory)o;
        return Objects.equals(this.predicate, that.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.predicate);
    }
}

