/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;

class LookupBean {
    private final LookupExtractorFactoryContainer container;
    private final String name;
    @Deprecated
    private final LookupExtractorFactory factory;

    @JsonCreator
    public LookupBean(@JsonProperty(value="name") String name, @Deprecated @JsonProperty(value="factory") LookupExtractorFactory factory, @JsonProperty(value="container") LookupExtractorFactoryContainer container) {
        Preconditions.checkArgument((factory != null || container != null ? 1 : 0) != 0, (Object)"either one of factory or container must exist");
        this.name = name;
        this.container = container != null ? container : new LookupExtractorFactoryContainer(null, factory);
        this.factory = factory != null ? factory : container.getLookupExtractorFactory();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public LookupExtractorFactoryContainer getContainer() {
        return this.container;
    }

    @Deprecated
    @JsonProperty
    public LookupExtractorFactory getFactory() {
        return this.factory;
    }

    public String toString() {
        return "LookupBean{container=" + String.valueOf(this.container) + ", name='" + this.name + "', factory=" + String.valueOf(this.factory) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupBean that = (LookupBean)o;
        return Objects.equals(this.container, that.container) && Objects.equals(this.name, that.name) && Objects.equals(this.factory, that.factory);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.name, this.factory);
    }
}

