/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.LongsColumn;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorValueSelector;

class LongsColumnWithNulls
extends LongsColumn {
    private final ImmutableBitmap nullValueBitmap;

    LongsColumnWithNulls(ColumnarLongs columnarLongs, ImmutableBitmap nullValueBitmap) {
        super(columnarLongs);
        this.nullValueBitmap = nullValueBitmap;
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset) {
        return this.column.makeColumnValueSelector(offset, this.nullValueBitmap);
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        return this.column.makeVectorValueSelector(offset, this.nullValueBitmap);
    }

    @Override
    public long getLongSingleValueRow(int rowNum) {
        assert (!this.nullValueBitmap.get(rowNum));
        return super.getLongSingleValueRow(rowNum);
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        super.inspectRuntimeShape(inspector);
        inspector.visit("nullValueBitmap", this.nullValueBitmap);
    }
}

