/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.join.Equality;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.Equiconditions;
import org.apache.druid.segment.join.filter.JoinFilterColumnCorrelationAnalysis;
import org.apache.druid.segment.join.filter.JoinFilterCorrelations;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysisKey;
import org.apache.druid.segment.join.filter.JoinableClauses;

public class JoinFilterPreAnalysis {
    private final JoinFilterPreAnalysisKey key;
    private final List<Filter> normalizedBaseTableClauses;
    private final List<Filter> normalizedJoinTableClauses;
    private final JoinFilterCorrelations correlations;
    private final Set<VirtualColumn> postJoinVirtualColumns;
    private final Equiconditions equiconditions;

    private JoinFilterPreAnalysis(JoinFilterPreAnalysisKey key, Set<VirtualColumn> postJoinVirtualColumns, List<Filter> normalizedBaseTableClauses, List<Filter> normalizedJoinTableClauses, JoinFilterCorrelations correlations, Equiconditions equiconditions) {
        this.key = key;
        this.postJoinVirtualColumns = postJoinVirtualColumns;
        this.normalizedBaseTableClauses = normalizedBaseTableClauses;
        this.normalizedJoinTableClauses = normalizedJoinTableClauses;
        this.correlations = correlations;
        this.equiconditions = equiconditions;
    }

    public JoinFilterPreAnalysisKey getKey() {
        return this.key;
    }

    public JoinableClauses getJoinableClauses() {
        return JoinableClauses.fromList(this.key.getJoinableClauses());
    }

    @Nullable
    public Filter getOriginalFilter() {
        return this.key.getFilter();
    }

    public Set<VirtualColumn> getPostJoinVirtualColumns() {
        return this.postJoinVirtualColumns;
    }

    public List<Filter> getNormalizedBaseTableClauses() {
        return this.normalizedBaseTableClauses;
    }

    public List<Filter> getNormalizedJoinTableClauses() {
        return this.normalizedJoinTableClauses;
    }

    public Map<String, List<JoinFilterColumnCorrelationAnalysis>> getCorrelationsByFilteringColumn() {
        return this.correlations.getCorrelationsByFilteringColumn();
    }

    public Map<String, List<JoinFilterColumnCorrelationAnalysis>> getCorrelationsByDirectFilteringColumn() {
        return this.correlations.getCorrelationsByDirectFilteringColumn();
    }

    public boolean isEnableFilterPushDown() {
        return this.key.getRewriteConfig().isEnableFilterPushDown();
    }

    public boolean isEnableFilterRewrite() {
        return this.key.getRewriteConfig().isEnableFilterRewrite();
    }

    public Equiconditions getEquiconditions() {
        return this.equiconditions;
    }

    public static class Builder {
        @Nonnull
        private final JoinFilterPreAnalysisKey key;
        @Nullable
        private List<Filter> normalizedBaseTableClauses;
        @Nullable
        private List<Filter> normalizedJoinTableClauses;
        @Nullable
        private JoinFilterCorrelations correlations;
        @Nonnull
        private final Set<VirtualColumn> postJoinVirtualColumns;
        @Nonnull
        private Equiconditions equiconditions = new Equiconditions(Collections.emptyMap());

        public Builder(@Nonnull JoinFilterPreAnalysisKey key, @Nonnull Set<VirtualColumn> postJoinVirtualColumns) {
            this.key = key;
            this.postJoinVirtualColumns = postJoinVirtualColumns;
        }

        public Builder withNormalizedBaseTableClauses(List<Filter> normalizedBaseTableClauses) {
            this.normalizedBaseTableClauses = normalizedBaseTableClauses;
            return this;
        }

        public Builder withNormalizedJoinTableClauses(List<Filter> normalizedJoinTableClauses) {
            this.normalizedJoinTableClauses = normalizedJoinTableClauses;
            return this;
        }

        public Builder withCorrelations(JoinFilterCorrelations correlations) {
            this.correlations = correlations;
            return this;
        }

        public Equiconditions computeEquiconditionsFromJoinableClauses() {
            HashMap<String, Set<Expr>> equiconditionsMap = new HashMap<String, Set<Expr>>();
            for (JoinableClause clause : this.key.getJoinableClauses()) {
                for (Equality equality : clause.getCondition().getEquiConditions()) {
                    Set exprsForRhs = equiconditionsMap.computeIfAbsent(clause.getPrefix() + equality.getRightColumn(), rhs -> new HashSet());
                    exprsForRhs.add(equality.getLeftExpr());
                }
            }
            this.equiconditions = new Equiconditions(equiconditionsMap);
            return this.equiconditions;
        }

        public JoinFilterPreAnalysis build() {
            return new JoinFilterPreAnalysis(this.key, this.postJoinVirtualColumns, this.normalizedBaseTableClauses, this.normalizedJoinTableClauses, this.correlations, this.equiconditions);
        }
    }
}

