/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.util.SuppressForbidden;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.RangeIntSet;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.join.Equality;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableColumnSelectorFactory;

public class IndexedTableJoinMatcher
implements JoinMatcher {
    static final int NO_CONDITION_MATCH = -1;
    private static final int UNINITIALIZED_CURRENT_ROW = -1;
    static final ColumnType DEFAULT_KEY_TYPE = ColumnType.STRING;
    private final IndexedTable table;
    private final List<ConditionMatcher> conditionMatchers;
    private final boolean singleRowMatching;
    private final ColumnSelectorFactory selectorFactory;
    private final IntSet matchedRows;
    private boolean matchingRemainder = false;
    @Nullable
    private IntIterator currentIterator;
    private int currentRow;
    private final SimpleSettableOffset joinableOffset;

    IndexedTableJoinMatcher(IndexedTable table, ColumnSelectorFactory leftSelectorFactory, JoinConditionAnalysis condition, boolean remainderNeeded, Closer closer) {
        this.table = table;
        this.joinableOffset = new SimpleAscendingOffset(table.numRows());
        this.reset();
        if (condition.isAlwaysTrue()) {
            this.conditionMatchers = Collections.singletonList(() -> new RangeIntSet(0, table.numRows()));
            this.singleRowMatching = false;
        } else if (condition.isAlwaysFalse()) {
            this.conditionMatchers = Collections.singletonList(() -> IntSortedSets.EMPTY_SET);
            this.singleRowMatching = false;
        } else if (condition.getNonEquiConditions().isEmpty()) {
            List indexes = condition.getEquiConditions().stream().map(eq -> Pair.of(IndexedTableJoinMatcher.getIndex(table, eq), eq)).collect(Collectors.toCollection(ArrayList::new));
            this.conditionMatchers = indexes.stream().map(pair -> IndexedTableJoinMatcher.makeConditionMatcher((IndexedTable.Index)pair.lhs, leftSelectorFactory, (Equality)pair.rhs)).collect(Collectors.toList());
            this.singleRowMatching = indexes.stream().allMatch(pair -> ((IndexedTable.Index)pair.lhs).areKeysUnique(((Equality)pair.rhs).isIncludeNull()));
        } else {
            throw new IAE("Cannot build hash-join matcher on non-equi-join condition: %s", condition.getOriginalExpression());
        }
        ColumnSelectorFactory selectorFactory = table.makeColumnSelectorFactory(this.joinableOffset, closer);
        this.selectorFactory = selectorFactory != null ? selectorFactory : new IndexedTableColumnSelectorFactory(table, () -> this.currentRow, closer);
        this.matchedRows = remainderNeeded ? new IntRBTreeSet() : null;
    }

    private static IndexedTable.Index getIndex(IndexedTable table, Equality condition) {
        if (!table.keyColumns().contains(condition.getRightColumn())) {
            throw new IAE("Cannot build hash-join matcher on non-key-based condition: %s", condition);
        }
        int keyColumnNumber = table.rowSignature().indexOf(condition.getRightColumn());
        return table.columnIndex(keyColumnNumber);
    }

    private static ConditionMatcher makeConditionMatcher(IndexedTable.Index index, ColumnSelectorFactory selectorFactory, Equality condition) {
        return ColumnProcessors.makeProcessor(condition.getLeftExpr(), index.keyType(), new ConditionMatcherFactory(index, condition.isIncludeNull()), selectorFactory);
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return this.selectorFactory;
    }

    @Override
    public void matchCondition() {
        this.reset();
        if (this.singleRowMatching) {
            if (this.conditionMatchers.size() == 1) {
                this.currentRow = this.conditionMatchers.get(0).matchSingleRow();
            } else {
                this.currentRow = this.conditionMatchers.get(0).matchSingleRow();
                for (int i = 1; i < this.conditionMatchers.size(); ++i) {
                    if (this.currentRow == this.conditionMatchers.get(i).matchSingleRow()) continue;
                    this.currentRow = -1;
                    break;
                }
            }
        } else {
            if (this.conditionMatchers.size() == 1) {
                this.currentIterator = this.conditionMatchers.get(0).match().iterator();
            } else {
                IntSortedSet[] matchingSets = new IntSortedSet[this.conditionMatchers.size()];
                int smallestMatchingSet = -1;
                for (int i = 0; i < this.conditionMatchers.size(); ++i) {
                    matchingSets[i] = this.conditionMatchers.get(i).match();
                    if (i != 0 && matchingSets[i].size() >= matchingSets[smallestMatchingSet].size()) continue;
                    smallestMatchingSet = i;
                }
                IntSortedSet intersection = matchingSets[smallestMatchingSet];
                boolean copied = false;
                block2: for (int i = 0; i < this.conditionMatchers.size(); ++i) {
                    int numIntersectionElements = intersection.size();
                    if (numIntersectionElements <= 0 || i == smallestMatchingSet) continue;
                    IntBidirectionalIterator it = intersection.iterator();
                    while (it.hasNext()) {
                        int rowNumber = it.nextInt();
                        if (matchingSets[i].contains(rowNumber)) continue;
                        if (numIntersectionElements == 1) {
                            intersection = IntSortedSets.EMPTY_SET;
                            continue block2;
                        }
                        if (!copied) {
                            intersection = new IntAVLTreeSet(intersection);
                            copied = true;
                        }
                        intersection.remove(rowNumber);
                    }
                }
                this.currentIterator = intersection.iterator();
            }
            this.advanceCurrentRow();
        }
        this.addCurrentRowToMatchedRows();
    }

    @Override
    public void matchRemainder() {
        Preconditions.checkState((this.matchedRows != null ? 1 : 0) != 0, (Object)"matchedRows != null");
        this.currentIterator = new IntIterator(){
            int current = -1;
            {
                this.advanceRemainderIterator();
            }

            public int nextInt() {
                if (this.current >= IndexedTableJoinMatcher.this.table.numRows()) {
                    throw new NoSuchElementException();
                }
                int retVal = this.current;
                this.advanceRemainderIterator();
                return retVal;
            }

            public boolean hasNext() {
                return this.current < IndexedTableJoinMatcher.this.table.numRows();
            }

            private void advanceRemainderIterator() {
                do {
                    ++this.current;
                } while (this.current < IndexedTableJoinMatcher.this.table.numRows() && IndexedTableJoinMatcher.this.matchedRows.contains(this.current));
            }
        };
        this.matchingRemainder = true;
        this.advanceCurrentRow();
    }

    @Override
    public boolean matchingRemainder() {
        return this.matchingRemainder;
    }

    @Override
    public boolean hasMatch() {
        return this.currentRow >= 0;
    }

    @Override
    public void nextMatch() {
        this.advanceCurrentRow();
        this.addCurrentRowToMatchedRows();
    }

    @Override
    public void reset() {
        this.currentIterator = null;
        this.currentRow = -1;
        this.matchingRemainder = false;
        this.joinableOffset.reset();
    }

    private void advanceCurrentRow() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            this.currentRow = this.currentIterator.nextInt();
        } else {
            this.currentIterator = null;
            this.currentRow = -1;
            this.joinableOffset.setCurrentOffset(this.currentRow);
        }
    }

    private void addCurrentRowToMatchedRows() {
        if (!this.matchingRemainder && this.matchedRows != null && this.hasMatch()) {
            this.matchedRows.add(this.currentRow);
        }
    }

    static interface ConditionMatcher {
        default public int matchSingleRow() {
            IntSortedSet rows = this.match();
            return rows.isEmpty() ? -1 : rows.firstInt();
        }

        public IntSortedSet match();
    }

    @VisibleForTesting
    static class ConditionMatcherFactory
    implements ColumnProcessorFactory<ConditionMatcher> {
        @VisibleForTesting
        static final int CACHE_MAX_SIZE = 1000;
        private static final int MAX_NUM_CACHE = 10;
        private final ColumnType keyType;
        private final IndexedTable.Index index;
        private final boolean includeNull;
        private final LruLoadingHashMap<DimensionSelector, Int2IntSortedSetMap> dimensionCaches;

        ConditionMatcherFactory(IndexedTable.Index index, boolean includeNull) {
            this.keyType = index.keyType();
            this.index = index;
            this.includeNull = includeNull;
            this.dimensionCaches = new LruLoadingHashMap<DimensionSelector, Int2IntSortedSetMap>(10, selector -> {
                int cardinality = selector.getValueCardinality();
                IntFunction<IntSortedSet> loader = dimensionId -> this.getRowNumbers(selector.lookupName(dimensionId));
                return cardinality <= 1000 ? new Int2IntSortedSetLookupTable(cardinality, loader) : new Int2IntSortedSetLruCache(1000, loader);
            });
        }

        private IntSortedSet getRowNumbers(@Nullable String key) {
            if (this.includeNull || key != null) {
                return this.index.find(key);
            }
            return IntSortedSets.EMPTY_SET;
        }

        private IntSortedSet getAndCacheRowNumbers(DimensionSelector selector, int dimensionId) {
            return this.dimensionCaches.getAndLoadIfAbsent(selector).getAndLoadIfAbsent(dimensionId);
        }

        @Override
        public ColumnType defaultType() {
            return this.keyType;
        }

        @Override
        public ConditionMatcher makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
            if (selector.getValueCardinality() == -1) {
                return () -> {
                    IndexedInts row = selector.getRow();
                    if (row.size() == 1) {
                        int dimensionId = row.get(0);
                        return this.getRowNumbers(selector.lookupName(dimensionId));
                    }
                    if (row.size() == 0) {
                        return this.getRowNumbers(null);
                    }
                    throw new QueryUnsupportedException("Joining against a multi-value dimension is not supported.");
                };
            }
            return () -> {
                IndexedInts row = selector.getRow();
                if (row.size() == 1) {
                    int dimensionId = row.get(0);
                    return this.getAndCacheRowNumbers(selector, dimensionId);
                }
                if (row.size() == 0) {
                    return this.getRowNumbers(null);
                }
                throw new QueryUnsupportedException("Joining against a multi-value dimension is not supported.");
            };
        }

        @Override
        public ConditionMatcher makeFloatProcessor(BaseFloatColumnValueSelector selector) {
            if (this.includeNull) {
                return () -> selector.isNull() ? this.index.find(null) : this.index.find(Float.valueOf(selector.getFloat()));
            }
            return () -> selector.isNull() ? IntSortedSets.EMPTY_SET : this.index.find(Float.valueOf(selector.getFloat()));
        }

        @Override
        public ConditionMatcher makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
            if (this.includeNull) {
                return () -> selector.isNull() ? this.index.find(null) : this.index.find(selector.getDouble());
            }
            return () -> selector.isNull() ? IntSortedSets.EMPTY_SET : this.index.find(selector.getDouble());
        }

        @Override
        public ConditionMatcher makeLongProcessor(BaseLongColumnValueSelector selector) {
            if (this.index.keyType().is(ValueType.LONG)) {
                return this.makePrimitiveLongMatcher(selector);
            }
            if (this.includeNull) {
                return () -> selector.isNull() ? this.index.find(null) : this.index.find(selector.getLong());
            }
            return () -> selector.isNull() ? IntSortedSets.EMPTY_SET : this.index.find(selector.getLong());
        }

        @Override
        public ConditionMatcher makeArrayProcessor(BaseObjectColumnValueSelector<?> selector, @Nullable ColumnCapabilities columnCapabilities) {
            return () -> {
                throw new QueryUnsupportedException("Joining against ARRAY columns is not supported.");
            };
        }

        @Override
        public ConditionMatcher makeComplexProcessor(BaseObjectColumnValueSelector<?> selector) {
            return new ConditionMatcher(){

                @Override
                public int matchSingleRow() {
                    return -1;
                }

                @Override
                public IntSortedSet match() {
                    return IntSortedSets.EMPTY_SET;
                }
            };
        }

        private ConditionMatcher makePrimitiveLongMatcher(final BaseLongColumnValueSelector selector) {
            if (this.includeNull) {
                return new ConditionMatcher(){

                    @Override
                    public int matchSingleRow() {
                        if (selector.isNull()) {
                            IntSortedSet rowNumbers = index.find(null);
                            return rowNumbers == null ? -1 : rowNumbers.firstInt();
                        }
                        return index.findUniqueLong(selector.getLong());
                    }

                    @Override
                    public IntSortedSet match() {
                        return selector.isNull() ? index.find(null) : index.find(selector.getLong());
                    }
                };
            }
            return new ConditionMatcher(){

                @Override
                public int matchSingleRow() {
                    return selector.isNull() ? -1 : index.findUniqueLong(selector.getLong());
                }

                @Override
                public IntSortedSet match() {
                    return selector.isNull() ? IntSortedSets.EMPTY_SET : index.find(selector.getLong());
                }
            };
        }
    }

    @VisibleForTesting
    static class Int2IntSortedSetLruCache
    implements Int2IntSortedSetMap {
        private final Int2ObjectLinkedOpenHashMap<IntSortedSet> cache;
        private final int maxSize;
        private final IntFunction<IntSortedSet> loader;

        Int2IntSortedSetLruCache(int maxSize, IntFunction<IntSortedSet> loader) {
            this.cache = new Int2ObjectLinkedOpenHashMap(maxSize);
            this.maxSize = maxSize;
            this.loader = loader;
        }

        @Override
        public IntSortedSet getAndLoadIfAbsent(int key) {
            IntSortedSet value = (IntSortedSet)this.cache.getAndMoveToFirst(key);
            if (value == null) {
                value = this.loader.apply(key);
                this.cache.putAndMoveToFirst(key, (Object)value);
            }
            if (this.cache.size() > this.maxSize) {
                this.cache.removeLast();
            }
            return value;
        }

        @VisibleForTesting
        IntSortedSet get(int key) {
            return (IntSortedSet)this.cache.get(key);
        }
    }

    @VisibleForTesting
    static class Int2IntSortedSetLookupTable
    implements Int2IntSortedSetMap {
        private final IntSortedSet[] lookup;
        private final IntFunction<IntSortedSet> loader;

        Int2IntSortedSetLookupTable(int maxSize, IntFunction<IntSortedSet> loader) {
            this.loader = loader;
            this.lookup = new IntSortedSet[maxSize];
        }

        @Override
        public IntSortedSet getAndLoadIfAbsent(int key) {
            IntSortedSet value = this.lookup[key];
            if (value == null) {
                this.lookup[key] = value = this.loader.apply(key);
            }
            return value;
        }
    }

    private static interface Int2IntSortedSetMap {
        public IntSortedSet getAndLoadIfAbsent(int var1);
    }

    @VisibleForTesting
    static class LruLoadingHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;
        private final Function<K, V> loader;

        @SuppressForbidden(reason="java.util.LinkedHashMap#<init>(int)")
        LruLoadingHashMap(int maxSize, Function<K, V> loader) {
            super(LruLoadingHashMap.capacity(maxSize));
            this.maxSize = maxSize;
            this.loader = loader;
        }

        V getAndLoadIfAbsent(K key) {
            return this.computeIfAbsent(key, this.loader);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }

        private static int capacity(int expectedSize) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
    }
}

