/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.StructuredData;

public abstract class StructuredDataProcessor {
    protected StructuredDataProcessor() {
    }

    public abstract ProcessedValue<?> processField(ArrayList<NestedPathPart> var1, @Nullable Object var2);

    @Nullable
    public abstract ProcessedValue<?> processArrayField(ArrayList<NestedPathPart> var1, @Nullable List<?> var2);

    public ProcessResults processFields(Object raw) {
        ArrayDeque<Field> toProcess = new ArrayDeque<Field>();
        raw = StructuredData.unwrap(raw);
        ArrayList<NestedPathPart> newPath = new ArrayList<NestedPathPart>();
        if (raw instanceof Map) {
            toProcess.add(new MapField(newPath, (Map)raw));
        } else if (raw instanceof List) {
            toProcess.add(new ArrayField(newPath, (List)raw));
        } else if (raw instanceof Object[]) {
            toProcess.add(new ArrayField(newPath, Arrays.asList((Object[])raw)));
        } else {
            return new ProcessResults().addLiteralField(newPath, this.processField(newPath, raw).getSize());
        }
        ProcessResults accumulator = new ProcessResults();
        while (!toProcess.isEmpty()) {
            Field next = (Field)toProcess.poll();
            if (next instanceof MapField) {
                accumulator.merge(this.processMapField(toProcess, (MapField)next));
                continue;
            }
            if (!(next instanceof ArrayField)) continue;
            accumulator.merge(this.processArrayField(toProcess, (ArrayField)next));
        }
        return accumulator;
    }

    private ProcessResults processMapField(Queue<Field> toProcess, MapField map) {
        ProcessResults processResults = new ProcessResults().withSize(16).setHasObjects();
        for (Map.Entry<String, ?> entry : map.getMap().entrySet()) {
            processResults.addSize(StructuredDataProcessor.estimateStringSize(entry.getKey()));
            Object value = StructuredData.unwrap(entry.getValue());
            ArrayList<NestedPathPart> newPath = new ArrayList<NestedPathPart>(map.getPath());
            newPath.add(new NestedPathField(entry.getKey()));
            if (value instanceof List) {
                List theList = (List)value;
                toProcess.add(new ArrayField(newPath, theList));
                continue;
            }
            if (value instanceof Object[]) {
                toProcess.add(new ArrayField(newPath, Arrays.asList((Object[])value)));
                continue;
            }
            if (value instanceof Map) {
                toProcess.add(new MapField(newPath, (Map)value));
                continue;
            }
            processResults.addLiteralField(newPath, this.processField(newPath, value).getSize());
        }
        return processResults;
    }

    private ProcessResults processArrayField(Queue<Field> toProcess, ArrayField list) {
        ProcessResults results = new ProcessResults().withSize(8);
        List<?> theList = list.getList();
        ProcessedValue<?> maybeProcessed = this.processArrayField(list.getPath(), theList);
        if (maybeProcessed != null) {
            results.addLiteralField(list.getPath(), maybeProcessed.getSize());
        } else {
            for (int i = 0; i < theList.size(); ++i) {
                ArrayList<NestedPathPart> newPath = new ArrayList<NestedPathPart>(list.getPath());
                newPath.add(new NestedPathArrayElement(i));
                Object element = StructuredData.unwrap(theList.get(i));
                if (element instanceof Map) {
                    toProcess.add(new MapField(newPath, (Map)element));
                    continue;
                }
                if (element instanceof List) {
                    toProcess.add(new ArrayField(newPath, (List)element));
                    continue;
                }
                if (element instanceof Object[]) {
                    toProcess.add(new ArrayField(newPath, Arrays.asList((Object[])element)));
                    continue;
                }
                results.addLiteralField(newPath, this.processField(newPath, element).getSize());
            }
        }
        return results;
    }

    public static int estimateStringSize(@Nullable String value) {
        return value == null ? 0 : 44 + 2 * value.length();
    }

    public static int getLongObjectEstimateSize() {
        return 16;
    }

    public static int getDoubleObjectEstimateSize() {
        return 16;
    }

    static class MapField
    extends Field {
        private final Map<String, ?> map;

        MapField(ArrayList<NestedPathPart> path, Map<String, ?> map) {
            super(path);
            this.map = map;
        }

        public Map<String, ?> getMap() {
            return this.map;
        }
    }

    static class ArrayField
    extends Field {
        private final List<?> list;

        ArrayField(ArrayList<NestedPathPart> path, List<?> list) {
            super(path);
            this.list = list;
        }

        public List<?> getList() {
            return this.list;
        }
    }

    public static class ProcessResults {
        private Set<ArrayList<NestedPathPart>> literalFields = new HashSet<ArrayList<NestedPathPart>>();
        private int estimatedSize = 0;
        private boolean hasObjects;

        public Set<ArrayList<NestedPathPart>> getLiteralFields() {
            return this.literalFields;
        }

        public int getEstimatedSize() {
            return this.estimatedSize;
        }

        public boolean hasObjects() {
            return this.hasObjects;
        }

        public ProcessResults addSize(int size) {
            this.estimatedSize += size;
            return this;
        }

        public ProcessResults addLiteralField(ArrayList<NestedPathPart> fieldPath, int sizeOfValue) {
            this.literalFields.add(fieldPath);
            this.estimatedSize += sizeOfValue;
            return this;
        }

        public ProcessResults withSize(int size) {
            this.estimatedSize = size;
            return this;
        }

        public ProcessResults setHasObjects() {
            this.hasObjects = true;
            return this;
        }

        public ProcessResults merge(ProcessResults other) {
            this.literalFields.addAll(other.literalFields);
            this.estimatedSize += other.estimatedSize;
            this.hasObjects = this.hasObjects || other.hasObjects;
            return this;
        }
    }

    public static class ProcessedValue<T> {
        public static final ProcessedValue<?> NULL_LITERAL = new ProcessedValue<Object>(null, 0);
        @Nullable
        private final T value;
        private final int size;

        public ProcessedValue(@Nullable T value, int size) {
            this.value = value;
            this.size = size;
        }

        @Nullable
        public T getValue() {
            return this.value;
        }

        public int getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessedValue that = (ProcessedValue)o;
            return this.size == that.size && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.size);
        }
    }

    private static abstract class Field {
        private final ArrayList<NestedPathPart> path;

        protected Field(ArrayList<NestedPathPart> path) {
            this.path = path;
        }

        public ArrayList<NestedPathPart> getPath() {
            return this.path;
        }
    }
}

