/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import java.util.Objects;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.timeline.partition.PartitionChunk;

public class StringPartitionChunk<T>
implements PartitionChunk<T> {
    private final StringTuple start;
    private final StringTuple end;
    private final int chunkNumber;
    private final T object;

    public static <T> StringPartitionChunk<T> makeForSingleDimension(String start, String end, int chunkNumber, T obj) {
        return new StringPartitionChunk<T>(start == null ? null : StringTuple.create(start), end == null ? null : StringTuple.create(end), chunkNumber, obj);
    }

    public static <T> StringPartitionChunk<T> make(StringTuple start, StringTuple end, int chunkNumber, T obj) {
        return new StringPartitionChunk<T>(start, end, chunkNumber, obj);
    }

    private StringPartitionChunk(StringTuple start, StringTuple end, int chunkNumber, T object) {
        this.start = start;
        this.end = end;
        this.chunkNumber = chunkNumber;
        this.object = object;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public boolean abuts(PartitionChunk<T> chunk) {
        if (chunk instanceof StringPartitionChunk) {
            StringPartitionChunk stringChunk = (StringPartitionChunk)chunk;
            return !stringChunk.isStart() && Objects.equals(stringChunk.start, this.end);
        }
        return false;
    }

    @Override
    public boolean isStart() {
        return this.start == null;
    }

    @Override
    public boolean isEnd() {
        return this.end == null;
    }

    @Override
    public int getChunkNumber() {
        return this.chunkNumber;
    }

    @Override
    public int compareTo(PartitionChunk<T> chunk) {
        if (chunk instanceof StringPartitionChunk) {
            StringPartitionChunk stringChunk = (StringPartitionChunk)chunk;
            return Integer.compare(this.chunkNumber, stringChunk.chunkNumber);
        }
        throw new IllegalArgumentException("Cannot compare against something that is not a StringPartitionChunk.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((StringPartitionChunk)o) == 0;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.start);
        result = 31 * result + Objects.hashCode(this.end);
        result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StringPartitionChunk{start='" + String.valueOf(this.start) + "', end='" + String.valueOf(this.end) + "', chunkNumber=" + this.chunkNumber + ", object=" + String.valueOf(this.object) + "}";
    }
}

