/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PatternRestriction
extends AbstractCommonRestriction
implements HelpHint {
    private final Pattern pattern;
    private final String description;

    public PatternRestriction(String pattern, int flags, String description) {
        this.pattern = Pattern.compile(pattern, flags);
        this.description = description;
    }

    @Override
    public <T> void preValidate(ParseState<T> state, OptionMetadata option, String value) {
        if (!this.pattern.matcher(value).find()) {
            throw new ParseRestrictionViolatedException("Option %s value '%s' was given value '%s' which does not match the regular expression '%s'.  %s", AirlineUtils.first(option.getOptions()), AbstractCommonRestriction.getOptionTitle(state, option), value, this.pattern.toString(), StringUtils.isNotBlank((CharSequence)this.description) ? this.description : "");
        }
    }

    @Override
    public <T> void preValidate(ParseState<T> state, ArgumentsMetadata arguments, String value) {
        if (!this.pattern.matcher(value).find()) {
            throw new ParseRestrictionViolatedException("Argument '%s' was given value '%s' which does not match the regular expression '%s'.  %s", AbstractCommonRestriction.getArgumentTitle(state, arguments), value, this.pattern.toString(), StringUtils.isNotBlank((CharSequence)this.description) ? this.description : "");
        }
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String[]{String.format("This options value must match the regular expression '%s'.  %s", this.pattern.toString(), StringUtils.isNotBlank((CharSequence)this.description) ? this.description : "")};
    }
}

