/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.theta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.datasketches.common.Util;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.theta.SketchHolder;
import org.apache.druid.query.aggregation.datasketches.theta.SketchModule;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class SketchSetPostAggregator
implements PostAggregator {
    private final String name;
    private final List<PostAggregator> fields;
    private final SketchHolder.Func func;
    private final int maxSketchSize;

    @JsonCreator
    public SketchSetPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="func") String func, @JsonProperty(value="size") Integer maxSize, @JsonProperty(value="fields") List<PostAggregator> fields) {
        this.name = name;
        this.fields = fields;
        this.func = SketchHolder.Func.valueOf(func);
        this.maxSketchSize = maxSize == null ? 16384 : maxSize;
        Util.checkIfIntPowerOf2((int)this.maxSketchSize, (String)"size");
        if (fields.size() <= 1) {
            throw new IAE("Illegal number of fields[%s], must be > 1", new Object[]{fields.size()});
        }
    }

    public Set<String> getDependentFields() {
        LinkedHashSet<String> dependentFields = new LinkedHashSet<String>();
        for (PostAggregator field : this.fields) {
            dependentFields.addAll(field.getDependentFields());
        }
        return dependentFields;
    }

    public Comparator<Object> getComparator() {
        return SketchHolder.COMPARATOR;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        Object[] sketches = new Object[this.fields.size()];
        for (int i = 0; i < sketches.length; ++i) {
            sketches[i] = this.fields.get(i).compute(combinedAggregators);
        }
        return SketchHolder.sketchSetOperation(this.func, this.maxSketchSize, sketches);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return SketchModule.MERGE_TYPE;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @JsonProperty
    public String getFunc() {
        return this.func.toString();
    }

    @JsonProperty
    public List<PostAggregator> getFields() {
        return this.fields;
    }

    @JsonProperty
    public int getSize() {
        return this.maxSketchSize;
    }

    public String toString() {
        return "SketchSetPostAggregator{name='" + this.name + "', fields=" + String.valueOf(this.fields) + ", func=" + String.valueOf((Object)this.func) + ", size=" + this.maxSketchSize + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SketchSetPostAggregator that = (SketchSetPostAggregator)o;
        if (this.maxSketchSize != that.maxSketchSize) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        return this.func.equals((Object)that.func);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.func.hashCode();
        result = 31 * result + this.maxSketchSize;
        return result;
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(18).appendString(this.getFunc()).appendInt(this.maxSketchSize);
        if (SketchSetPostAggregator.preserveFieldOrderInCacheKey(this.func)) {
            builder.appendCacheables(this.fields);
        } else {
            builder.appendCacheablesIgnoringOrder(this.fields);
        }
        return builder.build();
    }

    private static boolean preserveFieldOrderInCacheKey(SketchHolder.Func func) {
        switch (func) {
            case NOT: {
                return true;
            }
            case UNION: 
            case INTERSECT: {
                return false;
            }
        }
        throw new IAE(func.name(), new Object[0]);
    }
}

