/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public class SequenceDescriptor
extends PrivilegedSQLObject
implements Provider,
Dependent {
    private UUID sequenceUUID;
    private String sequenceName;
    private final SchemaDescriptor schemaDescriptor;
    private UUID schemaId;
    private DataTypeDescriptor dataType;
    private Long currentValue;
    private long startValue;
    private long minimumValue;
    private long maximumValue;
    private long increment;
    private boolean canCycle;

    public SequenceDescriptor(DataDictionary dataDictionary, SchemaDescriptor schemaDescriptor, UUID uUID, String string, DataTypeDescriptor dataTypeDescriptor, Long l, long l2, long l3, long l4, long l5, boolean bl) {
        super(dataDictionary);
        this.sequenceUUID = uUID;
        this.schemaDescriptor = schemaDescriptor;
        this.sequenceName = string;
        this.schemaId = schemaDescriptor.getUUID();
        this.dataType = dataTypeDescriptor;
        this.currentValue = l;
        this.startValue = l2;
        this.minimumValue = l3;
        this.maximumValue = l4;
        this.increment = l5;
        this.canCycle = bl;
    }

    @Override
    public UUID getUUID() {
        return this.sequenceUUID;
    }

    @Override
    public String getObjectTypeName() {
        return "SEQUENCE";
    }

    public String toString() {
        return "";
    }

    public void drop(LanguageConnectionContext languageConnectionContext) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dependencyManager.invalidateFor(this, 49, languageConnectionContext);
        dataDictionary.dropSequenceDescriptor(this, transactionController);
        dependencyManager.clearDependencies(languageConnectionContext, this);
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            default: 
        }
    }

    @Override
    public void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 14: {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                dependencyManager.invalidateFor(this, 11, languageConnectionContext);
                break;
            }
        }
    }

    @Override
    public String getName() {
        return this.sequenceName;
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.schemaDescriptor;
    }

    @Override
    public String getDescriptorType() {
        return "Sequence";
    }

    @Override
    public String getDescriptorName() {
        return this.sequenceName;
    }

    @Override
    public UUID getObjectID() {
        return this.sequenceUUID;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public String getObjectName() {
        return this.sequenceName;
    }

    @Override
    public String getClassType() {
        return "Sequence";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(472);
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public UUID getSchemaId() {
        return this.schemaId;
    }

    public DataTypeDescriptor getDataType() {
        return this.dataType;
    }

    public Long getCurrentValue() {
        return this.currentValue;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public long getMinimumValue() {
        return this.minimumValue;
    }

    public long getMaximumValue() {
        return this.maximumValue;
    }

    public long getIncrement() {
        return this.increment;
    }

    public boolean canCycle() {
        return this.canCycle;
    }
}

