/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.MetadataConfigModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.MetadataRuleManagerConfig;
import org.apache.druid.metadata.MetadataRuleManagerProvider;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.metadata.SQLMetadataRuleManagerProvider;
import org.apache.druid.metadata.SQLMetadataSupervisorManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SegmentsMetadataManagerProvider;
import org.apache.druid.metadata.SqlSegmentsMetadataManagerProvider;
import org.apache.druid.metadata.segment.SegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.SqlSegmentMetadataReadOnlyTransactionFactory;
import org.apache.druid.metadata.segment.SqlSegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.cache.HeapMemorySegmentMetadataCache;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.segment.metadata.NoopSegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.MetadataManager;

public class MetadataManagerModule
implements Module {
    private Set<NodeRole> nodeRoles;
    private boolean isSchemaCacheEnabled;

    @Inject
    public void configure(Properties properties, @Self Set<NodeRole> nodeRoles) {
        this.nodeRoles = nodeRoles;
        this.isSchemaCacheEnabled = MetadataConfigModule.isSegmentSchemaCacheEnabled((Properties)properties);
    }

    public void configure(Binder binder) {
        binder.bind(CoordinatorConfigManager.class).in(LazySingleton.class);
        binder.bind(MetadataSupervisorManager.class).to(SQLMetadataSupervisorManager.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.segments", SegmentsMetadataManagerConfig.class);
        binder.bind(SegmentsMetadataManagerProvider.class).to(SqlSegmentsMetadataManagerProvider.class).in(LazySingleton.class);
        binder.bind(SegmentsMetadataManager.class).toProvider(SegmentsMetadataManagerProvider.class).in(ManageLifecycle.class);
        binder.bind(IndexerMetadataStorageCoordinator.class).to(IndexerSQLMetadataStorageCoordinator.class).in(ManageLifecycle.class);
        binder.bind(SegmentMetadataCache.class).to(HeapMemorySegmentMetadataCache.class).in(LazySingleton.class);
        if (this.nodeRoles.contains(NodeRole.COORDINATOR)) {
            JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.rules", MetadataRuleManagerConfig.class);
            binder.bind(MetadataRuleManagerProvider.class).to(SQLMetadataRuleManagerProvider.class).in(LazySingleton.class);
            binder.bind(MetadataRuleManager.class).toProvider(MetadataRuleManagerProvider.class).in(ManageLifecycle.class);
            binder.bind(MetadataManager.class).in(LazySingleton.class);
        }
        if (this.nodeRoles.contains(NodeRole.COORDINATOR) && this.isSchemaCacheEnabled) {
            binder.bind(SegmentSchemaCache.class).in(LazySingleton.class);
        } else {
            binder.bind(SegmentSchemaCache.class).to(NoopSegmentSchemaCache.class).in(LazySingleton.class);
        }
        if (this.nodeRoles.contains(NodeRole.OVERLORD)) {
            binder.bind(SegmentMetadataTransactionFactory.class).to(SqlSegmentMetadataTransactionFactory.class).in(LazySingleton.class);
        } else {
            binder.bind(SegmentMetadataTransactionFactory.class).to(SqlSegmentMetadataReadOnlyTransactionFactory.class).in(LazySingleton.class);
        }
    }
}

