/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Arrays;
import java.util.Random;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.QuantilesAPI;

public abstract class KllSketch
implements QuantilesAPI {
    public static final int DEFAULT_K = 200;
    public static final int MAX_K = 65535;
    static final int DEFAULT_M = 8;
    static final int MAX_M = 8;
    static final int MIN_M = 2;
    static final Random random = new Random();
    final SketchType sketchType;
    final SketchStructure sketchStructure;
    boolean readOnly;
    int[] levelsArr;

    KllSketch(SketchType sketchType, SketchStructure sketchStructure) {
        this.sketchType = sketchType;
        this.sketchStructure = sketchStructure;
    }

    public static int getKFromEpsilon(double epsilon, boolean pmf) {
        return KllHelper.getKFromEpsilon(epsilon, pmf);
    }

    public static int getMaxSerializedSizeBytes(int k, long n, SketchType sketchType, boolean updatableMemFormat) {
        if (sketchType == SketchType.ITEMS_SKETCH) {
            throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
        }
        KllHelper.GrowthStats gStats = KllHelper.getGrowthSchemeForGivenN(k, 8, n, sketchType, false);
        return updatableMemFormat ? gStats.updatableBytes : gStats.compactBytes;
    }

    public static double getNormalizedRankError(int k, boolean pmf) {
        return KllHelper.getNormalizedRankError(k, pmf);
    }

    public final double getNormalizedRankError(boolean pmf) {
        return KllSketch.getNormalizedRankError(this.getMinK(), pmf);
    }

    @Override
    public final int getNumRetained() {
        return this.levelsArr[this.getNumLevels()] - this.levelsArr[0];
    }

    public int getSerializedSizeBytes() {
        return this.currentSerializedSizeBytes(false);
    }

    @Override
    public boolean hasMemory() {
        WritableMemory wmem = this.getWritableMemory();
        return wmem != null;
    }

    public boolean isCompactMemoryFormat() {
        return this.hasMemory() && this.sketchStructure != SketchStructure.UPDATABLE;
    }

    @Override
    public boolean isDirect() {
        WritableMemory wmem = this.getWritableMemory();
        return wmem != null ? wmem.isDirect() : false;
    }

    @Override
    public final boolean isEmpty() {
        return this.getN() == 0L;
    }

    @Override
    public final boolean isEstimationMode() {
        return this.getNumLevels() > 1;
    }

    public final boolean isMemoryUpdatableFormat() {
        return this.hasMemory() && this.sketchStructure == SketchStructure.UPDATABLE;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isSameResource(Memory that) {
        WritableMemory wmem = this.getWritableMemory();
        return wmem != null && wmem.isSameResource((Object)that);
    }

    public abstract void merge(KllSketch var1);

    @Override
    public final String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean withLevels, boolean withData) {
        return KllHelper.toStringImpl(this, withLevels, withData, this.getSerDe());
    }

    final int currentSerializedSizeBytes(boolean updatable) {
        boolean myUpdatable = this.sketchType == SketchType.ITEMS_SKETCH ? false : updatable;
        long srcN = this.getN();
        SketchStructure tgtStructure = myUpdatable ? SketchStructure.UPDATABLE : (srcN == 0L ? SketchStructure.COMPACT_EMPTY : (srcN == 1L ? SketchStructure.COMPACT_SINGLE : SketchStructure.COMPACT_FULL));
        int totalBytes = tgtStructure == SketchStructure.COMPACT_EMPTY ? 8 : (tgtStructure == SketchStructure.COMPACT_SINGLE ? 8 + this.getSingleItemSizeBytes() : (tgtStructure == SketchStructure.COMPACT_FULL ? 20 + this.getLevelsArrSizeBytes(tgtStructure) + this.getMinMaxSizeBytes() + this.getRetainedItemsSizeBytes() : 20 + this.getLevelsArrSizeBytes(tgtStructure) + this.getMinMaxSizeBytes() + this.getTotalItemsNumBytes()));
        return totalBytes;
    }

    int[] getLevelsArray(SketchStructure structure) {
        if (structure == SketchStructure.UPDATABLE) {
            return (int[])this.levelsArr.clone();
        }
        if (structure == SketchStructure.COMPACT_FULL) {
            return Arrays.copyOf(this.levelsArr, this.levelsArr.length - 1);
        }
        return new int[0];
    }

    final int getLevelsArrSizeBytes(SketchStructure structure) {
        if (structure == SketchStructure.UPDATABLE) {
            return this.levelsArr.length * 4;
        }
        if (structure == SketchStructure.COMPACT_FULL) {
            return (this.levelsArr.length - 1) * 4;
        }
        return 0;
    }

    abstract int getM();

    abstract MemoryRequestServer getMemoryRequestServer();

    abstract int getMinK();

    abstract byte[] getMinMaxByteArr();

    abstract int getMinMaxSizeBytes();

    final int getNumLevels() {
        if (this.sketchStructure == SketchStructure.UPDATABLE || this.sketchStructure == SketchStructure.COMPACT_FULL) {
            return this.levelsArr.length - 1;
        }
        return 1;
    }

    abstract byte[] getRetainedItemsByteArr();

    abstract int getRetainedItemsSizeBytes();

    abstract ArrayOfItemsSerDe<?> getSerDe();

    abstract byte[] getSingleItemByteArr();

    abstract int getSingleItemSizeBytes();

    abstract byte[] getTotalItemsByteArr();

    abstract int getTotalItemsNumBytes();

    abstract WritableMemory getWritableMemory();

    abstract void incN();

    abstract void incNumLevels();

    final boolean isCompactSingleItem() {
        return this.hasMemory() && this.sketchStructure == SketchStructure.COMPACT_SINGLE && this.getN() == 1L;
    }

    boolean isDoublesSketch() {
        return this.sketchType == SketchType.DOUBLES_SKETCH;
    }

    boolean isFloatsSketch() {
        return this.sketchType == SketchType.FLOATS_SKETCH;
    }

    boolean isItemsSketch() {
        return this.sketchType == SketchType.ITEMS_SKETCH;
    }

    abstract boolean isLevelZeroSorted();

    boolean isSingleItem() {
        return this.getN() == 1L;
    }

    final void setLevelsArray(int[] levelsArr) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        this.levelsArr = levelsArr;
        WritableMemory wmem = this.getWritableMemory();
        if (wmem != null) {
            wmem.putIntArray(20L, this.levelsArr, 0, levelsArr.length);
        }
    }

    final void setLevelsArrayAt(int index, int idxVal) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        this.levelsArr[index] = idxVal;
        WritableMemory wmem = this.getWritableMemory();
        if (wmem != null) {
            int offset = 20 + index * 4;
            wmem.putInt((long)offset, idxVal);
        }
    }

    abstract void setLevelZeroSorted(boolean var1);

    abstract void setMinK(int var1);

    abstract void setN(long var1);

    abstract void setNumLevels(int var1);

    abstract void setWritableMemory(WritableMemory var1);

    public static enum SketchStructure {
        COMPACT_EMPTY(2, 1),
        COMPACT_SINGLE(2, 2),
        COMPACT_FULL(5, 1),
        UPDATABLE(5, 3);

        private int preInts;
        private int serVer;

        private SketchStructure(int preInts, int serVer) {
            this.preInts = preInts;
            this.serVer = serVer;
        }

        public int getPreInts() {
            return this.preInts;
        }

        public int getSerVer() {
            return this.serVer;
        }

        public static SketchStructure getSketchStructure(int preInts, int serVer) {
            SketchStructure[] ssArr = SketchStructure.values();
            for (int i = 0; i < ssArr.length; ++i) {
                if (ssArr[i].preInts != preInts || ssArr[i].serVer != serVer) continue;
                return ssArr[i];
            }
            throw new SketchesArgumentException("Error combination of PreInts and SerVer: PreInts: " + preInts + ", SerVer: " + serVer);
        }
    }

    public static enum SketchType {
        DOUBLES_SKETCH(8, "DoublesSketch"),
        FLOATS_SKETCH(4, "FloatsSketch"),
        ITEMS_SKETCH(0, "ItemsSketch");

        private int typeBytes;
        private String name;

        private SketchType(int typeBytes, String name) {
            this.typeBytes = typeBytes;
            this.name = name;
        }

        public int getBytes() {
            return this.typeBytes;
        }

        public String getName() {
            return this.name;
        }
    }
}

