/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.PolyBind;
import org.apache.druid.indexing.common.config.FileTaskLogsConfig;
import org.apache.druid.indexing.common.tasklogs.FileTaskLogs;
import org.apache.druid.tasklogs.NoopTaskLogs;
import org.apache.druid.tasklogs.SwitchingTaskLogs;
import org.apache.druid.tasklogs.TaskLogKiller;
import org.apache.druid.tasklogs.TaskLogPusher;
import org.apache.druid.tasklogs.TaskLogs;
import org.apache.druid.tasklogs.TaskPayloadManager;

public class IndexingServiceTaskLogsModule
implements Module {
    private final Properties props;

    public IndexingServiceTaskLogsModule(Properties props) {
        this.props = props;
    }

    public void configure(Binder binder) {
        PolyBind.createChoice((Binder)binder, (String)"druid.indexer.logs.type", (Key)Key.get(TaskLogs.class), (Key)Key.get(FileTaskLogs.class));
        PolyBind.createChoice((Binder)binder, (String)"druid.indexer.logs.switching.defaultType", (Key)Key.get(TaskLogs.class, (Annotation)Names.named((String)"switching.defaultType")), (Key)Key.get(FileTaskLogs.class));
        this.bindTaskLogImplementation(binder, "druid.indexer.logs.switching.logPushType", "switching.logPushType");
        this.bindTaskLogImplementation(binder, "druid.indexer.logs.switching.reportsType", "switching.reportsType");
        this.bindTaskLogImplementation(binder, "druid.indexer.logs.switching.logStreamType", "switching.logStreamType");
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.logs", FileTaskLogsConfig.class);
        MapBinder taskLogBinder = Binders.taskLogsBinder((Binder)binder);
        taskLogBinder.addBinding((Object)"switching").to(SwitchingTaskLogs.class);
        Binders.bindTaskLogs((Binder)binder, (String)"noop", NoopTaskLogs.class);
        Binders.bindTaskLogs((Binder)binder, (String)"file", FileTaskLogs.class);
        binder.bind(NoopTaskLogs.class).in(LazySingleton.class);
        binder.bind(FileTaskLogs.class).in(LazySingleton.class);
        binder.bind(SwitchingTaskLogs.class).in(LazySingleton.class);
        binder.bind(TaskLogPusher.class).to(TaskLogs.class);
        binder.bind(TaskLogKiller.class).to(TaskLogs.class);
        binder.bind(TaskPayloadManager.class).to(TaskLogs.class);
    }

    private void bindTaskLogImplementation(Binder binder, String propertyKey, String typeName) {
        if (this.props != null && this.props.getProperty(propertyKey) != null) {
            PolyBind.createChoice((Binder)binder, (String)propertyKey, (Key)Key.get(TaskLogs.class, (Annotation)Names.named((String)typeName)), null);
        } else {
            binder.bind(Key.get(TaskLogs.class, (Annotation)Names.named((String)typeName))).to(Key.get(TaskLogs.class, (Annotation)Names.named((String)"switching.defaultType")));
        }
    }
}

