/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.nio.ByteBuffer;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DummyBlockingPool;
import org.apache.druid.collections.DummyNonBlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.ExecutorServiceMonitor;
import org.apache.druid.query.NoopQueryProcessingPool;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.utils.RuntimeInfo;

public class PeonProcessingModule
implements Module {
    private static final Logger log = new Logger(PeonProcessingModule.class);

    public void configure(Binder binder) {
        DruidProcessingModule.registerConfigsAndMonitor((Binder)binder);
    }

    @Provides
    @LazySingleton
    public CachePopulator getCachePopulator(@Smile ObjectMapper smileMapper, CachePopulatorStats cachePopulatorStats, CacheConfig cacheConfig) {
        return DruidProcessingModule.createCachePopulator((ObjectMapper)smileMapper, (CachePopulatorStats)cachePopulatorStats, (CacheConfig)cacheConfig);
    }

    @Provides
    @ManageLifecycle
    public QueryProcessingPool getProcessingExecutorPool(Task task, DruidProcessingConfig config, ExecutorServiceMonitor executorServiceMonitor, Lifecycle lifecycle) {
        if (task.supportsQueries()) {
            return DruidProcessingModule.createProcessingExecutorPool((DruidProcessingConfig)config, (ExecutorServiceMonitor)executorServiceMonitor, (Lifecycle)lifecycle);
        }
        if (config.isNumThreadsConfigured()) {
            log.warn("Ignoring the configured numThreads[%d] because task[%s] of type[%s] does not support queries", new Object[]{config.getNumThreads(), task.getId(), task.getType()});
        }
        return NoopQueryProcessingPool.instance();
    }

    @Provides
    @LazySingleton
    @Global
    public NonBlockingPool<ByteBuffer> getIntermediateResultsPool(Task task, DruidProcessingConfig config, RuntimeInfo runtimeInfo) {
        if (task.supportsQueries()) {
            return DruidProcessingModule.createIntermediateResultsPool((DruidProcessingConfig)config, (RuntimeInfo)runtimeInfo);
        }
        return DummyNonBlockingPool.instance();
    }

    @Provides
    @LazySingleton
    @Merging
    public BlockingPool<ByteBuffer> getMergeBufferPool(Task task, DruidProcessingConfig config, RuntimeInfo runtimeInfo) {
        if (task.supportsQueries()) {
            return DruidProcessingModule.createMergeBufferPool((DruidProcessingConfig)config, (RuntimeInfo)runtimeInfo);
        }
        if (config.isNumMergeBuffersConfigured()) {
            log.warn("Ignoring the configured numMergeBuffers[%d] because task[%s] of type[%s] does not support queries", new Object[]{config.getNumThreads(), task.getId(), task.getType()});
        }
        return DummyBlockingPool.instance();
    }

    @Provides
    @LazySingleton
    @Merging
    public GroupByResourcesReservationPool getGroupByResourcesReservationPool(@Merging BlockingPool<ByteBuffer> mergeBufferPool, GroupByQueryConfig groupByQueryConfig) {
        return new GroupByResourcesReservationPool(mergeBufferPool, groupByQueryConfig);
    }
}

