/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel.distribution;

import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.internal.UnsafeUtil;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.ArrayOfStringsNullSafeSerde;

public class ArrayOfStringTuplesSerDe
extends ArrayOfItemsSerDe<StringTuple> {
    private static final ArrayOfStringsNullSafeSerde STRINGS_SERDE = new ArrayOfStringsNullSafeSerde();

    public byte[] serializeToByteArray(StringTuple[] items) {
        int length = 0;
        byte[][] itemsBytes = new byte[items.length][];
        for (int i = 0; i < items.length; ++i) {
            itemsBytes[i] = STRINGS_SERDE.serializeToByteArray(items[i].toArray());
            length += 8 + itemsBytes[i].length;
        }
        byte[] bytes = new byte[length];
        int offsetBytes = 0;
        for (int i = 0; i < items.length; ++i) {
            ByteArrayUtil.putIntLE((byte[])bytes, (int)offsetBytes, (int)items[i].size());
            ByteArrayUtil.putIntLE((byte[])bytes, (int)(offsetBytes += 4), (int)itemsBytes[i].length);
            ByteArrayUtil.copyBytes((byte[])itemsBytes[i], (int)0, (byte[])bytes, (int)(offsetBytes += 4), (int)itemsBytes[i].length);
            offsetBytes += itemsBytes[i].length;
        }
        return bytes;
    }

    public StringTuple[] deserializeFromMemory(Memory mem, long offsetBytes, int numItems) {
        StringTuple[] array = new StringTuple[numItems];
        for (int i = 0; i < numItems; ++i) {
            UnsafeUtil.checkBounds((long)offsetBytes, (long)4L, (long)mem.getCapacity());
            int numItemsInTuple = mem.getInt(offsetBytes);
            UnsafeUtil.checkBounds((long)(offsetBytes += 4L), (long)4L, (long)mem.getCapacity());
            int byteContentSize = mem.getInt(offsetBytes);
            byte[] byteContent = new byte[byteContentSize];
            UnsafeUtil.checkBounds((long)(offsetBytes += 4L), (long)byteContentSize, (long)mem.getCapacity());
            mem.getByteArray(offsetBytes, byteContent, 0, byteContentSize);
            offsetBytes += (long)byteContentSize;
            array[i] = StringTuple.create((String[])STRINGS_SERDE.deserializeFromMemory(Memory.wrap((byte[])byteContent), numItemsInTuple));
        }
        return array;
    }

    public byte[] serializeToByteArray(StringTuple item) {
        byte[] itemBytes = STRINGS_SERDE.serializeToByteArray(item.toArray());
        byte[] bytes = new byte[8 + itemBytes.length];
        int offsetBytes = 0;
        ByteArrayUtil.putIntLE((byte[])bytes, (int)offsetBytes, (int)item.size());
        ByteArrayUtil.putIntLE((byte[])bytes, (int)(offsetBytes += 4), (int)itemBytes.length);
        ByteArrayUtil.copyBytes((byte[])itemBytes, (int)0, (byte[])bytes, (int)(offsetBytes += 4), (int)itemBytes.length);
        return bytes;
    }

    public StringTuple[] deserializeFromMemory(Memory mem, int numItems) {
        return this.deserializeFromMemory(mem, 0L, numItems);
    }

    public int sizeOf(StringTuple item) {
        int length = 8;
        for (String s : item.toArray()) {
            length += STRINGS_SERDE.sizeOf(s);
        }
        return length;
    }

    public int sizeOf(Memory mem, long offsetBytes, int numItems) {
        long start = offsetBytes;
        for (int i = 0; i < numItems; ++i) {
            Util.checkBounds((long)offsetBytes, (long)4L, (long)mem.getCapacity());
            Util.checkBounds((long)(offsetBytes += 4L), (long)4L, (long)mem.getCapacity());
            int byteContentSize = mem.getInt(offsetBytes);
            Util.checkBounds((long)(offsetBytes += 4L), (long)byteContentSize, (long)mem.getCapacity());
            offsetBytes += (long)byteContentSize;
        }
        return (int)(offsetBytes - start);
    }

    public String toString(StringTuple item) {
        return item.toString();
    }

    public Class<?> getClassOfT() {
        return StringTuple.class;
    }
}

