/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.duty;

import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.KillUnusedSegmentsTask;
import org.apache.druid.indexing.overlord.GlobalTaskLockbox;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.duty.DutySchedule;
import org.apache.druid.indexing.overlord.duty.KillTaskToolbox;
import org.apache.druid.indexing.overlord.duty.OverlordDuty;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.UnusedSegmentKillerConfig;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class UnusedSegmentsKiller
implements OverlordDuty {
    private static final EmittingLogger log = new EmittingLogger(UnusedSegmentsKiller.class);
    private static final String TASK_ID_PREFIX = "overlord-issued";
    private static final int INITIAL_KILL_QUEUE_SIZE = 1000;
    private static final int MAX_INTERVALS_TO_KILL_IN_DATASOURCE = 10000;
    private static final int MAX_SEGMENTS_TO_KILL_IN_INTERVAL = 1000;
    private static final Duration QUEUE_RESET_PERIOD = Duration.standardDays((long)1L);
    private static final Duration MAX_TASK_DURATION = Duration.standardMinutes((long)10L);
    private final ServiceEmitter emitter;
    private final GlobalTaskLockbox taskLockbox;
    private final DruidLeaderSelector leaderSelector;
    private final DataSegmentKiller dataSegmentKiller;
    private final UnusedSegmentKillerConfig killConfig;
    private final TaskActionClientFactory taskActionClientFactory;
    private final IndexerMetadataStorageCoordinator storageCoordinator;
    private final ScheduledExecutorService exec;
    private int previousLeaderTerm;
    private final AtomicReference<DateTime> lastResetTime = new AtomicReference<Object>(null);
    private final AtomicReference<TaskInfo> currentTaskInfo = new AtomicReference<Object>(null);
    private final PriorityBlockingQueue<KillCandidate> killQueue;

    @Inject
    public UnusedSegmentsKiller(SegmentsMetadataManagerConfig config, TaskActionClientFactory taskActionClientFactory, IndexerMetadataStorageCoordinator storageCoordinator, @IndexingService DruidLeaderSelector leaderSelector, ScheduledExecutorFactory executorFactory, DataSegmentKiller dataSegmentKiller, GlobalTaskLockbox taskLockbox, ServiceEmitter emitter) {
        this.emitter = emitter;
        this.taskLockbox = taskLockbox;
        this.leaderSelector = leaderSelector;
        this.dataSegmentKiller = dataSegmentKiller;
        this.storageCoordinator = storageCoordinator;
        this.taskActionClientFactory = taskActionClientFactory;
        this.killConfig = config.getKillUnused();
        if (this.isEnabled()) {
            this.exec = executorFactory.create(1, "UnusedSegmentsKiller-%s");
            this.killQueue = new PriorityBlockingQueue(1000, Ordering.from((Comparator)Comparators.intervalsByEndThenStart()).onResultOf(candidate -> candidate.interval));
        } else {
            this.exec = null;
            this.killQueue = null;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.killConfig.isEnabled();
    }

    @Override
    public void run() {
        TaskInfo taskInfo;
        if (!this.isEnabled()) {
            return;
        }
        this.updateStateIfNewLeader();
        if (this.shouldRebuildKillQueue()) {
            this.killQueue.clear();
            this.exec.submit(() -> {
                this.rebuildKillQueue();
                this.startNextJobInKillQueue();
            });
        }
        if ((taskInfo = this.currentTaskInfo.get()) != null && !taskInfo.future.isDone() && taskInfo.sinceTaskStarted.hasElapsed(MAX_TASK_DURATION)) {
            log.warn("Cancelling kill task[%s] as it has been running for [%,d] millis.", new Object[]{taskInfo.taskId, taskInfo.sinceTaskStarted.millisElapsed()});
            taskInfo.future.cancel(true);
        }
    }

    @Override
    public DutySchedule getSchedule() {
        if (this.isEnabled()) {
            long periodMillis = this.killConfig.getDutyPeriod().toStandardDuration().getMillis();
            long initialDelayMillis = periodMillis / 4L;
            log.info("Unused segment killer is enabled and will start after [%d] millis. Kill queue will be rebuilt every [%s] if empty.", new Object[]{initialDelayMillis, this.killConfig.getDutyPeriod()});
            return new DutySchedule(periodMillis, initialDelayMillis);
        }
        return new DutySchedule(0L, 0L);
    }

    private void updateStateIfNewLeader() {
        int currentLeaderTerm = this.leaderSelector.localTerm();
        if (currentLeaderTerm != this.previousLeaderTerm) {
            this.previousLeaderTerm = currentLeaderTerm;
            this.killQueue.clear();
            this.lastResetTime.set(null);
        }
    }

    private boolean shouldRebuildKillQueue() {
        DateTime now = DateTimes.nowUtc().plus(1L);
        return this.killQueue.isEmpty() || this.lastResetTime.get() == null || this.lastResetTime.get().plus((ReadableDuration)QUEUE_RESET_PERIOD).isBefore((ReadableInstant)now);
    }

    private void rebuildKillQueue() {
        Stopwatch resetDuration = Stopwatch.createStarted();
        try {
            this.killQueue.clear();
            if (!this.leaderSelector.isLeader()) {
                log.info("Not rebuilding kill queue as we are not leader anymore.", new Object[0]);
                return;
            }
            Set dataSources = this.storageCoordinator.retrieveAllDatasourceNames();
            HashMap<String, Integer> dataSourceToIntervalCounts = new HashMap<String, Integer>();
            for (String dataSource2 : dataSources) {
                this.storageCoordinator.retrieveUnusedSegmentIntervals(dataSource2, 10000).forEach(interval -> {
                    dataSourceToIntervalCounts.merge(dataSource2, 1, Integer::sum);
                    this.killQueue.offer(new KillCandidate(dataSource2, (Interval)interval));
                });
            }
            this.lastResetTime.set(DateTimes.nowUtc());
            log.info("Queued [%d] kill jobs for [%d] datasources in [%d] millis.", new Object[]{this.killQueue.size(), dataSources.size(), resetDuration.millisElapsed()});
            dataSourceToIntervalCounts.forEach((dataSource, intervalCount) -> this.emitMetric("segment/kill/unusedIntervals/count", intervalCount.intValue(), Map.of("dataSource", dataSource)));
            this.emitMetric("segment/kill/queueReset/time", resetDuration.millisElapsed(), null);
        }
        catch (Throwable t) {
            log.makeAlert(t, "Error while resetting kill queue.", new Object[0]);
        }
    }

    private void startNextJobInKillQueue() {
        if (!this.isEnabled() || !this.leaderSelector.isLeader()) {
            return;
        }
        if (this.killQueue.isEmpty()) {
            DateTime lastQueueResetTime = this.lastResetTime.get();
            if (lastQueueResetTime != null) {
                long processTimeMillis = DateTimes.nowUtc().getMillis() - lastQueueResetTime.getMillis();
                this.emitMetric("segment/kill/queueProcess/time", processTimeMillis, null);
            }
            return;
        }
        try {
            KillCandidate candidate = this.killQueue.poll();
            if (candidate == null) {
                return;
            }
            String taskId = IdUtils.newTaskId((String)TASK_ID_PREFIX, (String)"kill", (String)candidate.dataSource, (Interval)candidate.interval);
            Future<?> taskFuture = this.exec.submit(() -> {
                this.runKillTask(candidate, taskId);
                this.startNextJobInKillQueue();
            });
            this.currentTaskInfo.set(new TaskInfo(taskId, taskFuture));
        }
        catch (Throwable t) {
            log.makeAlert(t, "Error while processing kill queue.", new Object[0]);
            this.currentTaskInfo.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runKillTask(KillCandidate candidate, String taskId) {
        Stopwatch taskRunTime = Stopwatch.createStarted();
        EmbeddedKillTask killTask = new EmbeddedKillTask(taskId, candidate, DateTimes.nowUtc().minus((ReadablePeriod)this.killConfig.getBufferPeriod()));
        TaskActionClient taskActionClient = this.taskActionClientFactory.create(killTask);
        TaskToolbox taskToolbox = KillTaskToolbox.create(taskActionClient, this.dataSegmentKiller, this.emitter);
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder();
        IndexTaskUtils.setTaskDimensions(metricBuilder, killTask);
        try {
            this.taskLockbox.add(killTask);
            boolean isReady = killTask.isReady(taskActionClient);
            if (!isReady) {
                this.emitter.emit((ServiceEventBuilder)metricBuilder.setMetric("segment/kill/skippedIntervals/count", (Number)1L));
                return;
            }
            TaskStatus status = killTask.runTask(taskToolbox);
            IndexTaskUtils.setTaskStatusDimensions(metricBuilder, status);
            this.emitter.emit((ServiceEventBuilder)metricBuilder.setMetric("task/run/time", (Number)taskRunTime.millisElapsed()));
        }
        catch (Throwable t) {
            log.error(t, "Embedded kill task[%s] failed.", new Object[]{killTask.getId()});
            IndexTaskUtils.setTaskStatusDimensions(metricBuilder, TaskStatus.failure((String)taskId, (String)"Unknown error"));
            this.emitter.emit((ServiceEventBuilder)metricBuilder.setMetric("task/run/time", (Number)taskRunTime.millisElapsed()));
        }
        finally {
            this.cleanupLocksSilently(killTask);
            this.emitMetric("segment/kill/jobsProcessed/count", 1L, Map.of("dataSource", candidate.dataSource));
        }
    }

    private void cleanupLocksSilently(EmbeddedKillTask killTask) {
        try {
            this.taskLockbox.remove(killTask);
        }
        catch (Throwable t) {
            log.error(t, "Error while cleaning up locks for kill task[%s].", new Object[]{killTask.getId()});
        }
    }

    private void emitMetric(String metricName, long value, Map<String, String> dimensions) {
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        if (dimensions != null) {
            dimensions.forEach((arg_0, arg_1) -> ((ServiceMetricEvent.Builder)builder).setDimension(arg_0, arg_1));
        }
        this.emitter.emit((ServiceEventBuilder)builder.setMetric(metricName, (Number)value));
    }

    private static class TaskInfo {
        private final Stopwatch sinceTaskStarted;
        private final String taskId;
        private final Future<?> future;

        private TaskInfo(String taskId, Future<?> future) {
            this.future = future;
            this.taskId = taskId;
            this.sinceTaskStarted = Stopwatch.createStarted();
        }
    }

    public static class Metric {
        public static final String QUEUE_RESET_TIME = "segment/kill/queueReset/time";
        public static final String QUEUE_PROCESS_TIME = "segment/kill/queueProcess/time";
        public static final String PROCESSED_KILL_JOBS = "segment/kill/jobsProcessed/count";
        public static final String SKIPPED_INTERVALS = "segment/kill/skippedIntervals/count";
        public static final String UNUSED_SEGMENT_INTERVALS = "segment/kill/unusedIntervals/count";
    }

    private static class KillCandidate {
        private final String dataSource;
        private final Interval interval;

        private KillCandidate(String dataSource, Interval interval) {
            this.dataSource = dataSource;
            this.interval = interval;
        }
    }

    private class EmbeddedKillTask
    extends KillUnusedSegmentsTask {
        private EmbeddedKillTask(String taskId, KillCandidate candidate, DateTime maxUpdatedTimeOfEligibleSegment) {
            super(taskId, candidate.dataSource, candidate.interval, null, Map.of("priority", 25), null, null, maxUpdatedTimeOfEligibleSegment);
        }

        @Override
        @Nullable
        protected Integer getNumTotalBatches() {
            return 1;
        }

        @Override
        protected List<DataSegment> fetchNextBatchOfUnusedSegments(TaskToolbox toolbox, int nextBatchSize) {
            return UnusedSegmentsKiller.this.storageCoordinator.retrieveUnusedSegmentsWithExactInterval(this.getDataSource(), this.getInterval(), this.getMaxUsedStatusLastUpdatedTime(), 1000);
        }

        @Override
        protected void logInfo(String message, Object ... args) {
            log.debug(message, args);
        }
    }
}

