/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.setup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import org.apache.druid.indexing.overlord.setup.AffinityConfig;
import org.apache.druid.indexing.overlord.setup.TaskLimits;
import org.apache.druid.indexing.overlord.setup.WorkerCategorySpec;

public class WorkerSelectUtils {
    private WorkerSelectUtils() {
    }

    @Nullable
    public static ImmutableWorkerInfo selectWorker(Task task, Map<String, ImmutableWorkerInfo> allWorkers, WorkerTaskRunnerConfig workerTaskRunnerConfig, @Nullable AffinityConfig affinityConfig, Function<ImmutableMap<String, ImmutableWorkerInfo>, ImmutableWorkerInfo> workerSelector, TaskLimits taskLimits) {
        Map<String, ImmutableWorkerInfo> runnableWorkers = WorkerSelectUtils.getRunnableWorkers(task, allWorkers, workerTaskRunnerConfig, taskLimits);
        if (affinityConfig == null) {
            return workerSelector.apply((ImmutableMap<String, ImmutableWorkerInfo>)ImmutableMap.copyOf(runnableWorkers));
        }
        Set<String> dataSourceWorkers = affinityConfig.getAffinity().get(task.getDataSource());
        if (dataSourceWorkers == null) {
            return workerSelector.apply(WorkerSelectUtils.getNonAffinityWorkers(affinityConfig, runnableWorkers));
        }
        ImmutableMap dataSourceWorkerMap = ImmutableMap.copyOf((Map)Maps.filterKeys(runnableWorkers, dataSourceWorkers::contains));
        ImmutableWorkerInfo selected = workerSelector.apply((ImmutableMap<String, ImmutableWorkerInfo>)dataSourceWorkerMap);
        if (selected != null) {
            return selected;
        }
        if (affinityConfig.isStrong()) {
            return null;
        }
        return workerSelector.apply(WorkerSelectUtils.getNonAffinityWorkers(affinityConfig, runnableWorkers));
    }

    @Nullable
    public static ImmutableWorkerInfo selectWorker(Task task, Map<String, ImmutableWorkerInfo> allWorkers, WorkerTaskRunnerConfig workerTaskRunnerConfig, @Nullable WorkerCategorySpec workerCategorySpec, Function<ImmutableMap<String, ImmutableWorkerInfo>, ImmutableWorkerInfo> workerSelector, TaskLimits taskLimits) {
        WorkerCategorySpec.CategoryConfig categoryConfig;
        Map<String, ImmutableWorkerInfo> runnableWorkers = WorkerSelectUtils.getRunnableWorkers(task, allWorkers, workerTaskRunnerConfig, taskLimits);
        if (workerCategorySpec != null && (categoryConfig = workerCategorySpec.getCategoryMap().get(task.getType())) != null) {
            String defaultCategory = categoryConfig.getDefaultCategory();
            Map<String, String> categoryAffinity = categoryConfig.getCategoryAffinity();
            String preferredCategory = categoryAffinity.get(task.getDataSource());
            String string = preferredCategory = preferredCategory == null ? defaultCategory : preferredCategory;
            if (preferredCategory != null) {
                ImmutableMap<String, ImmutableWorkerInfo> categoryWorkers = WorkerSelectUtils.getCategoryWorkers(preferredCategory, runnableWorkers);
                ImmutableWorkerInfo selected = workerSelector.apply(categoryWorkers);
                if (selected != null) {
                    return selected;
                }
                if (workerCategorySpec.isStrong()) {
                    return null;
                }
            }
        }
        return workerSelector.apply((ImmutableMap<String, ImmutableWorkerInfo>)ImmutableMap.copyOf(runnableWorkers));
    }

    private static Map<String, ImmutableWorkerInfo> getRunnableWorkers(Task task, Map<String, ImmutableWorkerInfo> allWorkers, WorkerTaskRunnerConfig workerTaskRunnerConfig, TaskLimits taskLimits) {
        if (!taskLimits.canRunTask(task, WorkerSelectUtils.getTotalCapacityUsedByType(allWorkers, task.getType()), WorkerSelectUtils.getTotalCapacity(allWorkers))) {
            return Collections.emptyMap();
        }
        return allWorkers.values().stream().filter(worker -> worker.canRunTask(task, workerTaskRunnerConfig.getParallelIndexTaskSlotRatio()) && worker.isValidVersion(workerTaskRunnerConfig.getMinWorkerVersion())).collect(Collectors.toMap(w -> w.getWorker().getHost(), Function.identity()));
    }

    private static ImmutableMap<String, ImmutableWorkerInfo> getCategoryWorkers(String category, Map<String, ImmutableWorkerInfo> workerMap) {
        return ImmutableMap.copyOf((Map)Maps.filterValues(workerMap, workerInfo -> workerInfo.getWorker().getCategory().equals(category)));
    }

    private static ImmutableMap<String, ImmutableWorkerInfo> getNonAffinityWorkers(AffinityConfig affinityConfig, Map<String, ImmutableWorkerInfo> workerMap) {
        return ImmutableMap.copyOf((Map)Maps.filterKeys(workerMap, workerHost -> !affinityConfig.getAffinityWorkers().contains(workerHost)));
    }

    private static int getTotalCapacity(Map<String, ImmutableWorkerInfo> allWorkers) {
        return allWorkers.values().stream().mapToInt(workerInfo -> workerInfo.getWorker().getCapacity()).sum();
    }

    private static int getTotalCapacityUsedByType(Map<String, ImmutableWorkerInfo> allWorkers, String taskType) {
        return allWorkers.values().stream().mapToInt(workerInfo -> workerInfo.getCurrCapacityUsedByTaskType().getOrDefault(taskType, 0)).sum();
    }
}

