/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.spy.memcached.MemcachedClientIF;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.Cleaners;
import org.apache.druid.java.util.common.logger.Logger;

final class MemcacheClientPool
implements Supplier<ResourceHolder<MemcachedClientIF>> {
    private static final Logger log = new Logger(MemcacheClientPool.class);
    private static final AtomicLong LEAKED_CLIENTS = new AtomicLong(0L);
    private final CountingHolder[] connections;

    public static long leakedClients() {
        return LEAKED_CLIENTS.get();
    }

    MemcacheClientPool(int capacity, Supplier<MemcachedClientIF> generator) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"capacity must be greater than 0");
        Preconditions.checkNotNull(generator);
        CountingHolder[] connections = new CountingHolder[capacity];
        for (int i = 0; i < capacity; ++i) {
            connections[i] = new CountingHolder((MemcachedClientIF)generator.get());
        }
        this.connections = connections;
    }

    public synchronized IdempotentCloseableHolder get() {
        CountingHolder leastUsedClientHolder = this.connections[0];
        int minCount = leastUsedClientHolder.count.get();
        for (int i = 1; i < this.connections.length; ++i) {
            CountingHolder clientHolder = this.connections[i];
            int count = clientHolder.count.get();
            if (count >= minCount) continue;
            leastUsedClientHolder = clientHolder;
            minCount = count;
        }
        leastUsedClientHolder.count.incrementAndGet();
        return new IdempotentCloseableHolder(leastUsedClientHolder);
    }

    private static class CountingHolder {
        private final AtomicInteger count = new AtomicInteger(0);
        private final MemcachedClientIF clientIF;
        private final Cleaners.Cleanable cleanable;

        private CountingHolder(MemcachedClientIF clientIF) {
            this.clientIF = clientIF;
            this.cleanable = Cleaners.register((Object)this, (Runnable)new ClientLeakNotifier(this.count, clientIF));
        }
    }

    @VisibleForTesting
    static class IdempotentCloseableHolder
    implements ResourceHolder<MemcachedClientIF> {
        private CountingHolder countingHolder;

        private IdempotentCloseableHolder(CountingHolder countingHolder) {
            this.countingHolder = countingHolder;
        }

        public MemcachedClientIF get() {
            return this.countingHolder.clientIF;
        }

        int count() {
            return this.countingHolder.count.get();
        }

        public void close() {
            if (this.countingHolder != null) {
                this.countingHolder.count.decrementAndGet();
                this.countingHolder = null;
            }
        }
    }

    private static class ClientLeakNotifier
    implements Runnable {
        private final AtomicInteger count;
        private final MemcachedClientIF clientIF;

        private ClientLeakNotifier(AtomicInteger count, MemcachedClientIF clientIF) {
            this.count = count;
            this.clientIF = clientIF;
        }

        @Override
        public void run() {
            int shouldBeZero = this.count.get();
            if (shouldBeZero != 0) {
                LEAKED_CLIENTS.incrementAndGet();
                log.warn("Expected 0 resource count, got [%d]! Object was[%s].", new Object[]{shouldBeZero, this.clientIF});
            }
        }
    }
}

