/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.announcement;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.CreateBackgroundModeStatACLable;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.SetDataBackgroundVersionable;
import org.apache.curator.framework.api.transaction.CuratorMultiTransaction;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.curator.announcement.Announceable;
import org.apache.druid.curator.announcement.ServiceAnnouncer;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.CloseableUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class NodeAnnouncer
implements ServiceAnnouncer {
    private static final Logger log = new Logger(NodeAnnouncer.class);
    private final CuratorFramework curator;
    private final ExecutorService nodeCacheExecutor;
    private final ConcurrentHashMap<String, CuratorCache> listeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, byte[]> announcedPaths = new ConcurrentHashMap();
    @GuardedBy(value="toAnnounce")
    private boolean started = false;
    @GuardedBy(value="toAnnounce")
    private final List<Announceable> toAnnounce = new ArrayList<Announceable>();
    @GuardedBy(value="toAnnounce")
    private final List<Announceable> toUpdate = new ArrayList<Announceable>();
    @GuardedBy(value="toAnnounce")
    private final List<String> parentsIBuilt = new CopyOnWriteArrayList<String>();

    public NodeAnnouncer(CuratorFramework curator, ExecutorService exec) {
        this.curator = curator;
        this.nodeCacheExecutor = exec;
    }

    @VisibleForTesting
    Set<String> getAddedPaths() {
        return this.announcedPaths.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() {
        log.debug("Starting Announcer", new Object[0]);
        List<Announceable> list = this.toAnnounce;
        synchronized (list) {
            if (this.started) {
                log.debug("Announcer has already been started by another thread, ignoring start request.", new Object[0]);
                return;
            }
            this.started = true;
            for (Announceable announceable : this.toAnnounce) {
                this.announce(announceable.path, announceable.bytes, announceable.removeParentsIfCreated);
            }
            this.toAnnounce.clear();
            for (Announceable announceable : this.toUpdate) {
                this.update(announceable.path, announceable.bytes);
            }
            this.toUpdate.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void stop() {
        log.debug("Stopping Announcer", new Object[0]);
        List<Announceable> list = this.toAnnounce;
        synchronized (list) {
            if (!this.started) {
                log.debug("Announcer has already been stopped by another thread, ignoring stop request.", new Object[0]);
                return;
            }
            this.started = false;
            this.closeResources();
        }
    }

    @GuardedBy(value="toAnnounce")
    private void closeResources() {
        try {
            CloseableUtils.closeAll(this.listeners.values());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.nodeCacheExecutor.shutdown();
        }
        for (String announcementPath : this.announcedPaths.keySet()) {
            this.unannounce(announcementPath);
        }
        if (!this.parentsIBuilt.isEmpty()) {
            CuratorMultiTransaction transaction = this.curator.transaction();
            ArrayList<CuratorOp> operations = new ArrayList<CuratorOp>();
            for (String parent : this.parentsIBuilt) {
                try {
                    operations.add((CuratorOp)this.curator.transactionOp().delete().forPath(parent));
                }
                catch (Exception e) {
                    log.info((Throwable)e, "Unable to delete parent[%s] when closing Announcer.", new Object[]{parent});
                }
            }
            try {
                transaction.forOperations(operations);
            }
            catch (Exception e) {
                log.info((Throwable)e, "Unable to commit transaction when closing Announcer.", new Object[0]);
            }
        }
    }

    @Override
    public void announce(String path, byte[] bytes) {
        this.announce(path, bytes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void announce(String path, byte[] bytes, boolean removeParentIfCreated) {
        List<Announceable> e2;
        List<Announceable> list = this.toAnnounce;
        synchronized (list) {
            if (!this.started) {
                log.debug("Announcer has not started yet, queuing announcement for later processing...", new Object[0]);
                this.toAnnounce.add(new Announceable(path, bytes, removeParentIfCreated));
                return;
            }
        }
        String parentPath = ZKPaths.getPathAndNode((String)path).getPath();
        byte[] announcedPayload = this.announcedPaths.get(path);
        if (announcedPayload == null) {
            boolean buildParentPath = false;
            try {
                buildParentPath = this.curator.checkExists().forPath(parentPath) == null;
            }
            catch (Exception e2) {
                log.debug((Throwable)e2, "Problem checking if the parent existed, ignoring.", new Object[0]);
            }
            e2 = this.toAnnounce;
            synchronized (e2) {
                if (!this.listeners.containsKey(path)) {
                    CuratorCache cache = this.createCacheForPath(path);
                    if (this.started) {
                        if (buildParentPath) {
                            this.createPath(parentPath, removeParentIfCreated);
                        }
                        this.startCache(cache);
                        this.listeners.put(path, cache);
                    }
                }
            }
        }
        boolean created = false;
        e2 = this.toAnnounce;
        synchronized (e2) {
            if (this.started) {
                byte[] oldBytes = this.announcedPaths.putIfAbsent(path, bytes);
                if (oldBytes == null) {
                    created = true;
                } else if (!Arrays.equals(oldBytes, bytes)) {
                    throw new IAE("Cannot reannounce different values under the same path.", new Object[0]);
                }
            }
        }
        if (created) {
            try {
                this.createAnnouncement(path, bytes);
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
        }
    }

    @GuardedBy(value="toAnnounce")
    private CuratorCache createCacheForPath(String path) {
        CuratorCache cache = CuratorCache.build((CuratorFramework)this.curator, (String)path, (CuratorCache.Options[])new CuratorCache.Options[]{CuratorCache.Options.SINGLE_NODE_CACHE});
        cache.listenable().addListener((type, oldData, data) -> {
            byte[] previouslyAnnouncedData;
            if (type == CuratorCacheListener.Type.NODE_DELETED && (previouslyAnnouncedData = this.announcedPaths.get(path)) != null) {
                try {
                    log.info("ZooKeeper Node[%s] dropped, reinstating...", new Object[]{path});
                    this.createAnnouncement(path, previouslyAnnouncedData);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Executor)this.nodeCacheExecutor);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String path, byte[] bytes) {
        List<Announceable> list = this.toAnnounce;
        synchronized (list) {
            if (!this.started) {
                log.debug("Announcer has not started yet, queuing updates for later processing...", new Object[0]);
                this.toUpdate.add(new Announceable(path, bytes));
                return;
            }
            byte[] oldBytes = this.announcedPaths.get(path);
            if (oldBytes == null) {
                throw new ISE("Cannot update path[%s] that hasn't been announced!", new Object[]{path});
            }
            try {
                if (!Arrays.equals(oldBytes, bytes)) {
                    this.announcedPaths.put(path, bytes);
                    this.updateAnnouncement(path, bytes);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createAnnouncement(String path, byte[] value) throws Exception {
        ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)((CreateBackgroundModeStatACLable)this.curator.create().compressed()).withMode(CreateMode.EPHEMERAL)).inBackground()).forPath(path, value);
    }

    private void updateAnnouncement(String path, byte[] value) throws Exception {
        ((ErrorListenerPathAndBytesable)((SetDataBackgroundVersionable)this.curator.setData().compressed()).inBackground()).forPath(path, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unannounce(String path) {
        List<Announceable> list = this.toAnnounce;
        synchronized (list) {
            byte[] value = this.announcedPaths.remove(path);
            if (value == null) {
                log.debug("Path[%s] not announced, cannot unannounce.", new Object[]{path});
                return;
            }
        }
        log.info("unannouncing [%s]", new Object[]{path});
        try {
            CuratorOp deleteOp = (CuratorOp)this.curator.transactionOp().delete().forPath(path);
            this.curator.transaction().forOperations(new CuratorOp[]{deleteOp});
        }
        catch (KeeperException.NoNodeException e) {
            log.info("Unannounced node[%s] that does not exist.", new Object[]{path});
        }
        catch (KeeperException.NotEmptyException e) {
            log.warn("Unannouncing non-empty path[%s]", new Object[]{path});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void startCache(CuratorCache cache) {
        try {
            cache.start();
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch((Throwable)e, (Closeable)cache);
        }
    }

    @GuardedBy(value="toAnnounce")
    private void createPath(String parentPath, boolean removeParentsIfCreated) {
        try {
            this.curator.create().creatingParentsIfNeeded().forPath(parentPath);
            if (removeParentsIfCreated) {
                this.parentsIBuilt.add(parentPath);
            }
            log.debug("Created parentPath[%s], %s remove on stop.", new Object[]{parentPath, removeParentsIfCreated ? "will" : "will not"});
        }
        catch (KeeperException.NodeExistsException e) {
            log.info((Throwable)e, "Problem creating parentPath[%s], someone else created it first?", new Object[]{parentPath});
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unhandled exception when creating parentPath[%s].", new Object[]{parentPath});
        }
    }
}

