/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.timeline.SegmentId;

@LazySingleton
public class SegmentSchemaCache {
    private static final Logger log = new Logger(SegmentSchemaCache.class);
    private final AtomicReference<CountDownLatch> initialized = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final AtomicReference<PublishedSegmentSchemas> publishedSegmentSchemas = new AtomicReference<PublishedSegmentSchemas>(PublishedSegmentSchemas.EMPTY);
    private final ConcurrentMap<SegmentId, SchemaPayloadPlus> realtimeSegmentSchemas = new ConcurrentHashMap<SegmentId, SchemaPayloadPlus>();
    private final ConcurrentMap<SegmentId, SchemaPayloadPlus> schemasPendingBackfill = new ConcurrentHashMap<SegmentId, SchemaPayloadPlus>();
    private final ConcurrentMap<SegmentId, SchemaPayloadPlus> recentlyBackfilledSchemas = new ConcurrentHashMap<SegmentId, SchemaPayloadPlus>();
    private final AtomicInteger cacheMissCount = new AtomicInteger(0);

    public boolean isEnabled() {
        return true;
    }

    public void setInitialized() {
        if (!this.isInitialized()) {
            this.initialized.get().countDown();
            log.info("SegmentSchemaCache is initialized.", new Object[0]);
        }
    }

    public void onLeaderStop() {
        this.initialized.set(new CountDownLatch(1));
        this.publishedSegmentSchemas.set(PublishedSegmentSchemas.EMPTY);
        this.schemasPendingBackfill.clear();
        this.recentlyBackfilledSchemas.clear();
    }

    public boolean isInitialized() {
        return this.initialized.get().getCount() == 0L;
    }

    public void awaitInitialization() throws InterruptedException {
        this.initialized.get().await();
    }

    public void resetSchemaForPublishedSegments(Map<SegmentId, SegmentMetadata> usedSegmentIdToMetadata, Map<String, SchemaPayload> schemaFingerprintToPayload) {
        this.publishedSegmentSchemas.set(new PublishedSegmentSchemas(usedSegmentIdToMetadata, schemaFingerprintToPayload));
        this.recentlyBackfilledSchemas.keySet().removeAll(this.publishedSegmentSchemas.get().segmentIdToMetadata.keySet());
        this.setInitialized();
    }

    public void addRealtimeSegmentSchema(SegmentId segmentId, SchemaPayloadPlus schema) {
        this.realtimeSegmentSchemas.put(segmentId, schema);
    }

    public void addSchemaPendingBackfill(SegmentId segmentId, SchemaPayloadPlus schema) {
        this.schemasPendingBackfill.put(segmentId, schema);
    }

    public void markSchemaPersisted(SegmentId segmentId) {
        SchemaPayloadPlus segmentSchema = (SchemaPayloadPlus)this.schemasPendingBackfill.get(segmentId);
        if (segmentSchema == null) {
            log.info("SegmentId[%s] has no schema pending backfill.", new Object[]{segmentId});
        } else {
            this.recentlyBackfilledSchemas.put(segmentId, segmentSchema);
        }
        this.schemasPendingBackfill.remove(segmentId);
    }

    public Optional<SchemaPayloadPlus> getSchemaForSegment(SegmentId segmentId) {
        SchemaPayload schemaPayload;
        SchemaPayloadPlus payloadPlus = (SchemaPayloadPlus)this.realtimeSegmentSchemas.get(segmentId);
        if (payloadPlus != null) {
            return Optional.of(payloadPlus);
        }
        payloadPlus = (SchemaPayloadPlus)this.schemasPendingBackfill.get(segmentId);
        if (payloadPlus != null) {
            return Optional.of(payloadPlus);
        }
        payloadPlus = (SchemaPayloadPlus)this.recentlyBackfilledSchemas.get(segmentId);
        if (payloadPlus != null) {
            return Optional.of(payloadPlus);
        }
        SegmentMetadata segmentMetadata = this.getPublishedSegmentMetadataMap().get(segmentId);
        if (segmentMetadata != null && (schemaPayload = this.getPublishedSchemaPayloadMap().get(segmentMetadata.getSchemaFingerprint())) != null) {
            return Optional.of(new SchemaPayloadPlus(schemaPayload, Long.valueOf(segmentMetadata.getNumRows())));
        }
        this.cacheMissCount.incrementAndGet();
        return Optional.empty();
    }

    public boolean isSchemaCached(SegmentId segmentId) {
        return this.realtimeSegmentSchemas.containsKey(segmentId) || this.schemasPendingBackfill.containsKey(segmentId) || this.recentlyBackfilledSchemas.containsKey(segmentId) || this.isPublishedSegmentSchemaCached(segmentId);
    }

    private boolean isPublishedSegmentSchemaCached(SegmentId segmentId) {
        SegmentMetadata segmentMetadata = this.getPublishedSegmentMetadataMap().get(segmentId);
        if (segmentMetadata != null) {
            return this.getPublishedSchemaPayloadMap().containsKey(segmentMetadata.getSchemaFingerprint());
        }
        return false;
    }

    public Map<SegmentId, SegmentMetadata> getPublishedSegmentMetadataMap() {
        return this.publishedSegmentSchemas.get().segmentIdToMetadata;
    }

    public Map<String, SchemaPayload> getPublishedSchemaPayloadMap() {
        return this.publishedSegmentSchemas.get().schemaFingerprintToPayload;
    }

    public void segmentRemoved(SegmentId segmentId) {
        this.realtimeSegmentSchemas.remove(segmentId);
        this.schemasPendingBackfill.remove(segmentId);
        this.recentlyBackfilledSchemas.remove(segmentId);
    }

    public void realtimeSegmentRemoved(SegmentId segmentId) {
        this.realtimeSegmentSchemas.remove(segmentId);
    }

    public Map<String, Integer> getStats() {
        return Map.of("miss/count", this.cacheMissCount.getAndSet(0), "segment/schemaCache/realtime/count", this.realtimeSegmentSchemas.size(), "segment/schemaCache/used/count", this.getPublishedSegmentMetadataMap().size(), "segment/schemaCache/usedFingerprint/count", this.getPublishedSchemaPayloadMap().size(), "segment/schemaCache/pendingBackfill/count", this.schemasPendingBackfill.size());
    }

    @VisibleForTesting
    SchemaPayloadPlus getTemporaryPublishedMetadataQueryResults(SegmentId id) {
        return (SchemaPayloadPlus)this.recentlyBackfilledSchemas.get(id);
    }

    private static class PublishedSegmentSchemas {
        private static final PublishedSegmentSchemas EMPTY = new PublishedSegmentSchemas(Map.of(), Map.of());
        private final Map<SegmentId, SegmentMetadata> segmentIdToMetadata;
        private final Map<String, SchemaPayload> schemaFingerprintToPayload;

        private PublishedSegmentSchemas(Map<SegmentId, SegmentMetadata> segmentIdToMetadata, Map<String, SchemaPayload> schemaFingerprintToPayload) {
            this.segmentIdToMetadata = Map.copyOf(segmentIdToMetadata);
            this.schemaFingerprintToPayload = Map.copyOf(schemaFingerprintToPayload);
        }
    }
}

