/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ServerCloneStatus {
    private final String sourceServer;
    private final String targetServer;
    private final State state;
    private final long segmentLoadsRemaining;
    private final long segmentDropsRemaining;
    private final long bytesToLoad;

    @JsonCreator
    public ServerCloneStatus(@JsonProperty(value="sourceServer") String sourceServer, @JsonProperty(value="targetServer") String targetServer, @JsonProperty(value="state") State state, @JsonProperty(value="segmentLoadsRemaining") long segmentLoadsRemaining, @JsonProperty(value="segmentDropsRemaining") long segmentDropsRemaining, @JsonProperty(value="bytesToLoad") long bytesToLoad) {
        this.sourceServer = sourceServer;
        this.targetServer = targetServer;
        this.state = state;
        this.segmentLoadsRemaining = segmentLoadsRemaining;
        this.segmentDropsRemaining = segmentDropsRemaining;
        this.bytesToLoad = bytesToLoad;
    }

    @JsonProperty
    public String getSourceServer() {
        return this.sourceServer;
    }

    @JsonProperty
    public String getTargetServer() {
        return this.targetServer;
    }

    @JsonProperty
    public long getSegmentLoadsRemaining() {
        return this.segmentLoadsRemaining;
    }

    @JsonProperty
    public long getSegmentDropsRemaining() {
        return this.segmentDropsRemaining;
    }

    @JsonProperty
    public long getBytesToLoad() {
        return this.bytesToLoad;
    }

    @JsonProperty
    public State getState() {
        return this.state;
    }

    public static ServerCloneStatus unknown(String sourceServer, String targetServer) {
        return new ServerCloneStatus(sourceServer, targetServer, State.TARGET_SERVER_MISSING, -1L, -1L, -1L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerCloneStatus that = (ServerCloneStatus)o;
        return this.segmentLoadsRemaining == that.segmentLoadsRemaining && this.segmentDropsRemaining == that.segmentDropsRemaining && this.bytesToLoad == that.bytesToLoad && Objects.equals(this.sourceServer, that.sourceServer) && Objects.equals(this.targetServer, that.targetServer) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceServer, this.targetServer, this.state, this.segmentLoadsRemaining, this.segmentDropsRemaining, this.bytesToLoad});
    }

    public String toString() {
        return "ServerCloneStatus{sourceServer='" + this.sourceServer + "', targetServer='" + this.targetServer + "', state=" + String.valueOf((Object)this.state) + ", segmentLoadsRemaining=" + this.segmentLoadsRemaining + ", segmentDropsRemaining=" + this.segmentDropsRemaining + ", bytesToLoad=" + this.bytesToLoad + "}";
    }

    public static enum State {
        SOURCE_SERVER_MISSING,
        TARGET_SERVER_MISSING,
        IN_PROGRESS;

    }
}

