/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.discovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.k8s.discovery.K8sDiscoveryConfig;

@LazySingleton
public class PodInfo {
    private final String podName;
    private final String podNamespace;

    @Inject
    public PodInfo(K8sDiscoveryConfig discoveryConfig) {
        this.podName = System.getenv(discoveryConfig.getPodNameEnvKey());
        Preconditions.checkState((this.podName != null && !this.podName.isEmpty() ? 1 : 0) != 0, (Object)"Failed to find podName");
        this.podNamespace = System.getenv(discoveryConfig.getPodNamespaceEnvKey());
        Preconditions.checkState((this.podNamespace != null && !this.podNamespace.isEmpty() ? 1 : 0) != 0, (Object)"Failed to find podNamespace");
    }

    @VisibleForTesting
    public PodInfo(String podName, String podNamespace) {
        this.podName = podName;
        this.podNamespace = podNamespace;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getPodNamespace() {
        return this.podNamespace;
    }
}

