/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URISyntaxException;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.msq.dart.controller.sql.DartSqlClient;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.sql.http.GetQueriesResponse;
import org.apache.http.client.utils.URIBuilder;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class DartSqlClientImpl
implements DartSqlClient {
    private final ServiceClient client;
    private final ObjectMapper jsonMapper;

    public DartSqlClientImpl(ServiceClient client, ObjectMapper jsonMapper) {
        this.client = client;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public ListenableFuture<GetQueriesResponse> getRunningQueries(boolean selfOnly) {
        try {
            URIBuilder builder = new URIBuilder("/queries");
            if (selfOnly) {
                builder.addParameter("selfOnly", null);
            }
            return FutureUtils.transform((ListenableFuture)this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, builder.toString()), (HttpResponseHandler)new BytesFullResponseHandler()), holder -> (GetQueriesResponse)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), GetQueriesResponse.class));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

