/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class DartQueryableSegment {
    private final DataSegment segment;
    private final Interval interval;
    private final int workerNumber;
    @Nullable
    private final DruidServerMetadata realtimeServer;

    public DartQueryableSegment(DataSegment segment, Interval interval, int workerNumber, @Nullable DruidServerMetadata realtimeServer) {
        this.segment = (DataSegment)Preconditions.checkNotNull((Object)segment, (Object)"segment");
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.workerNumber = workerNumber;
        this.realtimeServer = realtimeServer;
    }

    public DataSegment getSegment() {
        return this.segment;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public int getWorkerNumber() {
        return this.workerNumber;
    }

    @Nullable
    public DruidServerMetadata getRealtimeServer() {
        return this.realtimeServer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DartQueryableSegment that = (DartQueryableSegment)o;
        return this.workerNumber == that.workerNumber && Objects.equals(this.segment, that.segment) && Objects.equals(this.interval, that.interval) && Objects.equals(this.realtimeServer, that.realtimeServer);
    }

    public int hashCode() {
        return Objects.hash(this.segment, this.interval, this.workerNumber, this.realtimeServer);
    }
}

